/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.base.catalog;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Collection;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogUtils;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.EventLocationType;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.EventType;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.IntervalUnitType;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.Schedule;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseasabasesqlmodelFactory;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.impl.SybaseASABaseEventImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASACatalogBaseEvent
extends SybaseASABaseEventImpl
implements ICatalogObject {
    private static final long serialVersionUID = 7542251482941333022L;
    protected Boolean eventInfoLoaded = Boolean.FALSE;
    protected Boolean schedulesLoaded = Boolean.FALSE;
    public static final String REMOTE_LOCATION_TYPE_IN_DATABASE = "R";
    public static final String CONSOLIDATED_LOCATION_TYPE_IN_DATABASE = "C";
    public static final String ALL_LOCATION_TYPE_IN_DATABASE = "A";
    public static final String INTERNAL_UNIT_HOURS_IN_DATABASE = "HH";
    public static final String INTERNAL_UNIT_MINUTES_IN_DATABASE = "NN";
    public static final String INTERNAL_UNIT_SECONDS_IN_DATABASE = "SS";

    public Database getCatalogDatabase() {
        return this.getDatabase();
    }

    public Connection getConnection() {
        return ((ICatalogObject)this.getCatalogDatabase()).getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.eventInfoLoaded;
        synchronized (bl) {
            if (this.eventInfoLoaded.booleanValue()) {
                this.eventInfoLoaded = Boolean.FALSE;
            }
        }
        bl = this.schedulesLoaded;
        synchronized (bl) {
            if (this.schedulesLoaded.booleanValue()) {
                this.schedulesLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 9: {
                this.getAction();
                break;
            }
            case 8: {
                this.getCondition();
                break;
            }
            case 10: {
                this.isEnabled();
                break;
            }
            case 13: {
                this.getEventCreator();
                break;
            }
            case 12: {
                this.getEventType();
                break;
            }
            case 14: {
                this.getLocation();
                break;
            }
            case 15: {
                this.getSchedules();
            }
        }
        return super.eIsSet(eFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAction() {
        Boolean bl = this.eventInfoLoaded;
        synchronized (bl) {
            if (!this.eventInfoLoaded.booleanValue()) {
                this.loadEventInfo();
                this.eventInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCondition() {
        Boolean bl = this.eventInfoLoaded;
        synchronized (bl) {
            if (!this.eventInfoLoaded.booleanValue()) {
                this.loadEventInfo();
                this.eventInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        Boolean bl = this.eventInfoLoaded;
        synchronized (bl) {
            if (!this.eventInfoLoaded.booleanValue()) {
                this.loadEventInfo();
                this.eventInfoLoaded = Boolean.TRUE;
            }
        }
        return super.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema getEventCreator() {
        Boolean bl = this.eventInfoLoaded;
        synchronized (bl) {
            if (!this.eventInfoLoaded.booleanValue()) {
                this.loadEventInfo();
                this.eventInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getEventCreator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventType getEventType() {
        Boolean bl = this.eventInfoLoaded;
        synchronized (bl) {
            if (!this.eventInfoLoaded.booleanValue()) {
                this.loadEventInfo();
                this.eventInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getEventType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventLocationType getLocation() {
        Boolean bl = this.eventInfoLoaded;
        synchronized (bl) {
            if (!this.eventInfoLoaded.booleanValue()) {
                this.loadEventInfo();
                this.eventInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getSchedules() {
        Boolean bl = this.schedulesLoaded;
        synchronized (bl) {
            if (!this.schedulesLoaded.booleanValue()) {
                this.loadSchedules();
                this.schedulesLoaded = Boolean.TRUE;
            }
        }
        return super.getSchedules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEventInfo() {
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("select TRIM(user_name) as user_name, enabled, location, action, condition,\tevtt.name as 'event type', evt.remarks from sysevent as evt left outer join syseventtype as evtt on evtt.event_type_id = evt.event_type_id, sysuserperm as up where evt.creator = up.user_id and event_name like ?");
            stmt.setString(1, this.getName());
            rs = stmt.executeQuery();
            while (rs.next()) {
                String creator = rs.getString(1);
                boolean enabled = rs.getString(2).equalsIgnoreCase("Y");
                String location = rs.getString(3);
                String action = rs.getString(4);
                String condition = rs.getString(5);
                String sEventType = rs.getString(6);
                String remark = rs.getString(7);
                EventLocationType elt = null;
                if (location != null) {
                    if (location.equals(REMOTE_LOCATION_TYPE_IN_DATABASE)) {
                        elt = EventLocationType.REMOTE_LITERAL;
                    } else if (location.equals(CONSOLIDATED_LOCATION_TYPE_IN_DATABASE)) {
                        elt = EventLocationType.CONSOLIDATED_LITERAL;
                    } else if (location.equals(ALL_LOCATION_TYPE_IN_DATABASE)) {
                        elt = EventLocationType.ALL_LITERAL;
                    }
                }
                EventType eventType = EventType.get((String)sEventType);
                if (sEventType != null && eventType == null) {
                    eventType = EventType.get((String)("\"" + sEventType + "\""));
                }
                Schema schema = (Schema)SybaseASACatalogUtils.findElement((Collection)this.getCatalogDatabase().getSchemas(), creator);
                super.setEventCreator(schema);
                super.setEnabled(enabled);
                super.setAction(action);
                super.setDescription(remark);
                super.setLocation(elt);
                super.setEventType(eventType);
                super.setCondition(condition);
            }
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        catch (SQLException e) {
            JDBCASAPlugin.getDefault().log(e);
        }
        finally {
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        this.eSetDeliver(deliver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSchedules() {
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        EList schedules = super.getSchedules();
        schedules.clear();
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("select sched_name, recurring, start_time, stop_time, start_date, days_of_week,\tdays_of_month, interval_units, interval_amt from sysschedule as sched, sysevent as evt where sched.event_id = evt.event_id and evt.event_name like ?");
            stmt.setString(1, this.getName());
            rs = stmt.executeQuery();
            while (rs.next()) {
                String scheduleName = rs.getString(1);
                boolean recurring = rs.getInt(2) == 1;
                Time startTime = rs.getTime(3);
                Time stopTime = rs.getTime(4);
                Date startDate = rs.getDate(5);
                int daysOfWeek = rs.getInt(6);
                int daysOfMonth = rs.getInt(7);
                String intervalUnit = rs.getString(8);
                int intervalAmount = rs.getInt(9);
                IntervalUnitType iut = null;
                if (intervalUnit != null) {
                    if (intervalUnit.equals(INTERNAL_UNIT_HOURS_IN_DATABASE)) {
                        iut = IntervalUnitType.HOURS_LITERAL;
                    } else if (intervalUnit.equals(INTERNAL_UNIT_MINUTES_IN_DATABASE)) {
                        iut = IntervalUnitType.MINUTES_LITERAL;
                    } else if (intervalUnit.equals(INTERNAL_UNIT_SECONDS_IN_DATABASE)) {
                        iut = IntervalUnitType.SECONDS_LITERAL;
                    }
                }
                Schedule schedule = SybaseasabasesqlmodelFactory.eINSTANCE.createSchedule();
                schedule.setName(scheduleName);
                schedule.setRecurring(recurring);
                schedule.setStartTime((java.util.Date)startTime);
                schedule.setStopTime((java.util.Date)stopTime);
                schedule.setStartDate((java.util.Date)startDate);
                schedule.setDaysOfWeek(daysOfWeek);
                schedule.setDaysOfMonth(daysOfMonth);
                schedule.setIntervalMount(intervalAmount);
                schedule.setIntervalUnit(iut);
                schedules.add((Object)schedule);
            }
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        catch (SQLException e) {
            JDBCASAPlugin.getDefault().log(e);
        }
        finally {
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        this.eSetDeliver(deliver);
    }
}

