/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.base.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SQLScriptsProvider;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogUtils;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseDatabase;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.impl.SybaseASABasePrimaryKeyImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASACatalogBasePrimaryKey
extends SybaseASABasePrimaryKeyImpl
implements ICatalogObject {
    private static final long serialVersionUID = -7797014533423629745L;
    protected Boolean pkInfoLoaded = Boolean.FALSE;

    public Database getCatalogDatabase() {
        return this.getBaseTable().getSchema().getDatabase();
    }

    public Connection getConnection() {
        return ((ICatalogObject)this.getCatalogDatabase()).getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.pkInfoLoaded;
        synchronized (bl) {
            if (this.pkInfoLoaded.booleanValue()) {
                this.pkInfoLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 11: {
                this.getMembers();
                break;
            }
            case 13: {
                this.isClustered();
            }
        }
        return super.eIsSet(eFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getMembers() {
        Boolean bl = this.pkInfoLoaded;
        synchronized (bl) {
            if (!this.pkInfoLoaded.booleanValue()) {
                this.loadPKInfo();
                this.pkInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getMembers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClustered() {
        Boolean bl = this.pkInfoLoaded;
        synchronized (bl) {
            if (!this.pkInfoLoaded.booleanValue()) {
                this.loadPKInfo();
                this.pkInfoLoaded = Boolean.TRUE;
            }
        }
        return super.isClustered();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadPKInfo() {
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        SybaseASABaseDatabase db = (SybaseASABaseDatabase)this.getCatalogDatabase();
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            BaseTable table = this.getBaseTable();
            String schemaName = table.getSchema().getName();
            String tableName = table.getName();
            stmt = conn.prepareStatement(SQLScriptsProvider.getQueryPrimaryKeyInfo((Database)db));
            stmt.setString(1, schemaName);
            stmt.setString(2, tableName);
            stmt.setString(3, this.getName());
            rs = stmt.executeQuery();
            while (rs.next()) {
                String colListStr = rs.getString(2);
                boolean isClustered = rs.getString(3).equals("Y");
                List columnList = SybaseASACatalogUtils.getSpecifiedColumns(colListStr, (Collection)table.getColumns());
                super.getMembers().clear();
                super.getMembers().addAll((Collection)columnList);
                super.setClustered(isClustered);
            }
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        catch (SQLException e) {
            JDBCASAPlugin.getDefault().log(e);
        }
        finally {
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        this.eSetDeliver(deliver);
    }
}

