/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.base.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogUtils;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseActionTime;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.impl.SybaseASABaseTriggerImpl;
import org.eclipse.datatools.modelbase.sql.expressions.SearchCondition;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatementDefault;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatementsFactory;
import org.eclipse.datatools.modelbase.sql.tables.ActionGranularityType;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASACatalogBaseTrigger
extends SybaseASABaseTriggerImpl
implements ICatalogObject {
    private static final long serialVersionUID = 7357619526611063764L;
    protected Boolean triggerInfoLoaded = Boolean.FALSE;
    private static final byte INSERT_EVENT = 1;
    private static final byte DELETE_EVENT = 2;
    private static final byte UPDATE_EVENT = 4;
    private static final byte UPDATE_COLUMN_EVENT = 8;

    public Database getCatalogDatabase() {
        return this.getSubjectTable().getSchema().getDatabase();
    }

    public Connection getConnection() {
        return ((ICatalogObject)this.getCatalogDatabase()).getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.triggerInfoLoaded;
        synchronized (bl) {
            if (this.triggerInfoLoaded.booleanValue()) {
                this.triggerInfoLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 3: {
                this.getDescription();
                break;
            }
            case 14: {
                this.getSybaseASABaseActionTime();
                break;
            }
            case 22: {
                this.getOrder();
                break;
            }
            case 11: {
                this.getActionGranularity();
                break;
            }
            case 12: {
                this.getWhen();
                break;
            }
            case 10: {
                this.getTriggerColumn();
                break;
            }
            case 15: {
                this.isUpdateType();
                break;
            }
            case 17: {
                this.isDeleteType();
                break;
            }
            case 16: {
                this.isInsertType();
                break;
            }
            case 19: {
                this.getNewRow();
                break;
            }
            case 21: {
                this.getNewTable();
                break;
            }
            case 18: {
                this.getOldRow();
                break;
            }
            case 20: {
                this.getOldTable();
                break;
            }
            case 24: {
                this.getRemoteName();
                break;
            }
            case 9: {
                this.getActionStatement();
            }
        }
        return super.eIsSet(eFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription() {
        Boolean bl = this.triggerInfoLoaded;
        synchronized (bl) {
            if (!this.triggerInfoLoaded.booleanValue()) {
                this.loadTriggerInfo();
                this.triggerInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SybaseASABaseActionTime getSybaseASABaseActionTime() {
        Boolean bl = this.triggerInfoLoaded;
        synchronized (bl) {
            if (!this.triggerInfoLoaded.booleanValue()) {
                this.loadTriggerInfo();
                this.triggerInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getSybaseASABaseActionTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOrder() {
        Boolean bl = this.triggerInfoLoaded;
        synchronized (bl) {
            if (!this.triggerInfoLoaded.booleanValue()) {
                this.loadTriggerInfo();
                this.triggerInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getOrder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionGranularityType getActionGranularity() {
        Boolean bl = this.triggerInfoLoaded;
        synchronized (bl) {
            if (!this.triggerInfoLoaded.booleanValue()) {
                this.loadTriggerInfo();
                this.triggerInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getActionGranularity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchCondition getWhen() {
        Boolean bl = this.triggerInfoLoaded;
        synchronized (bl) {
            if (!this.triggerInfoLoaded.booleanValue()) {
                this.loadTriggerInfo();
                this.triggerInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getWhen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getTriggerColumn() {
        Boolean bl = this.triggerInfoLoaded;
        synchronized (bl) {
            if (!this.triggerInfoLoaded.booleanValue()) {
                this.loadTriggerInfo();
                this.triggerInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getTriggerColumn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUpdateType() {
        Boolean bl = this.triggerInfoLoaded;
        synchronized (bl) {
            if (!this.triggerInfoLoaded.booleanValue()) {
                this.loadTriggerInfo();
                this.triggerInfoLoaded = Boolean.TRUE;
            }
        }
        return super.isUpdateType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeleteType() {
        Boolean bl = this.triggerInfoLoaded;
        synchronized (bl) {
            if (!this.triggerInfoLoaded.booleanValue()) {
                this.loadTriggerInfo();
                this.triggerInfoLoaded = Boolean.TRUE;
            }
        }
        return super.isDeleteType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInsertType() {
        Boolean bl = this.triggerInfoLoaded;
        synchronized (bl) {
            if (!this.triggerInfoLoaded.booleanValue()) {
                this.loadTriggerInfo();
                this.triggerInfoLoaded = Boolean.TRUE;
            }
        }
        return super.isInsertType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNewRow() {
        Boolean bl = this.triggerInfoLoaded;
        synchronized (bl) {
            if (!this.triggerInfoLoaded.booleanValue()) {
                this.loadTriggerInfo();
                this.triggerInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getNewRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNewTable() {
        Boolean bl = this.triggerInfoLoaded;
        synchronized (bl) {
            if (!this.triggerInfoLoaded.booleanValue()) {
                this.loadTriggerInfo();
                this.triggerInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getNewTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOldRow() {
        Boolean bl = this.triggerInfoLoaded;
        synchronized (bl) {
            if (!this.triggerInfoLoaded.booleanValue()) {
                this.loadTriggerInfo();
                this.triggerInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getOldRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOldTable() {
        Boolean bl = this.triggerInfoLoaded;
        synchronized (bl) {
            if (!this.triggerInfoLoaded.booleanValue()) {
                this.loadTriggerInfo();
                this.triggerInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getOldTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRemoteName() {
        Boolean bl = this.triggerInfoLoaded;
        synchronized (bl) {
            if (!this.triggerInfoLoaded.booleanValue()) {
                this.loadTriggerInfo();
                this.triggerInfoLoaded = Boolean.TRUE;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getActionStatement() {
        Boolean bl = this.triggerInfoLoaded;
        synchronized (bl) {
            if (!this.triggerInfoLoaded.booleanValue()) {
                this.loadTriggerInfo();
                this.triggerInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getActionStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTriggerInfo() {
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Table table = this.getSubjectTable();
            String schemaName = table.getSchema().getName();
            String tableName = table.getName();
            stmt = conn.prepareStatement("SELECT TRIM(G.trigger_name) as trigger_name, G.\"event\", G.trigger_time, G.trigger_order, G.trigger_defn, G.remarks, G.source FROM SYS.SYSTRIGGER G JOIN SYS.SYSTABLE T ON T.table_id = G.table_id JOIN SYS.SYSUSERPERMS U ON U.user_id = T.creator WHERE G.foreign_key_id IS NULL AND U.user_name like ? AND T.table_name like ? AND G.trigger_name like ?");
            stmt.setString(1, schemaName);
            stmt.setString(2, tableName);
            stmt.setString(3, this.getName());
            rs = stmt.executeQuery();
            while (rs.next()) {
                char event = SybaseASACatalogUtils.getCharValue(rs.getString(2));
                char time = SybaseASACatalogUtils.getCharValue(rs.getString(3));
                int order = rs.getInt(4);
                String triggerDefn = rs.getString(5);
                String remark = rs.getString(6);
                String source = rs.getString(7);
                boolean isInsertType = false;
                boolean isDeleteType = false;
                boolean isUpdateType = false;
                boolean isUpdateColumnType = false;
                byte eventId = this.getEventsId(event);
                if ((eventId & 1) != 0) {
                    isInsertType = true;
                }
                if ((eventId & 2) != 0) {
                    isDeleteType = true;
                }
                if ((eventId & 4) != 0) {
                    isUpdateType = true;
                }
                if ((eventId & 8) != 0) {
                    isUpdateColumnType = true;
                }
                String statement = source != null && source.length() > 0 ? source : triggerDefn;
                SybaseASABaseActionTime actionTime = this.getTimingId(time);
                ActionGranularityType agt = ActionGranularityType.ROW_LITERAL;
                if (time == 'S') {
                    agt = ActionGranularityType.STATEMENT_LITERAL;
                }
                super.setInsertType(isInsertType);
                super.setDeleteType(isDeleteType);
                super.setUpdateType(isUpdateType);
                super.setUpdateColumnType(isUpdateColumnType);
                super.setOrder(order);
                super.setDescription(remark);
                super.setActionGranularity(agt);
                super.setSybaseASABaseActionTime(actionTime);
                SQLStatementDefault sqlStmt = SQLStatementsFactory.eINSTANCE.createSQLStatementDefault();
                sqlStmt.setSQL(statement);
                super.getActionStatement().clear();
                super.getActionStatement().add((Object)sqlStmt);
            }
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        catch (SQLException e) {
            JDBCASAPlugin.getDefault().log(e);
        }
        finally {
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        this.eSetDeliver(deliver);
    }

    private byte getEventsId(char c) {
        switch (c) {
            case 'I': {
                return 1;
            }
            case 'U': {
                return 4;
            }
            case 'D': {
                return 2;
            }
            case 'C': {
                return 8;
            }
            case 'A': {
                return 3;
            }
            case 'B': {
                return 5;
            }
            case 'E': {
                return 6;
            }
            case 'M': {
                return 7;
            }
        }
        return 0;
    }

    private SybaseASABaseActionTime getTimingId(char c) {
        switch (c) {
            case 'B': {
                return SybaseASABaseActionTime.BEFORE_LITERAL;
            }
            case 'A': {
                return SybaseASABaseActionTime.AFTER_LITERAL;
            }
            case 'S': {
                return SybaseASABaseActionTime.ASE_LITERAL;
            }
            case 'R': {
                return SybaseASABaseActionTime.RESOLVE_LITERAL;
            }
        }
        return SybaseASABaseActionTime.AFTER_LITERAL;
    }
}

