/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.deltaddl;

import java.util.List;
import java.util.Map;
import org.eclipse.datatools.enablement.sybase.asa.ISybaseASADdlConstants;
import org.eclipse.datatools.enablement.sybase.asa.ddl.SybaseASADdlBuilder;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseColumn;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.enablement.sybase.deltaddl.AbstractDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.IDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.SybaseDeltaDdlGeneration;
import org.eclipse.datatools.modelbase.sql.expressions.ValueExpression;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.datatools.modelbase.sql.schema.TypedElement;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesPackage;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public class SybaseASAColumnDeltaDdlGenProvider
extends AbstractDeltaDdlGenProvider
implements IDeltaDdlGenProvider,
ISybaseASADdlConstants {
    public void analyze(SQLObject element, Map changeMap, Map modificationRecords) {
        super.analyze(element, changeMap, modificationRecords);
        List records = (List)modificationRecords.get(element);
        if (records == null) {
            return;
        }
        boolean flag1 = false;
        boolean flag2 = false;
        for (int i = records.size() - 1; i >= 0; --i) {
            SybaseDeltaDdlGeneration.FeatureChangeRecord record = (SybaseDeltaDdlGeneration.FeatureChangeRecord)records.get(i);
            EStructuralFeature f = record.feature;
            if (f == SQLSchemaPackage.eINSTANCE.getTypedElement_ContainedType() || f == SQLSchemaPackage.eINSTANCE.getTypedElement_ReferencedType() || f == SQLTablesPackage.eINSTANCE.getColumn_Nullable()) {
                if (flag1) {
                    records.remove(i);
                }
                flag1 = true;
            }
            if (f != SQLTablesPackage.eINSTANCE.getColumn_GenerateExpression() && f != SQLTablesPackage.eINSTANCE.getColumn_DefaultValue() || record.newValue != null && !record.newValue.equals("")) continue;
            if (flag2) {
                records.remove(i);
            }
            flag2 = true;
        }
    }

    protected void getModificationResult(SQLObject e, EStructuralFeature f, Object oldValue, Object newValue, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script) {
        SybaseASADdlBuilder builder = SybaseASADdlBuilder.getInstance();
        SybaseASABaseColumn column = (SybaseASABaseColumn)e;
        Table table = column.getTable();
        StringBuffer sb = new StringBuffer(256);
        sb.append("ALTER").append(" ").append("TABLE").append(" ");
        sb.append(builder.getName((ENamedElement)table, quoteIdentifiers, qualifyNames)).append(" ");
        if (f == EcorePackage.eINSTANCE.getENamedElement_Name()) {
            sb.append("RENAME").append(" ").append(oldValue).append(" ").append("TO").append(newValue);
            script.addAlterOtherStatements(sb.toString());
        } else if (f == SQLSchemaPackage.eINSTANCE.getTypedElement_ContainedType() || f == SQLSchemaPackage.eINSTANCE.getTypedElement_ReferencedType() || f == SQLTablesPackage.eINSTANCE.getColumn_Nullable()) {
            sb.append("MODIFY").append(" ").append(builder.getName((ENamedElement)column, quoteIdentifiers, false)).append(" ").append(this.getDataTypeString((TypedElement)column, column.getTable().getSchema())).append(" ").append(column.isNullable() ? "" : "NOT ").append("NULL");
        }
        sb.append("ALTER").append(" ").append(builder.getName((ENamedElement)e, quoteIdentifiers, qualifyNames)).append(" ");
        if (f == SQLTablesPackage.eINSTANCE.getColumn_DefaultValue()) {
            if (newValue != null) {
                sb.append("SET").append(" ").append("DEFAULT").append(" ").append(newValue);
            } else {
                sb.append("DROP").append(" ").append("DEFAULT");
            }
        } else if (f == SQLTablesPackage.eINSTANCE.getColumn_GenerateExpression()) {
            ValueExpression ve = (ValueExpression)newValue;
            if (ve != null && ve.getSQL() != null && !ve.getSQL().equals("")) {
                sb.append("SET").append(" ").append("COMPUTE").append(" ").append("(").append(ve.getSQL()).append(")");
            } else {
                sb.append("DROP").append(" ").append("COMPUTE");
            }
        }
        script.addAlterTableColumnStatements(sb.toString());
    }

    protected void addCreateStatement(SybaseDdlScript script, String statement) {
        script.addAlterTableColumnStatements(statement);
    }

    protected void addDropStatement(SybaseDdlScript script, String statement) {
        script.addAlterTableColumnStatements(statement);
    }
}

