/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.data.internal.ui.editor;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.sqltools.data.internal.core.editor.IRowData;
import org.eclipse.datatools.sqltools.data.internal.core.editor.ITableData;
import org.eclipse.datatools.sqltools.data.internal.core.editor.RowDataImpl;
import org.eclipse.datatools.sqltools.data.internal.ui.DataUIPlugin;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.DefaultExternalTableDataWizardPage;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.IExternalTableDataEditor;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.Messages;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.TableDataEditor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Shell;

public class DefaultExternalTableDataWizard
extends Wizard
implements IExternalTableDataEditor {
    protected boolean successfulPerformFinish = false;
    protected DefaultExternalTableDataWizardPage defaultPage;
    protected TableDataEditor editor;

    public void externalEdit(TableDataEditor editor) {
        this.init(editor);
        this.refreshValueFromDatabase();
        WizardDialog dialog = new WizardDialog(editor.getEditorSite().getShell(), (IWizard)this);
        dialog.setMinimumPageSize(300, 275);
        dialog.create();
        dialog.open();
    }

    protected boolean refreshValueFromDatabase() {
        final int col = this.editor.getCursor().getColumn();
        final IRowData row = this.editor.getRow();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    ITableData td = ((RowDataImpl)row).getTable();
                    if (td.getColumnDataAccessor(col).isSnippet(row.getValue(col), td.getColumnType(col))) {
                        ((RowDataImpl)row).doRefresh(col, false);
                    }
                }
                catch (Exception ex) {
                    throw new InvocationTargetException(ex);
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
            }
        };
        try {
            this.editor.getSite().getWorkbenchWindow().run(true, true, runnable);
        }
        catch (InterruptedException ex) {
            return false;
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getCause();
            Status status = new Status(2, "org.eclipse.datatools.sqltools.data.core", 0, t.getMessage(), t);
            ErrorDialog.openError((Shell)this.editor.getSite().getShell(), (String)Messages.getString("DefaultExternalTableDataWizard.RetrieveValueError"), (String)Messages.getString("DefaultExternalTableDataWizard.RetrieveValueMessage"), (IStatus)status);
            DataUIPlugin.getDefault().writeLog(status.getSeverity(), 0, status.getMessage(), t);
            return false;
        }
        this.editor.tableViewer.refresh((Object)((RowDataImpl)this.editor.getRow()));
        this.editor.getCursor().redraw();
        return true;
    }

    protected void init(TableDataEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(Messages.getString("DefaultExternalTableDataEditorWizard.InitError"));
        }
        this.editor = editor;
        int columnIndex = editor.getCursor().getColumn();
        try {
            String type = ((Column)editor.getSqlTable().getColumns().get(columnIndex)).getDataType().getName();
            this.setWindowTitle(Messages.getString("DefaultExternalTableDataEditorWizard.Title", new Object[]{type}));
        }
        catch (Exception e) {
            this.setWindowTitle(Messages.getString("DefaultExternalTableDataEditorWizard.DefaultTitle"));
        }
        this.setDefaultPageImageDescriptor(DataUIPlugin.getDefault().getPngImageDescriptor("ext_table_editor"));
    }

    public void addPages() {
        if (this.getPageCount() == 0) {
            this.defaultPage = this.createDefaultPage();
            this.addPage((IWizardPage)this.defaultPage);
        }
        this.defaultPage.init(this.editor);
    }

    protected DefaultExternalTableDataWizardPage createDefaultPage() {
        return new DefaultExternalTableDataWizardPage("NamePage");
    }

    public boolean performFinish() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                DefaultExternalTableDataWizard.this.successfulPerformFinish = DefaultExternalTableDataWizard.this.defaultPage.updateRowData();
            }
        });
        return this.successfulPerformFinish;
    }
}

