/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.plan.internal.ui.actions;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.plan.PlanRequest;
import org.eclipse.datatools.sqltools.plan.internal.IPlanInstance;
import org.eclipse.datatools.sqltools.plan.internal.PlanViewPlugin;
import org.eclipse.datatools.sqltools.plan.internal.ui.actions.Messages;
import org.eclipse.datatools.sqltools.plan.internal.util.ILogger;
import org.eclipse.datatools.sqltools.plan.internal.util.Images;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LoadPlanAction
extends Action {
    private static ILogger _log = PlanViewPlugin.getLogger(null);

    public LoadPlanAction() {
        this.setText(Messages.LoadPlanAction_title);
        this.setToolTipText(Messages.LoadPlanAction_tooltip);
        this.setImageDescriptor(Images.DESC_IMPORT_PLAN);
        this.setDisabledImageDescriptor(Images.DESC_IMPORT_PLAN_DISABLE);
    }

    public void run() {
        FileDialog dlg = new FileDialog(PlanViewPlugin.getActiveWorkbenchShell(), 4096);
        String file = dlg.open();
        if (file != null) {
            File f = new File(file);
            if (!f.exists()) {
                MessageDialog.openInformation((Shell)PlanViewPlugin.getActiveWorkbenchShell(), (String)Messages.LoadPlanAction_info, (String)Messages.LoadPlanAction_filenotfound);
                return;
            }
            try {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = builder.parse(file);
                NodeList list = document.getDocumentElement().getChildNodes();
                int nodeCount = list.getLength();
                for (int i = 0; i < nodeCount; ++i) {
                    Node type;
                    Node planNode = list.item(i);
                    PlanRequest request = null;
                    NamedNodeMap map = planNode.getAttributes();
                    Node status = map.getNamedItem("status");
                    if (status == null || (type = map.getNamedItem("type")) == null) continue;
                    NodeList planNodeList = planNode.getChildNodes();
                    for (int j = 0; j < planNodeList.getLength(); ++j) {
                        Node subNode = planNodeList.item(j);
                        if (subNode.getNodeName().equals("request")) {
                            NamedNodeMap subNodeAttrs = subNode.getAttributes();
                            Node dbId = subNodeAttrs.getNamedItem("dbDefinitionId");
                            String dbDefinitionId = "";
                            String sql = "";
                            dbDefinitionId = dbId == null ? Messages.LoadPlanAction_unknown_db : dbId.getNodeValue();
                            if (subNode.getFirstChild() != null) {
                                CDATASection sqlCDATA = (CDATASection)subNode.getFirstChild();
                                sql = sqlCDATA.getNodeValue();
                            }
                            request = new PlanRequest(sql, dbDefinitionId, this.getTypeId(type.getNodeValue()), 1);
                            continue;
                        }
                        if (!subNode.getNodeName().equals("rawPlan")) continue;
                        String rawPlan = "";
                        if (subNode.getFirstChild() != null) {
                            CDATASection rawPlanCDATA = (CDATASection)subNode.getFirstChild();
                            rawPlan = rawPlanCDATA.getNodeValue();
                        }
                        if (request == null) continue;
                        IPlanInstance instance = PlanViewPlugin.getPlanManager().createNewPlanInstance(request);
                        if (this.getStatus(status.getNodeValue()) == 1) {
                            instance.finishSuccess(rawPlan);
                            continue;
                        }
                        instance.finishFail(new Throwable(rawPlan));
                    }
                }
            }
            catch (Exception e) {
                Status fstatus = new Status(4, "org.eclipse.datatools.sqltools.plan", 0, e.getMessage(), (Throwable)e);
                final String title = Messages.LoadPlanAction_error;
                final String msg = Messages.LoadPlanAction_errorinfo;
                Display display = PlanViewPlugin.getActiveWorkbenchShell().getDisplay();
                display.asyncExec(new Runnable((IStatus)fstatus){
                    private final /* synthetic */ IStatus val$fstatus;
                    {
                        this.val$fstatus = val$fstatus;
                    }

                    public void run() {
                        ErrorDialog.openError((Shell)PlanViewPlugin.getActiveWorkbenchShell(), (String)title, (String)msg, (IStatus)this.val$fstatus);
                    }
                });
                _log.error("LoadPlanAction.error.message", (Throwable)e);
            }
        }
    }

    private int getStatus(String desc) {
        if ("SUCCESS".equals(desc)) {
            return 1;
        }
        if ("SUCCESS".equals(desc)) {
            return 2;
        }
        return 0;
    }

    private int getTypeId(String desc) {
        if (desc.equals("GRAPHIC_PLAN")) {
            return 1;
        }
        if (desc.equals("TEXT_PLAN")) {
            return 0;
        }
        return 0;
    }
}

