/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util.date;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.util.date.DateFormatHolder;
import org.eclipse.datatools.enablement.oda.xml.util.date.DateFormatISO8601;

public final class DateUtil {
    private static ULocale DEFAULT_LOCALE = ULocale.US;
    private static int DEFAULT_DATE_STYLE = 2;
    public static long count = 0L;

    public static Date toDate(Object source) throws OdaException {
        if (source == null) {
            return null;
        }
        if (source instanceof Date) {
            return new Date(((Date)source).getTime());
        }
        if (source instanceof String) {
            return DateUtil.toDate((String)source);
        }
        throw new OdaException(String.valueOf(Messages.getString("DateUtil.ConvertFails")) + source.toString());
    }

    public static Date toDate(String source, ULocale locale) throws OdaException {
        if (source == null) {
            return null;
        }
        DateFormat dateFormat = null;
        Date resultDate = null;
        boolean existTime = source.matches(".*[0-9]+:[0-9]+:[0-9]+.*") || source.matches(".*[0-9]+:[0-9]+.*");
        int i = DEFAULT_DATE_STYLE;
        while (i <= 3) {
            int j = DEFAULT_DATE_STYLE;
            while (j <= 3) {
                dateFormat = DateFormatHolder.getDateTimeInstance(i, j, locale);
                try {
                    resultDate = dateFormat.parse(source);
                    return resultDate;
                }
                catch (ParseException parseException) {
                    ++j;
                }
            }
            if (!existTime) {
                dateFormat = DateFormatHolder.getDateInstance(i, locale);
                try {
                    resultDate = dateFormat.parse(source);
                    return resultDate;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (resultDate == null) {
            throw new OdaException(String.valueOf(Messages.getString("DateUtil.ConvertFails")) + source.toString());
        }
        return resultDate;
    }

    private static Date toDate(String source) throws OdaException {
        try {
            return DateUtil.toDateISO8601(source);
        }
        catch (OdaException e) {
            try {
                return DateUtil.toDate(source, ULocale.getDefault());
            }
            catch (OdaException use) {
                return DateUtil.toDate(source, DEFAULT_LOCALE);
            }
        }
    }

    private static Date toDateISO8601(String source) throws OdaException {
        Date resultDate = null;
        try {
            resultDate = DateFormatISO8601.parse(source);
            return resultDate;
        }
        catch (ParseException e1) {
            throw new OdaException(String.valueOf(Messages.getString("DateUtil.ConvertFails")) + source.toString());
        }
    }
}

