/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util.ui;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSAttributeUseImpl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.util.ui.ATreeNode;
import org.eclipse.datatools.enablement.oda.xml.util.ui.VisitingRecorder;
import org.eclipse.datatools.enablement.oda.xml.util.ui.XMLFileSchemaTreePopulator;

final class XSDFileSchemaTreePopulator {
    private static boolean includeAttribute = true;

    XSDFileSchemaTreePopulator() {
    }

    private static void populateRoot(ATreeNode root) {
        Object[] toBeIterated = root.getChildren();
        int i = 0;
        while (i < toBeIterated.length) {
            String value = ((ATreeNode)toBeIterated[i]).getDataType();
            ArrayList container = new ArrayList();
            XSDFileSchemaTreePopulator.findNodeWithValue(root, value.toString(), container, new VisitingRecorder());
            int j = 0;
            while (j < container.size()) {
                if (((ATreeNode)container.get(j)).getChildren().length == 0) {
                    Object[] os = ((ATreeNode)toBeIterated[i]).getChildren();
                    int k = 0;
                    while (k < os.length) {
                        if (((ATreeNode)os[k]).getDataType() == null || !((ATreeNode)os[k]).getDataType().equals(((ATreeNode)container.get(j)).getDataType())) {
                            ((ATreeNode)container.get(j)).addChild(os[k]);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private static void findNodeWithValue(ATreeNode root, String value, List container, VisitingRecorder vr) {
        if (root.getType() == 1 && !vr.visit(root.getValue().toString())) {
            return;
        }
        if (root.getDataType() != null && root.getDataType().equals(value)) {
            container.add(root);
        }
        Object[] children = root.getChildren();
        int i = 0;
        while (i < children.length) {
            XSDFileSchemaTreePopulator.findNodeWithValue((ATreeNode)children[i], value, container, vr);
            ++i;
        }
    }

    public static ATreeNode getSchemaTree(String schemafileName, String xmlFileName, boolean incAttr) throws OdaException, MalformedURLException, URISyntaxException {
        ATreeNode xmlRoot = new XMLFileSchemaTreePopulator(2).getSchemaTree(xmlFileName, includeAttribute);
        includeAttribute = incAttr;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        URI uri = null;
        File f = new File(schemafileName);
        if (f.exists()) {
            uri = f.toURI();
        } else {
            URL url = new URL(schemafileName);
            uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        }
        if (uri == null) {
            uri = new URI(schemafileName);
        }
        XMLSchemaLoader xsLoader = new XMLSchemaLoader();
        XSModel xsModel = xsLoader.loadURI(uri.toString());
        ATreeNode complexTypesRoot = XSDFileSchemaTreePopulator.populateComplexTypeTree(xsModel);
        XSNamedMap map = xsModel.getComponents((short)2);
        ATreeNode xsdRoot = new ATreeNode();
        xsdRoot.setValue("ROOT");
        int i = 0;
        while (i < map.getLength()) {
            ATreeNode node = new ATreeNode();
            XSElementDecl element = (XSElementDecl)map.item(i);
            node.setValue(element.getName());
            node.setType(1);
            node.setDataType(element.getName());
            if (element.getTypeDefinition() instanceof XSComplexTypeDecl) {
                XSComplexTypeDecl complexType = (XSComplexTypeDecl)element.getTypeDefinition();
                if (complexType.getName() != null) {
                    node.setDataType(complexType.getName());
                    ATreeNode n = XSDFileSchemaTreePopulator.findComplexElement(complexTypesRoot, complexType.getName());
                    if (n != null) {
                        node.addChild(n.getChildren());
                    }
                } else {
                    XSDFileSchemaTreePopulator.addParticleAndAttributeInfo(node, complexType, complexTypesRoot, new VisitingRecorder());
                }
            }
            xsdRoot.addChild(node);
            if (xmlRoot != null && node.getValue().equals(((ATreeNode)xmlRoot.getChildren()[0]).getValue())) {
                xsdRoot = new ATreeNode();
                xsdRoot.setValue("ROOT");
                xsdRoot.addChild(node);
                break;
            }
            ++i;
        }
        XSDFileSchemaTreePopulator.populateRoot(xsdRoot);
        return xsdRoot;
    }

    public static ATreeNode getSchemaTree(String xsdFileName, boolean incAttr) throws OdaException, MalformedURLException, URISyntaxException {
        includeAttribute = incAttr;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        URI uri = null;
        File f = new File(xsdFileName);
        if (f.exists()) {
            uri = f.toURI();
        } else {
            URL url = new URL(xsdFileName);
            uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        }
        if (uri == null) {
            uri = new URI(xsdFileName);
        }
        XMLSchemaLoader xsLoader = new XMLSchemaLoader();
        XSModel xsModel = xsLoader.loadURI(uri.toString());
        ATreeNode complexTypesRoot = XSDFileSchemaTreePopulator.populateComplexTypeTree(xsModel);
        XSNamedMap map = xsModel.getComponents((short)2);
        ATreeNode root = new ATreeNode();
        root.setValue("ROOT");
        int i = 0;
        while (i < map.getLength()) {
            ATreeNode node = new ATreeNode();
            XSElementDecl element = (XSElementDecl)map.item(i);
            node.setValue(element.getName());
            node.setType(1);
            node.setDataType(element.getName());
            if (element.getTypeDefinition() instanceof XSComplexTypeDecl) {
                XSComplexTypeDecl complexType = (XSComplexTypeDecl)element.getTypeDefinition();
                if (complexType.getName() != null) {
                    node.setDataType(complexType.getName());
                    ATreeNode n = XSDFileSchemaTreePopulator.findComplexElement(complexTypesRoot, complexType.getName());
                    if (n != null) {
                        node.addChild(n.getChildren());
                    }
                } else {
                    XSDFileSchemaTreePopulator.addParticleAndAttributeInfo(node, complexType, complexTypesRoot, new VisitingRecorder());
                }
            }
            root.addChild(node);
            ++i;
        }
        XSDFileSchemaTreePopulator.populateRoot(root);
        return root;
    }

    private static void addParticleAndAttributeInfo(ATreeNode node, XSComplexTypeDecl complexType, ATreeNode complexTypesRoot, VisitingRecorder vr) throws OdaException {
        if (!vr.visit(node.getValue().toString())) {
            return;
        }
        XSParticle particle = complexType.getParticle();
        if (particle != null) {
            XSDFileSchemaTreePopulator.addElementToNode(node, complexTypesRoot, (XSModelGroupImpl)particle.getTerm(), vr);
        }
        if (!includeAttribute) {
            return;
        }
        XSAttributeGroupDecl group = complexType.getAttrGrp();
        if (group != null) {
            XSObjectList list = group.getAttributeUses();
            int j = 0;
            while (j < list.getLength()) {
                ATreeNode childNode = new ATreeNode();
                childNode.setValue(((XSAttributeUseImpl)list.item(j)).getAttrDeclaration().getName());
                childNode.setType(2);
                node.addChild(childNode);
                ++j;
            }
        }
    }

    private static void addElementToNode(ATreeNode node, ATreeNode complexTypesRoot, XSModelGroupImpl group, VisitingRecorder vr) throws OdaException {
        if (!vr.visit(node.getValue().toString())) {
            return;
        }
        XSObjectList list = group.getParticles();
        int j = 0;
        while (j < list.getLength()) {
            if (((XSParticleDecl)list.item(j)).getTerm() instanceof XSModelGroupImpl) {
                XSDFileSchemaTreePopulator.addElementToNode(node, complexTypesRoot, (XSModelGroupImpl)((XSParticleDecl)list.item(j)).getTerm(), vr);
            } else {
                ATreeNode childNode = new ATreeNode();
                childNode.setValue(((XSParticleDecl)list.item(j)).getTerm().getName());
                String dataType = ((XSElementDecl)((XSParticleDecl)list.item(j)).getTerm()).getTypeDefinition().getName();
                if (dataType == null || dataType.length() == 0) {
                    dataType = childNode.getValue().toString();
                }
                childNode.setDataType(dataType);
                childNode.setType(1);
                XSTypeDefinition xstype = ((XSElementDecl)((XSParticleDecl)list.item(j)).getTerm()).getTypeDefinition();
                if (!dataType.equals("anyType") && xstype instanceof XSComplexTypeDecl) {
                    ATreeNode n;
                    if (xstype.getName() == null) {
                        XSDFileSchemaTreePopulator.addParticleAndAttributeInfo(childNode, (XSComplexTypeDecl)xstype, complexTypesRoot, vr);
                    }
                    if ((n = XSDFileSchemaTreePopulator.findComplexElement(complexTypesRoot, dataType)) != null) {
                        childNode.addChild(n.getChildren());
                    }
                }
                node.addChild(childNode);
            }
            ++j;
        }
    }

    private static ATreeNode findComplexElement(ATreeNode root, String value) {
        Object[] os = root.getChildren();
        int i = 0;
        while (i < os.length) {
            if (((ATreeNode)os[i]).getValue().equals(value)) {
                return (ATreeNode)os[i];
            }
            ++i;
        }
        return null;
    }

    private static ATreeNode populateComplexTypeTree(XSModel xsModel) throws OdaException {
        XSNamedMap map = xsModel.getComponents((short)15);
        ATreeNode root = new ATreeNode();
        root.setValue("ROOT");
        root.setDataType("");
        int i = 0;
        while (i < map.getLength()) {
            ATreeNode node = new ATreeNode();
            XSComplexTypeDecl element = (XSComplexTypeDecl)map.item(i);
            if (!element.getName().equals("anyType")) {
                XSAttributeGroupDecl group;
                node.setValue(element.getName());
                node.setType(1);
                node.setDataType(element.getTypeName());
                root.addChild(node);
                XSParticle particle = element.getParticle();
                if (particle != null) {
                    XSObjectList list = ((XSModelGroupImpl)particle.getTerm()).getParticles();
                    XSDFileSchemaTreePopulator.populateTreeNodeWithParticles(node, list);
                }
                if (includeAttribute && (group = element.getAttrGrp()) != null) {
                    XSObjectList list = group.getAttributeUses();
                    int j = 0;
                    while (j < list.getLength()) {
                        ATreeNode childNode = new ATreeNode();
                        childNode.setValue(((XSAttributeUseImpl)list.item(j)).getAttrDeclaration().getName());
                        childNode.setType(2);
                        node.addChild(childNode);
                        ++j;
                    }
                }
            }
            ++i;
        }
        XSDFileSchemaTreePopulator.populateRoot(root);
        return root;
    }

    private static void populateTreeNodeWithParticles(ATreeNode node, XSObjectList list) throws OdaException {
        int j = 0;
        while (j < list.getLength()) {
            ATreeNode childNode = new ATreeNode();
            childNode.setValue(((XSParticleDecl)list.item(j)).getTerm().getName());
            if (((XSParticleDecl)list.item(j)).getTerm() instanceof XSElementDecl) {
                String dataType = ((XSElementDecl)((XSParticleDecl)list.item(j)).getTerm()).getTypeDefinition().getName();
                if (dataType == null || dataType.length() == 0) {
                    dataType = childNode.getValue().toString();
                }
                childNode.setDataType(dataType);
                childNode.setType(1);
                node.addChild(childNode);
            } else if (((XSParticleDecl)list.item(j)).getTerm() instanceof XSModelGroupImpl) {
                XSModelGroupImpl mGroup = (XSModelGroupImpl)((XSParticleDecl)list.item(j)).getTerm();
                XSObjectList obs = mGroup.getParticles();
                XSDFileSchemaTreePopulator.populateTreeNodeWithParticles(node, obs);
            }
            ++j;
        }
    }
}

