/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.model.validation;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseColumn;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseForeignKey;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABasePrimaryKey;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseUniqueConstraint;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseasabasesqlmodelPackage;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.ExamplePlugin;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.model.validation.Messages;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.model.validation.SybaseASABaseConstraintValidator;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils.ASAIdentifierValidator;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils.SQLUtil;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.modelvalidity.DefaultSQLModelValidator;
import org.eclipse.datatools.sqltools.core.modelvalidity.SQLModelValidationDelegate;
import org.eclipse.datatools.sqltools.core.services.ConnectionService;
import org.eclipse.datatools.sqltools.sql.identifier.IIdentifierValidator;
import org.eclipse.datatools.sqltools.sql.identifier.ValidatorMessage;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;

public class SybaseASABaseTableValidator
extends DefaultSQLModelValidator {
    protected boolean validateAttribute(EObject eObject, int featureId, DiagnosticChain diagnostics, Map sharedParams) {
        boolean isValid;
        block31: {
            isValid = true;
            BaseTable table = (BaseTable)eObject;
            if (featureId == 1) {
                IIdentifierValidator identifierValidator = ASAIdentifierValidator.getInstance();
                DatabaseIdentifier databaseIdentifier = (DatabaseIdentifier)sharedParams.get("didentifier");
                if (table.getName() == null || table.getName().equals("")) {
                    isValid = false;
                    BasicDiagnostic d = new BasicDiagnostic(1, Integer.toString(1), 1000, Messages.SybaseASABaseTableValidator_No_table_name_present, new Object[]{SybaseasabasesqlmodelPackage.eINSTANCE.getSybaseASABaseTable()});
                    diagnostics.add((Diagnostic)d);
                } else if (databaseIdentifier != null) {
                    ValidatorMessage msg = identifierValidator.isValid(SQLUtil.quoteWhenNecessary(table.getName(), databaseIdentifier), 0, databaseIdentifier);
                    if (msg != null && msg.getType() != 0) {
                        isValid = false;
                        BasicDiagnostic d = new BasicDiagnostic(4, Integer.toString(1), 1001, String.valueOf(NLS.bind((String)Messages.SybaseASABaseTableValidator_for_table, (Object)table.getName())) + msg.getMessage(), new Object[]{SybaseasabasesqlmodelPackage.eINSTANCE.getSybaseASABaseTable()});
                        diagnostics.add((Diagnostic)d);
                    } else if (this._currentItemContext.get("validate_duplicate_name_via_db") != null) {
                        Statement newSt = null;
                        Connection conn = null;
                        ResultSet rs = null;
                        ConnectionService connServ = SQLToolsFacade.getConnectionService((DatabaseIdentifier)databaseIdentifier);
                        try {
                            try {
                                conn = connServ.createConnection(databaseIdentifier, true);
                                StringBuffer sql = new StringBuffer("");
                                sql.append("select * from systable where table_name = '").append(table.getName()).append("'");
                                sql.append("and creator in (select user_id from sysuserperms where user_name = '").append(table.getSchema().getName()).append("')");
                                newSt = conn.createStatement();
                                rs = newSt.executeQuery(sql.toString());
                                if (rs.next()) {
                                    isValid = false;
                                    BasicDiagnostic d = new BasicDiagnostic(4, Integer.toString(1), 1002, NLS.bind((String)Messages.Table_Duplicate_Name_Error, (Object)table.getName()), new Object[]{SybaseasabasesqlmodelPackage.eINSTANCE.getSybaseASABaseTable()});
                                    diagnostics.add((Diagnostic)d);
                                }
                            }
                            catch (Exception exception) {
                                ExamplePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples", Messages.Database_Error));
                                try {
                                    rs.close();
                                }
                                catch (Exception exception2) {}
                                try {
                                    newSt.close();
                                }
                                catch (Exception exception3) {}
                                try {
                                    connServ.closeConnection(conn, SQLToolsFacade.getConnectionId((DatabaseIdentifier)databaseIdentifier, (Connection)conn), databaseIdentifier);
                                }
                                catch (Exception exception4) {}
                                break block31;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                rs.close();
                            }
                            catch (Exception exception) {}
                            try {
                                newSt.close();
                            }
                            catch (Exception exception) {}
                            try {
                                connServ.closeConnection(conn, SQLToolsFacade.getConnectionId((DatabaseIdentifier)databaseIdentifier, (Connection)conn), databaseIdentifier);
                            }
                            catch (Exception exception) {}
                            throw throwable;
                        }
                        try {
                            rs.close();
                        }
                        catch (Exception exception) {}
                        try {
                            newSt.close();
                        }
                        catch (Exception exception) {}
                        try {
                            connServ.closeConnection(conn, SQLToolsFacade.getConnectionId((DatabaseIdentifier)databaseIdentifier, (Connection)conn), databaseIdentifier);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        return isValid;
    }

    protected boolean validateReference(EObject eObject, int featureId, DiagnosticChain diagnostics, Map sharedParams) {
        boolean isValid = true;
        BaseTable table = (BaseTable)eObject;
        if (featureId == 17 && this._containmentItem != null) {
            boolean isPartScope = true;
            boolean checkPK = false;
            boolean checkFK = false;
            boolean checkUnique = false;
            Map pkContext = null;
            Map fkContext = null;
            Map uniqueContext = null;
            SybaseASABasePrimaryKey pk = (SybaseASABasePrimaryKey)table.getPrimaryKey();
            List fks = table.getForeignKeys();
            List uniques = table.getUniqueConstraints();
            if (this._containmentItem.getContext().get("vscope").equals("vscopecomplete")) {
                isPartScope = false;
            }
            if (!isPartScope) {
                checkPK = true;
                checkFK = true;
                checkUnique = true;
                pkContext = (Map)((HashMap)this._containmentItem.getContext()).clone();
                this._containmentItem.getContext().put("validator", new SybaseASABaseConstraintValidator());
                fkContext = (Map)((HashMap)this._containmentItem.getContext()).clone();
                this._containmentItem.getContext().put("validator", new SybaseASABaseConstraintValidator());
                uniqueContext = (Map)((HashMap)this._containmentItem.getContext()).clone();
            } else {
                if (this._containmentItem.getContext().get("vpk") != null) {
                    pkContext = (Map)this._containmentItem.getContext().get("vpk");
                    checkPK = true;
                }
                if (this._containmentItem.getContext().get("vfk") != null) {
                    fkContext = (Map)this._containmentItem.getContext().get("vfk");
                    checkFK = true;
                }
                if (this._containmentItem.getContext().get("vunique") != null) {
                    uniqueContext = (Map)this._containmentItem.getContext().get("vunique");
                    checkUnique = true;
                }
            }
            if (pk != null && checkPK && pkContext != null) {
                isValid &= SQLModelValidationDelegate.getInstance().validate((EObject)pk, diagnostics, pkContext, sharedParams);
            }
            if (fks != null && checkFK && fkContext != null) {
                for (SybaseASABaseForeignKey fk : fks) {
                    isValid &= SQLModelValidationDelegate.getInstance().validate((EObject)fk, diagnostics, fkContext, sharedParams);
                }
            }
            if (uniques != null && checkUnique && uniqueContext != null) {
                for (SybaseASABaseUniqueConstraint unique : uniques) {
                    isValid &= SQLModelValidationDelegate.getInstance().validate((EObject)unique, diagnostics, uniqueContext, sharedParams);
                }
            }
        }
        if (featureId == 7) {
            if (table.getColumns().size() == 0) {
                isValid = false;
                BasicDiagnostic d = new BasicDiagnostic(1, Integer.toString(7), 1, NLS.bind((String)Messages.SybaseASABaseTableValidator_No_column_defined, (Object)table.getName()), new Object[0]);
                diagnostics.add((Diagnostic)d);
            } else if (this._depth > 0) {
                Iterator iter = table.getColumns().iterator();
                while (iter.hasNext()) {
                    if (Thread.interrupted()) {
                        return isValid;
                    }
                    SybaseASABaseColumn column = (SybaseASABaseColumn)iter.next();
                    isValid &= SQLModelValidationDelegate.getInstance().validate((EObject)column, diagnostics, this._containmentItem.getContext(), sharedParams);
                }
            }
            ArrayList<String> names = new ArrayList<String>();
            for (SybaseASABaseColumn column : table.getColumns()) {
                names.add(column.getName());
            }
            String duplicateName = "";
            String[] ns = names.toArray(new String[names.size()]);
            int i = 0;
            while (i < ns.length) {
                boolean isDuplicate = false;
                String cname = ns[i];
                int j = i + 1;
                while (j < ns.length) {
                    if (j == ns.length) break;
                    if (cname != null && ns[j] != null && !cname.equals("") && cname.toLowerCase().equals(ns[j].toLowerCase())) {
                        duplicateName = cname;
                        isDuplicate = true;
                        break;
                    }
                    ++j;
                }
                if (isDuplicate) {
                    isValid = false;
                    BasicDiagnostic d = new BasicDiagnostic(4, Integer.toString(7), 1002, NLS.bind((String)Messages.SybaseASABaseTableValidator_Duplicate_column_name, (Object)duplicateName), new Object[0]);
                    diagnostics.add((Diagnostic)d);
                }
                ++i;
            }
        }
        return isValid;
    }
}

