/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.ui.wizards;

import java.util.Arrays;
import java.util.List;
import org.eclipse.datatools.enablement.oda.xml.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.ui.utils.XMLRelationInfoUtil;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.ColumnMappingElement;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.DataTypeUtil;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.StyledCCombo;
import org.eclipse.datatools.enablement.oda.xml.util.ui.XPathPopulationUtil;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ColumnMappingDialog
extends TrayDialog {
    private static final String EMPTY_STRING = "";
    private String title;
    private Combo typeCombo;
    private String columnName;
    private String xpath;
    private String type;
    private Text columnNameText;
    private Button absolutePathButton;
    private Button anyLocationButton;
    private Button customButton;
    private StyledCCombo xmlPathCombo;
    private StyledText xmlPathText;
    private Menu quickFixMenu;
    private List xpathList;
    private boolean isMappingMode;
    private static String[] dataTypeDisplayNames = new String[]{Messages.getString("datatypes.dateTime"), Messages.getString("datatypes.decimal"), Messages.getString("datatypes.float"), Messages.getString("datatypes.integer"), Messages.getString("datatypes.date"), Messages.getString("datatypes.time"), Messages.getString("datatypes.string"), Messages.getString("datatypes.boolean")};

    public ColumnMappingDialog(Shell parent, String title, String selectedItem, String xpath, int dataType, boolean isMappingMode) {
        super(parent);
        this.initializeDialogInfos(title, selectedItem, xpath, dataType, isMappingMode);
    }

    private void initializeDialogInfos(String title, String selectedItem, String xpath, int dataType, boolean isMappingMode) {
        this.title = title;
        this.columnName = selectedItem == null ? EMPTY_STRING : selectedItem;
        this.xpath = xpath == null ? EMPTY_STRING : xpath;
        this.type = DataTypeUtil.getDataTypeDisplayName(dataType);
        this.isMappingMode = isMappingMode;
        this.xpathList = isMappingMode ? XPathPopulationUtil.getPathList((String)xpath) : null;
        Arrays.sort(dataTypeDisplayNames);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        Composite panel = (Composite)super.createDialogArea(parent);
        Composite labelComposite = new Composite(panel, 0);
        GridLayout labelLayout = new GridLayout();
        labelLayout.marginLeft = 15;
        labelLayout.marginRight = 10;
        labelLayout.marginBottom = 0;
        labelLayout.marginTop = 0;
        labelComposite.setLayout((Layout)labelLayout);
        Label label = new Label(labelComposite, 0);
        label.setText(Messages.getString("ColumnMappingDialog.dialog.info"));
        GridData labelGd = new GridData(768);
        label.setLayoutData((Object)labelGd);
        Composite composite = new Composite(panel, 0);
        GridData gd = new GridData();
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Composite topComposite = new Composite(composite, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        topLayout.marginWidth = 15;
        topLayout.marginBottom = 5;
        topLayout.verticalSpacing = 8;
        topComposite.setLayout((Layout)topLayout);
        GridData gridData = new GridData(768);
        topComposite.setLayoutData((Object)gridData);
        this.setupTopComposite(topComposite);
        if (this.isMappingMode) {
            this.setupButtonComposite(composite);
        } else {
            this.setupCustomExprArea(topComposite);
        }
        return composite;
    }

    private void setupTopComposite(Composite topComposite) {
        GridData comboData = new GridData();
        comboData.widthHint = 320;
        GridData labelData = new GridData();
        Label label = new Label(topComposite, 0);
        label.setText(Messages.getString("ColumnMappingDialog.info.columnName"));
        label.setLayoutData((Object)labelData);
        labelData.widthHint = label.getSize().x > 100 ? label.getSize().x : 100;
        this.columnNameText = new Text(topComposite, 2048);
        this.columnNameText.setLayoutData((Object)comboData);
        this.columnNameText.setText(this.columnName);
        this.columnNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ColumnMappingDialog.this.columnName = ColumnMappingDialog.this.columnNameText.getText();
                ColumnMappingDialog.this.updateOKbuttonState();
            }
        });
        labelData = new GridData();
        Label label2 = new Label(topComposite, 0);
        label2.setText(Messages.getString("ColumnMappingDialog.info.dataType"));
        label2.setLayoutData((Object)labelData);
        labelData.widthHint = label2.getSize().x > 100 ? label2.getSize().x : 100;
        this.typeCombo = new Combo(topComposite, 12);
        int typeIndex = -1;
        int stringIndex = -1;
        int i = 0;
        while (i < dataTypeDisplayNames.length) {
            this.typeCombo.add(dataTypeDisplayNames[i]);
            if (dataTypeDisplayNames[i].equals(this.type)) {
                typeIndex = i;
            } else if (dataTypeDisplayNames[i].equals(Messages.getString("datatypes.string"))) {
                stringIndex = i;
            }
            ++i;
        }
        if (typeIndex == -1) {
            typeIndex = stringIndex;
        }
        this.columnNameText.setLayoutData((Object)comboData);
        this.typeCombo.setLayoutData((Object)comboData);
        this.typeCombo.select(typeIndex);
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ColumnMappingDialog.this.typeCombo.getSelectionIndex();
                ColumnMappingDialog.this.columnName = ColumnMappingDialog.this.typeCombo.getItem(index);
            }
        });
        XMLRelationInfoUtil.setSystemHelp((Control)topComposite, "org.eclipse.datatools.oda.cshelp.Dialog_ColumnMapping_ID");
    }

    private void setupCustomExprArea(Composite parent) {
        GridData labelData = new GridData();
        Label customLabel = new Label(parent, 64);
        customLabel.setText(Messages.getString("ColumnMappingDialog.info.xPath"));
        customLabel.setLayoutData((Object)labelData);
        GridData textData = new GridData(768);
        textData.widthHint = 320;
        this.xmlPathText = new StyledText(parent, 2048);
        this.xmlPathText.setText(TextProcessor.process((String)this.xpath, (String)"//"));
        this.xmlPathText.setLayoutData((Object)textData);
        this.createQuickFixMenu(this.xmlPathText);
        this.xmlPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ColumnMappingDialog.this.xpath = ColumnMappingDialog.this.xmlPathText.getText();
            }
        });
        this.xmlPathText.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent event) {
                ColumnMappingDialog.this.quickFixMenu.setLocation(event.x, event.y);
                ColumnMappingDialog.this.quickFixMenu.setVisible(true);
                ColumnMappingDialog.this.updateMenuItemStatus(ColumnMappingDialog.this.xmlPathText);
            }
        });
    }

    private void createQuickFixMenu(final StyledText text) {
        this.quickFixMenu = new Menu((Control)text);
        MenuItem createItem = new MenuItem(this.quickFixMenu, 8);
        createItem.setText(Messages.getString("ColumnMappingDialog.MenuItem.CreateParameter"));
        createItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ColumnMappingDialog.this.createXMLParameter(text);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        MenuItem deleteItem = new MenuItem(this.quickFixMenu, 8);
        deleteItem.setText(Messages.getString("ColumnMappingDialog.MenuItem.DeleteParameter"));
        deleteItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ColumnMappingDialog.this.deleteXMLParameter(text);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.updateMenuItemStatus(text);
    }

    private void updateMenuItemStatus(StyledText text) {
        String selectionText = text.getSelectionText().trim();
        boolean deleteEnabled = selectionText.length() > 0 && selectionText.startsWith("{?") && selectionText.endsWith("?}");
        this.quickFixMenu.getItem(0).setEnabled(selectionText.length() > 0 && !deleteEnabled);
        this.quickFixMenu.getItem(1).setEnabled(deleteEnabled);
    }

    ColumnMappingElement getColumnMapping() {
        ColumnMappingElement columnEle = new ColumnMappingElement();
        columnEle.setColumnName(this.columnName);
        columnEle.setXPath(this.xpath);
        columnEle.setType(this.type);
        return columnEle;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.columnName = this.columnNameText.getText();
            this.type = this.typeCombo.getItem(this.typeCombo.getSelectionIndex());
        }
        super.buttonPressed(buttonId);
    }

    private void setupButtonComposite(Composite composite) {
        Composite wrap = new Composite(composite, 0);
        GridLayout wrapLayout = new GridLayout();
        wrapLayout.marginLeft = 10;
        wrapLayout.marginRight = 15;
        wrap.setLayout((Layout)wrapLayout);
        Group exprBtnGroup = new Group(wrap, 0);
        exprBtnGroup.setText(Messages.getString("ColumnMappingDialog.group.message"));
        GridData gridData = new GridData(768);
        exprBtnGroup.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginLeft = 5;
        layout.verticalSpacing = 8;
        exprBtnGroup.setLayout((Layout)layout);
        GridData buttonGd = new GridData(768);
        buttonGd.horizontalSpan = 2;
        this.absolutePathButton = new Button((Composite)exprBtnGroup, 80);
        this.absolutePathButton.setLayoutData((Object)buttonGd);
        this.absolutePathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ColumnMappingDialog.this.absolutePathButton.getSelection()) {
                    ColumnMappingDialog.this.xpath = ColumnMappingDialog.this.xpathList.get(0).toString();
                    ColumnMappingDialog.this.absolutePathButton.setSelection(true);
                    ColumnMappingDialog.this.anyLocationButton.setSelection(false);
                    ColumnMappingDialog.this.customButton.setSelection(false);
                    ColumnMappingDialog.this.xmlPathCombo.setEnabled(false);
                    ColumnMappingDialog.this.xmlPathCombo.setText(TextProcessor.process((String)ColumnMappingDialog.this.xpathList.get(0).toString(), (String)"//"));
                }
            }
        });
        this.anyLocationButton = new Button((Composite)exprBtnGroup, 80);
        this.anyLocationButton.setLayoutData((Object)buttonGd);
        this.anyLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ColumnMappingDialog.this.anyLocationButton.getSelection()) {
                    ColumnMappingDialog.this.xpath = ColumnMappingDialog.this.xpathList.get(1).toString();
                    ColumnMappingDialog.this.anyLocationButton.setSelection(true);
                    ColumnMappingDialog.this.absolutePathButton.setSelection(false);
                    ColumnMappingDialog.this.customButton.setSelection(false);
                    ColumnMappingDialog.this.xmlPathCombo.setEnabled(false);
                    ColumnMappingDialog.this.xmlPathCombo.setText(TextProcessor.process((String)ColumnMappingDialog.this.xpathList.get(1).toString(), (String)"//"));
                }
            }
        });
        this.setBtnTextValues((Composite)exprBtnGroup);
        GridData customData = new GridData(832);
        customData.horizontalSpan = 2;
        this.customButton = new Button((Composite)exprBtnGroup, 80);
        this.customButton.setLayoutData((Object)customData);
        this.customButton.setText(Messages.getString("xPathChoosePage.messages.elementSelection.item.custom"));
        this.customButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ColumnMappingDialog.this.customButton.getSelection()) {
                    ColumnMappingDialog.this.xmlPathCombo.setEnabled(true);
                }
            }
        });
        GridData blankButtonData = new GridData();
        blankButtonData.horizontalSpan = 1;
        Button blankButton = new Button((Composite)exprBtnGroup, 0);
        blankButton.setData((Object)blankButtonData);
        blankButton.setVisible(false);
        GridData txtGridData = new GridData();
        txtGridData.horizontalSpan = 1;
        txtGridData.widthHint = 420;
        this.xmlPathCombo = new StyledCCombo((Composite)exprBtnGroup, 2052);
        this.xmlPathCombo.setLayoutData(txtGridData);
        this.xmlPathCombo.setVisible(true);
        this.setupCustomXMLPathField();
        this.createQuickFixMenu(this.xmlPathCombo.getStyledText());
        this.xmlPathCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.xmlPathCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ColumnMappingDialog.this.xpath = ColumnMappingDialog.this.xmlPathCombo.getText();
            }
        });
        this.xmlPathCombo.getStyledText().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent event) {
                ColumnMappingDialog.this.quickFixMenu.setLocation(event.x, event.y);
                ColumnMappingDialog.this.quickFixMenu.setVisible(true);
                ColumnMappingDialog.this.updateMenuItemStatus(ColumnMappingDialog.this.xmlPathCombo.getStyledText());
            }
        });
        if (this.xpathList != null && this.xpathList.size() > 0) {
            this.absolutePathButton.setSelection(true);
            this.xmlPathCombo.setEnabled(false);
        } else {
            this.customButton.setSelection(true);
        }
    }

    private void setBtnTextValues(Composite composite) {
        if (this.xpathList == null) {
            this.absolutePathButton.setText(Messages.getString("xPathChoosePage.messages.elementSelection.disable.absolutePath"));
            this.anyLocationButton.setText(Messages.getString("xPathChoosePage.messages.elementSelection.disable.anyLocation"));
            this.setButtonsEnabled(false);
            return;
        }
        if (this.xpathList.size() >= 2) {
            this.absolutePathButton.setText(Messages.getFormattedString("xPathChoosePage.messages.elementSelection.disable.absolutePath", new String[]{this.columnName}));
            this.anyLocationButton.setText(Messages.getFormattedString("xPathChoosePage.messages.elementSelection.item.anyLocation", new String[]{this.columnName}));
            this.setButtonsEnabled(true);
        } else {
            this.absolutePathButton.setText(Messages.getString("xPathChoosePage.messages.elementSelection.disable.absolutePath"));
            this.anyLocationButton.setText(Messages.getString("xPathChoosePage.messages.elementSelection.disable.anyLocation"));
            this.setButtonsEnabled(false);
        }
        composite.layout();
    }

    private void setButtonsEnabled(boolean enabled) {
        this.absolutePathButton.setEnabled(enabled);
        this.anyLocationButton.setEnabled(enabled);
    }

    private void setupCustomXMLPathField() {
        if (this.xpathList == null || this.xpathList.size() < 2) {
            this.xmlPathCombo.setText(EMPTY_STRING);
            this.setButtonsEnabled(false);
            return;
        }
        this.xmlPathCombo.setText(TextProcessor.process((String)this.xpathList.get(0).toString(), (String)"//"));
        this.xmlPathCombo.add(TextProcessor.process((String)this.xpathList.get(0).toString(), (String)"//"));
        this.xmlPathCombo.add(TextProcessor.process((String)this.xpathList.get(1).toString(), (String)"//"));
        this.xpath = this.xmlPathCombo.getText();
    }

    private void updateOKbuttonState() {
        if (this.columnName == null || this.columnName.trim().length() == 0) {
            this.enableOKButton(false);
        } else {
            this.enableOKButton(true);
        }
    }

    private void enableOKButton(boolean enabled) {
        Button okBtn = this.getButton(0);
        if (okBtn != null) {
            okBtn.setEnabled(enabled);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.updateOKbuttonState();
        return control;
    }

    private void createXMLParameter(StyledText text) {
        String selectedValue = text.getSelectionText();
        String changedValue = "{?" + selectedValue + "?}";
        this.resetXPathText(text, changedValue);
    }

    private void resetXPathText(StyledText text, String changedValue) {
        String xpathString = text.getText().trim();
        String result = String.valueOf(xpathString.substring(0, text.getSelection().x)) + changedValue + xpathString.substring(text.getSelection().y);
        text.setText(result);
    }

    private void deleteXMLParameter(StyledText text) {
        String selectedValue = text.getSelectionText();
        String changedValue = selectedValue.substring(2, selectedValue.length() - 2);
        this.resetXPathText(text, changedValue);
    }
}

