/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.derby.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;
import org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogDatabase;
import org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogPrimaryKey;
import org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogSchema;
import org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogTable;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.RefreshManager;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.impl.ForeignKeyImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DerbyCatalogForeignKey
extends ForeignKeyImpl
implements ICatalogObject {
    private static final long serialVersionUID = 3257285837955086384L;
    private boolean eAnnotationLoaded = false;
    private boolean uniqueConstraintLoaded = false;

    public void refresh() {
        this.eAnnotationLoaded = false;
        this.uniqueConstraintLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public EList getEAnnotations() {
        if (!this.eAnnotationLoaded) {
            this.loadEAnnotations();
        }
        return this.eAnnotations;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((DerbyCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getBaseTable().getSchema().getDatabase();
    }

    public UniqueConstraint getUniqueConstraint() {
        if (!this.uniqueConstraintLoaded) {
            this.loadUniqueConstraint();
        }
        return this.uniqueConstraint;
    }

    public EList getMembers() {
        if (!this.uniqueConstraintLoaded) {
            this.loadUniqueConstraint();
        }
        return this.members;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 0) {
            this.getEAnnotations();
        } else if (id == 13) {
            this.getUniqueConstraint();
        } else if (id == 9) {
            this.getMembers();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadEAnnotations() {
        if (this.eAnnotationLoaded) {
            return;
        }
        this.eAnnotationLoaded = true;
        EList memberList = super.getEAnnotations();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        DerbyCatalogForeignKey.setAsIdentifyingRelatinship((ForeignKey)this, this.isIdentifyingRelationship(super.getMembers()));
        this.eSetDeliver(deliver);
    }

    private synchronized void loadUniqueConstraint() {
        if (this.uniqueConstraintLoaded) {
            return;
        }
        this.uniqueConstraintLoaded = true;
        Connection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            BaseTable table = this.getBaseTable();
            Schema schema = table.getSchema();
            String query = "SELECT PK.CONSTRAINTNAME, PT.TABLENAME, PS.SCHEMANAME FROM SYS.SYSFOREIGNKEYS R, SYS.SYSCONSTRAINTS FK, SYS.SYSTABLES FT, SYS.SYSSCHEMAS FS, SYS.SYSCONSTRAINTS PK, SYS.SYSTABLES PT, SYS.SYSSCHEMAS PS WHERE R.CONSTRAINTID = FK.CONSTRAINTID AND R.KEYCONSTRAINTID = PK.CONSTRAINTID AND FK.TABLEID = FT.TABLEID AND FT.SCHEMAID = FS.SCHEMAID AND FS.SCHEMANAME='" + schema.getName() + "'" + " AND FT.TABLENAME='" + table.getName() + "'" + " AND FK.CONSTRAINTNAME='" + this.getName() + "'" + " AND PK.TABLEID = PT.TABLEID" + " AND PT.SCHEMAID = PS.SCHEMAID";
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String refKeyName = r.getString("CONSTRAINTNAME");
                String refTabSchema = r.getString("SCHEMANAME").trim();
                String refTabName = r.getString("TABLENAME");
                UniqueConstraint uk = this.getConstraint(refTabSchema, refTabName, refKeyName);
                this.setUniqueConstraint(uk);
                this.loadMembers(connection, uk);
            }
            r.close();
            s.close();
            this.loadEAnnotations();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadMembers(Connection connection, UniqueConstraint uk) {
        try {
            EList members = super.getMembers();
            ResultSet r = connection.getMetaData().getExportedKeys(null, uk.getBaseTable().getSchema().getName(), uk.getBaseTable().getName());
            BaseTable table = this.getBaseTable();
            Schema schema = table.getSchema();
            while (r.next()) {
                String fkSchema_Name = r.getString(6);
                String fkTable_Name = r.getString(7);
                String fkName = r.getString(12);
                if (!fkSchema_Name.equals(schema.getName()) || !fkTable_Name.equals(table.getName()) || !fkName.equals(this.getName())) continue;
                String columnName = r.getString(8);
                Column column = DerbyCatalogTable.getColumn((Table)table, columnName);
                members.add((Object)column);
            }
            r.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setAsIdentifyingRelatinship(ForeignKey fk, boolean identifying) {
        EAnnotation eAnnotation = fk.addEAnnotation(RDBCorePlugin.FK_MODELING_RELATIONSHIP);
        fk.addEAnnotationDetail(eAnnotation, RDBCorePlugin.FK_IS_IDENTIFYING_RELATIONSHIP, new Boolean(identifying).toString());
        fk.addEAnnotationDetail(eAnnotation, RDBCorePlugin.FK_CHILD_MULTIPLICITY, RDBCorePlugin.MANY);
        fk.addEAnnotationDetail(eAnnotation, RDBCorePlugin.FK_CHILD_ROLE_NAME, new String());
        fk.addEAnnotationDetail(eAnnotation, RDBCorePlugin.FK_PARENT_MULTIPLICITY, fk.getMembers().size() > 0 ? RDBCorePlugin.ZERO_TO_ONE : RDBCorePlugin.ONE);
        fk.addEAnnotationDetail(eAnnotation, RDBCorePlugin.FK_PARENT_ROLE_NAME, new String());
    }

    private boolean isIdentifyingRelationship(EList columns) {
        boolean isIdentifying = true;
        Iterator it = columns.iterator();
        while (it.hasNext()) {
            Column column = (Column)it.next();
            if (column.isPartOfPrimaryKey()) continue;
            isIdentifying = false;
            break;
        }
        return isIdentifying;
    }

    private Schema getSchema(String schemaName) {
        Schema s = this.getBaseTable().getSchema();
        if (s.getName().equals(schemaName)) {
            return s;
        }
        Database d = s.getDatabase();
        Iterator it = d.getSchemas().iterator();
        while (it.hasNext()) {
            s = (Schema)it.next();
            if (!s.getName().equals(schemaName)) continue;
            return s;
        }
        DerbyCatalogSchema schema = new DerbyCatalogSchema();
        schema.setName(schemaName);
        schema.setDatabase(d);
        return schema;
    }

    private Table getTable(String schemaName, String tableName) {
        Object table;
        Schema schema = this.getSchema(schemaName);
        Iterator it = schema.getTables().iterator();
        while (it.hasNext()) {
            table = (Table)it.next();
            if (!table.getName().equals(tableName)) continue;
            return table;
        }
        table = new DerbyCatalogTable();
        table.setName(tableName);
        table.setSchema(schema);
        return table;
    }

    private UniqueConstraint getConstraint(String schemaName, String tableName, String constraintName) {
        BaseTable table = (BaseTable)this.getTable(schemaName, tableName);
        Iterator it = table.getConstraints().iterator();
        while (it.hasNext()) {
            Constraint constraint = (Constraint)it.next();
            if (!constraint.getName().equals(constraintName)) continue;
            return (UniqueConstraint)constraint;
        }
        DerbyCatalogPrimaryKey uniqueConstrain = new DerbyCatalogPrimaryKey();
        uniqueConstrain.setName(constraintName);
        uniqueConstrain.setBaseTable(table);
        return uniqueConstrain;
    }
}

