/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.derby.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;
import org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogDatabase;
import org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogSchema;
import org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogTable;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.RefreshManager;
import org.eclipse.datatools.modelbase.derby.impl.SynonymImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DerbyCatalogSynonym
extends SynonymImpl
implements ICatalogObject {
    private static final long serialVersionUID = 3257804259579074800L;
    private boolean aliasedTableLoaded = false;
    private boolean columnsLoaded = false;

    public void refresh() {
        this.columnsLoaded = false;
        this.aliasedTableLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((DerbyCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public EList getColumns() {
        if (!this.columnsLoaded) {
            this.loadColumns();
        }
        return this.columns;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 5) {
            this.getColumns();
        } else if (id == 3) {
            this.getDescription();
        } else if (id == 15) {
            this.getAliasedTable();
        } else if (id == 5) {
            this.getColumns();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadColumns() {
        if (this.columnsLoaded) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            DerbyCatalogTable.loadColumns(this.getConnection(), super.getColumns(), this.getAliasedTable());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.columnsLoaded = true;
        this.eSetDeliver(deliver);
    }

    public Table getAliasedTable() {
        if (!this.aliasedTableLoaded) {
            this.loadAliasedTable();
        }
        return this.table;
    }

    static Column getColumn(Table table, String columnName) {
        Iterator it = table.getColumns().iterator();
        while (it.hasNext()) {
            Column c = (Column)it.next();
            if (!c.getName().equals(columnName)) continue;
            return c;
        }
        return null;
    }

    private Schema getSchema(String schemaName) {
        Schema s = this.getSchema();
        if (s.getName().equals(schemaName)) {
            return s;
        }
        Database d = s.getDatabase();
        Iterator it = d.getSchemas().iterator();
        while (it.hasNext()) {
            s = (Schema)it.next();
            if (!s.getName().equals(schemaName)) continue;
            return s;
        }
        DerbyCatalogSchema schema = new DerbyCatalogSchema();
        schema.setName(schemaName);
        schema.setDatabase(d);
        return schema;
    }

    private Table getTable(String schemaName, String tableName) {
        Object table;
        Schema schema = this.getSchema(schemaName);
        Iterator it = schema.getTables().iterator();
        while (it.hasNext()) {
            table = (Table)it.next();
            if (!table.getName().equals(tableName)) continue;
            return table;
        }
        table = new DerbyCatalogTable();
        table.setName(tableName);
        table.setSchema(schema);
        return table;
    }

    private synchronized void loadAliasedTable() {
        if (this.aliasedTableLoaded) {
            return;
        }
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            String query = "SELECT TABLENAME,TABLETYPE FROM SYS.SYSTABLES A,SYS.SYSSCHEMAS B WHERE A.SCHEMAID=B.SCHEMAID AND TABLETYPE='A'";
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String tableName = r.getString("TABLENAME");
                this.setTable(this.getTable(this.getSchema().getName(), tableName));
                this.aliasedTableLoaded = true;
            }
            r.close();
            s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.eSetDeliver(deliver);
    }
}

