/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.derby.catalog;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogColumn;
import org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogDatabase;
import org.eclipse.datatools.connectivity.internal.derby.ddl.DerbyDdlParser;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.RefreshManager;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.expressions.QueryExpression;
import org.eclipse.datatools.modelbase.sql.expressions.SQLExpressionsPackage;
import org.eclipse.datatools.modelbase.sql.expressions.ValueExpression;
import org.eclipse.datatools.modelbase.sql.expressions.ValueExpressionDefault;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.CheckType;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.datatools.modelbase.sql.tables.impl.ViewTableImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DerbyCatalogView
extends ViewTableImpl
implements ICatalogObject {
    private static final long serialVersionUID = 3258125856181269553L;
    private boolean columnsLoaded = false;
    private boolean viewLoaded = false;

    public void refresh() {
        this.columnsLoaded = false;
        this.viewLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((DerbyCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public EList getColumns() {
        if (!this.columnsLoaded) {
            this.loadColumns();
        }
        return this.columns;
    }

    public QueryExpression getQueryExpression() {
        if (!this.viewLoaded) {
            this.loadView();
        }
        return this.queryExpression;
    }

    public CheckType getCheckType() {
        if (!this.viewLoaded) {
            this.loadView();
        }
        return this.checkType;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 5) {
            this.getColumns();
        }
        if (id == 16) {
            this.getCheckType();
        }
        if (id == 15) {
            this.getQueryExpression();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadColumns() {
        if (this.columnsLoaded) {
            return;
        }
        EList columnList = super.getColumns();
        columnList.clear();
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            DatabaseMetaData metaData = this.getConnection().getMetaData();
            String catalogName = null;
            if (metaData.supportsCatalogsInTableDefinitions()) {
                catalogName = connection.getCatalog();
            }
            DatabaseDefinition databaseDefinition = this.getDatabaseDefinition();
            DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
            ResultSet r = metaData.getColumns(catalogName, this.getSchema().getName(), this.getName(), null);
            while (r.next()) {
                DerbyCatalogColumn column = new DerbyCatalogColumn();
                String columnName = r.getString(4);
                column.setName(columnName);
                String remarks = r.getString(12);
                column.setDescription(remarks);
                String typeName = r.getString(6);
                PredefinedDataTypeDefinition typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(typeName);
                if (typeDefinition != null) {
                    EStructuralFeature feature;
                    PredefinedDataType type = databaseDefinition.getPredefinedDataType(typeDefinition);
                    if (typeDefinition.isLengthSupported()) {
                        feature = type.eClass().getEStructuralFeature("length");
                        type.eSet(feature, (Object)new Integer(r.getInt(7)));
                    } else if (typeDefinition.isPrecisionSupported()) {
                        feature = type.eClass().getEStructuralFeature("precision");
                        type.eSet(feature, (Object)new Integer(r.getInt(10)));
                    }
                    if (typeDefinition.isScaleSupported()) {
                        feature = type.eClass().getEStructuralFeature("scale");
                        type.eSet(feature, (Object)new Integer(r.getInt(9)));
                    }
                    column.setContainedType((SQLDataType)type);
                } else {
                    ValueExpression expr = (ValueExpression)factory.create(SQLExpressionsPackage.eINSTANCE.getValueExpressionDefault());
                    column.setGenerateExpression(expr);
                    ((ValueExpressionDefault)expr).setSQL(typeName);
                }
                columnList.add((Object)column);
            }
            this.columnsLoaded = true;
            r.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadView() {
        if (this.viewLoaded) {
            return;
        }
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            Statement s = connection.createStatement();
            String query = " SELECT CHECKOPTION, VIEWDEFINITION FROM SYS.SYSVIEWS A, SYS.SYSTABLES B, SYS.SYSSCHEMAS C WHERE A.TABLEID=B.TABLEID AND B.TABLENAME='" + this.getName() + "'" + " AND B.SCHEMAID=C.SCHEMAID" + " AND C.SCHEMANAME='" + this.getSchema().getName() + "'";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String viewCheck = r.getString("CHECKOPTION");
                if (viewCheck.equals("N")) {
                    this.setCheckType(CheckType.NONE_LITERAL);
                } else if (viewCheck.equals("L")) {
                    this.setCheckType(CheckType.LOCAL_LITERAL);
                } else if (viewCheck.equals("C")) {
                    this.setCheckType(CheckType.CASCADED_LITERAL);
                }
                String text = r.getString("VIEWDEFINITION");
                DerbyDdlParser ddlParser = new DerbyDdlParser(this.getDatabaseDefinition());
                ddlParser.parseView((ViewTable)this, text);
            }
            this.viewLoaded = true;
            r.close();
            s.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.eSetDeliver(deliver);
    }

    private DatabaseDefinition getDatabaseDefinition() {
        Database d = this.getSchema().getDatabase();
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(d);
    }
}

