/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaConnection;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaDriverObject;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaParameterMetaData;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaResultSet;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.consumer.nls.Messages;

public class OdaQuery
extends OdaDriverObject
implements IQuery {
    private boolean m_isPreparedSuccessfully;
    private boolean m_isExecuted;
    private String m_dataSetType;
    private Object m_appContext;

    protected OdaQuery(IQuery statement, OdaConnection connection, String dataSetType, boolean switchContextClassloader, ClassLoader driverClassLoader) {
        super((Object)statement, connection, switchContextClassloader, driverClassLoader);
        String context = "OdaQuery.OdaQuery( " + statement + ", " + connection + ", " + dataSetType + " )\t";
        this.logMethodCalled(context);
        this.m_isPreparedSuccessfully = false;
        this.m_isExecuted = false;
        this.m_dataSetType = dataSetType;
        this.logMethodExitWithReturn(context, this);
    }

    protected IQuery getQuery() {
        return (IQuery)this.getObject();
    }

    protected OdaDataSetMetaData getDSMetaData() throws OdaException {
        return this.getOdaConnection().doGetMetaData(this.m_dataSetType);
    }

    protected boolean isPreparedSuccessfully() {
        return this.m_isPreparedSuccessfully;
    }

    protected boolean isExecuted() {
        return this.m_isExecuted;
    }

    protected void setIsExecuted(boolean flag) {
        this.m_isExecuted = flag;
    }

    private void resetStatementStates() {
        this.getOdaConnection().removeOpenStatement(this);
        this.m_isPreparedSuccessfully = false;
        this.resetExecuteStates();
    }

    protected void resetExecuteStates() {
        this.m_isExecuted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppContext(Object context) throws OdaException {
        String methodName = "OdaQuery.setAppContext()\t";
        String contextObjInfo = context == null ? "null" : context.toString();
        this.logMethodCalled("OdaQuery.setAppContext()\t");
        if (this.m_appContext == context) {
            this.log("OdaQuery.setAppContext()\t", "Same pass-thru application context object: " + contextObjInfo);
            this.logMethodExit("OdaQuery.setAppContext()\t");
            return;
        }
        try {
            this.setContextClassloader();
            this.log("OdaQuery.setAppContext()\t", "Passing thru application context to underlying ODA query: " + contextObjInfo);
            this.getQuery().setAppContext(context);
        }
        catch (UnsupportedOperationException uoException) {
            this.logUnsupportedOp(uoException, "IQuery.setAppContext");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
        this.m_appContext = context;
        this.logMethodExit("OdaQuery.setAppContext()\t");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(String queryText) throws OdaException {
        String context = "OdaQuery.prepare( " + queryText + " )\t";
        this.logMethodCalled(context);
        String unsupportedOpContext = "IQuery.prepare( String queryText )";
        this.setAppContext(this.getOdaConnection().getAppContext());
        try {
            this.setContextClassloader();
            this.doPrepare(queryText, context);
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.prepare( String queryText )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
        this.m_isPreparedSuccessfully = true;
        this.getOdaConnection().addOpenStatement(this);
        this.logMethodExit(context);
    }

    private void doPrepare(String queryText, String logContext) throws OdaException {
        this.resetStatementStates();
        if (queryText == null) {
            this.log(logContext, "Converted the null queryText argument to an empty String value to comply with the ODA interfaces specification.");
            queryText = "";
        }
        if (!this.getOdaConnection().canSupportMoreOpenedStatements()) {
            throw this.newOdaException(Messages.helper_maxConcurrentStatementsReached);
        }
        this.getQuery().prepare(queryText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String propertyName, String propertyValue) throws OdaException {
        String context = "OdaQuery.setProperty( " + propertyName + ", " + propertyValue + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.getQuery().setProperty(propertyName, propertyValue);
            this.logMethodExit(context);
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.setProperty( String propertyName, String propertyValue )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws OdaException {
        String context = "OdaQuery.close()\t";
        this.logMethodCalled("OdaQuery.close()\t");
        try {
            this.setContextClassloader();
            this.getQuery().close();
            this.resetStatementStates();
            this.m_dataSetType = null;
            this.logMethodExit("OdaQuery.close()\t");
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.close()");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxRows(int max) throws OdaException {
        String context = "OdaQuery.setMaxRows( " + max + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.getQuery().setMaxRows(max);
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.setMaxRows()");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
        this.logMethodExit(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxRows() throws OdaException {
        String context = "OdaQuery.getMaxRows()\t";
        this.logMethodCalled("OdaQuery.getMaxRows()\t");
        int ret = 0;
        try {
            this.setContextClassloader();
            ret = this.getQuery().getMaxRows();
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.getMaxRows()");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
        this.logMethodExitWithReturn("OdaQuery.getMaxRows()\t", ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResultSetMetaData getMetaData() throws OdaException {
        String context = "OdaQuery.getMetaData()\t";
        this.logMethodCalled("OdaQuery.getMetaData()\t");
        try {
            this.setContextClassloader();
            OdaResultSetMetaData ret = this.doGetMetaData();
            this.logMethodExitWithReturn("OdaQuery.getMetaData()\t", ret);
            OdaResultSetMetaData odaResultSetMetaData = ret;
            return odaResultSetMetaData;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.getMetaData()");
            IResultSetMetaData iResultSetMetaData = null;
            return iResultSetMetaData;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            IResultSetMetaData iResultSetMetaData = null;
            return iResultSetMetaData;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            IResultSetMetaData iResultSetMetaData = null;
            return iResultSetMetaData;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    private OdaResultSetMetaData doGetMetaData() throws OdaException {
        if (!this.isPreparedSuccessfully()) {
            throw this.newOdaException(Messages.helper_cannotGetResultSetMdBeforePrepare);
        }
        IResultSetMetaData resultSetMetaData = this.getQuery().getMetaData();
        OdaResultSetMetaData ret = resultSetMetaData == null ? null : new OdaResultSetMetaData(resultSetMetaData, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResultSet executeQuery() throws OdaException {
        String context = "OdaQuery.executeQuery()\t";
        this.logMethodCalled("OdaQuery.executeQuery()\t");
        try {
            this.setContextClassloader();
            OdaResultSet ret = this.doExecuteQuery();
            this.logMethodExitWithReturn("OdaQuery.executeQuery()\t", ret);
            OdaResultSet odaResultSet = ret;
            return odaResultSet;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.executeQuery()");
            IResultSet iResultSet = null;
            return iResultSet;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            IResultSet iResultSet = null;
            return iResultSet;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            IResultSet iResultSet = null;
            return iResultSet;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    private OdaResultSet doExecuteQuery() throws OdaException {
        this.resetExecuteStates();
        if (!this.isPreparedSuccessfully()) {
            throw this.newOdaException(Messages.helper_cannotExecuteBeforePrepare);
        }
        IResultSet resultSet = this.getQuery().executeQuery();
        this.m_isExecuted = true;
        if (resultSet == null) {
            return null;
        }
        OdaResultSet ret = this.newResultSetHelper(resultSet);
        return ret;
    }

    protected OdaResultSet newResultSetHelper(IResultSet resultSet) {
        return new OdaResultSet(resultSet, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInt(String parameterName, int value) throws OdaException {
        String context = "OdaQuery.setInt( " + parameterName + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfSetParamBeforePrepare();
            this.getQuery().setInt(parameterName, value);
            this.logMethodExit(context);
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.setInt( String parameterName, int value )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInt(int parameterId, int value) throws OdaException {
        String context = "OdaQuery.setInt( " + parameterId + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfSetParamBeforePrepare();
            this.getQuery().setInt(parameterId, value);
            this.logMethodExit(context);
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.setInt( int parameterId, int value )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDouble(String parameterName, double value) throws OdaException {
        String context = "OdaQuery.setDouble( " + parameterName + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfSetParamBeforePrepare();
            this.getQuery().setDouble(parameterName, value);
            this.logMethodExit(context);
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.setDouble( String parameterName, double value )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDouble(int parameterId, double value) throws OdaException {
        String context = "OdaQuery.setDouble( " + parameterId + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfSetParamBeforePrepare();
            this.getQuery().setDouble(parameterId, value);
            this.logMethodExit(context);
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.setDouble( int parameterId, double value )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
        String context = "OdaQuery.setBigDecimal( " + parameterName + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfSetParamBeforePrepare();
            this.getQuery().setBigDecimal(parameterName, value);
            this.logMethodExit(context);
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.setBigDecimal( String parameterName, BigDecimal value )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
        String context = "OdaQuery.setBigDecimal( " + parameterId + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfSetParamBeforePrepare();
            this.getQuery().setBigDecimal(parameterId, value);
            this.logMethodExit(context);
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.setBigDecimal( int parameterId, BigDecimal value )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(String parameterName, String value) throws OdaException {
        String context = "OdaQuery.setString( " + parameterName + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfSetParamBeforePrepare();
            this.getQuery().setString(parameterName, value);
            this.logMethodExit(context);
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.setString( String parameterName, String value )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(int parameterId, String value) throws OdaException {
        String context = "OdaQuery.setString( " + parameterId + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfSetParamBeforePrepare();
            this.getQuery().setString(parameterId, value);
            this.logMethodExit(context);
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.setString( int parameterId, String value )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDate(String parameterName, Date value) throws OdaException {
        String context = "OdaQuery.setDate( " + parameterName + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfSetParamBeforePrepare();
            this.getQuery().setDate(parameterName, value);
            this.logMethodExit(context);
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.setDate( String parameterName, Date value )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDate(int parameterId, Date value) throws OdaException {
        String context = "OdaQuery.setDate( " + parameterId + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfSetParamBeforePrepare();
            this.getQuery().setDate(parameterId, value);
            this.logMethodExit(context);
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.setDate( int parameterId, Date value )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTime(String parameterName, Time value) throws OdaException {
        String context = "OdaQuery.setTime( " + parameterName + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfSetParamBeforePrepare();
            this.getQuery().setTime(parameterName, value);
            this.logMethodExit(context);
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.setTime( String parameterName, Time value )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTime(int parameterId, Time value) throws OdaException {
        String context = "OdaQuery.setTime( " + parameterId + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfSetParamBeforePrepare();
            this.getQuery().setTime(parameterId, value);
            this.logMethodExit(context);
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.setTime( int parameterId, Time value )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
        String context = "OdaQuery.setTimestamp( " + parameterName + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfSetParamBeforePrepare();
            this.getQuery().setTimestamp(parameterName, value);
            this.logMethodExit(context);
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.setTimestamp( String parameterName, Timestamp value )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
        String context = "OdaQuery.setTimestamp( " + parameterId + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfSetParamBeforePrepare();
            this.getQuery().setTimestamp(parameterId, value);
            this.logMethodExit(context);
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.setTimestamp( int parameterId, Timestamp value )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInParameters() throws OdaException {
        String context = "OdaQuery.clearInParameters()\t";
        this.logMethodCalled("OdaQuery.clearInParameters()\t");
        try {
            this.setContextClassloader();
            this.getQuery().clearInParameters();
            this.logMethodExit("OdaQuery.clearInParameters()\t");
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.clearInParameters()");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findInParameter(String parameterName) throws OdaException {
        String context = "OdaQuery.findInParameter( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            if (!this.isPreparedSuccessfully()) {
                throw this.newOdaException(Messages.helper_cannotGetParamMdBeforePrepare);
            }
            int ret = this.getQuery().findInParameter(parameterName);
            this.logMethodExitWithReturn(context, ret);
            int n = ret;
            return n;
        }
        catch (UnsupportedOperationException uoException) {
            int n = this.handleUnsupportedOpAndRetZero(uoException, "IQuery.findInParameter( String parameterName )");
            return n;
        }
        catch (RuntimeException rtException) {
            int n = this.handleErrorAndReturnZero(rtException);
            return n;
        }
        catch (OdaException odaException) {
            int n = this.handleErrorAndReturnZero(odaException);
            return n;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IParameterMetaData getParameterMetaData() throws OdaException {
        String context = "OdaQuery.getParameterMetaData()\t";
        this.logMethodCalled("OdaQuery.getParameterMetaData()\t");
        try {
            this.setContextClassloader();
            if (!this.isPreparedSuccessfully()) {
                throw this.newOdaException(Messages.helper_cannotGetParamMdBeforePrepare);
            }
            IParameterMetaData parameterMetaData = this.getQuery().getParameterMetaData();
            OdaParameterMetaData ret = parameterMetaData == null ? null : new OdaParameterMetaData(parameterMetaData, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
            this.logMethodExitWithReturn("OdaQuery.getParameterMetaData()\t", ret);
            OdaParameterMetaData odaParameterMetaData = ret;
            return odaParameterMetaData;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.getParameterMetaData()");
            IParameterMetaData iParameterMetaData = null;
            return iParameterMetaData;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            IParameterMetaData iParameterMetaData = null;
            return iParameterMetaData;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            IParameterMetaData iParameterMetaData = null;
            return iParameterMetaData;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSortSpec(SortSpec sortBy) throws OdaException {
        String context = "OdaQuery.setSortSpec( " + sortBy + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            if (!this.isPreparedSuccessfully()) {
                throw this.newOdaException(Messages.helper_cannotSetSortSpecBeforePrepare);
            }
            this.getQuery().setSortSpec(sortBy);
            this.logMethodExit(context);
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.setSortSpec( SortSpec sortBy )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortSpec getSortSpec() throws OdaException {
        String context = "OdaQuery.getSortSpec()\t";
        this.logMethodCalled("OdaQuery.getSortSpec()\t");
        try {
            this.setContextClassloader();
            SortSpec sortSpec = this.getQuery().getSortSpec();
            this.logMethodExitWithReturn("OdaQuery.getSortSpec()\t", sortSpec);
            SortSpec sortSpec2 = sortSpec;
            return sortSpec2;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IQuery.getSortSpec()");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
        return null;
    }

    public String getInterfaceName() {
        return IQuery.class.getName();
    }

    private void throwIfSetParamBeforePrepare() throws OdaException {
        if (!this.isPreparedSuccessfully()) {
            throw this.newOdaException(Messages.helper_cannotSetParamBeforePrepare);
        }
    }
}

