/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.enablement.oda.ws.util.WSUtil;

public class Java2SOAPManager {
    private static final String METHOD_CONNECT = "connect";
    private static final String METHOD_QUERY = "executeQuery";
    private static final String METHOD_CLOSE = "close";
    private Map connectionProperties;
    private Map appConext;
    private String queryText;
    private Map parameterValues;
    private Map queryProperties;
    private Object aQuery;

    public void newQuery(String className) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException, OdaException, IOException, URISyntaxException {
        Class clazz = this.loadClass(className);
        Class[] parameterTypes = new Class[]{Map.class, Map.class};
        Object[] arguments = new Object[]{this.connectionProperties, this.getAppConext()};
        Method connect = clazz.getMethod(METHOD_CONNECT, parameterTypes);
        this.aQuery = connect.invoke(clazz.newInstance(), arguments);
    }

    public Object executeQuery() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        if (WSUtil.isNull(this.aQuery)) {
            return null;
        }
        Class<?> clazz = this.aQuery.getClass();
        Class[] parameterTypes = new Class[]{String.class, Map.class, Map.class};
        Object[] arguments = new Object[]{this.queryText, this.parameterValues, this.queryProperties};
        Method query = clazz.getMethod(METHOD_QUERY, parameterTypes);
        return query.invoke(this.aQuery, arguments);
    }

    public void close() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = this.aQuery.getClass();
        Class[] parameterTypes = new Class[]{};
        Object[] arguments = new Object[]{};
        Method close = null;
        try {
            close = clazz.getMethod(METHOD_CLOSE, parameterTypes);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (close == null) {
            return;
        }
        close.invoke(this.aQuery, arguments);
    }

    private Class loadClass(String className) throws ClassNotFoundException, OdaException, IOException, URISyntaxException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            URL[] urls = new URL[]{this.getLibDirectory()};
            URLClassLoader urlClassLoader = this.createClassLoader(urls);
            return urlClassLoader.loadClass(className);
        }
    }

    private URL getLibDirectory() throws OdaException, IOException, URISyntaxException {
        URL url = this.getInstallDirectory();
        if (url == null) {
            return null;
        }
        return new URL(url.toString() + "lib" + "/");
    }

    private URL getInstallDirectory() throws OdaException, IOException {
        ExtensionManifest extMF = null;
        extMF = ManifestExplorer.getInstance().getExtensionManifest("org.eclipse.datatools.enablement.oda.ws");
        if (extMF != null) {
            return extMF.getDriverLocation();
        }
        return null;
    }

    private URLClassLoader createClassLoader(URL[] urlList) throws MalformedURLException {
        return new URLClassLoader(urlList, ClassLoader.getSystemClassLoader());
    }

    public Map getAppConext() {
        return this.appConext == null ? new HashMap() : this.appConext;
    }

    public void setAppConext(Map appConext) {
        this.appConext = appConext;
    }

    public void setConnectionProperties(Map connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    public void setParameterValues(Map parameterValues) {
        this.parameterValues = parameterValues;
    }

    public void setQueryProperties(Map queryProperties) {
        this.queryProperties = queryProperties;
    }

    public void setQueryText(String queryText) {
        this.queryText = queryText;
    }
}

