/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core;

import java.util.Comparator;
import org.eclipse.jface.util.Assert;

public class DatabaseVendorDefinitionId
implements Comparable {
    private static VersionComparator _versionComparator = new VersionComparator();
    private String _vendorName;
    private String _version;

    public DatabaseVendorDefinitionId(String productName, String version) {
        this._vendorName = productName;
        this._version = version;
    }

    public DatabaseVendorDefinitionId(String dbDefName) {
        Assert.isTrue((dbDefName != null ? 1 : 0) != 0);
        int underscore = dbDefName.indexOf(95);
        if (underscore > 0) {
            this._vendorName = dbDefName.substring(0, dbDefName.indexOf(95));
            this._version = dbDefName.substring(dbDefName.indexOf(95) + 1);
        } else {
            this._vendorName = dbDefName;
            this._version = "";
        }
    }

    public String getProductName() {
        return this._vendorName;
    }

    public String getVersion() {
        return this._version;
    }

    public int hashCode() {
        return this._vendorName.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DatabaseVendorDefinitionId)) {
            return false;
        }
        DatabaseVendorDefinitionId v2 = (DatabaseVendorDefinitionId)obj;
        boolean sameName = this.getProductName() == v2.getProductName() || this.getProductName() != null && this.getProductName().equals(v2.getProductName());
        return sameName && _versionComparator.compare(this.getVersion(), v2.getVersion()) == 0;
    }

    public String toString() {
        return this._vendorName + "_" + this._version;
    }

    public int compareTo(Object o) {
        DatabaseVendorDefinitionId v2 = (DatabaseVendorDefinitionId)o;
        int result = 0;
        if (this.getProductName() != null && v2.getProductName() != null) {
            result = this.getProductName().compareTo(v2.getProductName());
        }
        if (result == 0) {
            result = _versionComparator.compare(this.getVersion(), v2.getVersion());
        }
        return result;
    }

    public static class VersionComparator
    implements Comparator {
        public int compare(Object left, Object right) {
            if (left == null && right == null) {
                return 0;
            }
            if (left == null) {
                return 1;
            }
            if (right == null) {
                return -1;
            }
            String leftString = ((String)left).toLowerCase();
            String rightString = ((String)right).toLowerCase();
            int result = 0;
            String[] ls = leftString.split("\\Q.\\E");
            String[] rs = rightString.split("\\Q.\\E");
            int length = Math.min(ls.length, rs.length);
            for (int i = 0; i < length; ++i) {
                if (ls[i].indexOf("x") >= 0 || rs[i].indexOf("x") >= 0) {
                    return 0;
                }
                result = ls[i].compareTo(rs[i]);
                if (result != 0) break;
            }
            return result;
        }
    }
}

