/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core.internal.dbitem;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.EngineeringOption;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.ICatalogObject;
import org.eclipse.datatools.modelbase.sql.datatypes.ExactNumericDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.NumericalDataType;
import org.eclipse.datatools.modelbase.sql.query.helper.DataTypeHelper;
import org.eclipse.datatools.modelbase.sql.routines.Parameter;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.dbitem.IDBItem;
import org.eclipse.datatools.sqltools.core.dbitem.IItemWithCode;
import org.eclipse.datatools.sqltools.core.dbitem.ISPUDF;
import org.eclipse.datatools.sqltools.core.dbitem.ParameterDescriptor;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.emf.common.util.EList;

public class SQLObjectItem
implements IDBItem,
IItemWithCode,
ISPUDF {
    ProcIdentifier _proc = null;
    SQLObject _routine = null;
    IControlConnection _controlConn = null;
    ParameterDescriptor[] _parameterDescriptors = null;

    public SQLObjectItem(ProcIdentifier proc, SQLObject routine, IControlConnection controlConn) {
        this._proc = proc;
        this._routine = routine;
        this._controlConn = controlConn;
    }

    public ProcIdentifier getProcIdentifier() {
        return this._proc;
    }

    public IControlConnection getControlConnection() {
        return this._controlConn;
    }

    public void refresh() {
        this.dispose();
    }

    public void dispose() {
        if (this._routine instanceof ICatalogObject) {
            Table table;
            ((ICatalogObject)this._routine).refresh();
            if (this._routine instanceof Trigger && (table = ((Trigger)this._routine).getSubjectTable()) instanceof ICatalogObject) {
                ((ICatalogObject)table).refresh();
            }
        }
    }

    public String getCode() throws SQLException {
        String code = "";
        DDLGenerator ddlg = ProfileUtil.getDatabaseDefinition(this._proc.getProfileName()).getDDLGenerator();
        if (ddlg != null) {
            EngineeringOption[] opts = ddlg.getOptions();
            boolean generateDrop = opts[2].getBoolean();
            boolean fullName = opts[0].getBoolean();
            opts[2].setBoolean(false);
            opts[0].setBoolean(true);
            String[] ddl = ddlg.generateDDL(new SQLObject[]{this._routine}, null);
            if (ddl != null && ddl.length > 0) {
                code = ddl[0];
            }
            opts[2].setBoolean(generateDrop);
            opts[0].setBoolean(fullName);
        }
        return code;
    }

    public void save(String code) throws SQLException {
        DDLGenerator ddlg = ProfileUtil.getDatabaseDefinition(this._proc.getProfileName()).getDDLGenerator();
        if (ddlg != null) {
            EngineeringOption[] opts = ddlg.getOptions();
            String[] drop = ddlg.dropSQLObjects(new SQLObject[]{this._routine}, opts[1].getBoolean(), true, null);
            String[] ddl = new String[]{drop[0], code};
            this._controlConn.createRoutine(ddl);
        }
    }

    public int getValidBreakpointLocation(int number) throws SQLException {
        return number;
    }

    public ParameterDescriptor[] getParameterDescriptor() throws SQLException {
        if (this._parameterDescriptors == null) {
            ArrayList<ParameterDescriptor> paramList = new ArrayList<ParameterDescriptor>();
            if (this._routine instanceof Routine) {
                Routine r = (Routine)this._routine;
                EList ps = r.getParameters();
                Iterator iter = ps.iterator();
                while (iter.hasNext()) {
                    Parameter p = (Parameter)iter.next();
                    String name = p.getName();
                    int type = p.getMode().getValue();
                    String dataTypeName = p.getDataType().getName();
                    int dataType = DataTypeHelper.getJDBCTypeForNamedType((String)dataTypeName);
                    int precision = 0;
                    int scale = 0;
                    if (p.getDataType() instanceof NumericalDataType) {
                        precision = ((NumericalDataType)p.getDataType()).getPrecision();
                    }
                    if (p.getDataType() instanceof ExactNumericDataType) {
                        scale = ((ExactNumericDataType)p.getDataType()).getScale();
                    }
                    short nullable = 2;
                    ParameterDescriptor pd = new ParameterDescriptor(this._proc.getDatabaseIdentifier(), name, type, dataType, precision, (short)scale, dataTypeName, nullable, null);
                    paramList.add(pd);
                }
            }
            this._parameterDescriptors = paramList.toArray(new ParameterDescriptor[paramList.size()]);
        }
        return this._parameterDescriptors;
    }

    public Map getParameterDefalutValues(String sql) throws SQLException {
        return new HashMap();
    }
}

