/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core.services;

import java.util.ArrayList;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.Messages;
import org.eclipse.datatools.sqltools.editor.template.GenericSQLContextType;
import org.eclipse.datatools.sqltools.sql.ISQLSyntax;
import org.eclipse.datatools.sqltools.sql.parser.ParserParameters;
import org.eclipse.datatools.sqltools.sql.parser.ParsingResult;
import org.eclipse.datatools.sqltools.sql.parser.SQLParser;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLDelimiter;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTStart;
import org.eclipse.datatools.sqltools.sql.parser.ast.Node;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;

public class SQLService {
    public ISQLSyntax getSQLSyntax() {
        return null;
    }

    public GenericSQLContextType getSQLContextType() {
        return new GenericSQLContextType();
    }

    public SQLParser getSQLParser() {
        return null;
    }

    public String[] splitSQL(String sql) {
        if (this.getSQLParser() == null) {
            return new String[]{sql};
        }
        ArrayList<String> groups = new ArrayList<String>();
        try {
            SQLParser parser = this.getSQLParser();
            Document doc = new Document(sql);
            ParsingResult result = parser.parse(sql, new ParserParameters(true));
            IASTStart root = result.getRootNode();
            root.setDocument((IDocument)doc);
            String group = "";
            int start = 0;
            int end = 0;
            if (root.jjtGetNumChildren() > 0) {
                for (int i = 0; i < root.jjtGetNumChildren(); ++i) {
                    Node node = root.jjtGetChild(i);
                    if (!(node instanceof IASTSQLDelimiter)) continue;
                    end = node.getStartOffset();
                    group = doc.get(start, end - start);
                    start = node.getEndOffset();
                    if (group.trim().equals("")) continue;
                    groups.add(group);
                    group = "";
                }
            } else {
                group = sql;
            }
            if (end < doc.getLength()) {
                group = doc.get(start, doc.getLength() - start);
            }
            if (!group.trim().equals("")) {
                groups.add(group);
            }
        }
        catch (Exception e1) {
            EditorCorePlugin.getDefault().log(NLS.bind((String)Messages.DefaultSQLSyntax_exception_splitSQL, (Object)sql), e1);
        }
        return groups.toArray(new String[groups.size()]);
    }
}

