/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfoImpl;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.modelbase.sql.routines.Function;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.sqltools.core.DBHelper;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;

public class SQLDevToolsUtil {
    public static ProcIdentifier getProcIdentifier(SQLObject routine) {
        Database db = null;
        if (routine instanceof Routine) {
            db = ((Routine)routine).getSchema().getDatabase();
        } else if (routine instanceof Trigger) {
            db = ((Trigger)routine).getSchema().getDatabase();
        } else {
            return null;
        }
        return SQLDevToolsUtil.getProcIdentifier(SQLDevToolsUtil.getDatabaseIdentifier(db), routine);
    }

    public static ProcIdentifier getProcIdentifier(DatabaseIdentifier databaseIdentifier, SQLObject routine) {
        SQLDevToolsConfiguration config = SQLToolsFacade.getConfigurationByProfileName(databaseIdentifier.getProfileName());
        DBHelper h = null;
        h = config != null ? config.getDBHelper() : new DBHelper();
        ProcIdentifier proc = null;
        if (routine instanceof Routine) {
            Schema schema = ((Routine)routine).getSchema();
            if (routine instanceof Procedure) {
                proc = h.getProcIdentifier(databaseIdentifier, routine.getName(), 0, null, schema.getName());
            } else if (routine instanceof Function) {
                proc = h.getProcIdentifier(databaseIdentifier, routine.getName(), 1, null, schema.getName());
            }
        } else if (routine instanceof Trigger) {
            Schema schema = ((Trigger)routine).getSchema();
            Table table = ((Trigger)routine).getSubjectTable();
            proc = h.getProcIdentifier(databaseIdentifier, routine.getName(), 3, table.getName(), schema.getName());
        }
        return proc;
    }

    public static int getProcType(SQLObject routine) {
        if (routine instanceof Trigger) {
            return 3;
        }
        if (routine instanceof Procedure) {
            return 0;
        }
        if (routine instanceof Function) {
            return 1;
        }
        return 4;
    }

    public static DatabaseIdentifier getDatabaseIdentifier(Database database) {
        ConnectionInfo connInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(database);
        if (connInfo instanceof ConnectionInfoImpl) {
            IConnectionProfile profile = ((ConnectionInfoImpl)connInfo).getConnectionProfile();
            return new DatabaseIdentifier(profile.getName(), database.getName());
        }
        return null;
    }
}

