/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.core;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.IControlConnectionListener;
import org.eclipse.datatools.sqltools.core.IControlConnectionManager;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.internal.core.Messages;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.osgi.util.NLS;

public class ControlConnectionManager
implements IControlConnectionManager {
    ListenerList _listeners = new ListenerList();
    public Map _controlConnectionMap = new HashMap();

    public IControlConnection getOrCreateControlConnection(DatabaseIdentifier databaseIdentifier) throws SQLException, NoSuchProfileException {
        if (databaseIdentifier == null) {
            throw new NoSuchProfileException(databaseIdentifier.toString());
        }
        IControlConnection con = null;
        con = (IControlConnection)this._controlConnectionMap.get(databaseIdentifier);
        if (con == null) {
            con = SQLToolsFacade.getConfiguration(databaseIdentifier, null).getConnectionService().createControlConnection(databaseIdentifier);
            if (con == null) {
                throw new SQLException(NLS.bind((String)Messages.ControlConnectionManager_unknownServerType, (Object[])new Object[]{databaseIdentifier.getProfileName()}));
            }
            this._controlConnectionMap.put(databaseIdentifier, con);
            this.fireAdded(con);
        }
        return con;
    }

    public IControlConnection[] getControlConnection(String profileName) {
        return this.getControlConnections(profileName);
    }

    public synchronized IControlConnection[] getControlConnections() {
        return this._controlConnectionMap.values().toArray(new IControlConnection[this._controlConnectionMap.size()]);
    }

    public boolean hasControlConnection() {
        return !this._controlConnectionMap.isEmpty();
    }

    public void addControlConnectionListener(IControlConnectionListener listener) {
        this._listeners.add((Object)listener);
    }

    public void removeControlConnectionListener(IControlConnectionListener listener) {
        this._listeners.remove((Object)listener);
    }

    public void fireAdded(IControlConnection con) {
        Object[] listeners = this._listeners.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            IControlConnectionListener l = (IControlConnectionListener)listeners[i];
            l.controlConnectionAdded(con);
        }
    }

    public void fireDetached(IControlConnection con) {
        Object[] listeners = this._listeners.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            IControlConnectionListener l = (IControlConnectionListener)listeners[i];
            l.controlConnectionDetached(con);
        }
    }

    public void fireRefreshed(IControlConnection con) {
        Object[] listeners = this._listeners.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            IControlConnectionListener l = (IControlConnectionListener)listeners[i];
            l.controlConnectionRefreshed(con);
        }
    }

    public void fireRefreshed(IControlConnection con, ProcIdentifier proc) {
        Object[] listeners = this._listeners.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            IControlConnectionListener l = (IControlConnectionListener)listeners[i];
            l.controlConnectionRefreshed(con, proc);
        }
    }

    public void remove(IControlConnection connection) {
        this._controlConnectionMap.remove(connection.getDatabaseIdentifier());
        this.fireDetached(connection);
    }

    public void shutdown() {
        ArrayList list = new ArrayList(this._controlConnectionMap.values());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            IControlConnection con = (IControlConnection)iter.next();
            con.disconnect(true);
        }
    }

    public IControlConnection[] getControlConnections(String profileName) {
        ArrayList controlConnections = new ArrayList();
        Set databaseIdentifierSet = this._controlConnectionMap.keySet();
        Iterator iterator = databaseIdentifierSet.iterator();
        ArrayList databaseIdentifiers = new ArrayList();
        while (iterator.hasNext()) {
            databaseIdentifiers.add(iterator.next());
        }
        if (databaseIdentifiers.size() < 1) {
            return null;
        }
        for (int i = 0; i < databaseIdentifiers.size(); ++i) {
            DatabaseIdentifier databaseIdentifier = (DatabaseIdentifier)databaseIdentifiers.get(i);
            if (!databaseIdentifier.getProfileName().equals(profileName)) continue;
            controlConnections.add(this._controlConnectionMap.get(databaseIdentifier));
        }
        return controlConnections.toArray(new IControlConnection[controlConnections.size()]);
    }

    public IControlConnection getControlConnection(DatabaseIdentifier databaseIdentifier) {
        return (IControlConnection)this._controlConnectionMap.get(databaseIdentifier);
    }
}

