/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.loader;

import com.ibm.icu.text.MessageFormat;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.Messages;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;

public class JDBCTableSuperTableLoader
extends JDBCBaseLoader {
    public static final String COLUMN_SUPERTABLE_NAME = "SUPERTABLE_NAME";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.connectivity.sqm.loader.JDBCTableSuperTableLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public JDBCTableSuperTableLoader(ICatalogObject catalogObject) {
        this(catalogObject, null);
    }

    public JDBCTableSuperTableLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
        if (!$assertionsDisabled && !(catalogObject instanceof Table)) {
            throw new AssertionError();
        }
    }

    public Table loadSuperTable() throws SQLException {
        Table retVal = null;
        ResultSet rs = null;
        try {
            rs = this.createResultSet();
            if (rs.next()) {
                retVal = this.findTable(rs.getString(COLUMN_SUPERTABLE_NAME));
            }
            Table table = retVal;
            Object var3_4 = null;
            if (rs != null) {
                this.closeResultSet(rs);
            }
            return table;
        }
        catch (Throwable throwable) {
            block4: {
                Object var3_5 = null;
                if (rs == null) break block4;
                this.closeResultSet(rs);
            }
            throw throwable;
        }
    }

    protected ResultSet createResultSet() throws SQLException {
        try {
            Table table = this.getTable();
            Schema schema = table.getSchema();
            return this.getCatalogObject().getConnection().getMetaData().getSuperTables(schema.getCatalog().getName(), schema.getName(), table.getName());
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException(MessageFormat.format((String)Messages.Error_Unsupported_DatabaseMetaData_Method, (Object[])new Object[]{"java.sql.DatabaseMetaData.getSuperTables()"}));
            error.initCause(e);
            throw error;
        }
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {}
    }

    protected Table getTable() {
        return (Table)this.getCatalogObject();
    }

    protected Table findTable(String tableName) {
        if (tableName == null) {
            return null;
        }
        Iterator tableIt = this.getTable().getSchema().getTables().iterator();
        while (tableIt.hasNext()) {
            Table table = (Table)tableIt.next();
            if (!tableName.equals(table.getName())) continue;
            return table;
        }
        return null;
    }
}

