/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConfigurationType;
import org.eclipse.datatools.connectivity.IConnectionFactoryProvider;
import org.eclipse.datatools.connectivity.IConnectionProfileProvider;
import org.eclipse.datatools.connectivity.internal.CategoryProvider;
import org.eclipse.datatools.connectivity.internal.ConfigurationTypeProvider;
import org.eclipse.datatools.connectivity.internal.ConnectionFactoryAdapter;
import org.eclipse.datatools.connectivity.internal.ConnectionFactoryAdapterProvider;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileProvider;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;

public class ConnectionProfileManager {
    private static ConnectionProfileManager sInstance = new ConnectionProfileManager();
    public static final String EXTENSION_ID = "org.eclipse.datatools.connectivity.connectionProfile";
    public static final String EXT_ELEM_CATEGORY = "category";
    public static final String EXT_ELEM_CONFIGURATION_TYPE = "configurationType";
    public static final String EXT_ELEM_CONNECTION_FACTORY = "connectionFactory";
    public static final String EXT_ELEM_PROFILE_EXTENSION = "profileExtension";
    public static final String EXT_ELEM_CONNECTION_PROFILE = "connectionProfile";
    public static final String EXT_ELEM_NEW_WIZARD = "newWizard";
    public static final String EXT_ELEM_WIZARD_CATEGORY = "wizardCategory";
    public static final String EXT_ELEM_CONNECTION_FACTORY_ADAPTER = "connectionFactoryAdapter";
    public static boolean DEBUG_CONNECTION_PROFILE_EXTENSION = false;
    private static final String OPTION_DEBUG_CONNECTION_PROFILE_EXTENSION = "org.eclipse.datatools.connectivity/connectionprofileextension";
    private Map mProviders = null;
    private Map mCategories = null;
    private Map mConfigurationTypes = null;
    private Map mConnectionFactoryAdapters = null;
    private Collection mDisabledProviders = null;

    public static ConnectionProfileManager getInstance() {
        return sInstance;
    }

    private ConnectionProfileManager() {
        String debug = Platform.getDebugOption((String)OPTION_DEBUG_CONNECTION_PROFILE_EXTENSION);
        DEBUG_CONNECTION_PROFILE_EXTENSION = debug == null ? false : debug.equalsIgnoreCase("true");
    }

    public Map getProviders() {
        if (this.mProviders == null) {
            this.processExtensions();
        }
        return this.mProviders;
    }

    public IConnectionProfileProvider getProvider(String id) {
        Map providers = this.getProviders();
        IConnectionProfileProvider provider = (IConnectionProfileProvider)this.getProviders().get(id);
        if (provider == null) {
            provider = new ConnectionProfileProvider(id);
            providers.put(id, provider);
            Map categories = this.getCategories();
            if (!categories.containsKey("org.eclipse.datatools.connectivity.category.unknown")) {
                categories.put("org.eclipse.datatools.connectivity.category.unknown", CategoryProvider.UNKNOWN_CATEGORY);
            }
        }
        return provider;
    }

    public Map getCategories() {
        if (this.mProviders == null) {
            this.processExtensions();
        }
        return this.mCategories;
    }

    public CategoryProvider getCategory(String id) {
        return (CategoryProvider)this.getCategories().get(id);
    }

    public IConfigurationType getConfigurationType(String id) {
        if (this.mProviders == null) {
            this.processExtensions();
        }
        return (IConfigurationType)this.mConfigurationTypes.get(id);
    }

    public List getConnectionProfilesByCategory(ICategory category, boolean recurse, IProject project) {
        return null;
    }

    private void processExtensions() {
        this.mProviders = new HashMap();
        this.mCategories = new HashMap();
        this.mConfigurationTypes = new HashMap();
        this.mConnectionFactoryAdapters = new HashMap();
        this.mDisabledProviders = new HashSet();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint exp = registry.getExtensionPoint(EXTENSION_ID);
        IExtension[] exts = exp.getExtensions();
        ArrayList<IConfigurationElement> profileExts = new ArrayList<IConfigurationElement>(exts.length);
        Iterator<IExtension> xit = Arrays.asList(exts).iterator();
        while (xit.hasNext()) {
            IExtension ext = xit.next();
            IConfigurationElement[] elems = ext.getConfigurationElements();
            Iterator<IConfigurationElement> eit = Arrays.asList(elems).iterator();
            while (eit.hasNext()) {
                IConfigurationElement elem = eit.next();
                String elemName = elem.getName();
                if (EXT_ELEM_CONNECTION_PROFILE.equals(elemName)) {
                    this.processConnectionProfile(elem);
                    continue;
                }
                if (EXT_ELEM_CATEGORY.equals(elemName)) {
                    this.processCategory(elem);
                    continue;
                }
                if (EXT_ELEM_CONFIGURATION_TYPE.equals(elemName)) {
                    this.processConfigurationType(elem);
                    continue;
                }
                profileExts.add(elem);
            }
        }
        Iterator eit = profileExts.iterator();
        while (eit.hasNext()) {
            ConnectionProfileProvider p;
            IConfigurationElement elem = (IConfigurationElement)eit.next();
            String elemName = elem.getName();
            if (EXT_ELEM_CONNECTION_FACTORY.equals(elemName)) {
                p = (ConnectionProfileProvider)this.mProviders.get(elem.getAttribute("profile"));
                Assert.isTrue((p != null ? 1 : 0) != 0, (String)ConnectivityPlugin.getDefault().getResourceString("assert.invalid.profile", new Object[]{elem.toString()}));
                p.addConnectionFactory(elem);
                continue;
            }
            if (EXT_ELEM_PROFILE_EXTENSION.equals(elemName)) {
                p = (ConnectionProfileProvider)this.mProviders.get(elem.getAttribute("profile"));
                Assert.isTrue((p != null ? 1 : 0) != 0, (String)ConnectivityPlugin.getDefault().getResourceString("assert.invalid.profile", new Object[]{elem.toString()}));
                p.addProfileExtension(elem);
                continue;
            }
            if (!EXT_ELEM_CONNECTION_FACTORY_ADAPTER.equals(elemName)) continue;
            this.processConnectionFactoryAdapter(elem);
        }
        this.registerConnectionFactoryAdapters();
        this.mProviders.keySet().removeAll(this.mDisabledProviders);
        this.initializeRepositoriesEnabledProperty();
    }

    private void processConnectionProfile(IConfigurationElement element) {
        ConnectionProfileProvider p = new ConnectionProfileProvider(element);
        if (!this.mProviders.containsKey(p.getId())) {
            this.mProviders.put(p.getId(), p);
        } else {
            ConnectivityPlugin.getDefault().log(ConnectivityPlugin.getDefault().getResourceString("assert.invalid.profile", new Object[]{String.valueOf(p.getId()) + ": " + element.toString()}));
            this.mDisabledProviders.add(p.getId());
        }
    }

    private void processCategory(IConfigurationElement element) {
        CategoryProvider c = new CategoryProvider(element);
        if (!this.mCategories.containsKey(c.getId())) {
            this.mCategories.put(c.getId(), c);
        }
    }

    private void processConfigurationType(IConfigurationElement element) {
        ConfigurationTypeProvider c = new ConfigurationTypeProvider(element);
        Assert.isTrue((!this.mConfigurationTypes.containsKey(c.getId()) ? 1 : 0) != 0, (String)ConnectivityPlugin.getDefault().getResourceString("assert.invalid.profile", new Object[]{element.toString()}));
        this.mConfigurationTypes.put(c.getId(), c);
    }

    private void processConnectionFactoryAdapter(IConfigurationElement element) {
        ConnectionFactoryAdapter cfa;
        ConnectionFactoryAdapterProvider cfap = new ConnectionFactoryAdapterProvider(element);
        HashMap<String, ConnectionFactoryAdapter> adapters = (HashMap<String, ConnectionFactoryAdapter>)this.mConnectionFactoryAdapters.get(cfap.getFactoryId());
        if (adapters == null) {
            adapters = new HashMap<String, ConnectionFactoryAdapter>();
            this.mConnectionFactoryAdapters.put(cfap.getFactoryId(), adapters);
        }
        if ((cfa = (ConnectionFactoryAdapter)adapters.get(cfap.getId())) == null) {
            cfa = new ConnectionFactoryAdapter(cfap.getId(), cfap.getFactoryId());
            adapters.put(cfa.getId(), cfa);
        }
        cfa.addAdapter(cfap);
    }

    private void registerConnectionFactoryAdapters() {
        Iterator provIt = this.mProviders.values().iterator();
        while (provIt.hasNext()) {
            ConnectionProfileProvider cpp = (ConnectionProfileProvider)provIt.next();
            Iterator factIt = cpp.getConnectionFactories().values().iterator();
            while (factIt.hasNext()) {
                IConnectionFactoryProvider icfp = (IConnectionFactoryProvider)factIt.next();
                if (!this.mConnectionFactoryAdapters.containsKey(icfp.getId())) continue;
                Iterator adaptIt = ((Map)this.mConnectionFactoryAdapters.get(icfp.getId())).values().iterator();
                while (adaptIt.hasNext()) {
                    ConnectionFactoryAdapter cap = (ConnectionFactoryAdapter)adaptIt.next();
                    ConnectionFactoryAdapterProvider cfap = cap.getOverride(cpp.getId());
                    if (cfap == null) {
                        cfap = cap.getDefault();
                    }
                    if (cfap == null) continue;
                    cpp.addConnectionFactory(cfap);
                }
            }
        }
    }

    private void initializeRepositoriesEnabledProperty() {
        Iterator it = this.mProviders.values().iterator();
        while (it.hasNext()) {
            ConnectionProfileProvider cpp = (ConnectionProfileProvider)it.next();
            ICategory cat = cpp.getCategory();
            while (cat != null) {
                if ("org.eclipse.datatools.connectivity.connectionProfileRepositoryCategory".equals(cat.getId())) {
                    System.setProperty("org.eclipse.datatools.connectivity.repositoriesEnabled", Boolean.TRUE.toString());
                    return;
                }
                cat = cat.getParent();
            }
        }
    }
}

