/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.launching;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.IDatabaseSetting;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifierImpl;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.dbitem.ParameterDescriptor;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorActivator;
import org.eclipse.datatools.sqltools.routineeditor.launching.Messages;
import org.eclipse.datatools.sqltools.routineeditor.launching.RoutineLaunchConfigurationAttribute;
import org.eclipse.datatools.sqltools.routineeditor.ui.launching.LaunchUI;
import org.eclipse.datatools.sqltools.routineeditor.util.RoutineUtil;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.osgi.util.NLS;

public class LaunchHelper
implements RoutineLaunchConfigurationAttribute {
    public static ILaunchConfigurationType getLaunchConfigType() {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.datatools.sqltools.routineeditor.launching.launchConfigurationType");
    }

    public static ILaunchConfigurationWorkingCopy createExternalClientConfiguration(DatabaseIdentifier databaseIdentifier, String connid) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = null;
        ILaunchConfigurationType configType = LaunchHelper.getLaunchConfigType();
        wc = configType.newInstance(null, "externalCon" + connid);
        wc.setAttribute("org.eclipse.datatools.sqltools.debug.launching.profileName", databaseIdentifier.getProfileName());
        wc.setAttribute("org.eclipse.datatools.sqltools.debug.launching.databasename", databaseIdentifier.getDBname());
        wc.setAttribute("org.eclipse.datatools.sqltools.debug.launching.externalID", connid);
        return wc;
    }

    public static void saveSPUDF(ILaunchConfigurationWorkingCopy configuration, ProcIdentifier proc, List parameters, String sql) {
        configuration.setAttribute("org.eclipse.datatools.sqltools.debug.launching.profileName", proc == null ? "" : proc.getProfileName());
        configuration.setAttribute("org.eclipse.datatools.sqltools.debug.launching.databasename", proc == null ? "" : proc.getDatabaseIdentifier().getDBname());
        configuration.setAttribute("org.eclipse.datatools.sqltools.debug.launching.procid", proc == null ? "" : proc.encode());
        configuration.setAttribute("org.eclipse.datatools.sqltools.debug.launching.type", 0);
        configuration.setAttribute("org.eclipse.datatools.sqltools.debug.launching.triggersql", sql);
        LaunchHelper.saveParameterList(configuration, parameters);
        LaunchHelper.setConnectionLevelOptions(configuration);
    }

    private static void saveParameterList(ILaunchConfigurationWorkingCopy configuration, List parameters) {
        if (parameters == null || parameters.size() == 0) {
            configuration.setAttribute("org.eclipse.datatools.sqltools.debug.launching.parameters", (List)null);
            return;
        }
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < parameters.size(); ++i) {
            String s = (String)parameters.get(i);
            if (s == null) {
                l.add("N");
                continue;
            }
            l.add("Y" + s);
        }
        configuration.setAttribute("org.eclipse.datatools.sqltools.debug.launching.parameters", l);
    }

    public static void saveEvent(ILaunchConfigurationWorkingCopy configuration, ProcIdentifier proc, Map eventparams, String sql) {
        configuration.setAttribute("org.eclipse.datatools.sqltools.debug.launching.profileName", proc == null ? "" : proc.getProfileName());
        configuration.setAttribute("org.eclipse.datatools.sqltools.debug.launching.databasename", proc == null ? "" : proc.getDatabaseIdentifier().getDBname());
        configuration.setAttribute("org.eclipse.datatools.sqltools.debug.launching.procid", proc == null ? "" : proc.encode());
        configuration.setAttribute("org.eclipse.datatools.sqltools.debug.launching.type", 0);
        configuration.setAttribute("org.eclipse.datatools.sqltools.debug.launching.triggersql", sql);
        LaunchHelper.saveEventParameter(configuration, eventparams);
    }

    private static void saveEventParameter(ILaunchConfigurationWorkingCopy wc, Map triggerParams) {
        wc.setAttribute("org.eclipse.datatools.sqltools.debug.launching.eventparams", triggerParams);
    }

    public static void saveAdHocSQL(ILaunchConfigurationWorkingCopy configuration, String profileName, String dbName, String sql) {
        configuration.setAttribute("org.eclipse.datatools.sqltools.debug.launching.profileName", profileName);
        configuration.setAttribute("org.eclipse.datatools.sqltools.debug.launching.databasename", dbName);
        configuration.setAttribute("org.eclipse.datatools.sqltools.debug.launching.type", 3);
        configuration.setAttribute("org.eclipse.datatools.sqltools.debug.launching.triggersql", sql);
    }

    public static void saveTrigger(ILaunchConfigurationWorkingCopy configuration, ProcIdentifier proc, String sql) {
        configuration.setAttribute("org.eclipse.datatools.sqltools.debug.launching.profileName", proc == null ? "" : proc.getDatabaseIdentifier().getProfileName());
        configuration.setAttribute("org.eclipse.datatools.sqltools.debug.launching.databasename", proc == null ? "" : proc.getDatabaseIdentifier().getDBname());
        configuration.setAttribute("org.eclipse.datatools.sqltools.debug.launching.procid", proc == null ? "" : proc.encode());
        configuration.setAttribute("org.eclipse.datatools.sqltools.debug.launching.type", 0);
        configuration.setAttribute("org.eclipse.datatools.sqltools.debug.launching.triggersql", sql);
    }

    public static void initializeConfiguration(ILaunchConfigurationWorkingCopy configuration, ProcIdentifier proc) {
        if (proc.getType() == 3) {
            LaunchHelper.saveTrigger(configuration, proc, "");
        } else if (proc.getType() == 2) {
            LaunchHelper.saveEvent(configuration, proc, new HashMap(), "");
        } else {
            ArrayList<String> values = new ArrayList<String>();
            try {
                ParameterDescriptor[] pds = LaunchUI.getParameterDescriptors(proc);
                for (int i = 0; i < pds.length; ++i) {
                    ParameterDescriptor descriptor = pds[i];
                    if (descriptor != null) {
                        String defaultValue = descriptor.getDefaultValue();
                        if (defaultValue != null) {
                            values.add(defaultValue);
                            continue;
                        }
                        values.add(null);
                        continue;
                    }
                    values.add(null);
                }
            }
            catch (SQLException e) {
                RoutineEditorActivator.getDefault().log(e);
            }
            catch (NoSuchProfileException e) {
                RoutineEditorActivator.getDefault().log(e);
            }
            LaunchHelper.saveSPUDF(configuration, proc, values, "");
        }
    }

    public static String readExternalClientId(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.datatools.sqltools.debug.launching.externalID", "");
    }

    public static DatabaseIdentifier readDatabaseIdentifier(ILaunchConfiguration configuration) throws CoreException {
        String profileName = configuration.getAttribute("org.eclipse.datatools.sqltools.debug.launching.profileName", "");
        String dbName = configuration.getAttribute("org.eclipse.datatools.sqltools.debug.launching.databasename", "");
        if ("".equals(profileName)) {
            throw new CoreException((IStatus)new Status(4, RoutineEditorActivator.PLUGIN_ID, 0, Messages.LaunchHelper_invalid_launch_configuration, null));
        }
        return new DatabaseIdentifier(profileName, dbName);
    }

    public static boolean isAdHocSQL(ILaunchConfiguration configuration) throws CoreException {
        int type = configuration.getAttribute("org.eclipse.datatools.sqltools.debug.launching.type", 0);
        return type == 3;
    }

    public static ProcIdentifier readProcIdentifier(ILaunchConfiguration configuration) throws CoreException {
        if (LaunchHelper.isAdHocSQL(configuration)) {
            return null;
        }
        String encoded = configuration.getAttribute("org.eclipse.datatools.sqltools.debug.launching.procid", "");
        try {
            return ProcIdentifierImpl.decode((String)encoded);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static List readParameterList(ILaunchConfiguration configuration) throws CoreException {
        List l = configuration.getAttribute("org.eclipse.datatools.sqltools.debug.launching.parameters", new ArrayList());
        ArrayList<String> nl = new ArrayList<String>();
        for (int i = 0; i < l.size(); ++i) {
            String s = (String)l.get(i);
            nl.add(s);
            if (s == null || s.length() == 0) {
                nl.set(i, null);
                continue;
            }
            if (s.charAt(0) == 'N') {
                nl.set(i, null);
                continue;
            }
            if (s.charAt(0) == 'Y') {
                nl.set(i, s.substring(1));
                continue;
            }
            nl.set(i, s);
        }
        return nl;
    }

    public static Map readEventParameter(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.datatools.sqltools.debug.launching.eventparams", new HashMap());
    }

    public static String readLaunchSQLStatement(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.datatools.sqltools.debug.launching.triggersql", "");
    }

    public static String constructDirectInvocationSQLString(ILaunchConfiguration configuration) throws CoreException, SQLException, NoSuchProfileException {
        if (LaunchHelper.isAdHocSQL(configuration)) {
            return LaunchHelper.readLaunchSQLStatement(configuration);
        }
        ProcIdentifier proc = LaunchHelper.readProcIdentifier(configuration);
        if (proc == null) {
            return "";
        }
        boolean quoted_id = LaunchHelper.readQuotedIDConfig(configuration, proc);
        switch (proc.getType()) {
            case 0: 
            case 1: {
                return RoutineUtil.constructSPUDFDirectInvocationString(proc, LaunchHelper.readParameterList(configuration), LaunchUI.getParameterDescriptors(proc), quoted_id);
            }
            case 2: {
                return RoutineUtil.constructTriggerEventString(proc, LaunchHelper.readEventParameter(configuration), quoted_id);
            }
            case 3: {
                return LaunchHelper.readLaunchSQLStatement(configuration);
            }
        }
        return "";
    }

    public static String constructCallableStatementSQLString(ILaunchConfiguration configuration) throws CoreException, SQLException, NoSuchProfileException {
        if (LaunchHelper.isAdHocSQL(configuration)) {
            return LaunchHelper.readLaunchSQLStatement(configuration);
        }
        ProcIdentifier proc = LaunchHelper.readProcIdentifier(configuration);
        if (proc == null) {
            return "";
        }
        boolean quoted_id = LaunchHelper.readQuotedIDConfig(configuration, proc);
        switch (proc.getType()) {
            case 0: 
            case 1: {
                return RoutineUtil.constructCallableSPUDFString(proc, LaunchHelper.readParameterList(configuration), LaunchUI.getAllParameterDescriptors(proc), quoted_id);
            }
            case 2: {
                return RoutineUtil.constructTriggerEventString(proc, LaunchHelper.readEventParameter(configuration), quoted_id);
            }
        }
        return "";
    }

    public static String constructCallableStatementDisplayString(ILaunchConfiguration configuration) throws CoreException, SQLException, NoSuchProfileException {
        if (LaunchHelper.isAdHocSQL(configuration)) {
            return LaunchHelper.readLaunchSQLStatement(configuration);
        }
        ProcIdentifier proc = LaunchHelper.readProcIdentifier(configuration);
        if (proc == null) {
            return "";
        }
        boolean quoted_id = LaunchHelper.readQuotedIDConfig(configuration, proc);
        switch (proc.getType()) {
            case 0: 
            case 1: {
                return RoutineUtil.constructCallableSPUDFDisplayString(proc, LaunchHelper.readParameterList(configuration), LaunchUI.getAllParameterDescriptors(proc), quoted_id);
            }
            case 2: {
                return RoutineUtil.constructTriggerEventString(proc, LaunchHelper.readEventParameter(configuration), quoted_id);
            }
        }
        return "";
    }

    public static boolean readQuotedIDConfig(ILaunchConfiguration configuration, ProcIdentifier proc) {
        boolean quoted_id = false;
        SQLDevToolsConfiguration factory = SQLToolsFacade.getConfiguration(null, (DatabaseIdentifier)proc.getDatabaseIdentifier());
        IDatabaseSetting config = factory.getDatabaseSetting(proc.getDatabaseIdentifier());
        if (config != null) {
            try {
                Boolean value = (Boolean)config.getLaunchConfigProperty(configuration, "C_QUOTED_IDENTIFIER");
                quoted_id = value;
            }
            catch (IDatabaseSetting.NotSupportedSettingException e) {
                RoutineEditorActivator.getDefault().log(NLS.bind((String)Messages.NotSupportedSettingException_cause, (Object[])new Object[]{"C_QUOTED_IDENTIFIER"}));
            }
        }
        return quoted_id;
    }

    public static void setConnectionLevelOptions(ILaunchConfigurationWorkingCopy configuration) {
        try {
            if (configuration.getAttribute("org.eclipse.datatools.sqltools.debug.launching.optiontype", -1) == -1) {
                configuration.setAttribute("org.eclipse.datatools.sqltools.debug.launching.optiontype", 1);
            }
        }
        catch (CoreException ce) {
            RoutineEditorActivator.getDefault().log(Messages.LaunchHelper_error_readconfiguration, ce);
        }
    }

    public static void renameAllConfigurations(ProcIdentifier oldProc, ProcIdentifier newProc) {
        ILaunchConfigurationType type = LaunchHelper.getLaunchConfigType();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
            for (int i = 0; i < configs.length; ++i) {
                try {
                    ProcIdentifier p = LaunchHelper.readProcIdentifier(configs[i]);
                    if (!oldProc.equals(p)) continue;
                    ILaunchConfigurationWorkingCopy copy = configs[i].getWorkingCopy();
                    copy.setAttribute("org.eclipse.datatools.sqltools.debug.launching.procid", newProc.encode());
                    copy.doSave();
                    String sql = LaunchHelper.constructDirectInvocationSQLString(configs[i]);
                    copy.setAttribute("org.eclipse.datatools.sqltools.debug.launching.triggersql", sql);
                    if (configs[i].getName().equals(oldProc.getProcName())) {
                        String newName = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(newProc.getProcName());
                        copy.rename(newName);
                    }
                    copy.doSave();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (CoreException ex) {
            RoutineEditorActivator.getDefault().log(ex);
        }
    }
}

