/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal;

import java.util.ResourceBundle;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorResources;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.SQLConnectAction;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.SQLDisconnectAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;

public class SQLEditorActionContributor
extends TextEditorActionContributor {
    protected RetargetTextEditorAction fContentAssistProposalAction;
    protected RetargetTextEditorAction fContentAssistTipAction;
    protected RetargetTextEditorAction fContentFormatAction;
    private IPropertyChangeListener fConnectActionListener;

    public SQLEditorActionContributor() {
        ResourceBundle bundle = SQLEditorResources.getResourceBundle();
        this.fContentAssistProposalAction = new RetargetTextEditorAction(bundle, "ContentAssistProposal.");
        this.fContentAssistTipAction = new RetargetTextEditorAction(bundle, "ContentAssistTip.");
        this.fContentFormatAction = new RetargetTextEditorAction(bundle, "ContentFormat.");
    }

    public void contributeToMenu(IMenuManager mm) {
        IMenuManager editMenu = mm.findMenuUsingPath("edit");
        if (editMenu != null) {
            editMenu.add((IContributionItem)new Separator());
            editMenu.add((IAction)this.fContentAssistProposalAction);
            editMenu.add((IAction)this.fContentFormatAction);
            editMenu.add((IAction)this.fContentAssistTipAction);
        }
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        super.setActiveEditor(targetEditor);
        ITextEditor textEditor = null;
        if (targetEditor instanceof ITextEditor) {
            textEditor = (ITextEditor)targetEditor;
        }
        this.fContentAssistProposalAction.setAction(this.getAction(textEditor, "ContentAssistProposal"));
        this.fContentAssistTipAction.setAction(this.getAction(textEditor, "ContentAssistTip"));
        this.fContentFormatAction.setAction(this.getAction(textEditor, "ContentFormat"));
        SQLConnectAction connectAction = (SQLConnectAction)this.getAction(textEditor, "SQLEditor.connectAction");
        SQLDisconnectAction disconnectAction = (SQLDisconnectAction)this.getAction(textEditor, "SQLEditor.disconnectAction");
        if (targetEditor instanceof SQLEditor) {
            SQLEditor sqlEditor = (SQLEditor)targetEditor;
            if (connectAction != null) {
                connectAction.setSQLEditor(sqlEditor);
                if (this.fConnectActionListener != null) {
                    connectAction.removePropertyChangeListener(this.fConnectActionListener);
                }
                this.fConnectActionListener = sqlEditor;
                connectAction.addPropertyChangeListener(this.fConnectActionListener);
            }
            if (disconnectAction != null) {
                disconnectAction.setSQLEditor(sqlEditor);
                if (this.fConnectActionListener != null) {
                    disconnectAction.removePropertyChangeListener(this.fConnectActionListener);
                }
                this.fConnectActionListener = sqlEditor;
                disconnectAction.addPropertyChangeListener(this.fConnectActionListener);
            }
        }
    }
}

