/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.actions;

import java.sql.Connection;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.core.services.ConnectionService;
import org.eclipse.datatools.sqltools.core.services.SQLService;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.Messages;
import org.eclipse.datatools.sqltools.sqleditor.result.GroupSQLResultRunnable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class BaseExecuteAction
extends Action
implements IUpdate {
    private Job _job;

    public abstract DatabaseIdentifier getDatabaseIdentifier();

    public abstract String getSQLStatements();

    public abstract Runnable getPostRun();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String sql = this.getSQLStatements();
        DatabaseIdentifier databaseIdentifier = this.getDatabaseIdentifier();
        if (databaseIdentifier == null || sql == null) {
            return;
        }
        Connection conn = null;
        try {
            SQLDevToolsConfiguration f = SQLToolsFacade.getConfigurationByProfileName((String)databaseIdentifier.getProfileName());
            ConnectionService conService = f.getConnectionService();
            conn = conService.createConnection(databaseIdentifier.getProfileName(), databaseIdentifier.getDBname());
            String[] groups = new String[]{sql};
            SQLService sqlService = f.getSQLService();
            if (sqlService != null) {
                groups = sqlService.splitSQL(sql);
            }
            this._job = new GroupSQLResultRunnable(conn, groups, null, this.getPostRun(), databaseIdentifier, this.promptVariable(), this.getVariableDeclarations());
            this._job.setUser(true);
            this._job.schedule();
            this._job.join();
            Runnable parallelRunnable = f.getExecutionService().createExecuteParallelRunnable(this.getSQLStatements(), databaseIdentifier);
            if (parallelRunnable != null) {
                new Thread(parallelRunnable).start();
            }
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.datatools.sqltools.result.resultView");
        }
        catch (Exception e) {
            try {
                this.processError(Messages.ExecuteSQLActionDelegate_error_execute, e, null);
            }
            catch (Throwable throwable) {
                ProfileUtil.closeConnection((String)databaseIdentifier.getProfileName(), (String)databaseIdentifier.getDBname(), conn);
                throw throwable;
            }
            ProfileUtil.closeConnection((String)databaseIdentifier.getProfileName(), (String)databaseIdentifier.getDBname(), (Connection)conn);
        }
        ProfileUtil.closeConnection((String)databaseIdentifier.getProfileName(), (String)databaseIdentifier.getDBname(), (Connection)conn);
    }

    protected boolean promptVariable() {
        return false;
    }

    protected HashMap getVariableDeclarations() {
        return null;
    }

    protected void processError(final String msg, final Exception error, final IStatus status) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                IStatus stat = status;
                if (stat == null) {
                    stat = new Status(4, "org.eclipse.datatools.sqltools.sqleditor", 0, error.getMessage() == null ? "" : error.getMessage(), (Throwable)error);
                }
                String title = Messages.common_error;
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)msg, (IStatus)stat);
            }
        });
        SQLEditorPlugin.getDefault().log(msg, error);
    }

    protected SQLEditor getEditor() {
        return null;
    }
}

