/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.sql;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultAutoIndentStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;

public class SQLAutoIndentStrategy
extends DefaultAutoIndentStrategy {
    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (c.length == 0 && c.text != null && this.endsWithDelimiter(d, c.text)) {
            this.smartIndentAfterNewLine(d, c);
        } else if ("}".equals(c.text)) {
            this.smartInsertAfterBracket(d, c);
        }
    }

    private boolean endsWithDelimiter(IDocument doc, String txt) {
        String[] delimiters = doc.getLegalLineDelimiters();
        if (delimiters != null) {
            return TextUtilities.endsWith((String[])delimiters, (String)txt) > -1;
        }
        return false;
    }

    protected int findEndOfWhiteSpace(IDocument doc, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = doc.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }

    protected int findMatchingOpenBracket(IDocument doc, int line, int end, int closingBracketIncrease) throws BadLocationException {
        int start = doc.getLineOffset(line);
        for (int brackcount = this.getBracketCount(doc, start, end, false) - closingBracketIncrease; brackcount < 0; brackcount += this.getBracketCount(doc, start, end, false)) {
            if (--line < 0) {
                return -1;
            }
            start = doc.getLineOffset(line);
            end = start + doc.getLineLength(line) - 1;
        }
        return line;
    }

    private int getBracketCount(IDocument doc, int start, int end, boolean ignoreCloseBrackets) throws BadLocationException {
        int begin = start;
        int bracketcount = 0;
        block8: while (begin < end) {
            char curr = doc.getChar(begin);
            ++begin;
            switch (curr) {
                case '/': {
                    if (begin >= end) break;
                    char next = doc.getChar(begin);
                    if (next != '*') continue block8;
                    begin = this.getCommentEnd(doc, begin + 1, end);
                    break;
                }
                case '*': {
                    if (begin >= end) break;
                    char next = doc.getChar(begin);
                    if (next != '/') continue block8;
                    bracketcount = 0;
                    ++begin;
                    break;
                }
                case '-': {
                    if (begin >= end) break;
                    char next = doc.getChar(begin);
                    if (next != '-') continue block8;
                    begin = end;
                    break;
                }
                case '{': {
                    ++bracketcount;
                    ignoreCloseBrackets = false;
                    break;
                }
                case '}': {
                    if (ignoreCloseBrackets) break;
                    --bracketcount;
                    break;
                }
                case '\"': 
                case '\'': {
                    begin = this.getStringEnd(doc, begin, end, curr);
                    break;
                }
            }
        }
        return bracketcount;
    }

    private int getCommentEnd(IDocument doc, int start, int end) throws BadLocationException {
        int currentPos = start;
        while (currentPos < end) {
            char currentChar = doc.getChar(currentPos);
            if (currentChar != '*' || ++currentPos >= end || doc.getChar(currentPos) != '/') continue;
            return currentPos + 1;
        }
        return end;
    }

    protected String getIndentOfLine(IDocument doc, int line) throws BadLocationException {
        if (line > -1) {
            int start = doc.getLineOffset(line);
            int end = start + doc.getLineLength(line) - 1;
            int whiteend = this.findEndOfWhiteSpace(doc, start, end);
            return doc.get(start, whiteend - start);
        }
        return "";
    }

    private int getStringEnd(IDocument doc, int start, int end, char character) throws BadLocationException {
        int currentPos = start;
        while (currentPos < end) {
            char currentChar = doc.getChar(currentPos);
            ++currentPos;
            if (currentChar == '\\') {
                ++currentPos;
                continue;
            }
            if (currentChar != character) continue;
            return currentPos;
        }
        return end;
    }

    protected void smartIndentAfterNewLine(IDocument doc, DocumentCommand command) {
        int docLength = doc.getLength();
        if (command.offset == -1 || docLength == 0) {
            return;
        }
        try {
            int p = command.offset == docLength ? command.offset - 1 : command.offset;
            int line = doc.getLineOfOffset(p);
            StringBuffer buf = new StringBuffer(command.text);
            if (command.offset < docLength && doc.getChar(command.offset) == '}') {
                int indLine = this.findMatchingOpenBracket(doc, line, command.offset, 0);
                if (indLine == -1) {
                    indLine = line;
                }
                buf.append(this.getIndentOfLine(doc, indLine));
            } else {
                int start = doc.getLineOffset(line);
                int whiteend = this.findEndOfWhiteSpace(doc, start, command.offset);
                buf.append(doc.get(start, whiteend - start));
                if (this.getBracketCount(doc, start, command.offset, true) > 0) {
                    buf.append('\t');
                }
            }
            command.text = buf.toString();
        }
        catch (BadLocationException excp) {
            // empty catch block
        }
    }

    protected void smartInsertAfterBracket(IDocument doc, DocumentCommand command) {
        if (command.offset == -1 || doc.getLength() == 0) {
            return;
        }
        try {
            int indLine;
            int p = command.offset == doc.getLength() ? command.offset - 1 : command.offset;
            int line = doc.getLineOfOffset(p);
            int start = doc.getLineOffset(line);
            int whiteend = this.findEndOfWhiteSpace(doc, start, command.offset);
            if (whiteend == command.offset && (indLine = this.findMatchingOpenBracket(doc, line, command.offset, 1)) != -1 && indLine != line) {
                StringBuffer replaceText = new StringBuffer(this.getIndentOfLine(doc, indLine));
                replaceText.append(doc.get(whiteend, command.offset - whiteend));
                replaceText.append(command.text);
                command.length = command.offset - start;
                command.offset = start;
                command.text = replaceText.toString();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

