/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.sql;

import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.ISQLCompletionProposal;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.internal.Workbench;

public class SQLCompletionProposal
implements ISQLCompletionProposal {
    private String _displayString;
    private String _replacementString;
    private int _replacementOffset;
    private int _replacementLength;
    private int _cursorPosition;
    private Image _image;
    private IContextInformation _contextInformation;
    private String _additionalProposalInfo;
    private int _relevance;
    public static final int TEMPLATE = 0;
    public static final int OPERATOR = 1;
    public static final int OTHER = 2;
    public static final int KEYWORD = 3;
    public static final int UNRESERVEDKEYWORD = 3;
    public static final int DATABASE = 4;
    public static final int TABLE = 5;
    public static final int STORED_PROCEDURE = 6;
    public static final int TRIGGER = 7;
    public static final int EVENT = 8;
    public static final int COLUMN = 9;
    public static final int VARIABLE = 0;
    public static final int TEMPTABLE_TEMPLATE = 10;
    private IAction _postAction = null;

    public SQLCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, int relevance) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, null, null, null, null, relevance);
    }

    public SQLCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int relevance) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, relevance, null);
    }

    public SQLCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int relevance, IAction postAction) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this._replacementString = replacementString;
        this._replacementOffset = replacementOffset;
        this._replacementLength = replacementLength;
        this._cursorPosition = cursorPosition;
        this._image = image;
        this._displayString = displayString;
        this._contextInformation = contextInformation;
        this._additionalProposalInfo = additionalProposalInfo;
        this._relevance = relevance;
        this._postAction = postAction;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this._replacementOffset, this._replacementLength, this._replacementString);
            if (this._postAction != null) {
                SQLEditor editor;
                Point selection = this.getSelection(document);
                if (selection != null && (editor = (SQLEditor)Workbench.getInstance().getActiveWorkbenchWindow().getActivePage().getActiveEditor()) != null) {
                    editor.getSV().setSelectedRange(selection.x, selection.y);
                }
                this._postAction.run();
            }
        }
        catch (BadLocationException x) {
            SQLEditorPlugin.getDefault().log(x);
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(this._replacementOffset + this._cursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return this._contextInformation;
    }

    public Image getImage() {
        return this._image;
    }

    public String getDisplayString() {
        if (this._displayString != null) {
            return this._displayString;
        }
        return this._replacementString;
    }

    public String getAdditionalProposalInfo() {
        return this._additionalProposalInfo;
    }

    public int getRelevance() {
        return this._relevance;
    }

    public void setRelevance(int relevance) {
        this._relevance = relevance;
    }
}

