/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.sql;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.ISQLDBProposalsService;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLDBProposal;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class SQLDBProposalsService
implements ISQLDBProposalsService {
    protected static int PROPOSAL_TYPE_INVALID = -1;
    protected static int PROPOSAL_TYPE_TABLES = 1;
    protected static int PROPOSAL_TYPE_COLUMNS = 2;
    private ISQLEditorConnectionInfo fConnInfo;
    private List fDBProposalList;
    private List fTokenList;

    public SQLDBProposalsService(ISQLEditorConnectionInfo connInfo) {
        this.fConnInfo = connInfo;
        this.fDBProposalList = new ArrayList();
        this.fTokenList = null;
    }

    protected int determineProposalType(List tokenList) {
        int proposalType = PROPOSAL_TYPE_INVALID;
        if (tokenList.size() == 1) {
            proposalType = this.fConnInfo.getDefaultSchemaName() == null ? PROPOSAL_TYPE_TABLES : PROPOSAL_TYPE_TABLES | PROPOSAL_TYPE_COLUMNS;
        } else if (tokenList.size() == 2) {
            proposalType = PROPOSAL_TYPE_COLUMNS;
        }
        return proposalType;
    }

    public ISQLEditorConnectionInfo getConnectionInfo() {
        return this.fConnInfo;
    }

    public List getDBProposals() {
        return this.fDBProposalList;
    }

    protected Schema getSchema(Database database, String schemaName) {
        EList schemaList = database.getSchemas();
        Schema schema = null;
        for (int i = 0; i < schemaList.size(); ++i) {
            Schema thisSchema = (Schema)schemaList.get(i);
            if (!thisSchema.getName().equalsIgnoreCase(schemaName)) continue;
            schema = thisSchema;
            break;
        }
        return schema;
    }

    public List getTokenList() {
        return this.fTokenList;
    }

    protected void loadColumns(Table table) {
        this.loadColumns(table, true);
    }

    protected void loadColumns(Table table, boolean clear) {
        if (table != null) {
            if (clear) {
                this.fDBProposalList.clear();
            }
            EList columns = table.getColumns();
            for (int j = 0; j < columns.size(); ++j) {
                Column column = (Column)columns.get(j);
                this.fDBProposalList.add(new SQLDBProposal((EObject)column));
            }
        }
    }

    protected void loadDBProposals(List tokenList) {
        this.fDBProposalList.clear();
        Database database = this.fConnInfo.getDatabase();
        String fImpliedSchemaName = this.fConnInfo.getDefaultSchemaName();
        if (database != null) {
            int proposalsType = this.determineProposalType(tokenList);
            Schema schema = this.getSchema(database, (String)tokenList.get(0));
            if ((proposalsType & PROPOSAL_TYPE_TABLES) == PROPOSAL_TYPE_TABLES) {
                this.loadTables(schema, false);
            }
            if ((proposalsType & PROPOSAL_TYPE_COLUMNS) == PROPOSAL_TYPE_COLUMNS) {
                String tableToken = null;
                if (tokenList.size() == 1 && fImpliedSchemaName != null) {
                    schema = this.getSchema(database, fImpliedSchemaName);
                    tableToken = (String)tokenList.get(0);
                } else if (tokenList.size() >= 0) {
                    tableToken = (String)tokenList.get(1);
                }
                if (tableToken != null && tableToken.trim().length() > 0) {
                    Table table = null;
                    EList tables = schema.getTables();
                    for (int i = 0; i < tables.size(); ++i) {
                        table = (Table)tables.get(i);
                        this.loadColumns(table, false);
                    }
                }
            }
        }
    }

    protected void loadTables(Schema schema) {
        this.loadTables(schema, true);
    }

    protected void loadTables(Schema schema, boolean clear) {
        if (schema != null) {
            if (clear) {
                this.fDBProposalList.clear();
            }
            EList tables = schema.getTables();
            for (int i = 0; i < tables.size(); ++i) {
                Table table = (Table)tables.get(i);
                this.fDBProposalList.add(new SQLDBProposal((EObject)table));
            }
        }
    }

    public boolean populate(List tokenList) {
        boolean loaded = false;
        if (tokenList.size() > 0) {
            ISQLEditorConnectionInfo connInfo = this.getConnectionInfo();
            boolean connected = false;
            if (connInfo != null && connInfo.getConnectionProfile() != null) {
                connected = connInfo.getConnectionProfile().isConnected();
            }
            if (connected) {
                loaded = true;
                this.fTokenList = tokenList;
                try {
                    IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                    progressService.runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            List tknList = SQLDBProposalsService.this.getTokenList();
                            SQLDBProposalsService.this.loadDBProposals(tknList);
                        }
                    }, null);
                }
                catch (InterruptedException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
            }
        }
        return loaded;
    }

    public ISQLEditorConnectionInfo getSQLEditorConnectionInfo() {
        return this.fConnInfo;
    }
}

