/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.sql.parser.ParseException;
import org.eclipse.datatools.sqltools.sql.parser.ParserParameters;
import org.eclipse.datatools.sqltools.sql.parser.ParsingResult;
import org.eclipse.datatools.sqltools.sql.parser.SQLParser;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.ISQLCompletionEngine;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLCompletionProposal;
import org.eclipse.datatools.sqltools.sqleditor.internal.utils.SQLWordFinder;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.internal.Workbench;

public class SQLParserCompletionEngine
implements ISQLCompletionEngine {
    private SQLParser _parser;
    private String _fFullText;
    private String _fStartText;
    private int _fWordOffset;
    private int _fDocumentOffset;
    private String _fWord;
    private int _fStartOffset;
    private SQLEditor _editor;
    private Comparator _comparator;
    private Point _selection;

    public ICompletionProposal[] computeProposals(IDocument doc, ITypedRegion partition, int documentOffset, Point selection) {
        this._editor = (SQLEditor)Workbench.getInstance().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        SQLDevToolsConfiguration factory = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)this._editor.getConnectionInfo().getDatabaseVendorDefinitionId());
        this._parser = factory.getSQLService().getSQLParser();
        if (this._parser == null) {
            return null;
        }
        this._fDocumentOffset = documentOffset;
        this._selection = selection;
        String text = doc.get();
        if (text.trim().length() == 0) {
            this._fStartText = text.trim();
            this._fFullText = text.trim();
            this._fWordOffset = 0;
            this._fStartOffset = 0;
            this._fWord = text.trim();
        } else {
            String sqlCmdStartToCurrentCursorText;
            int wordOffset = SQLWordFinder.getWordStartOffset(text, documentOffset - 1);
            int expStart = SQLParserCompletionEngine.findStatementStart(text, this._fDocumentOffset - 1, this._parser.getStatementStartTokens(), this._parser.getStatementTerminators());
            String uptoCurrentCursorText = text.substring(0, documentOffset);
            this._fStartText = sqlCmdStartToCurrentCursorText = text.substring(expStart, documentOffset);
            this._fFullText = uptoCurrentCursorText;
            this._fWordOffset = wordOffset;
            this._fStartOffset = expStart;
            this._fWord = this._fStartText.substring(this._fWordOffset + 1 - this._fStartOffset, this._fDocumentOffset - this._fStartOffset);
        }
        String parseText = null;
        parseText = this._fFullText.equals("") ? this._fFullText : this._fFullText.substring(this._fStartOffset, this._fWordOffset + 1);
        ParserParameters pp = new ParserParameters(this._editor.getEditorInput() instanceof IFileEditorInput || this._editor.getEditorInput() instanceof ILocationProvider);
        pp.setProperty((Object)"__profile_name", (Object)this._editor.getConnectionInfo().getConnectionProfileName());
        pp.setProperty((Object)"__db_name", (Object)this._editor.getConnectionInfo().getDatabaseName());
        pp.setProperty((Object)"__consume_exception", (Object)Boolean.FALSE);
        ParsingResult result = this._parser.parse(parseText + "!%^&", pp);
        if (result.getExceptions() == null || result.getExceptions().size() == 0) {
            return null;
        }
        ParseException pe = (ParseException)result.getExceptions().get(result.getExceptions().size() - 1);
        return this.getProposals(pe.tokenImage, pe.expectedTokenSequences, this._parser);
    }

    private ICompletionProposal[] getProposals(String[] tokenImage, int[][] expectedTokenSequences, SQLParser parser) {
        ArrayList<SQLCompletionProposal> proposals = new ArrayList<SQLCompletionProposal>();
        int replacementOffset = this._fWordOffset >= 0 ? this._fWordOffset + 1 : 0;
        int replacementLength = this._fDocumentOffset > this._fWordOffset ? this._fDocumentOffset - (this._fWordOffset + 1) + this._selection.y : this._fDocumentOffset;
        for (int i = 0; i < expectedTokenSequences.length; ++i) {
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < expectedTokenSequences[i].length; ++j) {
                sb.append(tokenImage[expectedTokenSequences[i][j]]).append(" ");
            }
            String expected = SQLParserCompletionEngine.removeQuotes(sb.toString());
            if (!Character.isLetter(expected.charAt(0))) {
                if (!SQLParserCompletionEngine.startsWithIgnoreCase(expected, this._fWord)) continue;
                proposals.add(new SQLCompletionProposal(expected, replacementOffset, replacementLength, expected.length(), null, expected, null, null, 1));
                continue;
            }
            if (this._fWord.equals("")) {
                proposals.add(new SQLCompletionProposal(expected, this._fDocumentOffset, this._fWord.length() + this._selection.y, expected.length(), null, expected, null, null, 3));
                continue;
            }
            if (!SQLParserCompletionEngine.startsWithIgnoreCase(expected, this._fWord)) continue;
            proposals.add(new SQLCompletionProposal(expected, replacementOffset, replacementLength, expected.length(), null, expected, null, null, 3));
        }
        List unservedKeywordsList = this._parser.getExpectedUnreservedKeywords();
        for (int i = 0; i < unservedKeywordsList.size(); ++i) {
            String sqlWordName = (String)unservedKeywordsList.get(i);
            if (!SQLParserCompletionEngine.startsWithIgnoreCase(sqlWordName, this._fWord)) continue;
            proposals.add(new SQLCompletionProposal(sqlWordName, replacementOffset, replacementLength, sqlWordName.length(), null, sqlWordName, null, null, 3));
        }
        return this.order(proposals.toArray(new ICompletionProposal[0]));
    }

    public static int findStatementStart(String text, int offset, String[] startTokens, String[] terminators) {
        int i;
        if (terminators == null || terminators.length == 0) {
            return 0;
        }
        int lastWhitespace = i = offset;
        while (i >= 0) {
            String check;
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) {
                lastWhitespace = i;
            }
            if ((check = text.substring(i, lastWhitespace)).length() != 0) {
                for (int k = 0; k < terminators.length; ++k) {
                    if (check.equalsIgnoreCase(terminators[k])) {
                        return i;
                    }
                    if (terminators[k].length() != 1 || Character.isLetter(terminators[k].charAt(0)) || !check.endsWith(terminators[k])) continue;
                    return i;
                }
            }
            --i;
        }
        return 0;
    }

    private static String removeQuotes(String string) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\"' && c != '\\') {
                sb.append(c);
                continue;
            }
            if (c != '\\' || string.charAt(i + 1) != '\"') continue;
            sb.append('\"');
            ++i;
        }
        return sb.toString();
    }

    protected ICompletionProposal[] order(ICompletionProposal[] proposals) {
        if (this._comparator != null) {
            Arrays.sort(proposals, this._comparator);
        }
        return proposals;
    }

    private static boolean startsWithIgnoreCase(String string, String prefix) {
        int i;
        if (prefix == null) {
            return true;
        }
        int n = prefix.length();
        int m = string.length();
        for (i = 0; i < n && i < m && Character.toLowerCase(string.charAt(i)) == Character.toLowerCase(prefix.charAt(i)); ++i) {
        }
        return i == n;
    }
}

