/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.result;

import java.sql.Connection;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.editor.core.connection.IConnectionTracker;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.result.Messages;
import org.eclipse.datatools.sqltools.sqleditor.result.SimpleSQLResultRunnable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class GroupSQLResultRunnable
extends SimpleSQLResultRunnable {
    private Connection _conn;
    private Runnable _postRun;
    private String[] _groups;
    private SimpleSQLResultRunnable _currentJob = null;
    private boolean _promptVar = false;
    private HashMap _varDefs = null;

    public GroupSQLResultRunnable(Connection con, String[] groups, IConnectionTracker tracker, Runnable postRun, DatabaseIdentifier databaseIdentifier, boolean promptVar, HashMap varDefs) {
        super(con, "", false, tracker, null, databaseIdentifier, null);
        this._conn = con;
        this._postRun = postRun;
        this._groups = groups;
        this._promptVar = promptVar;
        this._varDefs = varDefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        block17: {
            IStatus iStatus;
            block16: {
                IStatus iStatus2;
                block15: {
                    IStatus e2;
                    block14: {
                        block13: {
                            IJobManager manager = Platform.getJobManager();
                            if (monitor == null) {
                                monitor = manager.createProgressGroup();
                            }
                            String task = Messages.GroupSQLResultRunnable_name;
                            if (this._groups.length > 1) {
                                task = task + NLS.bind((String)"GroupSQLResultRunnable.groups", (Object[])new Object[]{"" + this._groups.length});
                            }
                            monitor.beginTask(task, this._groups.length);
                            try {
                                for (int i = 0; i < this._groups.length; ++i) {
                                    if (this._groups.length > 1) {
                                        monitor.subTask(NLS.bind((String)"GroupSQLResultRunnable.group", (Object[])new Object[]{"" + i}));
                                    }
                                    this._currentJob = new SimpleSQLResultRunnable(this._conn, this._groups[i], false, this._tracker, monitor, this.getDatabaseIdentifier(), null);
                                    this._currentJob.setProgressGroup(monitor, 1);
                                    this._currentJob.schedule();
                                    try {
                                        this._currentJob.join();
                                    }
                                    catch (InterruptedException e2) {
                                        OperationCommand operationCommand = this._currentJob.getOperationCommand();
                                        synchronized (operationCommand) {
                                            this.resultsViewAPI.appendStatusMessage(this._currentJob.getOperationCommand(), e2.getLocalizedMessage());
                                            this.resultsViewAPI.updateStatus(this._currentJob.getOperationCommand(), 4);
                                        }
                                    }
                                    monitor.worked(1);
                                    if (monitor.isCanceled()) {
                                        this._currentJob.terminateExecution();
                                        e2 = Status.CANCEL_STATUS;
                                        Object var10_9 = null;
                                        break block13;
                                    }
                                    if (this.resultsViewAPI.getCurrentStatus(this._currentJob.getOperationCommand()) == 3 || i >= this._groups.length - 1) continue;
                                    if (this.resultsViewAPI.getCurrentStatus(this._currentJob.getOperationCommand()) == 5) {
                                        e2 = Status.CANCEL_STATUS;
                                        break block14;
                                    }
                                    IPreferenceStore store = SQLEditorPlugin.getDefault().getPreferenceStore();
                                    String errorpm = store.getString("PreferenceConstants.EXECUTE_SQL_ERROR_MODE");
                                    if (errorpm == null || errorpm.equals("") || "PreferenceConstants.PROMPT_MODE_PROMPT".equals(errorpm)) {
                                        final ConfirmAction run = new ConfirmAction();
                                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                                            public void run() {
                                                run.run();
                                            }
                                        });
                                        if (run._goon) continue;
                                        iStatus2 = Status.CANCEL_STATUS;
                                        break block15;
                                    }
                                    if ("PreferenceConstants.PROMPT_MODE_ALWAYS".equals(errorpm)) continue;
                                    iStatus = Status.CANCEL_STATUS;
                                    break block16;
                                }
                                break block17;
                            }
                            catch (Throwable throwable) {
                                Object var10_14 = null;
                                monitor.done();
                                if (this._postRun == null) throw throwable;
                                PlatformUI.getWorkbench().getDisplay().syncExec(this._postRun);
                                throw throwable;
                            }
                        }
                        monitor.done();
                        if (this._postRun == null) return e2;
                        PlatformUI.getWorkbench().getDisplay().syncExec(this._postRun);
                        return e2;
                    }
                    Object var10_10 = null;
                    monitor.done();
                    if (this._postRun == null) return e2;
                    PlatformUI.getWorkbench().getDisplay().syncExec(this._postRun);
                    return e2;
                }
                Object var10_11 = null;
                monitor.done();
                if (this._postRun == null) return iStatus2;
                PlatformUI.getWorkbench().getDisplay().syncExec(this._postRun);
                return iStatus2;
            }
            Object var10_12 = null;
            monitor.done();
            if (this._postRun == null) return iStatus;
            PlatformUI.getWorkbench().getDisplay().syncExec(this._postRun);
            return iStatus;
        }
        Object var10_13 = null;
        monitor.done();
        if (this._postRun == null) return Status.OK_STATUS;
        PlatformUI.getWorkbench().getDisplay().syncExec(this._postRun);
        return Status.OK_STATUS;
    }

    public void run() {
        this.run(null);
    }

    private final class ConfirmAction
    extends Action {
        boolean _goon = false;

        private ConfirmAction() {
        }

        public void run() {
            IPreferenceStore store = SQLEditorPlugin.getDefault().getPreferenceStore();
            MessageDialogWithToggle dlg = MessageDialogWithToggle.openYesNoQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.GroupSQLResultRunnable_title, (String)Messages.GroupSQLResultRunnable_message, null, (boolean)false, (IPreferenceStore)store, (String)"PreferenceConstants.EXECUTE_SQL_ERROR_MODE");
            int result = dlg.getReturnCode();
            if (dlg.getToggleState()) {
                String preferenceValue = result == 2 ? "PreferenceConstants.PROMPT_MODE_ALWAYS" : "PreferenceConstants.PROMPT_MODE_NEVER";
                store.setValue("PreferenceConstants.EXECUTE_SQL_ERROR_MODE", preferenceValue);
            }
            this._goon = result == 2;
        }
    }
}

