/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.result;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.editor.core.connection.IConnectionInitializer;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.ResultsViewAPI;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.result.Messages;
import org.eclipse.debug.core.ILaunchConfiguration;

public abstract class ResultSupportRunnable
extends Job
implements Runnable {
    private static int TASK_TOTAL = 100;
    private static int TASK_CONNECTION = 10;
    private static int TASK_STATEMENT = 10;
    private static int TASK_RUN = 50;
    private static int TASK_ITERATE = 30;
    protected Statement _stmt;
    protected boolean _terminated = false;
    protected IProgressMonitor _monitor = null;
    protected IProgressMonitor _parentMonitor = null;
    protected DatabaseIdentifier _databaseIdentifier = null;
    protected Runnable _connKiller = null;
    protected ResultsViewAPI resultsViewAPI = ResultsViewAPI.getInstance();

    public ResultSupportRunnable(String name, IProgressMonitor parentMonitor, DatabaseIdentifier databaseIdentifier) {
        super(name == null ? Messages.ResultSupportRunnable_name : name);
        this._databaseIdentifier = databaseIdentifier;
        this._parentMonitor = parentMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        block28: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            this._monitor = monitor;
            monitor.beginTask(Messages.ResultSupportRunnable_name, TASK_TOTAL);
            monitor.subTask(Messages.ResultSupportRunnable_task_connection);
            this.resultsViewAPI.createNewInstance(this.getOperationCommand(), this.getTerminateHandler());
            Connection connection = this.getConnection();
            this._connKiller = SQLToolsFacade.getConfiguration((DatabaseIdentifier)this._databaseIdentifier, null).getConnectionService().getConnectionKiller(this._databaseIdentifier, connection);
            IConnectionInitializer init = SQLToolsFacade.getConfiguration((DatabaseIdentifier)this._databaseIdentifier, null).getConnectionService().getConnectionInitializer();
            if (init != null) {
                init.init(this._databaseIdentifier, connection, this.getConfiguration());
            }
            try {
                boolean moreResult;
                block27: {
                    block26: {
                        monitor.worked(TASK_CONNECTION);
                        if (monitor.isCanceled()) {
                            this.terminateExecution();
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        monitor.subTask(Messages.ResultSupportRunnable_task_statement);
                        try {
                            this._stmt = this.prepareStatement(connection);
                            this._stmt.setMaxFieldSize(16384);
                            monitor.worked(TASK_STATEMENT);
                            if (!monitor.isCanceled()) break block26;
                            this.terminateExecution();
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        catch (Throwable th) {
                            OperationCommand operationCommand = this.getOperationCommand();
                            synchronized (operationCommand) {
                                this.resultsViewAPI.appendStatusMessage(this.getOperationCommand(), th.getMessage());
                                this.resultsViewAPI.updateStatus(this.getOperationCommand(), 4);
                            }
                            operationCommand = Status.CANCEL_STATUS;
                            this.handleEnd(connection, this._stmt);
                            monitor.done();
                            return operationCommand;
                        }
                    }
                    monitor.subTask(Messages.ResultSupportRunnable_task_run);
                    moreResult = false;
                    try {
                        moreResult = this.runStatement(this._stmt);
                        monitor.worked(TASK_RUN);
                        if (!monitor.isCanceled()) break block27;
                        this.terminateExecution();
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    catch (Throwable th) {
                        OperationCommand operationCommand;
                        if (th instanceof SQLException) {
                            this.handleSQLException((SQLException)th);
                        } else {
                            operationCommand = this.getOperationCommand();
                            synchronized (operationCommand) {
                                this.resultsViewAPI.appendStatusMessage(this.getOperationCommand(), th.getMessage());
                                this.resultsViewAPI.updateStatus(this.getOperationCommand(), 4);
                            }
                        }
                        operationCommand = Status.CANCEL_STATUS;
                        this.handleEnd(connection, this._stmt);
                        monitor.done();
                        return operationCommand;
                    }
                }
                monitor.subTask(Messages.ResultSupportRunnable_task_iterate);
                boolean success = this.handleSuccess(moreResult);
                if (success) {
                    monitor.worked(TASK_ITERATE);
                    break block28;
                }
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            finally {
                this.handleEnd(connection, this._stmt);
                monitor.done();
            }
        }
        return Status.OK_STATUS;
    }

    public void run() {
        this.run(null);
    }

    protected abstract Connection getConnection();

    protected abstract OperationCommand getOperationCommand();

    protected abstract Statement prepareStatement(Connection var1) throws SQLException;

    protected abstract boolean runStatement(Statement var1) throws SQLException;

    protected void handleEnd(Connection connection, Statement stmt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleSuccess(boolean moreResult) {
        if (this.isTerminated() || this.isCanceled()) {
            return false;
        }
        try {
            this.loopThroughResults(this._stmt, moreResult);
            OperationCommand operationCommand = this.getOperationCommand();
            synchronized (operationCommand) {
                this.resultsViewAPI.updateStatus(this.getOperationCommand(), 3);
            }
        }
        catch (SQLException ex) {
            OperationCommand operationCommand = this.getOperationCommand();
            synchronized (operationCommand) {
                this.resultsViewAPI.appendStatusMessage(this.getOperationCommand(), ex.getMessage());
                this.resultsViewAPI.updateStatus(this.getOperationCommand(), 4);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSQLException(SQLException exception) {
        this.resultsViewAPI.appendStatusMessage(this.getOperationCommand(), exception.getMessage());
        if (this.isTerminated() || this.isCanceled()) {
            return;
        }
        try {
            this.loopThroughResults(this._stmt, this._stmt.getMoreResults());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        OperationCommand operationCommand = this.getOperationCommand();
        synchronized (operationCommand) {
            this.resultsViewAPI.updateStatus(this.getOperationCommand(), 4);
        }
    }

    protected Runnable getTerminateHandler() {
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (ResultSupportRunnable.this.isTerminated()) {
                    return;
                }
                OperationCommand operationCommand = ResultSupportRunnable.this.getOperationCommand();
                synchronized (operationCommand) {
                    if (ResultSupportRunnable.this._stmt != null) {
                        try {
                            ResultSupportRunnable.this._stmt.cancel();
                        }
                        catch (Exception e) {
                            SQLEditorPlugin.getDefault().log(e);
                        }
                    }
                    ResultSupportRunnable.this._terminated = true;
                    OperationCommand operationCommand2 = ResultSupportRunnable.this.getOperationCommand();
                    synchronized (operationCommand2) {
                        ResultSupportRunnable.this.resultsViewAPI.updateStatus(ResultSupportRunnable.this.getOperationCommand(), 5);
                    }
                }
                if (ResultSupportRunnable.this._monitor != null && !ResultSupportRunnable.this._monitor.isCanceled()) {
                    ResultSupportRunnable.this.cancel();
                }
                if (ResultSupportRunnable.this._connKiller != null) {
                    ResultSupportRunnable.this._connKiller.run();
                }
            }
        };
        return run;
    }

    public void loopThroughResults(Statement cstmt, boolean moreResult) throws SQLException {
        boolean hasException = false;
        boolean lastException = false;
        SQLException exception = null;
        ResultSet rs = null;
        ArrayList<Integer> updateCountList = new ArrayList<Integer>();
        while (!this.isTerminated()) {
            if (this.isCanceled()) {
                this.terminateExecution();
                throw new SQLException(Messages.ResultSupportRunnable_exception_terminated);
            }
            int updateCount = 0;
            if (!lastException) {
                try {
                    if (moreResult && (rs = cstmt.getResultSet()) != null) {
                        this.resultsViewAPI.appendResultSet(this.getOperationCommand(), rs);
                    }
                    if ((updateCount = cstmt.getUpdateCount()) == 0) {
                        moreResult = cstmt.getMoreResults();
                        continue;
                    }
                    if (updateCount > 0) {
                        updateCountList.add(new Integer(updateCount));
                        this.resultsViewAPI.appendUpdateCountMessage(this.getOperationCommand(), updateCount);
                    }
                    if (updateCount <= 0 && rs == null) break;
                    moreResult = cstmt.getMoreResults();
                    rs = null;
                    continue;
                }
                catch (SQLException ex) {
                    this.resultsViewAPI.appendStatusMessage(this.getOperationCommand(), ex.getMessage());
                    exception = ex;
                    hasException = true;
                    lastException = true;
                    if (cstmt == null || this.getConnection() == null || this.getConnection().isClosed()) break;
                }
            }
            try {
                moreResult = cstmt.getMoreResults();
                lastException = false;
            }
            catch (SQLException ex) {
                if (ex.getSQLState() != null && exception != null && ex.getSQLState().equals(exception.getSQLState())) break;
                this.resultsViewAPI.appendStatusMessage(this.getOperationCommand(), ex.getMessage());
                exception = ex;
                hasException = true;
                lastException = true;
                if (cstmt != null && this.getConnection() != null && !this.getConnection().isClosed()) continue;
                break;
            }
        }
        if (hasException) {
            throw exception;
        }
    }

    protected boolean isTerminated() {
        return this._terminated;
    }

    protected boolean isCanceled() {
        return this._monitor != null && this._monitor.isCanceled() || this._parentMonitor != null && this._parentMonitor.isCanceled();
    }

    protected void terminateExecution() {
        this.getTerminateHandler().run();
    }

    public abstract ILaunchConfiguration getConfiguration();

    public DatabaseIdentifier getDatabaseIdentifier() {
        return this._databaseIdentifier;
    }
}

