/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.result;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.editor.core.connection.IConnectionTracker;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.sql.util.SQLUtil;
import org.eclipse.datatools.sqltools.sqleditor.result.ResultSupportRunnable;
import org.eclipse.debug.core.ILaunchConfiguration;

public class SimpleSQLResultRunnable
extends ResultSupportRunnable {
    private static final int SQL_SHORT_DESC_LENGTH = 40;
    protected Connection _connection;
    protected String _sql;
    protected boolean _closeCon;
    protected IConnectionTracker _tracker;
    protected boolean _promptVar = false;
    protected HashMap _varDecs = null;
    private ILaunchConfiguration _configuration;
    private OperationCommand _command = null;

    public SimpleSQLResultRunnable(Connection con, String sql, boolean closeCon, IConnectionTracker tracker, IProgressMonitor parentMonitor, DatabaseIdentifier databaseIdentifier, ILaunchConfiguration configuration) {
        super(SQLUtil.describeSQL((String)sql, (int)40), parentMonitor, databaseIdentifier);
        this._connection = con;
        this._sql = sql;
        this._closeCon = closeCon;
        this._tracker = tracker;
        this._configuration = configuration;
    }

    protected Connection getConnection() {
        return this._connection;
    }

    protected OperationCommand getOperationCommand() {
        if (this._command == null) {
            this._command = new OperationCommand(1, this._sql, "SQL Editor", this._databaseIdentifier.getProfileName(), this._databaseIdentifier.getDBname());
        }
        return this._command;
    }

    protected Statement prepareStatement(Connection connection) throws SQLException {
        return connection.createStatement();
    }

    protected boolean runStatement(Statement stmt) throws SQLException {
        return stmt.execute(this._sql);
    }

    protected void handleEnd(Connection connection, Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (connection != null && !this.isTerminated() && !this.isCanceled() && this._closeCon) {
                connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._closeCon && this._tracker != null) {
            this._tracker.connectionClosed();
        }
    }

    public ILaunchConfiguration getConfiguration() {
        return this._configuration;
    }
}

