/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;

public class DatabaseHelper {
    public static List getTableList(Database database) {
        ArrayList tempList = new ArrayList();
        if (database != null) {
            List sList = DatabaseHelper.getSchemaList(database);
            Iterator schemaIter = sList.iterator();
            while (schemaIter.hasNext()) {
                Schema lSchema = (Schema)schemaIter.next();
                tempList.addAll(DatabaseHelper.getTableList(lSchema));
            }
        }
        return tempList;
    }

    public static List getTableList(Schema schema) {
        ArrayList<Table> tempList = new ArrayList<Table>();
        if (schema != null) {
            EList tList = schema.getTables();
            Iterator tableIter = tList.iterator();
            while (tableIter.hasNext()) {
                Table table = (Table)tableIter.next();
                tempList.add(table);
            }
        }
        return tempList;
    }

    public static List getSchemaList(Database database) {
        ArrayList tempList = new ArrayList();
        if (database != null && database.getSchemas() != null && database.getSchemas().size() > 0) {
            tempList.addAll(database.getSchemas());
        } else if (database != null && database.getCatalogs() != null && database.getCatalogs().size() > 0) {
            EList catalogs = database.getCatalogs();
            Iterator itCatalogs = catalogs.iterator();
            while (itCatalogs.hasNext()) {
                Catalog catalog = (Catalog)itCatalogs.next();
                catalog.getName();
                if (catalog.getSchemas() == null || catalog.getSchemas().size() <= 0) continue;
                tempList.addAll(catalog.getSchemas());
            }
        }
        return tempList;
    }
}

