/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionBody;
import org.eclipse.datatools.modelbase.sql.query.QueryUpdateStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryModelFactory;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.TableInDatabase;
import org.eclipse.datatools.modelbase.sql.query.UpdateAssignmentExpression;
import org.eclipse.datatools.modelbase.sql.query.UpdateSource;
import org.eclipse.datatools.modelbase.sql.query.UpdateSourceExprList;
import org.eclipse.datatools.modelbase.sql.query.UpdateSourceQuery;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionDefaultValue;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.TableHelper;
import org.eclipse.datatools.modelbase.sql.query.impl.SQLQueryModelFactoryImpl;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.emf.common.util.EList;

public class UpdateHelper {
    static SQLQueryModelFactory factory = SQLQueryModelFactoryImpl.eINSTANCE;

    public static void clearAssignmentExprList(QueryUpdateStatement statement) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{statement});
        }
        EList assignExprList = statement.getAssignmentClause();
        assignExprList.clear();
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static List getTargetColumns(QueryUpdateStatement statement) {
        ArrayList columns = null;
        EList assignExprList = statement.getAssignmentClause();
        if (assignExprList != null) {
            columns = new ArrayList();
            Iterator assignExprItr = assignExprList.iterator();
            while (assignExprItr.hasNext()) {
                UpdateAssignmentExpression assignExpr = (UpdateAssignmentExpression)assignExprItr.next();
                EList colList = assignExpr.getTargetColumnList();
                if (colList == null) continue;
                Iterator colListItr = colList.iterator();
                while (colListItr.hasNext()) {
                    columns.add(colListItr.next());
                }
            }
        }
        return columns;
    }

    public static UpdateAssignmentExpression getAssignmentExprForColumn(QueryUpdateStatement statement, ValueExpressionColumn column) {
        UpdateAssignmentExpression assignExpr = null;
        if (statement != null && column != null) {
            Iterator exprListItr = statement.getAssignmentClause().iterator();
            boolean found = false;
            while (!found && exprListItr.hasNext()) {
                UpdateAssignmentExpression tempExpr = (UpdateAssignmentExpression)exprListItr.next();
                Iterator colItr = tempExpr.getTargetColumnList().iterator();
                while (!found && colItr.hasNext()) {
                    ValueExpressionColumn tempColumn = (ValueExpressionColumn)colItr.next();
                    if (!tempColumn.getName().equals(column.getName())) continue;
                    assignExpr = tempExpr;
                    found = true;
                }
            }
        }
        return assignExpr;
    }

    public static void removeColumn(QueryUpdateStatement statement, ValueExpressionColumn column) {
        UpdateAssignmentExpression expr;
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{statement, column});
        }
        if (statement != null && column != null && (expr = UpdateHelper.getAssignmentExprForColumn(statement, column)) != null) {
            EList colList = expr.getTargetColumnList();
            int index = colList.indexOf(column);
            if (index == -1) {
                int size = colList.size();
                String removedColumnName = column.getName();
                int i = 0;
                while (i < size) {
                    ValueExpressionColumn targetColumn = (ValueExpressionColumn)colList.get(i);
                    if (removedColumnName.equalsIgnoreCase(targetColumn.getName())) {
                        index = i;
                        break;
                    }
                    ++i;
                }
            }
            if (index != -1) {
                EList values;
                colList.remove(index);
                UpdateSource source = expr.getUpdateSource();
                if (source instanceof UpdateSourceExprList && (values = ((UpdateSourceExprList)source).getValueExprList()) != null) {
                    values.remove(index);
                }
            }
            if (colList.size() == 0) {
                expr.setUpdateSource(null);
                EList assignExprList = statement.getAssignmentClause();
                assignExprList.remove(expr);
            } else {
                EList assignExprList = statement.getAssignmentClause();
                int indx = assignExprList.indexOf(expr);
                assignExprList.set(indx, expr);
            }
            SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)statement));
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static void removeColumn(QueryUpdateStatement statement, Column column) {
        ValueExpressionColumn valExprCol = TableHelper.getColumnExpressionForColumn((TableExpression)statement.getTargetTable(), (Column)column);
        UpdateHelper.removeColumn(statement, valExprCol);
    }

    public static void replaceStatementContents(QueryUpdateStatement oldStmt, QueryUpdateStatement newStmt) {
        if (oldStmt != null && newStmt != null) {
            oldStmt.setLabel(newStmt.getLabel());
            oldStmt.setName(newStmt.getName());
            oldStmt.setSourceInfo(newStmt.getSourceInfo());
            oldStmt.setWhereClause(newStmt.getWhereClause());
            oldStmt.setWhereCurrentOfClause(newStmt.getWhereCurrentOfClause());
            oldStmt.setTargetTable(newStmt.getTargetTable());
            UpdateHelper.clearAssignmentExprList(oldStmt);
            EList oldList = oldStmt.getAssignmentClause();
            EList newList = newStmt.getAssignmentClause();
            oldList.addAll(newList);
        }
    }

    public static void addColumn(QueryUpdateStatement statement, Column column) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{statement, column});
        }
        if (statement != null && column != null) {
            ValueExpressionColumn valueExprCol = TableHelper.getColumnExpressionForColumn((TableExpression)statement.getTargetTable(), (Column)column);
            QueryValueExpression valueExpr = UpdateHelper.getDefaultColumnValue(column);
            UpdateAssignmentExpression assignExpr = factory.createUpdateAssignmentExpression();
            assignExpr.getTargetColumnList().add((Object)valueExprCol);
            UpdateSourceExprList sourceExprList = factory.createUpdateSourceExprList();
            sourceExprList.getValueExprList().add((Object)valueExpr);
            assignExpr.setUpdateSource((UpdateSource)sourceExprList);
            EList assignExprList = statement.getAssignmentClause();
            assignExprList.add(assignExpr);
            SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)statement));
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static void addColumn(QueryUpdateStatement statement, ValueExpressionColumn valueExprCol, QueryValueExpression valueExpr) {
        if (statement == null || valueExprCol == null || valueExpr == null) {
            return;
        }
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{statement});
        }
        UpdateAssignmentExpression assignExpr = factory.createUpdateAssignmentExpression();
        assignExpr.getTargetColumnList().add((Object)valueExprCol);
        UpdateSourceExprList sourceExprList = factory.createUpdateSourceExprList();
        sourceExprList.getValueExprList().add((Object)valueExpr);
        assignExpr.setUpdateSource((UpdateSource)sourceExprList);
        EList assignExprList = statement.getAssignmentClause();
        assignExprList.add(assignExpr);
        SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)statement));
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static void addColumns(QueryUpdateStatement statement, List columns) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{statement, columns});
        }
        if (statement != null && columns != null) {
            UpdateAssignmentExpression assignExpr = factory.createUpdateAssignmentExpression();
            EList targetColList = assignExpr.getTargetColumnList();
            UpdateSourceExprList sourceExprList = factory.createUpdateSourceExprList();
            EList valuesList = sourceExprList.getValueExprList();
            Iterator colsItr = columns.iterator();
            while (colsItr.hasNext()) {
                Column col = (Column)colsItr.next();
                ValueExpressionColumn valueExprCol = TableHelper.getColumnExpressionForColumn((TableExpression)statement.getTargetTable(), (Column)col);
                targetColList.add(valueExprCol);
                QueryValueExpression valueExpr = UpdateHelper.getDefaultColumnValue(col);
                valuesList.add(valueExpr);
            }
            assignExpr.setUpdateSource((UpdateSource)sourceExprList);
            EList assignExprList = statement.getAssignmentClause();
            assignExprList.add(assignExpr);
            SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)statement));
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static QueryValueExpression getDefaultColumnValue(Column column) {
        ValueExpressionDefaultValue valueExpr = factory.createValueExpressionDefaultValue();
        return valueExpr;
    }

    public static QueryValueExpression getValueForColumn(QueryUpdateStatement statement, ValueExpressionColumn column) {
        if (statement == null || column == null) {
            return null;
        }
        QueryValueExpression valueExpr = null;
        EList updateAssignmentExprList = statement.getAssignmentClause();
        if (updateAssignmentExprList == null || updateAssignmentExprList.isEmpty()) {
            return null;
        }
        Iterator assignmentIter = updateAssignmentExprList.iterator();
        while (assignmentIter.hasNext()) {
            UpdateSource updateSource;
            UpdateAssignmentExpression updExpr = (UpdateAssignmentExpression)assignmentIter.next();
            int columnIndex = updExpr.getTargetColumnList().indexOf((Object)column);
            if (columnIndex < 0 || !((updateSource = updExpr.getUpdateSource()) instanceof UpdateSourceExprList)) continue;
            valueExpr = (QueryValueExpression)((UpdateSourceExprList)updateSource).getValueExprList().get(columnIndex);
            break;
        }
        return valueExpr;
    }

    public static ValueExpressionColumn getColumnExpressionForName(QueryUpdateStatement statement, String columnName) {
        ValueExpressionColumn column = null;
        ValueExpressionColumn tempColumn = null;
        boolean found = false;
        Iterator exprListItr = statement.getAssignmentClause().iterator();
        while (!found && exprListItr.hasNext()) {
            UpdateAssignmentExpression expr = (UpdateAssignmentExpression)exprListItr.next();
            Iterator colItr = expr.getTargetColumnList().iterator();
            while (colItr.hasNext()) {
                tempColumn = (ValueExpressionColumn)colItr.next();
                if (!tempColumn.getName().equals(columnName)) continue;
                found = true;
                column = tempColumn;
            }
        }
        return column;
    }

    public static void removeTableFromStatement(QueryUpdateStatement statement) {
        statement.setTargetTable(null);
    }

    public static void setValueForColumn(UpdateSourceExprList source, ValueExpressionColumn column, QueryValueExpression value) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{source, column, value});
        }
        if (source != null) {
            UpdateAssignmentExpression assignExpr = source.getUpdateAssignmentExpr();
            EList colList = assignExpr.getTargetColumnList();
            int index = colList.indexOf(column);
            if (index != -1) {
                EList values = source.getValueExprList();
                values.set(index, value);
            }
            EList exprList = assignExpr.getUpdateStatement().getAssignmentClause();
            exprList.set(0, exprList.get(0));
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static void clearStatementContents(QueryUpdateStatement stmt) {
        if (stmt != null) {
            stmt.setTargetTable(null);
            UpdateHelper.clearAssignmentExprList(stmt);
            stmt.setWhereClause(null);
            stmt.setWhereCurrentOfClause(null);
            stmt.setName(null);
            stmt.setLabel(null);
        }
    }

    public static void setTargetTable(QueryUpdateStatement statement, TableInDatabase targetTable) {
        if (statement != null) {
            statement.setTargetTable(targetTable);
        }
    }

    public static void refresh(QueryUpdateStatement stmt) {
        stmt.setWhereClause(stmt.getWhereClause());
    }

    public static void createUpdateSourceQuery(UpdateAssignmentExpression assignExpr, QueryExpressionBody query) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{assignExpr, query});
        }
        UpdateSourceQuery updateSource = factory.createUpdateSourceQuery();
        updateSource.setQueryExpr(query);
        assignExpr.setUpdateSource((UpdateSource)updateSource);
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static void createUpdateSourceExpressionList(UpdateAssignmentExpression assignExpr, ValueExpressionColumn column, QueryValueExpression valueExpr) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{assignExpr, valueExpr});
        }
        UpdateSourceExprList updateSource = factory.createUpdateSourceExprList();
        EList valuesList = updateSource.getValueExprList();
        EList colList = assignExpr.getTargetColumnList();
        Iterator colsItr = colList.iterator();
        while (colsItr.hasNext()) {
            colsItr.next();
            QueryValueExpression defaultValueExpr = UpdateHelper.getDefaultColumnValue(null);
            valuesList.add(defaultValueExpr);
        }
        int index = colList.indexOf(column);
        if (index != -1) {
            valuesList.set(index, valueExpr);
        }
        assignExpr.setUpdateSource((UpdateSource)updateSource);
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }
}

