/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.ui.wizards;

import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.enablement.oda.ws.soap.SOAPParameter;
import org.eclipse.datatools.enablement.oda.ws.soap.SOAPRequest;
import org.eclipse.datatools.enablement.oda.ws.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.ws.ui.util.WSConsole;
import org.eclipse.datatools.enablement.oda.ws.ui.util.WSUIUtil;
import org.eclipse.datatools.enablement.oda.ws.util.WSUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SOAPRequestPage
extends DataSetWizardPage {
    private transient Text queryText;
    private SOAPParameter[] parameters;
    private static String DEFAULT_MESSAGE = Messages.getString("soapRequestPage.message.default");
    private boolean saved = false;
    protected final String COLUMN_NAME = Messages.getString("parameterInputDialog.column.name");
    protected final String COLUMN_DATATYPE = Messages.getString("parameterInputDialog.column.type");
    protected final String COLUMN_DEFAULTVALUE = Messages.getString("parameterInputDialog.column.defaultValue");

    public SOAPRequestPage(String pageName) {
        super(pageName);
        this.setMessage(DEFAULT_MESSAGE);
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        this.initializeControl();
        WSUIUtil.setSystemHelp(this.getControl(), "org.eclipse.datatools.oda.cshelp.Wizard_WS_SOAP_REQUEST_ID");
    }

    private Control createPageControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(272);
        composite.setLayoutData((Object)layoutData);
        this.setupQueryTextComposite(composite);
        this.setupButtonComposite(composite);
        return composite;
    }

    private void setupQueryTextComposite(Composite parent) {
        this.queryText = new Text(parent, 0x2000B00);
        GridData layoutData = new GridData(1808);
        this.queryText.setLayoutData((Object)layoutData);
    }

    private void setupButtonComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData layoutData = new GridData(272);
        composite.setLayoutData((Object)layoutData);
        Button button = new Button(composite, 0);
        button.setText(Messages.getString("soapRequestPage.button.regenerateTemplate"));
        layoutData = new GridData();
        layoutData.widthHint = 120;
        button.setLayoutData((Object)layoutData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openConfirm(null, (String)Messages.getString("soapRequestPage.title.regenerateTemplate"), (String)Messages.getString("soapRequestPage.message.regenerateTemplate"))) {
                    SOAPRequestPage.this.regenerateTemplate();
                }
            }
        });
        button = new Button(composite, 0);
        button.setText(Messages.getString("soapRequestPage.button.insertParameter"));
        layoutData = new GridData();
        layoutData.widthHint = 120;
        button.setLayoutData((Object)layoutData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterInputDialog dlg = new ParameterInputDialog();
                if (dlg.open() == 0) {
                    SOAPRequestPage.this.parameters = dlg.getSOAPParameters();
                }
            }
        });
        button = new Button(composite, 0);
        button.setText(Messages.getString("soapRequestPage.button.clear"));
        layoutData = new GridData();
        layoutData.widthHint = 120;
        button.setLayoutData((Object)layoutData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SOAPRequestPage.this.queryText.setText("");
            }
        });
    }

    private void regenerateTemplate() {
        this.queryText.setText(WSConsole.getInstance().getTemplate());
    }

    private void initializeControl() {
        this.initWSConsole();
        this.initFromModel();
    }

    private void initWSConsole() {
        if (!WSConsole.getInstance().isSessionOK()) {
            WSConsole.getInstance().start(this.getInitializationDesign());
        }
    }

    private void initFromModel() {
        String wsQueryText = WSConsole.getInstance().getPropertyValue("wsQueryText");
        if (wsQueryText != null) {
            this.queryText.setText(wsQueryText);
        }
        this.parameters = WSConsole.getInstance().getParameters();
        this.saved = false;
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        this.savePage(design);
        WSUIUtil.savePage(design);
        return design;
    }

    private void savePage(DataSetDesign dataSetDesign) {
        if (!WSConsole.getInstance().isSessionOK()) {
            return;
        }
        if (this.isControlCreated() && !this.saved) {
            this.saveToModel();
        }
        dataSetDesign.setQueryText(WSConsole.getInstance().getPropertyValue("wsQueryText"));
    }

    protected void refresh(DataSetDesign dataSetDesign) {
        super.refresh(dataSetDesign);
        this.initFromModel();
    }

    void refresh() {
        String value = WSConsole.getInstance().manipulateTemplate();
        if (value != null) {
            this.queryText.setText(value);
        }
        this.parameters = WSConsole.getInstance().getParameters();
        this.saved = false;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public IWizardPage getNextPage() {
        this.saveToModel();
        return super.getNextPage();
    }

    protected boolean canLeave() {
        this.saveToModel();
        return super.canLeave();
    }

    private void saveToModel() {
        WSConsole.getInstance().setPropertyValue("wsQueryText", this.queryText.getText());
        WSConsole.getInstance().setParameters(this.parameters);
        this.saved = true;
    }

    protected void cleanup() {
        WSConsole.getInstance().terminateSession();
    }

    class ParameterEditDialog
    extends TrayDialog {
        private static final String COLON = ":";
        private static final String EMPTY_STRING = "";
        private String DEFAULT_TITLE;
        private String defaultValue;
        private Text defualtValueText;
        private SOAPParameter soapParameter;

        protected ParameterEditDialog(SOAPParameter soapParameter) {
            super(PlatformUI.getWorkbench().getDisplay().getActiveShell());
            this.DEFAULT_TITLE = Messages.getString("soapRequestPage.paramEditDialog.title");
            this.soapParameter = soapParameter;
            this.defaultValue = soapParameter.getDefaultValue() == null || soapParameter.getDefaultValue().trim().length() == 0 ? EMPTY_STRING : soapParameter.getDefaultValue();
        }

        public void create() {
            super.create();
            Point pt = this.getShell().computeSize(-1, -1);
            pt.x = Math.max(pt.x, 300);
            pt.y = Math.max(pt.y, 200);
            this.getShell().setSize(pt);
            this.getShell().setText(this.getTitle());
        }

        protected String getTitle() {
            return this.DEFAULT_TITLE;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginTop = 15;
            layout.marginRight = 10;
            layout.marginLeft = 10;
            layout.marginBottom = 20;
            layout.numColumns = 2;
            layout.verticalSpacing = 15;
            composite.setLayout((Layout)layout);
            this.createCustomControls(composite);
            WSUIUtil.setSystemHelp((Control)composite, "org.eclipse.datatools.oda.cshelp.Dialog_SOAP_Request_Parameter_Properties_ID");
            return composite;
        }

        protected void createCustomControls(Composite parent) {
            GridData labelGd = new GridData();
            labelGd.widthHint = 100;
            labelGd.heightHint = 15;
            Label columnName = new Label(parent, 0);
            columnName.setText(String.valueOf(SOAPRequestPage.this.COLUMN_NAME) + COLON);
            columnName.setLayoutData((Object)labelGd);
            GridData textGd = new GridData();
            textGd.widthHint = 180;
            textGd.heightHint = 15;
            Text columnNameText = new Text(parent, 2048);
            columnNameText.setText(this.soapParameter.getName());
            columnNameText.setLayoutData((Object)textGd);
            columnNameText.setEnabled(false);
            Label columnType = new Label(parent, 0);
            columnType.setText(String.valueOf(SOAPRequestPage.this.COLUMN_DATATYPE) + COLON);
            columnType.setLayoutData((Object)labelGd);
            Text columnTypeText = new Text(parent, 2048);
            columnTypeText.setText(EMPTY_STRING);
            columnTypeText.setLayoutData((Object)textGd);
            columnTypeText.setEnabled(false);
            Label defualtValue = new Label(parent, 0);
            defualtValue.setText(String.valueOf(SOAPRequestPage.this.COLUMN_DEFAULTVALUE) + COLON);
            defualtValue.setLayoutData((Object)labelGd);
            this.defualtValueText = new Text(parent, 2048);
            this.defualtValueText.setText(this.soapParameter.getDefaultValue());
            this.defualtValueText.setLayoutData((Object)textGd);
            this.defualtValueText.addModifyListener(new ModifyListener(this){
                final /* synthetic */ ParameterEditDialog this$1;
                {
                    this.this$1 = parameterEditDialog;
                }

                public void modifyText(ModifyEvent e) {
                    ParameterEditDialog.access$1(this.this$1, ParameterEditDialog.access$0(this.this$1).getText());
                }
            });
        }

        protected SOAPParameter getModifiedSOAPParameter() {
            this.soapParameter.setDefaultValue(this.defaultValue);
            return this.soapParameter;
        }

        protected void cancelPressed() {
            super.cancelPressed();
        }

        protected Status getOKStatus() {
            return this.getMiscStatus(0, EMPTY_STRING);
        }

        protected Status getMiscStatus(int severity, String message) {
            return new Status(severity, "org.eclipse.ui", 0, message, null);
        }

        static /* synthetic */ Text access$0(ParameterEditDialog parameterEditDialog) {
            return parameterEditDialog.defualtValueText;
        }

        static /* synthetic */ void access$1(ParameterEditDialog parameterEditDialog, String string) {
            parameterEditDialog.defaultValue = string;
        }
    }

    class ParameterInputDialog
    extends StatusDialog {
        private TableViewer viewer;
        private SOAPRequest soapRequest;

        public ParameterInputDialog() {
            super(PlatformUI.getWorkbench().getDisplay().getActiveShell());
        }

        public void create() {
            super.create();
            Point pt = this.getShell().computeSize(-1, -1);
            pt.x = Math.max(pt.x, 400);
            pt.y = Math.max(pt.y, 200);
            this.getShell().setSize(pt);
            this.getShell().setText(SOAPRequestPage.this.getTitle());
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            composite.setLayout((Layout)layout);
            composite.setLayout((Layout)layout);
            this.createCustomControls(composite);
            this.initParameters();
            WSUIUtil.setSystemHelp((Control)composite, "org.eclipse.datatools.oda.cshelp.Dialog_SOAP_Request_Parameters_ID");
            return composite;
        }

        private void createCustomControls(Composite parent) {
            Table table = new Table(parent, 67584);
            TableLayout tableLayout = new TableLayout();
            table.setLayout((Layout)tableLayout);
            GridData layouData = new GridData(1808);
            table.setLayoutData((Object)layouData);
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            TableColumn column0 = new TableColumn(table, 0);
            column0.setText(SOAPRequestPage.this.COLUMN_NAME);
            column0.setWidth(150);
            TableColumn column1 = new TableColumn(table, 0);
            column1.setText(SOAPRequestPage.this.COLUMN_DATATYPE);
            column1.setWidth(100);
            TableColumn column2 = new TableColumn(table, 0);
            column2.setText(SOAPRequestPage.this.COLUMN_DEFAULTVALUE);
            column2.setWidth(150);
            this.viewer = new TableViewer(table);
            this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(this){
                final /* synthetic */ ParameterInputDialog this$1;
                {
                    this.this$1 = parameterInputDialog;
                }

                public Object[] getElements(Object inputElement) {
                    if (inputElement == null || !(inputElement instanceof SOAPParameter[])) {
                        return new Object[0];
                    }
                    return (SOAPParameter[])inputElement;
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }
            });
            this.viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(this){
                final /* synthetic */ ParameterInputDialog this$1;
                {
                    this.this$1 = parameterInputDialog;
                }

                public Image getColumnImage(Object element, int columnIndex) {
                    return null;
                }

                public String getColumnText(Object element, int columnIndex) {
                    SOAPParameter param = (SOAPParameter)element;
                    String value = "";
                    switch (columnIndex) {
                        case 0: {
                            value = param.getName();
                            break;
                        }
                        case 1: {
                            value = "";
                            break;
                        }
                        case 2: {
                            value = param.getDefaultValue();
                        }
                    }
                    return value;
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            });
            this.setupEditors();
        }

        private void setupEditors() {
            CellEditor[] editors = new CellEditor[3];
            int i = 0;
            while (i < editors.length) {
                editors[i] = new TextCellEditor((Composite)this.viewer.getTable(), 0);
                ++i;
            }
            this.viewer.setCellEditors(editors);
            this.viewer.setColumnProperties(new String[]{SOAPRequestPage.this.COLUMN_NAME, SOAPRequestPage.this.COLUMN_DATATYPE, SOAPRequestPage.this.COLUMN_DEFAULTVALUE});
            this.viewer.getTable().addMouseListener((MouseListener)new MouseAdapter(this){
                final /* synthetic */ ParameterInputDialog this$1;
                {
                    this.this$1 = parameterInputDialog;
                }

                public void mouseDoubleClick(MouseEvent e) {
                    ParameterInputDialog.access$0(this.this$1);
                }
            });
        }

        private void doEdit() {
            SOAPParameter soapParameter;
            ParameterEditDialog dialog;
            int index = this.viewer.getTable().getSelectionIndex();
            if (index == -1) {
                return;
            }
            Object data = this.viewer.getTable().getItem(index).getData();
            if (data instanceof SOAPParameter && (dialog = new ParameterEditDialog(soapParameter = (SOAPParameter)data)).open() == 0) {
                soapParameter = dialog.getModifiedSOAPParameter();
                this.viewer.refresh();
            }
        }

        private void initParameters() {
            this.soapRequest = new SOAPRequest(SOAPRequestPage.this.queryText.getText());
            this.mergeParameters();
            this.viewer.setInput((Object)this.soapRequest.getParameters());
        }

        private void mergeParameters() {
            SOAPParameter[] soapParameters = this.soapRequest.getParameters();
            int i = 0;
            while (SOAPRequestPage.this.parameters != null && i < SOAPRequestPage.this.parameters.length) {
                if (!WSUtil.isNull((Object)SOAPRequestPage.this.parameters[i])) {
                    int pos = -1;
                    int j = 0;
                    while (j < soapParameters.length) {
                        if (!WSUtil.isNull((Object)soapParameters[j].getName()) && soapParameters[j].getName().equals(SOAPRequestPage.this.parameters[i].getName())) {
                            pos = j;
                            break;
                        }
                        ++j;
                    }
                    if (pos != -1) {
                        soapParameters[pos].setDefaultValue(SOAPRequestPage.this.parameters[i].getDefaultValue());
                    }
                }
                ++i;
            }
        }

        SOAPParameter[] getSOAPParameters() {
            return this.soapRequest.getParameters();
        }

        static /* synthetic */ void access$0(ParameterInputDialog parameterInputDialog) {
            parameterInputDialog.doEdit();
        }
    }
}

