/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.ui;

import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.datatools.sqltools.result.ResultConfiguration;
import org.eclipse.datatools.sqltools.result.ResultsConstants;
import org.eclipse.datatools.sqltools.result.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.core.IResultManagerListener;
import org.eclipse.datatools.sqltools.result.internal.core.IResultManager;
import org.eclipse.datatools.sqltools.result.internal.ui.PreferenceConstants;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultsView;
import org.eclipse.datatools.sqltools.result.internal.utils.ILogger;
import org.eclipse.datatools.sqltools.result.internal.utils.StatusLogger;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.model.ResultItem;
import org.eclipse.datatools.sqltools.result.ui.ResultViewUIUtil;
import org.eclipse.datatools.sqltools.result.ui.view.ResultsViewControl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ResultsViewUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.datatools.sqltools.result.ui";
    public static final String BUNDLE_NAME = "org.eclipse.datatools.sqltools.result.ui.PluginResources";
    private ResourceBundle _bundle = ResourceBundle.getBundle("org.eclipse.datatools.sqltools.result.ui.PluginResources");
    private Color _disabledBakColor;
    private static ResultsViewUIPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String name = event.getProperty();
                Object newValue = event.getNewValue();
                if (name.equals(ResultsConstants.SQL_RESULTS_VIEW_MAX_ROW_COUNT)) {
                    ResultConfiguration.getInstance().setMaxRowCount(((Integer)newValue).intValue());
                }
                if (name.equals(ResultsConstants.SQL_RESULTS_VIEW_MAX_DISPLAY_ROW_COUNT)) {
                    ResultConfiguration.getInstance().setMaxDisplayRowCount(((Integer)newValue).intValue());
                }
                if (name.equals(PreferenceConstants.RESULT_HISTORY_SAVE_HISTORY)) {
                    ResultConfiguration.getInstance().setAutoSave(((Boolean)newValue).booleanValue());
                }
                if (name.equals(PreferenceConstants.RESULT_HISTORY_CLEAN_HISTORY)) {
                    ResultConfiguration.getInstance().setAutoClean(((Boolean)newValue).booleanValue());
                }
                if (name.equals(PreferenceConstants.SQL_RESULT_VIEW_SHOW_LABELS)) {
                    ResultConfiguration.getInstance().setShowLabel(((Boolean)newValue).booleanValue());
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        if (this._disabledBakColor != null) {
            this._disabledBakColor.dispose();
        }
        plugin = null;
        super.stop(context);
    }

    public static ResultsViewUIPlugin getDefault() {
        return plugin;
    }

    public synchronized Color getDisabledBakColor() {
        if (this._disabledBakColor == null) {
            this._disabledBakColor = new Color((Device)ResultsViewUIPlugin.getDefault().getWorkbench().getDisplay(), 238, 237, 224);
        }
        return this._disabledBakColor;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static IResultManager getResultManager() {
        return ResultsViewPlugin.getDefault().getResultManager();
    }

    public static ILogger getLogger(ResourceBundle bundle) {
        return new StatusLogger(ResultsViewUIPlugin.getDefault().getLog(), PLUGIN_ID, bundle == null ? ResultsViewUIPlugin.getDefault()._bundle : bundle);
    }

    public ResourceBundle getResourceBundle() {
        return this._bundle;
    }

    public static class ResultViewControlListener
    implements IResultManagerListener {
        public void allResultInstancesRemoved() {
            this.getResultsViewConstrol().allResultInstancesRemoved();
        }

        public void parametersShow(IResultInstance instance, List params) {
            this.getResultsViewConstrol().parametersShow(instance, params);
        }

        public void resultInstanceAppended(IResultInstance instance, ResultItem result, int index) {
            this.getResultsViewConstrol().resultInstanceAppended(instance, result, index);
        }

        public void resultInstanceCreated(IResultInstance instance) {
            this.getResultsViewConstrol().resultInstanceCreated(instance);
        }

        public void resultInstanceRemoved(IResultInstance instance) {
            this.getResultsViewConstrol().resultInstanceRemoved(instance);
        }

        public void resultInstanceReset(IResultInstance instance) {
            this.getResultsViewConstrol().resultInstanceReset(instance);
        }

        public void resultInstanceStatusUpdated(IResultInstance instance) {
            this.getResultsViewConstrol().resultInstanceStatusUpdated(instance);
        }

        public void resultInstancesRemoved(IResultInstance[] instances) {
            this.getResultsViewConstrol().resultInstancesRemoved(instances);
        }

        private ResultsViewControl getResultsViewConstrol() {
            ResultsView resultsView = ResultViewUIUtil.checkResultView();
            return resultsView.getResultsViewControl();
        }

        public boolean equals(Object obj) {
            return obj instanceof ResultViewControlListener;
        }
    }
}

