/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.enablement.oda.xml.impl.DataTypes;
import org.eclipse.datatools.enablement.oda.xml.ui.UiPlugin;
import org.eclipse.datatools.enablement.oda.xml.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.ui.utils.ExceptionHandler;
import org.eclipse.datatools.enablement.oda.xml.ui.utils.XMLRelationInfoUtil;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.ColumnMappingDialog;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.ColumnMappingElement;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.ColumnMappingTableViewer;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.DataSetDesignPopulator;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.ResultSetTableViewer;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.TreeNodeData;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.TreePopulationUtil;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.XMLInformationHolder;
import org.eclipse.datatools.enablement.oda.xml.util.RelationInformation;
import org.eclipse.datatools.enablement.oda.xml.util.ui.ATreeNode;
import org.eclipse.datatools.enablement.oda.xml.util.ui.SchemaPopulationUtil;
import org.eclipse.datatools.enablement.oda.xml.util.ui.XPathPopulationUtil;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ColumnMappingPage
extends DataSetWizardPage
implements ITableLabelProvider {
    private final int DEFAULT_WIDTH = 300;
    private final int DEFAULT_HEIGHT = 200;
    private Tree availableXmlTree;
    private Button btnAdd;
    private Composite btnComposite;
    private ColumnMappingTableViewer columnMappingTable;
    private Group treeGroup;
    private Group rightGroup;
    private ATreeNode treeNode;
    private TreeItem selectedItem;
    private ResultSetTableViewer previewViewer;
    private String tableName;
    private String xsdFileName;
    private String xmlFileName;
    private String xmlEncoding;
    private Map columnMap;
    private List columnMappingList = new ArrayList();
    private ColumnMappingElement newColumn;
    private String selectedTreeItemText;
    private static String COLUMN_NAME = Messages.getString("dataset.editor.columnName");
    private static String XPATH_NAME = Messages.getString("dataset.editor.xpathexpression");
    private static String TYPE_NAME = Messages.getString("dataset.editor.datatype");
    private static String DEFAULT_PAGE_NAME = Messages.getString("xPathChoosePage.messages.xmlColumnMapping");
    private static String DEFAULT_PAGE_Message = Messages.getString("wizard.title.defineColumnMapping");
    private static String[] dataTypeDisplayNames = new String[]{Messages.getString("datatypes.dateTime"), Messages.getString("datatypes.decimal"), Messages.getString("datatypes.float"), Messages.getString("datatypes.integer"), Messages.getString("datatypes.date"), Messages.getString("datatypes.time"), Messages.getString("datatypes.string"), Messages.getString("datatypes.boolean")};

    public ColumnMappingPage() {
        this(Messages.getString("wizard.title.newDataSet"));
        Arrays.sort(dataTypeDisplayNames);
    }

    public ColumnMappingPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        DEFAULT_PAGE_Message = Messages.getString("wizard.title.defineColumnMapping");
        this.setMessage(DEFAULT_PAGE_Message);
        this.columnMap = new HashMap();
        this.columnMappingList = new ArrayList();
        this.setPageComplete(false);
        Arrays.sort(dataTypeDisplayNames);
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        if (XMLInformationHolder.hasDestroyed()) {
            XMLInformationHolder.start(this.getInitializationDesign());
        }
        this.initializeControl();
        if (this.selectedTreeItemText != null) {
            this.populateXMLTree();
        }
        XMLRelationInfoUtil.setSystemHelp(this.getControl(), "org.eclipse.datatools.oda.cshelp.Wizard_XML_ColumnMapping_ID");
    }

    private void initializeControl() {
        this.xsdFileName = XMLInformationHolder.getPropertyValue("SCHEMAFILELIST");
        this.xmlFileName = XMLInformationHolder.getPropertyValue("FILELIST");
        this.xmlEncoding = XMLInformationHolder.getPropertyValue("ENCODINGLIST");
        String queryText = XMLInformationHolder.getPropertyValue("RELATIONINFORMATION");
        this.tableName = XMLRelationInfoUtil.getTableName(queryText);
        if (this.tableName != null && this.tableName.trim().length() > 0) {
            this.selectedTreeItemText = XMLRelationInfoUtil.getXPathExpression(queryText, this.tableName);
            RelationInformation info = null;
            try {
                info = new RelationInformation(queryText);
            }
            catch (OdaException e) {
                e.printStackTrace();
            }
            this.columnMap = new HashMap();
            this.columnMappingList = this.columnMappingTable.refresh(info, this.tableName, this.columnMap);
            this.refreshColumnMappingViewer();
        } else {
            this.selectedTreeItemText = XMLInformationHolder.getPropertyValue("XPATHTEXT");
            this.tableName = XMLRelationInfoUtil.getUniqueName(null);
            XMLInformationHolder.setPropertyValue("TABLENAME", this.tableName);
        }
        this.setPageProperties();
    }

    public void refresh() {
        this.selectedTreeItemText = XMLInformationHolder.getPropertyValue("XPATHTEXT");
        this.xsdFileName = XMLInformationHolder.getPropertyValue("SCHEMAFILELIST");
        this.xmlFileName = XMLInformationHolder.getPropertyValue("FILELIST");
        this.xmlEncoding = XMLInformationHolder.getPropertyValue("ENCODINGLIST");
        if (this.selectedTreeItemText != null) {
            this.selectedItem = null;
            this.populateXMLTree();
        }
        this.setPageProperties();
    }

    protected void refresh(DataSetDesign dataSetDesign) {
        DEFAULT_PAGE_Message = Messages.getString("xPathChoosePage.messages.xmlColumnMapping");
        if (XMLInformationHolder.hasDestroyed()) {
            XMLInformationHolder.start(dataSetDesign);
        }
        this.setMessage(DEFAULT_PAGE_Message);
        this.refresh();
    }

    public Control createPageControl(Composite parent) {
        DEFAULT_PAGE_Message = Messages.getString("wizard.title.defineColumnMapping");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.createTopComposite(composite);
        this.createBottomComposite(composite);
        this.setPageProperties();
        return composite;
    }

    private void createTopComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createLeftGroup(composite);
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.treeGroup, 5);
        data.bottom = new FormAttachment(50);
        this.btnComposite = new Composite(composite, 0);
        this.btnComposite.setLayoutData((Object)data);
        FillLayout btnLayout = new FillLayout(512);
        btnLayout.spacing = 5;
        this.btnComposite.setLayout((Layout)btnLayout);
        this.btnAdd = new Button(this.btnComposite, 0);
        this.btnAdd.setText(">");
        this.btnAdd.setToolTipText("Use the selected node as column mapping");
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMappingDialog columnDialog;
                String pathStr = ColumnMappingPage.this.createXPath(ColumnMappingPage.this.selectedItem);
                String name = ColumnMappingPage.this.selectedItem.getText();
                int type = -1;
                if (ColumnMappingPage.this.selectedItem.getData() instanceof TreeNodeData) {
                    TreeNodeData node = (TreeNodeData)ColumnMappingPage.this.selectedItem.getData();
                    if (node.getTreeNode().getType() == 2) {
                        name = (String)node.getTreeNode().getValue();
                    }
                    try {
                        type = DataTypes.getType((String)node.getTreeNode().getDataType());
                    }
                    catch (OdaException e1) {
                        type = 12;
                    }
                }
                if ((columnDialog = new ColumnMappingDialog(ColumnMappingPage.this.getShell(), DEFAULT_PAGE_NAME, name, pathStr, type)).open() == 0) {
                    ColumnMappingElement columnElement = columnDialog.getColumnMapping();
                    if (ColumnMappingPage.this.isUniqueName(columnElement.getColumnName(), columnElement)) {
                        ColumnMappingPage.this.columnMap.put(columnElement.getColumnName(), columnElement);
                        ColumnMappingPage.this.columnMappingList.add(columnElement);
                        ColumnMappingPage.this.refreshColumnMappingViewer();
                        String relationInfo = XMLInformationHolder.getPropertyValue("RELATIONINFORMATION");
                        if (relationInfo != null && relationInfo.trim().length() > 0) {
                            String tableInfo = XMLRelationInfoUtil.getTableRelationInfo(relationInfo, ColumnMappingPage.this.tableName);
                            if (tableInfo != null && tableInfo.trim().length() > 0) {
                                XMLInformationHolder.setPropertyValue("RELATIONINFORMATION", XMLRelationInfoUtil.replaceInfo(ColumnMappingPage.this.tableName, ColumnMappingPage.this.saveQueryString(), relationInfo));
                            } else {
                                XMLInformationHolder.setPropertyValue("RELATIONINFORMATION", XMLRelationInfoUtil.concatRelationInfo(relationInfo, ColumnMappingPage.this.saveQueryString()));
                            }
                        } else {
                            XMLInformationHolder.setPropertyValue("RELATIONINFORMATION", ColumnMappingPage.this.saveQueryString());
                        }
                    }
                    ColumnMappingPage.this.setPageProperties();
                }
            }
        });
        this.createRightGroup(composite);
    }

    private void createBottomComposite(Composite parent) {
        Group previewGroup = new Group(parent, 512);
        GridData data = new GridData(1808);
        data.heightHint = 80;
        previewGroup.setLayoutData((Object)data);
        previewGroup.setText(Messages.getString("ColumnMappingDialog.info.dataPreview"));
        previewGroup.setLayout((Layout)new FillLayout());
        this.previewViewer = new ResultSetTableViewer((Composite)previewGroup, true, true, true);
        this.previewViewer.getViewer().setHeaderVisible(true);
    }

    private void createRightGroup(Composite composite2) {
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment((Control)this.btnComposite, 5);
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(100, -5);
        data.width = 300;
        this.rightGroup = new Group(composite2, 0);
        this.rightGroup.setLayout((Layout)new FillLayout());
        this.rightGroup.setText(Messages.getString("xPathChoosePage.messages.xmlColumnMapping"));
        this.rightGroup.setLayoutData((Object)data);
        this.rightGroup.setEnabled(true);
        this.columnMappingTable = new ColumnMappingTableViewer((Composite)this.rightGroup, true, true, true);
        this.columnMappingTable.getViewer().getTable().setHeaderVisible(true);
        this.columnMappingTable.getViewer().getTable().setLinesVisible(true);
        TableColumn column = new TableColumn(this.columnMappingTable.getViewer().getTable(), 16384);
        column.setText(COLUMN_NAME);
        column.setWidth(100);
        column = new TableColumn(this.columnMappingTable.getViewer().getTable(), 16384);
        column.setText(XPATH_NAME);
        column.setWidth(100);
        column = new TableColumn(this.columnMappingTable.getViewer().getTable(), 16384);
        column.setText(TYPE_NAME);
        column.setWidth(60);
        this.columnMappingTable.getViewer().setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ArrayList) {
                    ArrayList<ColumnMappingElement> inputList = new ArrayList<ColumnMappingElement>(10);
                    inputList.addAll(ColumnMappingPage.this.columnMappingList);
                    if (ColumnMappingPage.this.newColumn == null) {
                        ColumnMappingPage.this.newColumn = new ColumnMappingElement();
                    }
                    inputList.add(ColumnMappingPage.this.newColumn);
                    return inputList.toArray();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.columnMappingTable.getViewer().setLabelProvider((IBaseLabelProvider)this);
        this.columnMappingTable.getViewer().setInput((Object)this.columnMappingList);
        this.refreshColumnMappingViewer();
        this.setupEditors();
        this.addListenersAndToolTip();
    }

    private boolean isUniqueName(String columnName, ColumnMappingElement actualElement) {
        boolean success = true;
        if (this.columnMap != null) {
            if (this.columnMap.get(columnName) != actualElement && this.columnMap.get(columnName) != null) {
                this.setDetailsMessage(Messages.getFormattedString("error.columnMapping.sameColumnName", new Object[]{columnName}), 3);
                success = false;
            } else {
                this.setDetailsMessage(DEFAULT_PAGE_Message, 0);
            }
        } else {
            this.setDetailsMessage(DEFAULT_PAGE_Message, 0);
            this.columnMap = new HashMap();
            this.columnMappingList = new ArrayList();
        }
        return success;
    }

    private String createXPath(TreeItem selectedItem) {
        if (selectedItem == null) {
            return null;
        }
        TreeItem select = selectedItem;
        String columnPath = "";
        Object data = selectedItem.getData();
        if (data instanceof TreeNodeData) {
            columnPath = this.generateXpathFromTreeItem(select);
        }
        return XPathPopulationUtil.populateColumnPath((String)this.getRootPathWithOutFilter(), (String)columnPath);
    }

    private String generateXpathFromTreeItem(TreeItem treeItem) {
        String columnPath = treeItem.getText();
        while (treeItem.getParentItem() != null && treeItem.getParentItem().getData() instanceof TreeNodeData) {
            if (((TreeNodeData)(treeItem = treeItem.getParentItem()).getData()).getTreeNode().getType() == 1 && columnPath.trim().length() > 0) {
                columnPath = treeItem.getText() + "/" + columnPath;
                continue;
            }
            if (((TreeNodeData)treeItem.getData()).getTreeNode().getType() != 2) continue;
            columnPath = columnPath + "/" + treeItem.getText();
        }
        if (!columnPath.startsWith("/")) {
            columnPath = "/" + columnPath;
        }
        return columnPath;
    }

    private void createLeftGroup(Composite composite2) {
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(40, -5);
        data.bottom = new FormAttachment(100, -5);
        data.height = 200;
        this.treeGroup = new Group(composite2, 0);
        this.treeGroup.setLayout((Layout)new FillLayout());
        this.treeGroup.setLayoutData((Object)data);
        this.availableXmlTree = new Tree((Composite)this.treeGroup, 2818);
        this.availableXmlTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] items = ColumnMappingPage.this.availableXmlTree.getSelection();
                for (int i = 0; i < items.length; ++i) {
                    ColumnMappingPage.this.selectedItem = items[0];
                    if (!items[i].getGrayed()) continue;
                    ColumnMappingPage.this.availableXmlTree.setRedraw(false);
                    ColumnMappingPage.this.availableXmlTree.deselectAll();
                    ColumnMappingPage.this.availableXmlTree.setRedraw(true);
                    ColumnMappingPage.this.availableXmlTree.redraw();
                }
                if (ColumnMappingPage.this.selectedItem != null) {
                    ColumnMappingPage.this.btnAdd.setEnabled(true);
                } else {
                    ColumnMappingPage.this.btnAdd.setEnabled(false);
                }
            }
        });
        this.treeGroup.setText(Messages.getString("xPathChoosePage.messages.xmlStructure"));
    }

    private void addListenersAndToolTip() {
        this.columnMappingTable.getViewer().getTable().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    ColumnMappingPage.this.removeSelectedItem();
                    ColumnMappingPage.this.setPageProperties();
                }
            }
        });
        this.columnMappingTable.getRemoveButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMappingPage.this.removeSelectedItem();
                ColumnMappingPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.columnMappingTable.getRemoveButton().setToolTipText("Remove column mapping");
        this.columnMappingTable.getRemoveMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMappingPage.this.removeSelectedItem();
                ColumnMappingPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.columnMappingTable.getRemoveAllMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMappingPage.this.removeAllItem();
                ColumnMappingPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.columnMappingTable.getUpButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMappingPage.this.upMoveSelectedItem();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.columnMappingTable.getUpButton().setToolTipText("Move column mappping Up");
        this.columnMappingTable.getDownButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMappingPage.this.downMoveSelectedItem();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.columnMappingTable.getDownButton().setToolTipText("Move column mapping Down");
    }

    private void removeSelectedItem() {
        int index = this.columnMappingTable.getViewer().getTable().getSelectionIndex();
        int count = this.columnMappingTable.getViewer().getTable().getItemCount();
        if (index > -1 && index < count) {
            TableItem item = this.columnMappingTable.getViewer().getTable().getItem(index);
            Object element = item.getData();
            String elementName = "";
            if (element instanceof ColumnMappingElement && element != this.newColumn) {
                ColumnMappingElement entry = (ColumnMappingElement)element;
                elementName = entry.getColumnName();
                this.columnMappingTable.getViewer().getTable().select(index);
                this.columnMap.remove(elementName);
                this.columnMappingList.remove(index);
                String str = XMLRelationInfoUtil.replaceInfo(this.tableName, this.saveQueryString(), XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"));
                XMLInformationHolder.setPropertyValue("RELATIONINFORMATION", str);
            }
        }
        if (this.columnMappingList.size() <= 0) {
            String str = XMLRelationInfoUtil.replaceInfo(this.tableName, "", XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"));
            XMLInformationHolder.setPropertyValue("RELATIONINFORMATION", str);
        }
        this.refreshColumnMappingViewer();
    }

    private void removeAllItem() {
        int count = this.columnMappingTable.getViewer().getTable().getItemCount();
        for (int index = 0; index < count - 1; ++index) {
            TableItem item = this.columnMappingTable.getViewer().getTable().getItem(0);
            Object element = item.getData();
            String elementName = "";
            if (element instanceof ColumnMappingElement) {
                ColumnMappingElement entry = (ColumnMappingElement)element;
                elementName = entry.getColumnName();
            }
            this.columnMappingTable.getViewer().getTable().remove(0);
            this.columnMap.remove(elementName);
            this.columnMappingList.remove(0);
        }
        String str = XMLRelationInfoUtil.replaceInfo(this.tableName, "", XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"));
        XMLInformationHolder.setPropertyValue("RELATIONINFORMATION", str);
        this.refreshColumnMappingViewer();
    }

    private void upMoveSelectedItem() {
        int count = this.columnMappingTable.getViewer().getTable().getItemCount();
        int index = this.columnMappingTable.getViewer().getTable().getSelectionIndex();
        if (index > 0 && index < count) {
            Object obj = this.columnMappingList.get(index);
            this.columnMappingList.set(index, this.columnMappingList.get(index - 1));
            this.columnMappingList.set(index - 1, obj);
            String str = XMLRelationInfoUtil.replaceInfo(this.tableName, this.saveQueryString(), XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"));
            XMLInformationHolder.setPropertyValue("RELATIONINFORMATION", str);
            this.refreshColumnMappingViewer();
        }
    }

    private void downMoveSelectedItem() {
        int count = this.columnMappingTable.getViewer().getTable().getItemCount();
        int index = this.columnMappingTable.getViewer().getTable().getSelectionIndex();
        if (index > -1 && index < count - 2) {
            Object obj = this.columnMappingList.get(index);
            this.columnMappingList.set(index, this.columnMappingList.get(index + 1));
            this.columnMappingList.set(index + 1, obj);
            String str = XMLRelationInfoUtil.replaceInfo(this.tableName, this.saveQueryString(), XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"));
            XMLInformationHolder.setPropertyValue("RELATIONINFORMATION", str);
            this.refreshColumnMappingViewer();
        }
    }

    private void populateXMLTree() {
        if (!(this.xsdFileName != null && this.xsdFileName.trim().length() != 0 || this.xmlFileName != null && this.xmlFileName.trim().length() != 0)) {
            return;
        }
        try {
            this.treeNode = null;
            this.availableXmlTree.removeAll();
            int numberOfElement = 0;
            Preferences preferences = UiPlugin.getDefault().getPluginPreferences();
            if (preferences.contains("user_max_num_of_element_passed")) {
                numberOfElement = preferences.getInt("user_max_num_of_element_passed");
            } else {
                numberOfElement = 100000;
                preferences.setValue("user_max_num_of_element_passed", numberOfElement);
            }
            this.treeNode = SchemaPopulationUtil.getSchemaTree((String)this.xsdFileName, (String)this.xmlFileName, (String)this.xmlEncoding, (int)numberOfElement);
            Object[] childs = this.treeNode.getChildren();
            this.populateTreeItems(this.availableXmlTree, childs, 0);
            this.availableXmlTree.addListener(17, new Listener(){

                public void handleEvent(Event event) {
                    TreeItem currentItem = (TreeItem)event.item;
                    if (((TreeNodeData)currentItem.getData()).hasBeenExpandedOnce()) {
                        return;
                    }
                    ((TreeNodeData)currentItem.getData()).setHasBeenExpandedOnce();
                    currentItem.removeAll();
                    try {
                        if (((TreeNodeData)currentItem.getData()).getTreeNode().getChildren() != null && ((TreeNodeData)currentItem.getData()).getTreeNode().getChildren().length > 0) {
                            TreePopulationUtil.populateTreeItems(currentItem, ((TreeNodeData)currentItem.getData()).getTreeNode().getChildren(), true);
                        }
                    }
                    catch (OdaException e) {
                        e.printStackTrace();
                    }
                }
            });
            if (this.selectedItem == null) {
                this.btnAdd.setEnabled(false);
                this.setMessage(Messages.getString("error.columnMapping.tableMappingXPathNotExist"), 3);
            } else {
                this.btnAdd.setEnabled(true);
                this.setMessage(DEFAULT_PAGE_Message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void populateTreeItems(Object tree, Object[] node, int level) throws OdaException {
        ++level;
        for (int i = 0; i < node.length; ++i) {
            TreeItem treeItem = tree instanceof Tree ? new TreeItem((Tree)tree, 0) : new TreeItem((TreeItem)tree, 0);
            ATreeNode treeNode = (ATreeNode)node[i];
            TreeNodeData data = new TreeNodeData(treeNode);
            treeItem.setData((Object)data);
            int type = treeNode.getType();
            if (type == 2) {
                treeItem.setText("@" + treeNode.getValue().toString());
            } else {
                treeItem.setText(treeNode.getValue().toString());
            }
            String populateString = XPathPopulationUtil.populateColumnPath((String)this.getRootPathWithOutFilter(), (String)this.generateXpathFromTreeItem(treeItem));
            if (populateString != null) {
                if (populateString.equals("")) {
                    FontData fontData = new FontData("", 8, 1);
                    treeItem.setFont(new Font(null, fontData));
                    this.availableXmlTree.setSelection(new TreeItem[]{treeItem});
                    this.availableXmlTree.setFocus();
                    this.selectedItem = treeItem;
                }
                this.setExpanded(treeItem);
            }
            if (treeNode.getChildren() == null || treeNode.getChildren().length <= 0) continue;
            if (level > (this.selectedTreeItemText == null || this.selectedTreeItemText.split("/").length < 5 ? 5 : this.selectedTreeItemText.split("/").length)) {
                new TreeItem(treeItem, 0);
                continue;
            }
            data.setHasBeenExpandedOnce();
            this.populateTreeItems(treeItem, treeNode.getChildren(), level);
        }
    }

    private String getRootPathWithOutFilter() {
        return this.selectedTreeItemText.replaceAll("\\Q[\\E.*\\Q]\\E", "");
    }

    private void setExpanded(TreeItem treeItem) {
        if (treeItem.getParentItem() != null) {
            this.setExpanded(treeItem.getParentItem());
        }
        treeItem.setExpanded(true);
    }

    private void setupEditors() {
        CellEditor[] editors = new CellEditor[]{new TextCellEditor((Composite)this.columnMappingTable.getViewer().getTable(), 0), new TextCellEditor((Composite)this.columnMappingTable.getViewer().getTable(), 0), new ComboBoxCellEditor((Composite)this.columnMappingTable.getViewer().getTable(), dataTypeDisplayNames, 8)};
        this.columnMappingTable.getViewer().setCellEditors(editors);
        this.columnMappingTable.getViewer().setColumnProperties(new String[]{COLUMN_NAME, XPATH_NAME, TYPE_NAME});
        this.columnMappingTable.getViewer().setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return element != ColumnMappingPage.this.newColumn || property.equals(COLUMN_NAME);
            }

            public Object getValue(Object element, String property) {
                Object value;
                block7: {
                    value = null;
                    try {
                        if (property.equals(COLUMN_NAME)) {
                            value = ((ColumnMappingElement)element).getColumnName();
                            break block7;
                        }
                        if (property.equals(XPATH_NAME)) {
                            value = ((ColumnMappingElement)element).getXPath();
                            break block7;
                        }
                        if (!property.equals(TYPE_NAME)) break block7;
                        String temp = ((ColumnMappingElement)element).getType();
                        if (temp == null) {
                            value = new Integer(0);
                            break block7;
                        }
                        for (int i = 0; i < dataTypeDisplayNames.length; ++i) {
                            if (!temp.equals(dataTypeDisplayNames[i])) continue;
                            value = new Integer(i);
                            break;
                        }
                    }
                    catch (Exception ex) {
                        ExceptionHandler.showException(ColumnMappingPage.this.getShell(), Messages.getString("error.label"), ex.getMessage(), ex);
                    }
                }
                if (value == null) {
                    value = "";
                }
                return value;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void modify(Object element, String property, Object value) {
                Object actualElement = ((TableItem)element).getData();
                if (value == null) return;
                if (property.equals(COLUMN_NAME)) {
                    if (!ColumnMappingPage.this.isUniqueName((String)value, (ColumnMappingElement)actualElement)) return;
                    if (ColumnMappingPage.this.columnMap.get(((ColumnMappingElement)actualElement).getColumnName()) != null) {
                        ColumnMappingPage.this.columnMap.remove(((ColumnMappingElement)actualElement).getColumnName());
                        ((ColumnMappingElement)actualElement).setColumnName((String)value);
                        ColumnMappingPage.this.columnMap.put((String)value, actualElement);
                    } else {
                        ((ColumnMappingElement)actualElement).setColumnName((String)value);
                    }
                } else if (property.equals(XPATH_NAME)) {
                    if (!ColumnMappingPage.this.isXpathValid((String)value)) {
                        ColumnMappingPage.this.setDetailsMessage(Messages.getFormattedString("error.invalidXpath", new Object[]{value}), 3);
                        return;
                    }
                    ((ColumnMappingElement)actualElement).setXPath((String)value);
                } else if (property.equals(TYPE_NAME)) {
                    int selectedType = (Integer)value;
                    ((ColumnMappingElement)actualElement).setType(dataTypeDisplayNames[selectedType]);
                }
                ColumnMappingPage.this.columnMappingTable.getViewer().update(((TableItem)element).getData(), null);
                if (!(actualElement instanceof ColumnMappingElement)) return;
                if (ColumnMappingPage.this.newColumn != null && ColumnMappingPage.this.newColumn.getColumnName() != null && ColumnMappingPage.this.newColumn.getColumnName().trim().length() > 0) {
                    ColumnMappingPage.this.columnMap.put(ColumnMappingPage.this.newColumn.getColumnName(), ColumnMappingPage.this.newColumn);
                    ColumnMappingPage.this.columnMappingList.add(ColumnMappingPage.this.newColumn);
                    ColumnMappingPage.this.clearNewColumnMapping();
                    ColumnMappingPage.this.columnMappingTable.getViewer().refresh();
                    ColumnMappingPage.this.setPageProperties();
                }
                ColumnMappingPage.this.refreshXMLConnection();
            }
        });
    }

    private boolean isXpathValid(String value) {
        return true;
    }

    private void refreshXMLConnection() {
        String str = XMLRelationInfoUtil.replaceInfo(this.tableName, this.saveQueryString(), XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"));
        if (str != null) {
            XMLInformationHolder.setPropertyValue("RELATIONINFORMATION", str);
        }
    }

    private void clearNewColumnMapping() {
        this.newColumn = null;
    }

    public boolean performOk() {
        return this.isValid();
    }

    private boolean isValid() {
        String queryText = XMLInformationHolder.getPropertyValue("RELATIONINFORMATION");
        return queryText != null && queryText.trim().length() != 0;
    }

    private void setDetailsMessage(String message, int type) {
        this.setMessage(message, type);
    }

    private String saveQueryString() {
        String queryString = "";
        String tablePath = "[" + this.selectedTreeItemText + "]";
        queryString = this.tableName + "#:#" + tablePath + "#:#";
        Iterator rowObj = this.columnMappingList.iterator();
        if (rowObj != null) {
            String rowStr = "";
            while (rowObj.hasNext()) {
                ColumnMappingElement element = (ColumnMappingElement)rowObj.next();
                rowStr = "{" + element.getColumnName() + ";" + element.getTypeStandardString() + ";" + element.getXPath() + "}";
                if (rowObj.hasNext()) {
                    rowStr = rowStr + ",";
                }
                queryString = queryString + rowStr;
            }
        }
        return queryString;
    }

    public boolean performCancel() {
        return true;
    }

    private void refreshColumnMappingViewer() {
        this.columnMappingTable.getViewer().setInput((Object)this.columnMappingList);
        for (int i = 0; i < this.columnMappingTable.getViewer().getTable().getItemCount() - 1; ++i) {
            TableItem ti = this.columnMappingTable.getViewer().getTable().getItem(i);
            Object element = ti.getData();
            String c1 = "";
            String c2 = "";
            String c3 = "";
            if (element instanceof ColumnMappingElement) {
                ColumnMappingElement colElement = (ColumnMappingElement)element;
                c1 = colElement.getColumnName() == null ? "" : colElement.getColumnName();
                c2 = colElement.getXPath() == null ? "" : colElement.getXPath();
                c3 = colElement.getType() == null ? "" : colElement.getType();
            }
            ti.setText(0, c1);
            ti.setText(1, c2);
            ti.setText(2, c3);
        }
        this.clearNewColumnMapping();
        this.columnMappingTable.getViewer().refresh();
    }

    public String getToolTip() {
        return null;
    }

    public void setSchemaFile(String fileName) {
        this.xsdFileName = fileName;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String value = null;
        try {
            if (element != this.newColumn) {
                switch (columnIndex) {
                    case 0: {
                        value = ((ColumnMappingElement)element).getColumnName();
                        break;
                    }
                    case 1: {
                        value = ((ColumnMappingElement)element).getXPath();
                        break;
                    }
                    case 2: {
                        value = ((ColumnMappingElement)element).getType();
                    }
                }
            } else if (columnIndex == 0) {
                value = Messages.getString("ColumnMappingDialog.prompt.new");
            }
        }
        catch (Exception ex) {
            ExceptionHandler.showException(this.getShell(), Messages.getString("error.label"), ex.getMessage(), ex);
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    private void setPageProperties() {
        boolean columnMappingExist = false;
        boolean dataFileExist = true;
        String dataSourceXmlDataFile = XMLInformationHolder.getPropertyValue("FILELIST");
        String dataSetXmlDataFile = XMLInformationHolder.getPropertyValue("XML_FILE");
        if (dataSetXmlDataFile == null || dataSetXmlDataFile.toString().length() == 0) {
            dataFileExist = false;
        }
        if (!dataFileExist && dataSourceXmlDataFile != null && dataSourceXmlDataFile.toString().trim().length() > 0) {
            dataFileExist = true;
        }
        columnMappingExist = this.columnMappingList != null && this.columnMappingList.size() > 0;
        boolean active = columnMappingExist && dataFileExist;
        this.columnMappingTable.getDownButton().setEnabled(columnMappingExist);
        this.columnMappingTable.getUpButton().setEnabled(columnMappingExist);
        this.columnMappingTable.getRemoveButton().setEnabled(columnMappingExist);
        this.columnMappingTable.getRemoveMenuItem().setEnabled(columnMappingExist);
        this.columnMappingTable.getRemoveAllMenuItem().setEnabled(columnMappingExist);
        this.previewViewer.getRefreshButton().setEnabled(active);
        this.previewViewer.getRefreshMenu().setEnabled(active);
        this.setPageComplete(columnMappingExist);
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        try {
            this.savePage(design);
        }
        catch (OdaException odaException) {
            // empty catch block
        }
        return design;
    }

    private void savePage(DataSetDesign dataSetDesign) throws OdaException {
        if (XMLInformationHolder.hasDestroyed()) {
            return;
        }
        if (dataSetDesign != null) {
            if (this.getQueryText(dataSetDesign) == null) {
                this.setQueryText(dataSetDesign, XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"));
            }
            if (this.getQueryText(dataSetDesign) != null && !this.getQueryText(dataSetDesign).equals(XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"))) {
                this.setQueryText(dataSetDesign, XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"));
                this.updateDesign(dataSetDesign);
            }
        }
    }

    protected void updateDesign(DataSetDesign dataSetDesign) {
        DataSetDesignPopulator.populateResultSet(dataSetDesign);
    }

    protected String getQueryText(DataSetDesign dataSetDesign) {
        return dataSetDesign.getQueryText();
    }

    protected void setQueryText(DataSetDesign dataSetDesign, String queryText) {
        dataSetDesign.setQueryText(queryText);
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getControl().setFocus();
    }

    protected void cleanup() {
        XMLInformationHolder.destory();
    }
}

