/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.util;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.spec.AdvancedQuerySpecification;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ExtensionContributor;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ResultExtensionExplorer;
import org.eclipse.datatools.connectivity.oda.spec.result.FilterExpression;
import org.eclipse.datatools.connectivity.oda.spec.result.ResultProjection;
import org.eclipse.datatools.connectivity.oda.spec.result.ResultSetSpecification;
import org.eclipse.datatools.connectivity.oda.spec.result.SortSpecification;
import org.eclipse.datatools.connectivity.oda.spec.util.QuerySpecificationFactory;

public class QuerySpecificationHelper {
    private QuerySpecificationFactory m_factory;

    public QuerySpecificationHelper(String dynamicResultSetExtnId) {
        if (dynamicResultSetExtnId == null) {
            return;
        }
        try {
            ExtensionContributor contributor = ResultExtensionExplorer.getInstance().getExtensionContributor(dynamicResultSetExtnId);
            this.setFactory(contributor);
        }
        catch (OdaException odaException) {}
    }

    public QuerySpecificationHelper(ExtensionContributor contributor) {
        this.setFactory(contributor);
    }

    public QuerySpecificationHelper(QuerySpecificationFactory factory) {
        this.m_factory = factory;
    }

    QuerySpecificationHelper() {
        this((QuerySpecificationFactory)null);
    }

    private void setFactory(ExtensionContributor contributor) {
        if (contributor == null) {
            return;
        }
        try {
            this.m_factory = contributor.getSpecificationFactory();
        }
        catch (OdaException odaException) {}
    }

    public QuerySpecificationFactory getFactory() {
        if (this.m_factory == null) {
            this.m_factory = new QuerySpecificationFactory();
        }
        return this.m_factory;
    }

    public QuerySpecification createQuerySpecification(FilterExpression filterExpr) {
        return this.createQuerySpecification(filterExpr, null, null);
    }

    public QuerySpecification createQuerySpecification(ResultProjection projectionSpec) {
        return this.createQuerySpecification(null, projectionSpec, null);
    }

    public QuerySpecification createQuerySpecification(SortSpecification sortSpec) {
        return this.createQuerySpecification(null, null, sortSpec);
    }

    public QuerySpecification createQuerySpecification(FilterExpression filterExpr, ResultProjection projectionSpec, SortSpecification sortSpec) {
        return this.getFactory().createQuerySpecification(filterExpr, projectionSpec, sortSpec);
    }

    public QuerySpecification createQuerySpecification() {
        return this.getFactory().createQuerySpecification();
    }

    public AdvancedQuerySpecification createAdvancedQuerySpecification() {
        return this.getFactory().createAdvancedQuerySpecification();
    }

    public ResultSetSpecification createResultSetSpecification() {
        return this.getFactory().createResultSetSpecification();
    }

    public ResultProjection createResultProjection() {
        return this.getFactory().createResultProjection();
    }

    public SortSpecification createSortSpecification() {
        return this.getFactory().createSortSpecification();
    }

    public SortSpecification createSortSpecification(int sortMode) {
        return this.getFactory().createSortSpecification(sortMode);
    }

    public static FilterExpression getFilterSpecification(QuerySpecification querySpec) {
        ResultSetSpecification resultSpec = QuerySpecificationHelper.getResultSetSpecification(querySpec);
        return resultSpec != null ? resultSpec.getFilterSpecification() : null;
    }

    public static ResultProjection getResultProjection(QuerySpecification querySpec) {
        ResultSetSpecification resultSpec = QuerySpecificationHelper.getResultSetSpecification(querySpec);
        return resultSpec != null ? resultSpec.getResultProjection() : null;
    }

    public static SortSpecification getSortSpecification(QuerySpecification querySpec) {
        ResultSetSpecification resultSpec = QuerySpecificationHelper.getResultSetSpecification(querySpec);
        return resultSpec != null ? resultSpec.getSortSpecification() : null;
    }

    public static ResultSetSpecification getResultSetSpecification(QuerySpecification querySpec) {
        return querySpec != null ? querySpec.getResultSetSpecification() : null;
    }
}

