/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util.manifest;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataTypeMapping;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestUtil;
import org.eclipse.datatools.connectivity.oda.util.manifest.Property;
import org.eclipse.datatools.connectivity.oda.util.manifest.Relationship;

public class DataSetType {
    private String m_id;
    private String m_displayName;
    private Hashtable m_dataTypeMappingsByNativeCode;
    private Hashtable m_dataTypeMappingsByNativeName;
    private Property[] m_properties = null;
    private Properties m_propsVisibility;
    private IConfigurationElement m_configElement;
    private Relationship m_relationship;
    static final /* synthetic */ boolean $assertionsDisabled;

    DataSetType(IConfigurationElement dataSetElement) throws OdaException {
        this.init(dataSetElement);
    }

    protected DataSetType() {
    }

    protected void init(IConfigurationElement dataSetElement) throws OdaException {
        this.m_id = dataSetElement.getAttribute("id");
        if (!$assertionsDisabled && this.m_id == null) {
            throw new AssertionError();
        }
        this.m_displayName = ManifestExplorer.getElementDisplayName(dataSetElement);
        this.m_dataTypeMappingsByNativeCode = new Hashtable();
        this.m_dataTypeMappingsByNativeName = new Hashtable();
        IConfigurationElement[] typeMappings = dataSetElement.getChildren("dataTypeMapping");
        int numOfTypeMappings = typeMappings.length;
        if (numOfTypeMappings == 0) {
            throw new OdaException(Messages.bind((String)Messages.manifest_NO_DATA_TYPE_MAPPINGS_DEFINED, (Object)this.m_id));
        }
        for (int i = 0; i < numOfTypeMappings; ++i) {
            IConfigurationElement typeMapping = typeMappings[i];
            DataTypeMapping dataTypeMap = new DataTypeMapping(typeMapping, this.m_id);
            this.m_dataTypeMappingsByNativeCode.put(new Integer(dataTypeMap.getNativeTypeCode()), dataTypeMap);
            this.m_dataTypeMappingsByNativeName.put(dataTypeMap.getNativeType(), dataTypeMap);
        }
        IConfigurationElement[] propertiesElements = dataSetElement.getChildren("properties");
        if (propertiesElements.length > 0) {
            IConfigurationElement propertiesElement = propertiesElements[propertiesElements.length - 1];
            this.m_properties = ExtensionManifest.getPropertyDefinitions(propertiesElement);
            this.m_propsVisibility = ExtensionManifest.getPropertyVisibilities(propertiesElement);
        }
        this.m_relationship = Relationship.createInstance(dataSetElement);
        this.m_configElement = dataSetElement;
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.m_configElement;
    }

    public String getID() {
        return this.m_id;
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public DataTypeMapping getDataTypeMapping(int nativeDataTypeCode) {
        Integer typeCode = new Integer(nativeDataTypeCode);
        return (DataTypeMapping)this.m_dataTypeMappingsByNativeCode.get(typeCode);
    }

    public DataTypeMapping getDataTypeMapping(String nativeDataTypeName) {
        return (DataTypeMapping)this.m_dataTypeMappingsByNativeName.get(nativeDataTypeName);
    }

    public DataTypeMapping[] getDataTypeMappings() {
        Collection typeMappings = this.m_dataTypeMappingsByNativeCode.values();
        int count = typeMappings.size();
        return typeMappings.toArray(new DataTypeMapping[count]);
    }

    public int getDefaultOdaDataTypeCode(int nativeDataTypeCode) {
        DataTypeMapping mapping = this.getDataTypeMapping(nativeDataTypeCode);
        if (mapping != null) {
            return mapping.getOdaScalarDataTypeCode();
        }
        if (nativeDataTypeCode == 0) {
            return 1;
        }
        return 0;
    }

    public Property[] getProperties() {
        if (this.m_properties == null) {
            this.m_properties = new Property[0];
        }
        return this.m_properties;
    }

    public Property[] getVisibleProperties() {
        return ManifestUtil.getVisiblePropertiesDefn(this.getProperties(), this.getPropertiesVisibility());
    }

    public Property[] getHiddenProperties() {
        return ManifestUtil.getHiddenPropertiesDefn(this.getProperties(), this.getPropertiesVisibility());
    }

    public Property getProperty(String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            return null;
        }
        Property[] props = this.getProperties();
        for (int i = 0; i < props.length; ++i) {
            if (!propertyName.equals(props[i].getName())) continue;
            return props[i];
        }
        return null;
    }

    public Properties getPropertiesVisibility() {
        if (this.m_propsVisibility == null) {
            this.m_propsVisibility = new Properties();
        }
        return this.m_propsVisibility;
    }

    public boolean isDeprecated() {
        return this.m_relationship != null && this.m_relationship.isDeprecated();
    }

    public String getRelatedDataSetId() {
        if (this.m_relationship == null) {
            return null;
        }
        return this.m_relationship.getRelatedId();
    }

    static {
        $assertionsDisabled = !DataSetType.class.desiredAssertionStatus();
    }
}

