/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.export;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.IResultSetRow;
import org.eclipse.datatools.sqltools.result.export.AbstractOutputter;
import org.eclipse.datatools.sqltools.result.export.IResultConstants;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.utils.HexHelper;
import org.eclipse.datatools.sqltools.result.internal.utils.SQLUtil;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.model.ResultItem;

public class TextOutputter
extends AbstractOutputter {
    private static Map _columnLen = new HashMap();
    private static String _userDefinedDelimiter;

    public void output(IResultSetObject resultset, Properties options, OutputStream stream) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(stream, options.getProperty("encoding")));
        this.output(resultset, options, writer);
    }

    public void output(IResultSetObject resultset, Properties options, PrintWriter writer) throws IOException {
        String delimiter = options.getProperty("delimiter");
        if (delimiter.equals(IResultConstants.USER_DEFINED)) {
            _userDefinedDelimiter = options.getProperty("userdefined_delimiter");
        }
        StringBuffer sb = new StringBuffer("");
        if (delimiter.equals(IResultConstants.COLUMN_ALIGNED)) {
            sb.append(this.getColumnHeadings(resultset));
        } else {
            sb.append(this.getColumnHeadings(resultset, delimiter));
        }
        sb.append(this.getLineSeparator());
        String nullString = ResultsViewPlugin.getDefault().getPreferenceStore().getString("org.eclipse.datatools.sqltools.result.preferences.display.nulldisplaystr");
        sb.append(this.getColumnData(resultset, nullString, delimiter));
        writer.write(sb.toString());
        writer.flush();
    }

    public void output(IResultInstance rs, Properties props, OutputStream os) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(os, props.getProperty("encoding")));
        this.output(rs, props, writer);
    }

    public void output(IResultInstance rs, Properties props, PrintWriter pw) throws IOException {
        int i = 0;
        while (i < rs.getItemCount()) {
            ResultItem item = rs.getItem(i);
            if (item != null && item.getResultObject() instanceof IResultSetObject) {
                IResultSetObject result = (IResultSetObject)item.getResultObject();
                this.output(result, props, pw);
                pw.println();
                pw.flush();
            }
            ++i;
        }
    }

    public String getPrintString(IResultSetObject rs) {
        StringBuffer sb = new StringBuffer("");
        sb.append(this.getColumnHeadings(rs));
        String nullString = ResultsViewPlugin.getDefault().getPreferenceStore().getString("org.eclipse.datatools.sqltools.result.preferences.display.nulldisplaystr");
        sb.append(this.getColumnData(rs, nullString, IResultConstants.COLUMN_ALIGNED));
        return sb.toString();
    }

    public String getPrintString(IResultInstance rs) {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < rs.getItemCount()) {
            ResultItem item = rs.getItem(i);
            if (item != null && item.getResultObject() instanceof IResultSetObject) {
                IResultSetObject result = (IResultSetObject)item.getResultObject();
                sb.append(this.getPrintString(result));
                sb.append(this.getLineSeparator());
            }
            ++i;
        }
        return sb.toString();
    }

    private String getColumnHeadings(IResultSetObject result) {
        boolean emptyHeading = false;
        _columnLen.clear();
        int columnCount = result.getColumnCount();
        StringBuffer cn = new StringBuffer(" ");
        StringBuffer cs = new StringBuffer(" ");
        int i = 1;
        while (i < columnCount + 1) {
            String columnName = result.getColumnName(i);
            if (columnName.equals("")) {
                emptyHeading = true;
            }
            StringBuffer nameDataSeparator = new StringBuffer();
            int columnWidth = this.getMaxWidth(result, i, "NULL");
            int j = 0;
            while (j < columnWidth) {
                nameDataSeparator.append("-");
                ++j;
            }
            _columnLen.put(columnName, new Integer(columnWidth));
            cn.append(this.getDisplayString(columnName, ++columnWidth, false, i == columnCount));
            cs.append(this.getDisplayString(nameDataSeparator.toString(), columnWidth, false, false));
            ++i;
        }
        cn.append(cs);
        if (emptyHeading) {
            return "";
        }
        return cn.toString();
    }

    private int getMaxWidth(IResultSetObject result, int index, String nullValue) {
        String columnName = result.getColumnName(index);
        int nameLength = columnName.length();
        int actualMaxSize = 0;
        Iterator iter = result.getDisplayRecords();
        while (iter.hasNext()) {
            String outValue;
            IResultSetRow row = (IResultSetRow)iter.next();
            Object columnValue = row.getData()[index - 1];
            if (columnValue == null) {
                columnValue = nullValue;
            }
            if (columnValue instanceof byte[]) {
                byte[] os = (byte[])columnValue;
                outValue = HexHelper.toHexString(os);
            } else {
                outValue = columnValue.toString();
            }
            if (outValue.length() <= actualMaxSize) continue;
            actualMaxSize = outValue.length();
        }
        int columnWidth = nameLength > actualMaxSize ? nameLength : actualMaxSize;
        return columnWidth;
    }

    private String getColumnData(IResultSetObject result, String nullValue, String delimiter) {
        StringBuffer data = new StringBuffer("");
        Iterator iter = result.getAllRecords();
        while (iter.hasNext()) {
            IResultSetRow row = (IResultSetRow)iter.next();
            int columnCount = result.getColumnCount();
            int i = 1;
            while (i < columnCount + 1) {
                String outValue;
                Object columnValue = row.getData(i - 1);
                if (columnValue == null) {
                    columnValue = nullValue;
                }
                if (columnValue instanceof byte[]) {
                    byte[] os = (byte[])columnValue;
                    outValue = HexHelper.toHexString(os);
                } else {
                    outValue = columnValue.toString();
                }
                if (delimiter.equals(IResultConstants.COLUMN_ALIGNED)) {
                    data.append(" ");
                    int columnWidth = (Integer)_columnLen.get(result.getColumnName(i));
                    data.append(this.getDisplayString(outValue, columnWidth, SQLUtil.isNumericType(result.getColumnSQLType(i)), i == columnCount));
                } else {
                    data.append(this.getDisplayString(outValue, delimiter, i == columnCount));
                }
                ++i;
            }
        }
        return data.toString();
    }

    private String getColumnHeadings(IResultSetObject resultset, String delimiter) {
        StringBuffer sb = new StringBuffer("");
        String[] columnNames = resultset.getColumnNames();
        int columnCount = columnNames.length;
        int i = 0;
        while (i < columnNames.length) {
            if (delimiter.equals(IResultConstants.CSV_SEPARATED)) {
                sb.append(this.escape(columnNames[i]));
            } else {
                sb.append(columnNames[i]);
            }
            if (i != columnCount - 1) {
                sb.append(this.getRealDelimiter(delimiter));
            }
            ++i;
        }
        return sb.toString();
    }

    private String getRealDelimiter(String delimiter) {
        if (delimiter.equals(IResultConstants.CSV_SEPARATED)) {
            return ",";
        }
        if (delimiter.equals(IResultConstants.COMMA_SEPARATED)) {
            return ",";
        }
        if (delimiter.equals(IResultConstants.TAB_DELIMITED)) {
            return "\t";
        }
        if (delimiter.equals(IResultConstants.USER_DEFINED)) {
            return _userDefinedDelimiter;
        }
        return "";
    }

    private String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    private String escape(String s) {
        StringBuffer sb = new StringBuffer("");
        if (s == null || s.trim().equals("")) {
            return "";
        }
        sb.append('\"');
        int i = 0;
        int size = s.length();
        while (i < size) {
            char c = s.charAt(i);
            if (c == '\"') {
                sb.append("\"\"");
            } else {
                sb.append(c);
            }
            ++i;
        }
        sb.append('\"');
        return sb.toString();
    }

    private String getDisplayString(String str, String delimiter, boolean lastColumn) {
        StringBuffer sb = new StringBuffer("");
        if (delimiter.equals(IResultConstants.CSV_SEPARATED)) {
            sb.append(this.escape(str));
        } else {
            sb.append(str);
        }
        if (!lastColumn) {
            sb.append(this.getRealDelimiter(delimiter));
        } else {
            sb.append(this.getLineSeparator());
        }
        return sb.toString();
    }

    private String getDisplayString(String str, int length, boolean isRightAligned, boolean lastColumn) {
        int strLength = str.length();
        StringBuffer sb = new StringBuffer();
        if (isRightAligned) {
            if (strLength < length) {
                int numOfSpaces = length - strLength;
                int j = 0;
                while (j < numOfSpaces) {
                    sb.append(" ");
                    ++j;
                }
            }
            sb.append(str);
        } else {
            sb.append(str);
            if (strLength < length) {
                int numOfSpaces = length - strLength;
                int j = 0;
                while (j < numOfSpaces) {
                    sb.append(" ");
                    ++j;
                }
            }
        }
        if (lastColumn) {
            sb.append(this.getLineSeparator());
        }
        return sb.toString();
    }

    public void output(IResultSetObject rs, Properties props, String path) throws IOException {
        PrintWriter writer = this.createPrintWriter(path, props.getProperty("encoding"));
        this.output(rs, props, writer);
        writer.close();
    }

    public void output(IResultInstance rs, Properties props, String path) throws IOException {
        PrintWriter writer = this.createPrintWriter(path, props.getProperty("encoding"));
        this.output(rs, props, writer);
        writer.close();
    }
}

