/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class SessionStatus
extends AbstractEnumerator {
    public static final String copyright = "Copyright (c) 2005, 2007 Actuate Corporation";
    public static final int OK = 0;
    public static final int USER_CANCELLED = 1;
    public static final int LOGIN_FAILED = 2;
    public static final int ERROR = 3;
    public static final SessionStatus OK_LITERAL = new SessionStatus(0, "Ok", "Ok");
    public static final SessionStatus USER_CANCELLED_LITERAL = new SessionStatus(1, "UserCancelled", "UserCancelled");
    public static final SessionStatus LOGIN_FAILED_LITERAL = new SessionStatus(2, "LoginFailed", "LoginFailed");
    public static final SessionStatus ERROR_LITERAL = new SessionStatus(3, "Error", "Error");
    private static final SessionStatus[] VALUES_ARRAY = new SessionStatus[]{OK_LITERAL, USER_CANCELLED_LITERAL, LOGIN_FAILED_LITERAL, ERROR_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static SessionStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SessionStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SessionStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SessionStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SessionStatus get(int value) {
        switch (value) {
            case 0: {
                return OK_LITERAL;
            }
            case 1: {
                return USER_CANCELLED_LITERAL;
            }
            case 2: {
                return LOGIN_FAILED_LITERAL;
            }
            case 3: {
                return ERROR_LITERAL;
            }
        }
        return null;
    }

    private SessionStatus(int value, String name, String literal) {
        super(value, name, literal);
    }
}

