/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.parsers.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lpg.lpgjavaruntime.LexStream;
import lpg.lpgjavaruntime.PrsStream;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceFormat;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatement;
import org.eclipse.datatools.sqltools.parsers.sql.AbstractSQLParser;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParseErrorInfo;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParseResult;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParser;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserException;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserInternalException;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserLogger;
import org.eclipse.datatools.sqltools.parsers.sql.lexer.AbstractSQLLexer;
import org.eclipse.datatools.sqltools.parsers.sql.lexer.SQLCharacterKindMap;
import org.eclipse.datatools.sqltools.parsers.sql.postparse.PostParseProcessor;
import org.eclipse.datatools.sqltools.parsers.sql.postparse.PostParseProcessorConfiguration;
import org.eclipse.datatools.sqltools.parsers.sql.util.EObjectPrinter;
import org.eclipse.emf.ecore.EObject;

public abstract class SQLParserManager {
    public int statementCount = 0;
    public int astElementCount = 0;
    public int byteCount = 0;
    public int timeCount = 0;
    boolean debug = false;
    public boolean debugPerformance = false;
    private SQLQuerySourceFormat sourceFormat = SQLQuerySourceFormat.copyDefaultFormat();
    private List postParseProcessors = this.getInternalDefaultPostParseProcessorList();
    public static final int ERROR_DIAGNOSING_NONE = 0;
    public static final int ERROR_DIAGNOSING_UNLIMITED = Integer.MAX_VALUE;
    public static final int ERROR_DIAGNOSING_TIME_MAX_DEFAULT = 1500;
    public static final int ERROR_DIAGNOSING_NUMBER_MAX_DEFAULT = 5;
    private int errorDiagnosingTimeMax = 1500;
    private int errorDiagnosingNumberMax = 5;
    private SQLCharacterKindMap characterKindMap = new SQLCharacterKindMap();
    protected AbstractSQLLexer lexer = null;
    protected AbstractSQLParser parser = null;
    public EObjectPrinter PRINTER = new EObjectPrinter();
    private long timeBeforeLexerInit;
    private long timeBeforeParserInit;
    private long timeParserInit;
    private long timeLexerInit;
    private long timeAfterParserInit;
    private long timeAfterLexerInit;
    private long timeBeforeLexing;
    private long timeAfterLexing;
    private long timeLexing;
    private long timeBeforeParsing;
    private long timeAfterParsing;
    private long timeParsing;

    public abstract List getDefaultPostParseProcessorList();

    public abstract List copyDefaultPostParseProcessorList();

    protected abstract List getInternalDefaultPostParseProcessorList();

    protected void setCharacterKindMap(SQLCharacterKindMap characterKindMap) {
        if (characterKindMap == null) {
            characterKindMap = new SQLCharacterKindMap();
        }
        this.characterKindMap = characterKindMap;
        this.setupCharacterKindMap(this.getSourceFormat());
    }

    protected SQLCharacterKindMap getCharacterKindMap() {
        if (this.characterKindMap == null) {
            this.setCharacterKindMap(new SQLCharacterKindMap());
        }
        return this.characterKindMap;
    }

    protected final void setVariableCharacterKind(char character, int charKind) {
        this.getCharacterKindMap().setTokenKind((int)character, charKind);
    }

    protected void setupCharacterKindMap(SQLQuerySourceFormat p_format) {
        this.setVariableCharacterKind(p_format.getStatementTerminator(), 78);
        this.setVariableCharacterKind(p_format.getHostVariablePrefix(), 56);
        this.setVariableCharacterKind(p_format.getParameterMarker(), 55);
        this.setVariableCharacterKind(p_format.getDelimitedIdentifierQuote(), 41);
    }

    public final List getPostParseProcessors() {
        if (this.postParseProcessors == this.getInternalDefaultPostParseProcessorList()) {
            return null;
        }
        return this.postParseProcessors;
    }

    public final void setPostParseProcessors(List postParseProcessors) {
        if (postParseProcessors == null) {
            postParseProcessors = this.getInternalDefaultPostParseProcessorList();
        }
        this.postParseProcessors = postParseProcessors;
    }

    public SQLQuerySourceFormat getSourceFormat() {
        if (this.sourceFormat == SQLQuerySourceFormat.SQL_SOURCE_FORMAT_DEFAULT || this.sourceFormat == null) {
            this.sourceFormat = SQLQuerySourceFormat.copyDefaultFormat();
        }
        return this.sourceFormat;
    }

    public void setSourceFormat(SQLQuerySourceFormat sourceFormat) {
        if (sourceFormat == SQLQuerySourceFormat.SQL_SOURCE_FORMAT_DEFAULT || sourceFormat == null) {
            sourceFormat = SQLQuerySourceFormat.copyDefaultFormat();
        }
        this.sourceFormat = sourceFormat;
        this.setupCharacterKindMap(sourceFormat);
    }

    public void configParser(SQLQuerySourceFormat sourceFormat, List postParseProcessors) {
        this.setSourceFormat(sourceFormat);
        this.setPostParseProcessors(postParseProcessors);
    }

    public void configPostParseProcessors(PostParseProcessorConfiguration config) {
        if (this.postParseProcessors == null || this.postParseProcessors == this.getInternalDefaultPostParseProcessorList()) {
            this.setPostParseProcessors(this.copyDefaultPostParseProcessorList());
        }
        List p3s = this.getPostParseProcessors();
        Iterator iter = p3s.iterator();
        while (iter.hasNext()) {
            PostParseProcessor p3 = (PostParseProcessor)iter.next();
            p3.config(config);
        }
    }

    protected abstract SQLParser createParser(AbstractSQLLexer var1, boolean var2) throws SQLParserInternalException;

    protected abstract AbstractSQLLexer createLexer(String var1);

    protected abstract SQLParseResult createParseResult(SQLStatement var1, List var2);

    public SQLParserManager() {
        this.configParser(SQLQuerySourceFormat.copyDefaultFormat(), this.getInternalDefaultPostParseProcessorList());
    }

    public SQLParserManager(SQLQuerySourceFormat sourceFormat, List postParseProcessors) {
        this.configParser(sourceFormat, postParseProcessors);
    }

    protected AbstractSQLLexer getLexer(String input) {
        this.lexer = this.createLexer(input);
        return this.lexer;
    }

    protected AbstractSQLParser getParser(AbstractSQLLexer lexer, boolean syntaxCheckOnly) throws SQLParserInternalException {
        if (this.parser == null) {
            this.parser = this.createParser(lexer, syntaxCheckOnly);
        } else {
            this.parser.resetParser((LexStream)lexer);
            this.parser.setCheckStmtOnly(syntaxCheckOnly);
        }
        return this.parser;
    }

    protected synchronized List makeAST(String input, boolean syntaxCheckOnly) throws SQLParserException, SQLParserInternalException {
        List resultList = null;
        if (input == null || input.trim().length() == 0) {
            return null;
        }
        input = input.concat(String.valueOf(this.sourceFormat.getStatementTerminator()));
        if (this.debugPerformance) {
            this.timeBeforeLexerInit = System.currentTimeMillis();
        }
        AbstractSQLLexer lexer = this.getLexer(input);
        if (this.debugPerformance) {
            this.timeAfterLexerInit = System.currentTimeMillis();
        }
        if (this.debugPerformance) {
            this.timeBeforeParserInit = this.timeAfterLexerInit;
        }
        AbstractSQLParser sqlmodelParser = this.getParser(lexer, syntaxCheckOnly);
        if (this.debugPerformance) {
            this.timeAfterParserInit = System.currentTimeMillis();
        }
        if (this.debugPerformance) {
            this.timeLexerInit = this.timeBeforeParserInit - this.timeBeforeLexerInit;
            this.timeParserInit = this.timeAfterParserInit - this.timeBeforeParserInit;
            System.out.println("[init time Lexer: " + this.timeLexerInit + ", Parser: " + this.timeParserInit + "]");
        }
        this.byteCount += input.length();
        sqlmodelParser.setErrorDiagnosingTimeMax(this.getErrorDiagnosingTimeMax());
        sqlmodelParser.setErrorDiagnosingNumberMax(this.getErrorDiagnosingNumberMax());
        try {
            this.timeBeforeLexing = this.timeAfterParserInit;
            lexer.lexer((PrsStream)sqlmodelParser);
            if (this.debug) {
                this.parser.dumpTokens();
            }
            if (this.debugPerformance) {
                this.timeAfterLexing = System.currentTimeMillis();
            }
            if (this.debugPerformance) {
                this.timeLexing = this.timeAfterLexing - this.timeBeforeLexing;
            }
            if (this.debugPerformance) {
                this.timeBeforeParsing = this.timeAfterLexing;
            }
            List script = sqlmodelParser.parser();
            long time = 0L;
            if (this.debugPerformance) {
                this.timeAfterParsing = System.currentTimeMillis();
                this.timeParsing = this.timeAfterParsing - this.timeBeforeParsing;
                System.out.println("[time lexing: " + this.timeLexing + ", parsing: " + this.timeParsing + ", input size (byte): " + input.length() + "]");
                time = this.timeAfterParsing - this.timeBeforeLexing;
                this.timeCount = (int)((long)this.timeCount + time);
                this.statementCount += script.size();
            }
            if (this.debug) {
                SQLParserLogger.getLogger().writeInfo("Successful parse of:                                            " + (this.debugPerformance ? "(" + time + "ms)" : ""));
                if (script != null) {
                    this.printAST(script);
                }
            }
            resultList = script;
            if (syntaxCheckOnly) {
                return script;
            }
            List queryElements = sqlmodelParser.getASTElementList();
            this.astElementCount += queryElements.size();
            if (this.postParseProcessors != null) {
                try {
                    resultList = this.executePostParseProcessorList(script, queryElements, this.postParseProcessors);
                }
                catch (Exception e1) {
                    if (this.postParseProcessors != this.getInternalDefaultPostParseProcessorList()) {
                        if (e1 instanceof SQLParserException) {
                            throw (SQLParserException)e1;
                        }
                        e1.printStackTrace();
                    }
                    resultList = this.wrapQueryStmtListInParseResults(script);
                }
            }
            return resultList;
        }
        catch (Exception e) {
            if (e instanceof SQLParserException) {
                throw (SQLParserException)e;
            }
            if (e instanceof SQLParserInternalException) {
                throw (SQLParserInternalException)e;
            }
            SQLParserInternalException pre = new SQLParserInternalException();
            pre.initCause(e);
            throw pre;
        }
    }

    private List wrapQueryStmtListInParseResults(List script) {
        ArrayList<SQLParseResult> resultList = new ArrayList<SQLParseResult>();
        if (script != null) {
            Iterator it = script.iterator();
            while (it.hasNext()) {
                QueryStatement stmt = (QueryStatement)it.next();
                resultList.add(this.createParseResult((SQLStatement)stmt, null));
            }
        }
        return resultList;
    }

    private List executePostParseProcessorList(List queryStmtList, List queryElements, List postParseProcessors) throws SQLParserException {
        ArrayList<SQLParseResult> parseResultList = new ArrayList<SQLParseResult>();
        if (postParseProcessors != null) {
            Iterator scriptIt = queryStmtList.iterator();
            while (scriptIt.hasNext()) {
                QueryStatement queryStmt = (QueryStatement)scriptIt.next();
                List errorList = this.postParseProcess(queryStmt, queryElements, postParseProcessors);
                if (postParseProcessors == this.getInternalDefaultPostParseProcessorList()) {
                    errorList = null;
                }
                parseResultList.add(this.createParseResult((SQLStatement)queryStmt, errorList));
            }
        }
        return parseResultList;
    }

    private List postParseProcess(QueryStatement queryStatement, List queryElements, List postParseProcessors) throws SQLParserException {
        ArrayList errorList = new ArrayList();
        Iterator processIt = postParseProcessors.iterator();
        while (processIt.hasNext()) {
            Map queryElemSubstMap;
            PostParseProcessor ppp = (PostParseProcessor)processIt.next();
            boolean isLastProcessor = !processIt.hasNext();
            Iterator queryIt = queryElements.iterator();
            while (queryIt.hasNext()) {
                List elementErrors;
                SQLQueryObject queryObject;
                Object queryElement = queryIt.next();
                if (queryElement instanceof SQLQueryObject && this.isPostParseCandidate(queryObject = (SQLQueryObject)queryElement, ppp) && (elementErrors = ppp.process(queryObject)) != null) {
                    errorList.addAll(elementErrors);
                }
                if (isLastProcessor) {
                    queryIt.remove();
                }
                if (queryElement != queryStatement) continue;
                break;
            }
            if ((queryElemSubstMap = ppp.getParsedObjectsReplacementMap()) != null) {
                Set elementsToSubstituteMappings = queryElemSubstMap.entrySet();
                Iterator replaceIt = elementsToSubstituteMappings.iterator();
                while (replaceIt.hasNext()) {
                    Map.Entry elementToSubstitute = replaceIt.next();
                    Object oldElement = elementToSubstitute.getKey();
                    Object substitute = elementToSubstitute.getValue();
                    Collections.replaceAll(queryElements, oldElement, substitute);
                }
            }
            ppp.resetState();
        }
        return errorList;
    }

    private boolean isPostParseCandidate(Object queryElement, PostParseProcessor ppp) {
        Class candidate;
        boolean isCandidate = false;
        Class[] candidateTypes = ppp.getProcessCandidateTypes();
        for (int i = 0; i < candidateTypes.length && !(isCandidate = (candidate = candidateTypes[i]).isAssignableFrom(queryElement.getClass())); ++i) {
        }
        return isCandidate;
    }

    public SQLParseResult parse(String stmt) throws SQLParserException, SQLParserInternalException {
        List resultList = null;
        resultList = this.makeAST(stmt, false);
        return (SQLParseResult)resultList.get(0);
    }

    public List parseScript(String script) throws SQLParserException, SQLParserInternalException {
        return this.makeAST(script, false);
    }

    public QueryStatement checkSyntax(String stmt) throws SQLParserException, SQLParserInternalException {
        return (QueryStatement)this.makeAST(stmt, true).get(0);
    }

    public List checkSyntaxScript(String script) throws SQLParserException, SQLParserInternalException {
        return this.makeAST(script, true);
    }

    public int getErrorDiagnosingNumberMax() {
        return this.errorDiagnosingNumberMax;
    }

    public void setErrorDiagnosingNumberMax(int errorDiagnosingNumberMax) {
        this.errorDiagnosingNumberMax = errorDiagnosingNumberMax;
    }

    public int getErrorDiagnosingTimeMax() {
        return this.errorDiagnosingTimeMax;
    }

    public void setErrorDiagnosingTimeMax(int errorDiagnosingTimeMax) {
        this.errorDiagnosingTimeMax = errorDiagnosingTimeMax;
    }

    public void printParseRuntimeException(SQLParserException e1) {
        e1.printParseRuntimeException();
    }

    public void printErrorList(SQLParseResult parseResult) {
        if (parseResult == null) {
            return;
        }
        List errorList = parseResult.getErrorList();
        SQLStatement sqlStmt = parseResult.getSQLStatement();
        if (errorList == null || errorList.isEmpty()) {
            return;
        }
        SQLParserLogger.getLogger().writeLog("Errors encountered during post parse processing of statement:");
        SQLParserLogger.getLogger().writeLog(sqlStmt.getSQL());
        Iterator errorIt = errorList.iterator();
        while (errorIt.hasNext()) {
            SQLParseErrorInfo errorInfo = (SQLParseErrorInfo)errorIt.next();
            SQLParserLogger.getLogger().writeLog("   " + errorInfo.getParserErrorMessage() + " at line:column " + errorInfo.getLineNumberStart() + ":" + errorInfo.getColumnNumberStart() + " to line:column " + errorInfo.getLineNumberEnd() + ":" + errorInfo.getColumnNumberEnd() + " \"" + errorInfo.getErrorSourceText() + "\"" + ", expected: \"" + errorInfo.getExpectedText() + "\"");
        }
    }

    public void printAST(List sqlStmts) {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        Iterator iter = sqlStmts.iterator();
        while (iter.hasNext()) {
            SQLStatement next = (SQLStatement)iter.next();
            SQLParserLogger.getLogger().writeInfo("\nStatement " + i + ": " + next.getSQL());
            this.printAST(next);
            ++i;
        }
    }

    public void printAST(SQLStatement p_Stmt) {
        this.PRINTER.printEObjectReferenceTree((EObject)p_Stmt);
    }

    public void printSQL(List sqlQueryStmts) {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        Iterator iter = sqlQueryStmts.iterator();
        while (iter.hasNext()) {
            SQLQueryObject next = (SQLQueryObject)iter.next();
            SQLParserLogger.getLogger().writeInfo("\n" + next.getClass().getName() + " " + i + ":\n" + next.getSQL());
            ++i;
        }
    }
}

