/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.plan;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.sqltools.plan.EPVFacade;
import org.eclipse.datatools.sqltools.plan.Messages;
import org.eclipse.datatools.sqltools.plan.PlanRequest;

public abstract class PlanSupportRunnable
extends Job {
    protected PlanRequest _request;
    protected Connection _conn;
    protected String _plan;
    protected Statement _stmt;
    protected Map _varDecs;
    protected String _profileName;
    protected String _dbName;

    public PlanSupportRunnable() {
        super(Messages.PlanSupportRunnable_getplan_name);
    }

    public PlanSupportRunnable(PlanRequest request, String profileName, String dbName) {
        super(Messages.PlanSupportRunnable_getplan_name);
        this._request = request;
        this._profileName = profileName;
        this._dbName = dbName;
    }

    protected Statement prepareStatement(Connection connection) throws SQLException {
        return connection.createStatement();
    }

    protected abstract String explainPlan(Statement var1) throws SQLException;

    protected String getPlan() {
        return this._plan;
    }

    protected void handleSuccess() {
        EPVFacade.getInstance().planGenerated(this._request, this.getPlan());
    }

    protected abstract void handleEnd(Connection var1, Statement var2);

    protected String retrievePlan(ResultSet rs, int columnIndex) throws SQLException {
        String plan = null;
        if (rs.next()) {
            plan = rs.getString(columnIndex);
        }
        rs.close();
        return plan;
    }

    public Connection getConnection() {
        return this._conn;
    }

    public PlanRequest getRequest() {
        return this._request;
    }

    public void setRequest(PlanRequest _request) {
        this._request = _request;
    }

    public void setVarDecs(Map decs) {
        this._varDecs = decs;
    }
}

