/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.data.internal.core.editor;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.sqltools.data.internal.core.common.Output;
import org.eclipse.datatools.sqltools.data.internal.core.editor.AbstractRowData;
import org.eclipse.datatools.sqltools.data.internal.core.editor.ITableData;
import org.eclipse.datatools.sqltools.data.internal.core.editor.Messages;
import org.eclipse.datatools.sqltools.data.internal.core.editor.StmtLog;
import org.eclipse.datatools.sqltools.data.internal.core.editor.TableDataImpl;
import org.eclipse.datatools.sqltools.data.internal.core.editor.TableDataSaveStatus;

public class RowDataImpl
extends AbstractRowData {
    protected TableDataImpl table;
    private String GRAPHIC = "GRAPHIC";
    private String VARGRAPHIC = "VARGRAPHIC";

    public RowDataImpl(TableDataImpl table, int state, Object[] data) {
        super(state, data);
        this.table = table;
    }

    public ITableData getTable() {
        return this.table;
    }

    public void save(TableDataSaveStatus status, Output output) throws SQLException, IOException {
        switch (this.state) {
            case 1: {
                this.doUpdate(status, output);
                break;
            }
            case 3: {
                this.doInsert(status, output);
                break;
            }
            case 2: {
                this.doDelete(status, output);
                break;
            }
        }
    }

    protected void doInsert(TableDataSaveStatus status, Output output) throws SQLException, IOException {
        Vector exprs = this.computeValuesClause();
        String q = "insert into " + this.table.getQualifiedTableName();
        q = q + this.formatClause(" (", this.computeInsertColList(exprs), ", ", ")");
        q = q + this.formatClause(" values(", exprs, ", ", ")");
        PreparedStatement pst = this.table.getConnection().prepareStatement(q);
        StmtLog stmtLog = new StmtLog(q);
        this.setValuesClauseArguments(pst, stmtLog);
        output.write(stmtLog.toString());
        pst.executeUpdate();
        pst.close();
        ++status.inserted;
    }

    protected Vector computeInsertColList(Vector exprs) {
        Vector<String> cols = new Vector<String>();
        int index = -1;
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            Column sqlCol = (Column)this.table.getSQLTable().getColumns().get(i);
            if (sqlCol.getIdentitySpecifier() != null || exprs.elementAt(++index) == null) continue;
            cols.add(this.table.getQuotedColumnName(i));
        }
        if (cols.size() == this.table.getColumnCount()) {
            return new Vector();
        }
        return cols;
    }

    protected void doUpdate(TableDataSaveStatus status, Output output) throws SQLException, IOException {
        String q = "update " + this.table.getQualifiedTableName();
        q = q + this.formatClause(" set ", this.computeSetClause(), ", ", "");
        q = q + this.formatClause(" where ", this.computeWhereClause(), " and ", "");
        PreparedStatement pst = this.table.getConnection().prepareStatement(q);
        StmtLog stmtLog = new StmtLog(q);
        this.setSetClauseArguments(pst, stmtLog);
        this.setWhereClauseArguments(pst, stmtLog);
        output.write(stmtLog.toString());
        int n = pst.executeUpdate();
        pst.close();
        status.updated += n;
        if (n != 1) {
            status.duplicateRow = true;
        }
    }

    protected void doDelete(TableDataSaveStatus status, Output output) throws SQLException, IOException {
        String q = "delete from " + this.table.getQualifiedTableName();
        q = q + this.formatClause(" where ", this.computeWhereClause(), " and ", "");
        PreparedStatement pst = this.table.getConnection().prepareStatement(q);
        StmtLog stmtLog = new StmtLog(q);
        this.setWhereClauseArguments(pst, stmtLog);
        output.write(stmtLog.toString());
        int n = pst.executeUpdate();
        pst.close();
        status.deleted += n;
        if (n != 1) {
            status.duplicateRow = true;
        }
    }

    public void doRefresh(int col, boolean snippet) throws SQLException, IOException, Exception {
        if (this.state == 3) {
            return;
        }
        String q = "select " + this.table.getQuotedColumnName(col);
        q = q + " from " + this.table.getQualifiedTableName();
        q = q + this.formatClause(" where ", this.computeWhereClause(), " and ", "");
        PreparedStatement pst = this.table.getConnection().prepareStatement(q);
        StmtLog stmtLog = new StmtLog(q);
        this.setWhereClauseArguments(pst, stmtLog);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            Object o = this.table.getColumnDataAccessor(col).read(rs, 0, this.table.getColumnType(col), snippet);
            if (this.newData[col] == this.oldData[col]) {
                this.newData[col] = o;
            }
            this.oldData[col] = o;
            if (rs.next()) {
                throw new Exception(stmtLog.toString() + Messages.getString("RowDataImpl.refreshTooManyRows"));
            }
        } else {
            throw new Exception(stmtLog.toString() + Messages.getString("RowDataImpl.RefreshNoRow"));
        }
        rs.close();
        pst.close();
    }

    protected Vector computeValuesClause() {
        Vector<String> exprs = new Vector<String>();
        for (int col = 0; col < this.newData.length; ++col) {
            Column sqlCol = (Column)this.table.getSQLTable().getColumns().get(col);
            if (sqlCol.getIdentitySpecifier() != null) continue;
            exprs.add(this.table.getColumnDataAccessor(col).getValuesExpr(this.newData[col]));
        }
        return exprs;
    }

    protected void setValuesClauseArguments(PreparedStatement pst, StmtLog stmtLog) throws SQLException, IOException {
        for (int col = 0; col < this.newData.length; ++col) {
            Column sqlCol = (Column)this.table.getSQLTable().getColumns().get(col);
            if (sqlCol.getIdentitySpecifier() != null) continue;
            String[] args = this.table.getColumnDataAccessor(col).writeValuesExprArgs(pst, stmtLog.getArgsCount(), this.newData[col], this.table.getColumnType(col));
            if (args != null && (this.table.getColumnType(col) == 1 || this.table.getColumnType(col) == 12)) {
                for (int i = 0; i < args.length; ++i) {
                    if (!this.GRAPHIC.equalsIgnoreCase(this.table.getColumnTypeName(col)) && !this.VARGRAPHIC.equalsIgnoreCase(this.table.getColumnTypeName(col))) continue;
                    args[i] = "G" + args[i];
                }
            }
            stmtLog.addArgs(args);
        }
    }

    protected Vector computeSetClause() {
        Vector<String> assignments = new Vector<String>();
        for (int col = 0; col < this.newData.length; ++col) {
            if (this.oldData[col] == this.newData[col]) continue;
            assignments.add(this.table.getColumnDataAccessor(col).getSetAss(this.newData[col]));
        }
        return assignments;
    }

    protected void setSetClauseArguments(PreparedStatement pst, StmtLog stmtLog) throws SQLException, IOException {
        for (int col = 0; col < this.newData.length; ++col) {
            if (this.oldData[col] == this.newData[col]) continue;
            String[] args = this.table.getColumnDataAccessor(col).writeSetAssArgs(pst, stmtLog.getArgsCount(), this.newData[col], this.table.getColumnType(col));
            stmtLog.addArgs(args);
        }
    }

    protected Vector computeWhereClause() {
        Vector<String> conds = new Vector<String>();
        int[] keyColumns = this.table.getKeyColumns();
        for (int i = 0; i < keyColumns.length; ++i) {
            conds.add(this.table.getColumnDataAccessor(keyColumns[i]).getWhereCond(this.oldData[keyColumns[i]]));
        }
        return conds;
    }

    protected void setWhereClauseArguments(PreparedStatement pst, StmtLog stmtLog) throws SQLException, IOException {
        int[] keyColumns = this.table.getKeyColumns();
        for (int i = 0; i < keyColumns.length; ++i) {
            int col = keyColumns[i];
            String[] args = this.table.getColumnDataAccessor(col).writeWhereCondArgs(pst, stmtLog.getArgsCount(), this.oldData[col], this.table.getColumnType(col));
            stmtLog.addArgs(args);
        }
    }

    protected String formatClause(String start, Vector elements, String sep, String end) {
        StringBuffer sb = new StringBuffer();
        sb.append(start);
        boolean first = true;
        for (int i = 0; i < elements.size(); ++i) {
            String s = (String)elements.elementAt(i);
            if (s == null || s.equals("")) continue;
            if (!first) {
                sb.append(sep);
            }
            sb.append(s);
            first = false;
        }
        if (first) {
            return "";
        }
        sb.append(end);
        return sb.toString();
    }
}

