/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui;

import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignerState;
import org.eclipse.datatools.connectivity.oda.design.Locale;
import org.eclipse.datatools.connectivity.oda.design.OdaDesignSession;
import org.eclipse.datatools.connectivity.oda.design.internal.designsession.DesignerLogger;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.AdaptableDataSourceProfile;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.DesignerUtil;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.ProfileSelectionEditorPage;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;
import org.eclipse.datatools.connectivity.ui.PingJob;
import org.eclipse.datatools.connectivity.ui.wizards.ProfileDetailsPropertyPage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public abstract class DataSourceEditorPageCore
extends ProfileDetailsPropertyPage {
    private OdaDesignSession m_designSession;
    private Properties m_dataSourceProps;
    private DesignerState m_responseDesignerState;
    private Boolean m_setPingButtonVisible;
    private static final String sm_className;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.connectivity.oda.design.internal.ui.DataSourceEditorPageCore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.datatools.connectivity.oda.design.internal.ui.DataSourceEditorPageCore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sm_className = clazz2.getName();
    }

    protected DataSourceDesign collectDataSourceDesign(DataSourceDesign design) {
        Properties propertyValuePairs = this.collectProperties();
        try {
            this.setDataSourceDesignProperties(design, propertyValuePairs);
        }
        catch (OdaException ex) {
            DesignerLogger logger = DesignerLogger.getInstance();
            logger.warning(sm_className, "collectDataSourceDesign( DataSourceDesign )", "Caught exception while assigning property name-value pairs to data source design properties.", ex);
        }
        return design;
    }

    protected void setDataSourceDesignProperties(DataSourceDesign design, Properties propertyValuePairs) throws OdaException {
        design.setPublicProperties(DesignSessionUtil.createDataSourcePublicProperties(design.getOdaExtensionDataSourceId(), propertyValuePairs));
        design.setPrivateProperties(DesignSessionUtil.createDataSourceNonPublicProperties(design.getOdaExtensionDataSourceId(), propertyValuePairs));
    }

    protected abstract void cleanup();

    protected DataSourceEditorPageCore() {
        this.noDefaultAndApplyButton();
    }

    public Properties getDataSourceProperties() {
        Properties props = this.getProfileProperties();
        if (props != null) {
            return props;
        }
        return this.getPageDataProperties();
    }

    protected void updateDataSourceProperties(Properties props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        Properties associatedProps = this.getDataSourceProperties();
        Iterator<Object> propKeys = props.keySet().iterator();
        while (propKeys.hasNext()) {
            String propName = (String)propKeys.next();
            associatedProps.setProperty(propName, props.getProperty(propName));
        }
    }

    protected Properties getProfileProperties() {
        IConnectionProfile profile = null;
        try {
            profile = this.getConnectionProfile();
        }
        catch (RuntimeException runtimeException) {}
        if (profile != null) {
            return profile.getBaseProperties();
        }
        return null;
    }

    protected Properties getPageDataProperties() {
        if (this.m_dataSourceProps == null) {
            this.m_dataSourceProps = new Properties();
        }
        return this.m_dataSourceProps;
    }

    protected DataSourceDesign getEditingDataSource() {
        IAdaptable element = this.getElement();
        if (element == null || !(element instanceof AdaptableDataSourceProfile)) {
            return DesignFactory.eINSTANCE.createDataSourceDesign();
        }
        DataSourceDesign dataSourceDesign = ((AdaptableDataSourceProfile)element).getDataSourceDesign();
        if (!$assertionsDisabled && dataSourceDesign == null) {
            throw new AssertionError();
        }
        return dataSourceDesign;
    }

    public void initEditSession(OdaDesignSession requestSession) throws OdaException {
        if (this.getElement() != null && this.getElement() instanceof AdaptableDataSourceProfile && this.m_designSession == requestSession) {
            return;
        }
        this.setElement((IAdaptable)DesignerUtil.getAdaptableDataSourceDesign(requestSession));
        this.m_designSession = requestSession;
    }

    public void initProfileSelectionEditSession(ProfileSelectionEditorPage profileSelectionPage) {
    }

    protected OdaDesignSession getDesignSession() {
        return this.m_designSession;
    }

    public boolean isInOdaDesignSession() {
        return this.m_designSession != null;
    }

    protected String getOdaDataSourceId() {
        if (!this.isInOdaDesignSession()) {
            return this.getConnectionProfile().getProviderId();
        }
        return this.getEditingDataSource().getOdaExtensionDataSourceId();
    }

    protected DataSourceDesign getInitializationDesign() {
        if (!this.isInOdaDesignSession()) {
            return null;
        }
        return (DataSourceDesign)EcoreUtil.copy((EObject)this.m_designSession.getRequestDataSourceDesign());
    }

    protected DesignerState getInitializationDesignerState() {
        if (!this.isInOdaDesignSession() || this.m_designSession.getRequest().getDesignerState() == null) {
            return null;
        }
        return (DesignerState)EcoreUtil.copy((EObject)this.m_designSession.getRequest().getDesignerState());
    }

    protected Locale getInitializationLocale() {
        if (!this.isInOdaDesignSession() || this.m_designSession.getRequest().getSessionLocale() == null) {
            return null;
        }
        return (Locale)EcoreUtil.copy((EObject)this.m_designSession.getRequest().getSessionLocale());
    }

    protected boolean isEditableSessionRequested() {
        if (!this.isInOdaDesignSession()) {
            return true;
        }
        return this.m_designSession.getRequest().isEditable();
    }

    protected boolean isSessionEditable() {
        return this.isEditableSessionRequested() && !this.getEditingDataSource().hasLinkToProfile();
    }

    public boolean performOk() {
        if (!this.isInOdaDesignSession()) {
            return super.performOk();
        }
        return this.finishEditSession();
    }

    public OdaDesignSession getEditSessionResponse() throws OdaException {
        if (!this.isInOdaDesignSession()) {
            throw new OdaException(Messages.common_notInDesignSession);
        }
        if (this.m_designSession.getResponse() == null) {
            this.finishEditSession();
        }
        OdaDesignSession responseSession = this.m_designSession;
        this.m_designSession = null;
        return responseSession;
    }

    protected boolean finishEditSession() {
        boolean isSessionOk;
        DataSourceDesign editedDataSource = null;
        try {
            editedDataSource = this.finishDataSourceDesign();
        }
        catch (OdaException ex) {
            editedDataSource = null;
            DesignerLogger logger = DesignerLogger.getInstance();
            logger.warning(sm_className, "finishEditSession", "Caught exception while finishDataSourceDesign.", ex);
        }
        boolean bl = isSessionOk = editedDataSource != null;
        if (!$assertionsDisabled && this.m_designSession == null) {
            throw new AssertionError();
        }
        this.m_designSession.setNewResponse(isSessionOk, editedDataSource);
        DesignerState customState = this.getResponseDesignerState();
        if (customState != null) {
            this.m_designSession.getResponse().setDesignerState(customState);
        }
        return isSessionOk;
    }

    protected DataSourceDesign finishDataSourceDesign() throws OdaException {
        if (!this.isInOdaDesignSession()) {
            throw new OdaException(Messages.common_notInDesignSession);
        }
        return this.collectDataSourceDesign(this.getEditingDataSource());
    }

    protected DesignerState getResponseDesignerState() {
        return this.m_responseDesignerState;
    }

    protected void setResponseDesignerState(DesignerState customDesignerState) {
        this.m_responseDesignerState = customDesignerState;
    }

    public void refresh() {
        this.refresh(this.getDataSourceProperties());
    }

    protected abstract void refresh(Properties var1);

    public void dispose() {
        this.cleanup();
        super.dispose();
    }

    protected void setPingButtonVisible(boolean visible) {
        this.m_setPingButtonVisible = null;
        if (this.btnPing == null) {
            this.m_setPingButtonVisible = new Boolean(visible);
        } else {
            super.setPingButtonVisible(visible);
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (this.m_setPingButtonVisible != null) {
            super.setPingButtonVisible(this.m_setPingButtonVisible.booleanValue());
        }
    }

    protected Runnable createTestConnectionRunnable(final IConnectionProfile profile) {
        return new Runnable(){

            public void run() {
                IConnection conn = PingJob.createTestConnection((IConnectionProfile)profile);
                Throwable exception = PingJob.getTestConnectionException((IConnection)conn);
                if (conn != null) {
                    conn.close();
                }
                PingJob.PingUIJob.showTestConnectionMessage((Shell)DataSourceEditorPageCore.this.getShell(), (Throwable)exception);
            }
        };
    }
}

