/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.loader;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCProcedure;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCUserDefinedFunction;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.SchemaObjectFilterProvider;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.SQLRoutinesPackage;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.ecore.EClass;

public class JDBCRoutineLoader
extends JDBCBaseLoader {
    public static final String COLUMN_PROCEDURE_NAME = "PROCEDURE_NAME";
    public static final String COLUMN_REMARKS = "REMARKS";
    public static final String COLUMN_PROCEDURE_TYPE = "PROCEDURE_TYPE";
    private IRoutineFactory mUserDefinedFunctionFactory;
    private IRoutineFactory mProcedureFactory;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JDBCRoutineLoader(ICatalogObject catalogObject) {
        this(catalogObject, new SchemaObjectFilterProvider("DatatoolsSPFilterPredicate"));
    }

    public JDBCRoutineLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        this(catalogObject, connectionFilterProvider, new UserDefinedFunctionFactory(), new ProcedureFactory());
    }

    public JDBCRoutineLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider, IRoutineFactory udfFactory, IRoutineFactory spFactory) {
        super(catalogObject, connectionFilterProvider);
        if (!$assertionsDisabled && !(catalogObject instanceof Schema)) {
            throw new AssertionError();
        }
        this.mUserDefinedFunctionFactory = udfFactory;
        this.mProcedureFactory = spFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List loadRoutines() throws SQLException {
        ArrayList<Routine> retVal = new ArrayList<Routine>();
        ResultSet rs = null;
        try {
            this.initActiveFilter();
            rs = this.createResultSet();
            while (rs.next()) {
                Routine routine = this.processRow(rs);
                if (routine == null) continue;
                retVal.add(routine);
            }
            ArrayList<Routine> arrayList = retVal;
            return arrayList;
        }
        finally {
            if (rs != null) {
                this.closeResultSet(rs);
            }
        }
    }

    public void clearRoutines(List routines) {
        routines.clear();
    }

    public IRoutineFactory getProcedureFactory() {
        return this.mProcedureFactory;
    }

    public void setProcedureFactory(IRoutineFactory procedureFactory) {
        this.mProcedureFactory = procedureFactory;
    }

    public IRoutineFactory getUserDefinedFunctionFactory() {
        return this.mUserDefinedFunctionFactory;
    }

    public void setUserDefinedFunctionFactory(IRoutineFactory userDefinedFunctionFactory) {
        this.mUserDefinedFunctionFactory = userDefinedFunctionFactory;
    }

    protected ResultSet createResultSet() throws SQLException {
        Schema schema = this.getSchema();
        return this.getCatalogObject().getConnection().getMetaData().getProcedures(schema.getCatalog().getName(), schema.getName(), this.getJDBCFilterPattern());
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected Routine processRow(ResultSet rs) throws SQLException {
        String routineName = rs.getString(COLUMN_PROCEDURE_NAME);
        if (routineName == null || this.isFiltered(routineName)) {
            return null;
        }
        IRoutineFactory routineFactory = this.isProcedure(rs) ? this.mProcedureFactory : this.mUserDefinedFunctionFactory;
        return routineFactory.createRoutine(rs);
    }

    protected Schema getSchema() {
        return (Schema)this.getCatalogObject();
    }

    protected boolean isProcedure(ResultSet rs) throws SQLException {
        return rs.getShort(COLUMN_PROCEDURE_TYPE) == 1;
    }

    static {
        $assertionsDisabled = !JDBCRoutineLoader.class.desiredAssertionStatus();
    }

    public static class UserDefinedFunctionFactory
    extends ProcedureFactory {
        public EClass getRoutineEClass() {
            return SQLRoutinesPackage.eINSTANCE.getUserDefinedFunction();
        }

        protected Routine newRoutine() {
            return new JDBCUserDefinedFunction();
        }
    }

    public static class ProcedureFactory
    implements IRoutineFactory {
        public EClass getRoutineEClass() {
            return SQLRoutinesPackage.eINSTANCE.getProcedure();
        }

        public Routine createRoutine(ResultSet rs) throws SQLException {
            Routine retVal = this.newRoutine();
            this.initialize(retVal, rs);
            return retVal;
        }

        protected Routine newRoutine() {
            return new JDBCProcedure();
        }

        protected void initialize(Routine routine, ResultSet rs) throws SQLException {
            routine.setName(rs.getString(JDBCRoutineLoader.COLUMN_PROCEDURE_NAME));
            routine.setDescription(rs.getString(JDBCRoutineLoader.COLUMN_REMARKS));
        }
    }

    public static interface IRoutineFactory {
        public EClass getRoutineEClass();

        public Routine createRoutine(ResultSet var1) throws SQLException;
    }
}

