/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.modelbase.sql.query.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.query.ColumnName;
import org.eclipse.datatools.modelbase.sql.query.GroupingExpression;
import org.eclipse.datatools.modelbase.sql.query.GroupingSets;
import org.eclipse.datatools.modelbase.sql.query.GroupingSpecification;
import org.eclipse.datatools.modelbase.sql.query.OrderBySpecification;
import org.eclipse.datatools.modelbase.sql.query.OrderByValueExpression;
import org.eclipse.datatools.modelbase.sql.query.Predicate;
import org.eclipse.datatools.modelbase.sql.query.PredicateBasic;
import org.eclipse.datatools.modelbase.sql.query.PredicateBetween;
import org.eclipse.datatools.modelbase.sql.query.PredicateExists;
import org.eclipse.datatools.modelbase.sql.query.PredicateInValueList;
import org.eclipse.datatools.modelbase.sql.query.PredicateInValueRowSelect;
import org.eclipse.datatools.modelbase.sql.query.PredicateInValueSelect;
import org.eclipse.datatools.modelbase.sql.query.PredicateIsNull;
import org.eclipse.datatools.modelbase.sql.query.PredicateLike;
import org.eclipse.datatools.modelbase.sql.query.PredicateQuantifiedRowSelect;
import org.eclipse.datatools.modelbase.sql.query.PredicateQuantifiedValueSelect;
import org.eclipse.datatools.modelbase.sql.query.QueryCombined;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionBody;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionRoot;
import org.eclipse.datatools.modelbase.sql.query.QueryNested;
import org.eclipse.datatools.modelbase.sql.query.QueryResultSpecification;
import org.eclipse.datatools.modelbase.sql.query.QuerySearchCondition;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryUpdateStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.QueryValues;
import org.eclipse.datatools.modelbase.sql.query.ResultColumn;
import org.eclipse.datatools.modelbase.sql.query.ResultTableAllColumns;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryModelFactory;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionCombined;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionNested;
import org.eclipse.datatools.modelbase.sql.query.SuperGroup;
import org.eclipse.datatools.modelbase.sql.query.TableCorrelation;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.TableFunction;
import org.eclipse.datatools.modelbase.sql.query.TableInDatabase;
import org.eclipse.datatools.modelbase.sql.query.TableJoined;
import org.eclipse.datatools.modelbase.sql.query.TableNested;
import org.eclipse.datatools.modelbase.sql.query.TableReference;
import org.eclipse.datatools.modelbase.sql.query.UpdateAssignmentExpression;
import org.eclipse.datatools.modelbase.sql.query.UpdateSourceExprList;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseElse;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSearch;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSearchContent;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSimple;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSimpleContent;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCast;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCombined;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionDefaultValue;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionFunction;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionLabeledDuration;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionNested;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionNullValue;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionScalarSelect;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionSimple;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionVariable;
import org.eclipse.datatools.modelbase.sql.query.ValuesRow;
import org.eclipse.datatools.modelbase.sql.query.WithTableReference;
import org.eclipse.datatools.modelbase.sql.query.WithTableSpecification;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.ValueExpressionHelper;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceFormat;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class TableHelper {
    public static final String DELIMITED_IDENTIFIER_QUOTE = "\"";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public static String createFromClauseForStatement(QueryStatement stmt) {
        StringBuffer sqlBuf = new StringBuffer();
        List tableRefList = StatementHelper.getTablesForStatement(stmt);
        Iterator tableIt = tableRefList.iterator();
        while (tableIt.hasNext()) {
            TableExpression tblExpr = (TableExpression)tableIt.next();
            if (sqlBuf.length() > 0) {
                sqlBuf.append(", ");
            }
            String tblExprSQL = tblExpr.getSQL();
            sqlBuf.append(tblExprSQL);
        }
        if (sqlBuf.length() > 0) {
            sqlBuf.insert(0, "From ");
        }
        return sqlBuf.toString();
    }

    public static String createFromClauseForStatement(SQLQueryObject stmt) {
        String retVal = "";
        if (stmt instanceof QueryStatement) {
            retVal = TableHelper.createFromClauseForStatement((QueryStatement)stmt);
        } else if (stmt instanceof QuerySelect) {
            StringBuffer sqlBuf = new StringBuffer();
            List tableRefList = StatementHelper.getTablesForStatement(stmt);
            Iterator tableIt = tableRefList.iterator();
            while (tableIt.hasNext()) {
                TableExpression tblExpr = (TableExpression)tableIt.next();
                if (sqlBuf.length() > 0) {
                    sqlBuf.append(", ");
                }
                String tblExprSQL = tblExpr.getSQL();
                sqlBuf.append(tblExprSQL);
            }
            if (sqlBuf.length() > 0) {
                sqlBuf.insert(0, "FROM ");
            }
            retVal = sqlBuf.toString();
        }
        return retVal;
    }

    public static TableInDatabase createTableExpressionForTable(Table table) {
        TableInDatabase tableInDB = null;
        if (table != null) {
            SQLQueryModelFactory factory = SQLQueryModelFactory.eINSTANCE;
            tableInDB = factory.createTableInDatabase();
            tableInDB.setDatabaseTable(table);
            String tableName = table.getName();
            tableInDB.setName(tableName);
            EList rdbColumnList = tableInDB.getColumnList();
            EList cList = table.getColumns();
            Iterator columnItr = cList.iterator();
            while (columnItr.hasNext()) {
                Column col = (Column)columnItr.next();
                ValueExpressionColumn valueExprColumn = factory.createValueExpressionColumn();
                valueExprColumn.setName(col.getName());
                valueExprColumn.setDataType(ValueExpressionHelper.copyDataType(col.getDataType()));
                rdbColumnList.add(valueExprColumn);
            }
        }
        return tableInDB;
    }

    public static List exposeEffectiveResultColumns(QueryExpressionBody nestedQuery) {
        List exposedColumns = new ArrayList();
        if (nestedQuery instanceof QuerySelect) {
            QuerySelect select = (QuerySelect)nestedQuery;
            exposedColumns = TableHelper.exposeResultColumnsOfQuerySelect(select);
        } else if (nestedQuery instanceof QueryCombined) {
            QueryCombined combined = (QueryCombined)nestedQuery;
            exposedColumns = TableHelper.exposeResultColumnsOfQueryCombined(combined);
        } else if (nestedQuery instanceof QueryNested) {
            QueryNested qryNested = (QueryNested)nestedQuery;
            exposedColumns = TableHelper.exposeEffectiveResultColumns(qryNested.getNestedQuery());
        } else if (nestedQuery instanceof QueryValues) {
            QueryValues values = (QueryValues)nestedQuery;
            exposedColumns = TableHelper.exposeResultColumnsOfQueryValues(values);
        }
        return exposedColumns;
    }

    public static List exposeEffectiveResultColumns(TableExpression tableExpr) {
        EList corrColNameList;
        Object resultColExprList = new ArrayList();
        if (tableExpr == null) {
            return null;
        }
        if (tableExpr instanceof QueryExpressionBody) {
            QueryExpressionBody query = (QueryExpressionBody)tableExpr;
            resultColExprList = TableHelper.exposeEffectiveResultColumns(query);
        } else if (tableExpr instanceof TableInDatabase) {
            TableInDatabase tableInDB = (TableInDatabase)tableExpr;
            Table dbTable = tableInDB.getDatabaseTable();
            if (dbTable != null && dbTable.getColumns().size() != tableInDB.getColumnList().size()) {
                TableHelper.populateTableExpressionColumns(tableInDB, dbTable);
            }
            resultColExprList = tableInDB.getColumnList();
        } else if (tableExpr instanceof WithTableReference) {
            WithTableReference withTableRef = (WithTableReference)tableExpr;
            resultColExprList = TableHelper.exposeEffectiveResultColumns(withTableRef);
        } else if (tableExpr instanceof TableFunction) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.datatools.modelbase.sql.query.helper.TableHelper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer = new StringBuffer(String.valueOf(clazz.getName())).append(": implement exposeEffectiveResultColumns(TableExpression) for type");
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.datatools.modelbase.sql.query.TableFunction");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StatementHelper.logError(stringBuffer.append(clazz2.getName()).toString());
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.datatools.modelbase.sql.query.helper.TableHelper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StatementHelper.logError(String.valueOf(clazz.getName()) + ": implement exposeEffectiveResultColumns(TableExpression) for type" + tableExpr.getClass().getName());
        }
        TableCorrelation tableCorr = tableExpr.getTableCorrelation();
        if (tableCorr != null && (corrColNameList = tableCorr.getColumnNameList()).size() <= resultColExprList.size()) {
            ArrayList<ValueExpressionColumn> corrColList = new ArrayList<ValueExpressionColumn>();
            int i = 0;
            while (i < corrColNameList.size()) {
                Object obj1 = corrColNameList.get(i);
                Object obj2 = resultColExprList.get(i);
                if (obj1 instanceof ColumnName && obj2 instanceof ValueExpressionColumn) {
                    ColumnName corrColName = (ColumnName)obj1;
                    ValueExpressionColumn exposedCol = (ValueExpressionColumn)obj2;
                    ValueExpressionColumn exposedCorrCol = StatementHelper.createColumnExpression(corrColName.getName());
                    DataType exposedColDataType = exposedCol.getDataType();
                    DataType exposedCorrColDataType = ValueExpressionHelper.copyDataType(exposedColDataType);
                    exposedCorrCol.setDataType(exposedCorrColDataType);
                    TableInDatabase tableInDB = exposedCol.getTableInDatabase();
                    exposedCorrCol.setTableInDatabase(tableInDB);
                    corrColList.add(exposedCorrCol);
                }
                ++i;
            }
            resultColExprList = corrColList;
        }
        return resultColExprList;
    }

    public static List exposeEffectiveResultColumns(WithTableReference withTable) {
        ArrayList<ValueExpressionColumn> resultColExprList = new ArrayList<ValueExpressionColumn>();
        if (withTable == null || withTable.getWithTableSpecification() == null) {
            return resultColExprList;
        }
        WithTableSpecification withTableSpec = withTable.getWithTableSpecification();
        QueryExpressionBody withTableQuery = withTableSpec.getWithTableQueryExpr();
        List withTableQueryResultCols = TableHelper.getEffectiveResultColumns(withTableQuery);
        EList withTableColNames = withTableSpec.getColumnNameList();
        if (withTableColNames == null || withTableColNames.isEmpty()) {
            resultColExprList.addAll(TableHelper.copyColumnExprList(withTableQueryResultCols));
        } else if (withTableColNames != null && !withTableColNames.isEmpty() && withTableColNames.size() <= withTableQueryResultCols.size()) {
            int i = 0;
            while (i < withTableColNames.size()) {
                ColumnName columnName = (ColumnName)withTableColNames.get(i);
                ValueExpressionColumn exposedCol = StatementHelper.createColumnExpression(columnName.getName());
                ValueExpressionColumn withQueryResultCol = (ValueExpressionColumn)withTableQueryResultCols.get(i);
                DataType withQueryResultColDataType = withQueryResultCol.getDataType();
                DataType exposedColDataType = ValueExpressionHelper.copyDataType(withQueryResultColDataType);
                exposedCol.setTableInDatabase(withQueryResultCol.getTableInDatabase());
                exposedCol.setDataType(exposedColDataType);
                resultColExprList.add(exposedCol);
                ++i;
            }
        } else if (withTableColNames != null && !withTableColNames.isEmpty() && withTableQueryResultCols.isEmpty()) {
            int i = 0;
            while (i < withTableColNames.size()) {
                ColumnName columnName = (ColumnName)withTableColNames.get(i);
                ValueExpressionColumn exposedCol = StatementHelper.createColumnExpression(columnName.getName());
                resultColExprList.add(exposedCol);
                ++i;
            }
        }
        withTable.getColumnList().clear();
        withTable.getColumnList().addAll(resultColExprList);
        return resultColExprList;
    }

    public static Set findColumnReferencesInGroupingExpression(GroupingExpression groupingExpr) {
        if (groupingExpr == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(groupingExpr.getValueExpr()));
        return columnSet;
    }

    public static Set findColumnReferencesInGroupingSpecification(GroupingSpecification groupingSpec) {
        HashSet columnSet = new HashSet();
        if (groupingSpec != null) {
            if (groupingSpec instanceof GroupingExpression) {
                GroupingExpression groupingExpr = (GroupingExpression)groupingSpec;
                columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(groupingExpr.getValueExpr()));
            } else if (groupingSpec instanceof SuperGroup) {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Class<?> refWanted = clazz;
                Class[] classArray = new Class[2];
                Class<?> clazz2 = class$3;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$3 = Class.forName("org.eclipse.datatools.modelbase.sql.query.GroupingSpecification");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Class<?> clazz3 = class$4;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$4 = Class.forName("org.eclipse.datatools.modelbase.sql.query.SuperGroupElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz3;
                Class[] refsToCheck = classArray;
                Set groupColumns = StatementHelper.getReferencesViaSpecificReferencePaths((EObject)groupingSpec, refWanted, refsToCheck);
                columnSet.addAll(groupColumns);
            } else if (groupingSpec instanceof GroupingSets) {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Class<?> refWanted = clazz;
                Class[] classArray = new Class[3];
                Class<?> clazz4 = class$3;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$3 = Class.forName("org.eclipse.datatools.modelbase.sql.query.GroupingSpecification");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz4;
                Class<?> clazz5 = class$5;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$5 = Class.forName("org.eclipse.datatools.modelbase.sql.query.GroupingSetsElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz5;
                Class<?> clazz6 = class$4;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$4 = Class.forName("org.eclipse.datatools.modelbase.sql.query.SuperGroupElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[2] = clazz6;
                Class[] refsToCheck = classArray;
                Set groupColumns = StatementHelper.getReferencesViaSpecificReferencePaths((EObject)groupingSpec, refWanted, refsToCheck);
                columnSet.addAll(groupColumns);
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.datatools.modelbase.sql.query.helper.TableHelper");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new UnsupportedOperationException(String.valueOf(clazz.getName()) + "#findColumnReferencesInGroupingSpecification() not implemented for " + groupingSpec.getClass().getName() + ".");
            }
        }
        return columnSet;
    }

    public static Set findColumnReferencesInGroupingSpecificationList(List groupingSpecList) {
        HashSet columnSet = new HashSet();
        if (groupingSpecList != null) {
            Iterator it = groupingSpecList.iterator();
            while (it.hasNext()) {
                GroupingSpecification groupingSpec = (GroupingSpecification)it.next();
                columnSet.addAll(TableHelper.findColumnReferencesInGroupingSpecification(groupingSpec));
            }
        }
        return columnSet;
    }

    public static Set findColumnReferencesInOrderBySpecification(OrderBySpecification orderBySpec) {
        if (orderBySpec == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        if (orderBySpec instanceof OrderByValueExpression) {
            OrderByValueExpression orderByValue = (OrderByValueExpression)orderBySpec;
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(orderByValue.getValueExpr()));
        }
        return columnSet;
    }

    public static Set findColumnReferencesInOrderBySpecificationList(List orderBySpecList) {
        if (orderBySpecList == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        Iterator orderIt = orderBySpecList.iterator();
        while (orderIt.hasNext()) {
            OrderBySpecification orderBySpec = (OrderBySpecification)orderIt.next();
            columnSet.addAll(TableHelper.findColumnReferencesInOrderBySpecification(orderBySpec));
        }
        return columnSet;
    }

    public static Set findColumnReferencesInPredicate(Predicate predicate) {
        if (predicate == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        if (predicate instanceof PredicateBasic) {
            PredicateBasic basic = (PredicateBasic)predicate;
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(basic.getRightValueExpr()));
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(basic.getLeftValueExpr()));
            return columnSet;
        }
        if (predicate instanceof PredicateBetween) {
            PredicateBetween between = (PredicateBetween)predicate;
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(between.getRightValueExpr1()));
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(between.getRightValueExpr2()));
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(between.getLeftValueExpr()));
            return columnSet;
        }
        if (predicate instanceof PredicateExists) {
            PredicateExists exists = (PredicateExists)predicate;
            columnSet.addAll(TableHelper.findColumnReferencesInQueryExpressionBody(exists.getQueryExpr()));
            return columnSet;
        }
        if (predicate instanceof PredicateInValueList) {
            PredicateInValueList inValueList = (PredicateInValueList)predicate;
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(inValueList.getValueExpr()));
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpressionList((List)inValueList.getValueExprList()));
            return columnSet;
        }
        if (predicate instanceof PredicateInValueRowSelect) {
            PredicateInValueRowSelect inRowSelect = (PredicateInValueRowSelect)predicate;
            columnSet.addAll(TableHelper.findColumnReferencesInQueryExpressionRoot(inRowSelect.getQueryExpr()));
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpressionList((List)inRowSelect.getValueExprList()));
            return columnSet;
        }
        if (predicate instanceof PredicateInValueSelect) {
            PredicateInValueSelect inValueSelect = (PredicateInValueSelect)predicate;
            columnSet.addAll(TableHelper.findColumnReferencesInQueryExpressionRoot(inValueSelect.getQueryExpr()));
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(inValueSelect.getValueExpr()));
            return columnSet;
        }
        if (predicate instanceof PredicateIsNull) {
            PredicateIsNull isNull = (PredicateIsNull)predicate;
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(isNull.getValueExpr()));
            return columnSet;
        }
        if (predicate instanceof PredicateLike) {
            PredicateLike like = (PredicateLike)predicate;
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(like.getMatchingValueExpr()));
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(like.getPatternValueExpr()));
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(like.getEscapeValueExpr()));
            return columnSet;
        }
        if (predicate instanceof PredicateQuantifiedRowSelect) {
            PredicateQuantifiedRowSelect rowSelect = (PredicateQuantifiedRowSelect)predicate;
            columnSet.addAll(TableHelper.findColumnReferencesInQueryExpressionRoot(rowSelect.getQueryExpr()));
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpressionList((List)rowSelect.getValueExprList()));
            return columnSet;
        }
        if (predicate instanceof PredicateQuantifiedValueSelect) {
            PredicateQuantifiedValueSelect inValueSelect = (PredicateQuantifiedValueSelect)predicate;
            columnSet.addAll(TableHelper.findColumnReferencesInQueryExpressionRoot(inValueSelect.getQueryExpr()));
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(inValueSelect.getValueExpr()));
            return columnSet;
        }
        return columnSet;
    }

    public static Set findColumnReferencesInQueryExpressionBody(QueryExpressionBody queryExprBody) {
        if (queryExprBody == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        if (queryExprBody instanceof QuerySelect) {
            QuerySelect select = (QuerySelect)queryExprBody;
            columnSet.addAll(TableHelper.findColumnReferencesInQueryResultSpecificationList((List)select.getSelectClause()));
            columnSet.addAll(TableHelper.findColumnReferencesInTableReferenceList((List)select.getFromClause()));
            columnSet.addAll(TableHelper.findColumnReferencesInSearchCondition(select.getWhereClause()));
            columnSet.addAll(TableHelper.findColumnReferencesInSearchCondition(select.getHavingClause()));
            columnSet.addAll(TableHelper.findColumnReferencesInGroupingSpecificationList((List)select.getGroupByClause()));
        } else if (queryExprBody instanceof QueryCombined) {
            QueryCombined combined = (QueryCombined)queryExprBody;
            columnSet.addAll(TableHelper.findColumnReferencesInQueryExpressionBody(combined.getLeftQuery()));
            columnSet.addAll(TableHelper.findColumnReferencesInQueryExpressionBody(combined.getRightQuery()));
        } else if (queryExprBody instanceof QueryNested) {
            QueryNested qryNested = (QueryNested)queryExprBody;
            QueryExpressionBody nestedQuery = qryNested.getNestedQuery();
            columnSet.addAll(TableHelper.findColumnReferencesInQueryExpressionBody(nestedQuery));
        } else if (!(queryExprBody instanceof QueryValues)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.datatools.modelbase.sql.query.helper.TableHelper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new UnsupportedOperationException(String.valueOf(clazz.getName()) + "#findColumnReferencesInQueryExpressionBody( (" + queryExprBody.getClass().getName() + ") QueryExpressionBody ) not implemented.");
        }
        return columnSet;
    }

    public static Set findColumnReferencesInQueryExpressionRoot(QueryExpressionRoot queryExprRoot) {
        if (queryExprRoot == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        columnSet.addAll(TableHelper.findColumnReferencesInQueryExpressionBody(queryExprRoot.getQuery()));
        return columnSet;
    }

    public static Set findColumnReferencesInQueryResultSpecification(QueryResultSpecification queryResult) {
        if (queryResult == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        if (queryResult instanceof ResultColumn) {
            ResultColumn resultCol = (ResultColumn)queryResult;
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(resultCol.getValueExpr()));
        }
        return columnSet;
    }

    public static Set findColumnReferencesInQueryResultSpecificationList(List queryResultSpecList) {
        if (queryResultSpecList == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        Iterator it = queryResultSpecList.iterator();
        while (it.hasNext()) {
            QueryResultSpecification resultSpec = (QueryResultSpecification)it.next();
            columnSet.addAll(TableHelper.findColumnReferencesInQueryResultSpecification(resultSpec));
        }
        return columnSet;
    }

    public static Set findColumnReferencesInQuerySelectStatement(QuerySelectStatement querySelect) {
        if (querySelect == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        columnSet.addAll(TableHelper.findColumnReferencesInQueryExpressionRoot(querySelect.getQueryExpr()));
        EList orderBySpecList = querySelect.getOrderByClause();
        columnSet.addAll(TableHelper.findColumnReferencesInOrderBySpecificationList((List)orderBySpecList));
        return columnSet;
    }

    public static Set findColumnReferencesInQueryUpdateStatement(QueryUpdateStatement updateStmt) {
        if (updateStmt == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        columnSet.addAll(TableHelper.findColumnReferencesInUpdateAssignmentExprList((List)updateStmt.getAssignmentClause()));
        columnSet.addAll(TableHelper.findColumnReferencesInSearchCondition(updateStmt.getWhereClause()));
        if (updateStmt.getWhereCurrentOfClause() != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.datatools.modelbase.sql.query.helper.TableHelper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer = new StringBuffer(String.valueOf(clazz.getName())).append(" implement findColumnReferencesInQueryUpdateStatement(QueryUpdateStatement)").append(" for ");
            Class<?> clazz2 = class$6;
            if (clazz2 == null) {
                try {
                    clazz2 = class$6 = Class.forName("org.eclipse.datatools.modelbase.sql.query.CursorReference");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StatementHelper.logError(stringBuffer.append(clazz2.getName()).toString());
        }
        return columnSet;
    }

    public static Set findColumnReferencesInSearchCondition(QuerySearchCondition searchCond) {
        if (searchCond == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        if (searchCond instanceof Predicate) {
            Predicate pred = (Predicate)searchCond;
            return TableHelper.findColumnReferencesInPredicate(pred);
        }
        if (searchCond instanceof SearchConditionCombined) {
            SearchConditionCombined combined = (SearchConditionCombined)searchCond;
            columnSet.addAll(TableHelper.findColumnReferencesInSearchCondition(combined.getLeftCondition()));
            columnSet.addAll(TableHelper.findColumnReferencesInSearchCondition(combined.getRightCondition()));
            return columnSet;
        }
        if (searchCond instanceof SearchConditionNested) {
            SearchConditionNested nest = (SearchConditionNested)searchCond;
            return TableHelper.findColumnReferencesInSearchCondition(nest.getNestedCondition());
        }
        return columnSet;
    }

    public static Set findColumnReferencesInTableReference(TableReference tableRef) {
        HashSet columnSet = Collections.EMPTY_SET;
        if (tableRef != null) {
            columnSet = new HashSet();
            if (!(tableRef instanceof TableInDatabase)) {
                if (tableRef instanceof QueryExpressionBody) {
                    QueryExpressionBody queryExprBody = (QueryExpressionBody)tableRef;
                    columnSet.addAll(TableHelper.findColumnReferencesInQueryExpressionBody(queryExprBody));
                } else if (tableRef instanceof TableFunction) {
                    TableFunction tableFunc = (TableFunction)tableRef;
                    columnSet.addAll(TableHelper.findColumnReferencesInValueExpressionList((List)tableFunc.getParameterList()));
                } else if (tableRef instanceof TableNested) {
                    TableNested tableNested = (TableNested)tableRef;
                    columnSet.addAll(TableHelper.findColumnReferencesInTableReference(tableNested.getNestedTableRef()));
                } else if (tableRef instanceof TableJoined) {
                    TableJoined tableJoined = (TableJoined)tableRef;
                    columnSet.addAll(TableHelper.findColumnReferencesInTableReference(tableJoined.getTableRefLeft()));
                    columnSet.addAll(TableHelper.findColumnReferencesInTableReference(tableJoined.getTableRefRight()));
                    columnSet.addAll(TableHelper.findColumnReferencesInSearchCondition(tableJoined.getJoinCondition()));
                } else if (tableRef instanceof WithTableReference) {
                    WithTableReference withTableRef = (WithTableReference)tableRef;
                    columnSet.addAll(TableHelper.findColumnReferencesInWithTableSpecification(withTableRef.getWithTableSpecification()));
                }
            }
        }
        return columnSet;
    }

    public static Set findColumnReferencesInTableReferenceList(List tableRefList) {
        HashSet columnSet = Collections.EMPTY_SET;
        if (tableRefList != null && tableRefList.size() > 0) {
            columnSet = new HashSet();
            Iterator tableRefListIter = tableRefList.iterator();
            while (tableRefListIter.hasNext()) {
                Object listObj = tableRefListIter.next();
                if (!(listObj instanceof TableReference)) continue;
                TableReference tableRef = (TableReference)listObj;
                columnSet.addAll(TableHelper.findColumnReferencesInTableReference(tableRef));
            }
        }
        return columnSet;
    }

    public static Set findColumnReferencesInUpdateAssignmentExpr(UpdateAssignmentExpression updateAssignmentExpr) {
        HashSet columnSet = new HashSet();
        columnSet.addAll(updateAssignmentExpr.getTargetColumnList());
        if (updateAssignmentExpr.getUpdateSource() instanceof UpdateSourceExprList) {
            UpdateSourceExprList updateSrcExprList = (UpdateSourceExprList)updateAssignmentExpr.getUpdateSource();
            columnSet.addAll(TableHelper.findColumnReferencesInUpdateSourceExprList(updateSrcExprList));
        }
        return columnSet;
    }

    public static Set findColumnReferencesInUpdateAssignmentExprList(List updateAssignmentExprList) {
        HashSet columnSet = new HashSet();
        Iterator assignIt = updateAssignmentExprList.iterator();
        while (assignIt.hasNext()) {
            UpdateAssignmentExpression upAssEx = (UpdateAssignmentExpression)assignIt.next();
            columnSet.addAll(TableHelper.findColumnReferencesInUpdateAssignmentExpr(upAssEx));
        }
        return columnSet;
    }

    public static Set findColumnReferencesInUpdateSourceExprList(UpdateSourceExprList updateSourceExprList) {
        if (updateSourceExprList == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        EList exprList = updateSourceExprList.getValueExprList();
        columnSet.addAll(TableHelper.findColumnReferencesInValueExpressionList((List)exprList));
        return columnSet;
    }

    public static Set findColumnReferencesInValueExpression(QueryValueExpression valueExpr) {
        if (valueExpr == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<QueryValueExpression> columnSet = new HashSet<QueryValueExpression>();
        if (valueExpr instanceof ValueExpressionColumn) {
            columnSet.add(valueExpr);
            return columnSet;
        }
        if (valueExpr instanceof ValueExpressionSimple) {
            return Collections.EMPTY_SET;
        }
        if (valueExpr instanceof ValueExpressionCombined) {
            ValueExpressionCombined combi = (ValueExpressionCombined)valueExpr;
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(combi.getRightValueExpr()));
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(combi.getLeftValueExpr()));
            return columnSet;
        }
        if (valueExpr instanceof ValueExpressionDefaultValue || valueExpr instanceof ValueExpressionNullValue || valueExpr instanceof ValueExpressionVariable) {
            return Collections.EMPTY_SET;
        }
        if (valueExpr instanceof ValueExpressionNested) {
            ValueExpressionNested nest = (ValueExpressionNested)valueExpr;
            return TableHelper.findColumnReferencesInValueExpression(nest.getNestedValueExpr());
        }
        if (valueExpr instanceof ValueExpressionCaseSearch) {
            ValueExpressionCaseSearch caseSearch = (ValueExpressionCaseSearch)valueExpr;
            Iterator searchContentList = caseSearch.getSearchContentList().iterator();
            while (searchContentList.hasNext()) {
                ValueExpressionCaseSearchContent searchContent = (ValueExpressionCaseSearchContent)searchContentList.next();
                columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(searchContent.getValueExpr()));
                columnSet.addAll(TableHelper.findColumnReferencesInSearchCondition(searchContent.getSearchCondition()));
            }
            ValueExpressionCaseElse caseElse = caseSearch.getCaseElse();
            if (caseElse != null) {
                columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(caseElse.getValueExpr()));
            }
            return columnSet;
        }
        if (valueExpr instanceof ValueExpressionCaseSimple) {
            ValueExpressionCaseSimple caseSimple = (ValueExpressionCaseSimple)valueExpr;
            columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(caseSimple.getValueExpr()));
            Iterator simpleContentList = caseSimple.getContentList().iterator();
            while (simpleContentList.hasNext()) {
                ValueExpressionCaseSimpleContent simpleContent = (ValueExpressionCaseSimpleContent)simpleContentList.next();
                columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(simpleContent.getResultValueExpr()));
                columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(simpleContent.getWhenValueExpr()));
            }
            ValueExpressionCaseElse caseElse = caseSimple.getCaseElse();
            if (caseElse != null) {
                columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(caseElse.getValueExpr()));
            }
            return columnSet;
        }
        if (valueExpr instanceof ValueExpressionCast) {
            ValueExpressionCast cast = (ValueExpressionCast)valueExpr;
            return TableHelper.findColumnReferencesInValueExpression(cast.getValueExpr());
        }
        if (valueExpr instanceof ValueExpressionFunction) {
            ValueExpressionFunction func = (ValueExpressionFunction)valueExpr;
            return TableHelper.findColumnReferencesInValueExpressionList((List)func.getParameterList());
        }
        if (valueExpr instanceof ValueExpressionLabeledDuration) {
            ValueExpressionLabeledDuration dur = (ValueExpressionLabeledDuration)valueExpr;
            return TableHelper.findColumnReferencesInValueExpression(dur.getValueExpr());
        }
        boolean cfr_ignored_0 = valueExpr instanceof ValueExpressionScalarSelect;
        return columnSet;
    }

    public static Set findColumnReferencesInValueExpressionList(List valueExprList) {
        HashSet columnSet = null;
        if (valueExprList != null) {
            columnSet = new HashSet();
            Iterator valIt = valueExprList.iterator();
            while (valIt.hasNext()) {
                QueryValueExpression valueExpr = (QueryValueExpression)valIt.next();
                columnSet.addAll(TableHelper.findColumnReferencesInValueExpression(valueExpr));
            }
        }
        return columnSet;
    }

    public static Set findColumnReferencesInValuesRow(ValuesRow valuesRow) {
        if (valuesRow == null) {
            return Collections.EMPTY_SET;
        }
        HashSet columnSet = new HashSet();
        columnSet.addAll(TableHelper.findColumnReferencesInValueExpressionList((List)valuesRow.getExprList()));
        return columnSet;
    }

    public static Set findColumnReferencesInWithTableSpecification(WithTableSpecification withTableSpec) {
        HashSet columnSet = Collections.EMPTY_SET;
        if (withTableSpec != null) {
            columnSet = new HashSet();
            columnSet.addAll(TableHelper.findColumnReferencesInQueryExpressionBody(withTableSpec.getWithTableQueryExpr()));
        }
        return columnSet;
    }

    public static TableExpression findTableExpressionInTableExpressionList(String schemaName, String tableName, List tableExprList) {
        TableExpression foundTableExpr = null;
        SQLQuerySourceFormat sourceFormat = null;
        if (tableName != null && tableExprList != null) {
            Iterator tableIt = tableExprList.iterator();
            while (tableIt.hasNext()) {
                TableExpression tableExpr = (TableExpression)tableIt.next();
                if (sourceFormat == null && tableExpr.getSourceInfo() != null && tableExpr.getSourceInfo().getSqlFormat() != null) {
                    sourceFormat = tableExpr.getSourceInfo().getSqlFormat();
                }
                if (!StatementHelper.equalSQLIdentifiers(tableName, tableExpr.getName())) continue;
                String tableExprSchemaName = TableHelper.getSchemaNameForTableExpression(tableExpr);
                if (schemaName != null && !StatementHelper.equalSQLIdentifiers(schemaName, tableExprSchemaName)) continue;
                foundTableExpr = tableExpr;
                break;
            }
        }
        return foundTableExpr;
    }

    public static TableExpression findTableExpressionsByNameOrAlias(String tableNameOrAlias, List tableExprList, String defaultSchemaName) {
        TableExpression tableExprFound = null;
        SQLQuerySourceFormat sourceFormat = null;
        ArrayList<TableExpression> matchingSchemaQualifiedTables = new ArrayList<TableExpression>();
        if (tableNameOrAlias != null && tableExprList != null) {
            Iterator tableIt = tableExprList.iterator();
            while (tableIt.hasNext()) {
                TableExpression tableExpr = (TableExpression)tableIt.next();
                TableCorrelation tableCorr = tableExpr.getTableCorrelation();
                String tableName = tableExpr.getName();
                String tableAlias = null;
                if (tableCorr != null) {
                    tableAlias = tableCorr.getName();
                }
                if (tableExpr.getSourceInfo() != null && tableExpr.getSourceInfo().getSqlFormat() != null && (sourceFormat = tableExpr.getSourceInfo().getSqlFormat()).getOmitSchema() != null && sourceFormat.getOmitSchema().length() > 0) {
                    defaultSchemaName = sourceFormat.getOmitSchema();
                }
                boolean equalNames = StatementHelper.equalSQLIdentifiers(tableNameOrAlias, tableName);
                boolean equalAlias = StatementHelper.equalSQLIdentifiers(tableNameOrAlias, tableAlias);
                if (equalAlias) {
                    tableExprFound = tableExpr;
                    break;
                }
                if (!equalNames || tableAlias != null) continue;
                String tableSchema = TableHelper.getSchemaName(tableExpr);
                if (tableSchema == null || StatementHelper.equalSQLIdentifiers(tableSchema, defaultSchemaName)) {
                    tableExprFound = tableExpr;
                    continue;
                }
                matchingSchemaQualifiedTables.add(tableExpr);
            }
        }
        if (tableExprFound == null && matchingSchemaQualifiedTables.size() == 1) {
            tableExprFound = (TableExpression)matchingSchemaQualifiedTables.get(0);
        }
        return tableExprFound;
    }

    public static ValueExpressionColumn getColumnExpressionForColumn(TableExpression tableExpr, Column column) {
        ValueExpressionColumn foundCol = null;
        if (column != null && tableExpr != null) {
            String colName = column.getName();
            foundCol = TableHelper.getColumnExpressionForName(tableExpr, colName);
        }
        return foundCol;
    }

    public static ValueExpressionColumn getColumnExpressionForName(TableExpression tableExpr, String columnName) {
        ValueExpressionColumn colExprFound;
        block5: {
            block6: {
                EList corrColNameList;
                colExprFound = null;
                if (tableExpr == null || columnName == null) break block5;
                boolean hasCorrColList = false;
                TableCorrelation tableCorr = tableExpr.getTableCorrelation();
                if (tableCorr != null && (corrColNameList = tableCorr.getColumnNameList()) != null && corrColNameList.size() > 0) {
                    hasCorrColList = true;
                }
                if (!hasCorrColList) break block6;
                corrColNameList = tableCorr.getColumnNameList();
                EList tableColList = tableExpr.getColumnList();
                if (corrColNameList.size() > tableColList.size()) break block5;
                int i = 0;
                while (colExprFound == null && i < corrColNameList.size()) {
                    Object obj1 = corrColNameList.get(i);
                    Object obj2 = tableColList.get(i);
                    if (obj1 instanceof ColumnName && obj2 instanceof ValueExpressionColumn) {
                        ColumnName corrColName = (ColumnName)obj1;
                        String corrColNameName = corrColName.getName();
                        ValueExpressionColumn tableColExpr = (ValueExpressionColumn)obj2;
                        if (StatementHelper.equalSQLIdentifiers(columnName, corrColNameName)) {
                            colExprFound = tableColExpr;
                        }
                    }
                    ++i;
                }
                break block5;
            }
            EList tableColList = tableExpr.getColumnList();
            Iterator tableColListIter = tableColList.iterator();
            while (tableColListIter.hasNext() && colExprFound == null) {
                ValueExpressionColumn tableColExpr = (ValueExpressionColumn)tableColListIter.next();
                String tableColName = tableColExpr.getName();
                if (!StatementHelper.equalSQLIdentifiers(columnName, tableColName)) continue;
                colExprFound = tableColExpr;
            }
        }
        return colExprFound;
    }

    public static ValueExpressionColumn getColumnExpressionForName(TableReference tableRef, String columnName) {
        ValueExpressionColumn colExpr = null;
        if (tableRef != null && columnName != null) {
            if (tableRef instanceof TableExpression) {
                TableExpression tableExpr = (TableExpression)tableRef;
                colExpr = TableHelper.getColumnExpressionForName(tableExpr, columnName);
            }
            if (tableRef instanceof TableNested) {
                TableNested nest = (TableNested)tableRef;
                TableReference nestedTableRef = nest.getNestedTableRef();
                colExpr = TableHelper.getColumnExpressionForName(nestedTableRef, columnName);
            }
            if (tableRef instanceof TableJoined) {
                ValueExpressionColumn rightColumn;
                TableJoined tableJoined = (TableJoined)tableRef;
                TableReference leftTableRef = tableJoined.getTableRefLeft();
                TableReference rightTableRef = tableJoined.getTableRefRight();
                ValueExpressionColumn leftColumn = TableHelper.getColumnExpressionForName(leftTableRef, columnName);
                colExpr = leftColumn != null ? leftColumn : (rightColumn = TableHelper.getColumnExpressionForName(rightTableRef, columnName));
            }
        }
        return colExpr;
    }

    public static ValueExpressionColumn getColumnExpressionForNameRecursively(TableExpression tableExpr, String columnName) {
        ValueExpressionColumn colExprFound = null;
        if (tableExpr != null && columnName != null) {
            colExprFound = TableHelper.getColumnExpressionForName(tableExpr, columnName);
        }
        if (colExprFound == null) {
            if (tableExpr instanceof QueryExpressionBody) {
                QueryExpressionBody tableQuery = (QueryExpressionBody)tableExpr;
                ResultColumn resultColFound = TableHelper.getResultColumnForAliasOrColumnName(tableQuery, columnName);
                if (resultColFound != null) {
                    ValueExpressionColumn resultColExpr = SQLQueryModelFactory.eINSTANCE.createValueExpressionColumn();
                    resultColExpr.setName(columnName);
                    tableQuery.getColumnList().add((Object)resultColExpr);
                    colExprFound = resultColExpr;
                }
            } else if (tableExpr instanceof TableInDatabase) {
                TableInDatabase tableInDB = (TableInDatabase)tableExpr;
                Column dbColumn = TableHelper.getColumnForName(tableInDB, columnName);
                if (dbColumn != null) {
                    colExprFound = TableHelper.getColumnExpressionForColumn(tableInDB, dbColumn);
                }
            } else if (tableExpr instanceof WithTableReference) {
                WithTableReference withTable = (WithTableReference)tableExpr;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.datatools.modelbase.sql.query.helper.TableHelper");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StatementHelper.logError(String.valueOf(clazz.getName()) + "#getColumnExpressionForName(TableExpression,String) not implemented for TableExpression of type " + withTable.getClass().getName());
            } else {
                if (tableExpr instanceof TableFunction) {
                    TableFunction tableFunc = (TableFunction)tableExpr;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.datatools.modelbase.sql.query.helper.TableHelper");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    throw new UnsupportedOperationException(String.valueOf(clazz.getName()) + "#getColumnExpressionForName(TableExpression,String) not implemented for TableExpression of type " + tableFunc.getClass().getName());
                }
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.datatools.modelbase.sql.query.helper.TableHelper");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new UnsupportedOperationException(String.valueOf(clazz.getName()) + "#getColumnExpressionForName(TableExpression,String) not implemented for TableExpression of type " + tableExpr.getClass().getName());
            }
        }
        return colExprFound;
    }

    public static Column getColumnForColumnExpression(TableExpression tableExpr, ValueExpressionColumn colExpr) {
        Column foundColumn = null;
        if (colExpr != null) {
            String columnName = colExpr.getName();
            if (tableExpr instanceof TableInDatabase) {
                TableInDatabase tableInDB = (TableInDatabase)tableExpr;
                foundColumn = TableHelper.getColumnForName(tableInDB, columnName);
            }
        }
        return foundColumn;
    }

    public static Column getColumnForName(TableInDatabase tableInDB, String columnName) {
        Table dbTable;
        Column columnFound = null;
        if (tableInDB != null && columnName != null && (dbTable = tableInDB.getDatabaseTable()) != null) {
            EList dbColList = dbTable.getColumns();
            Iterator dbColListIter = dbColList.iterator();
            while (dbColListIter.hasNext() && columnFound == null) {
                Column dbCol = (Column)dbColListIter.next();
                String dbColName = dbCol.getName();
                if (!StatementHelper.equalSQLIdentifiers(columnName, dbColName)) continue;
                columnFound = dbCol;
            }
        }
        return columnFound;
    }

    public static Column getColumnForName(TableReference tableRef, String columnName) {
        Column foundColumn = null;
        if (tableRef != null) {
            if (tableRef instanceof TableInDatabase) {
                TableInDatabase tableInDB = (TableInDatabase)tableRef;
                foundColumn = TableHelper.getColumnForName(tableInDB, columnName);
            }
            if (tableRef instanceof TableNested) {
                TableNested nest = (TableNested)tableRef;
                TableReference nestedTable = nest.getNestedTableRef();
                foundColumn = TableHelper.getColumnForName(nestedTable, columnName);
            }
            if (tableRef instanceof TableJoined) {
                TableJoined tableJoined = (TableJoined)tableRef;
                TableReference leftTableRef = tableJoined.getTableRefLeft();
                TableReference rightTableRef = tableJoined.getTableRefRight();
                Column leftColumn = TableHelper.getColumnForName(leftTableRef, columnName);
                Column rightColumn = TableHelper.getColumnForName(rightTableRef, columnName);
                foundColumn = leftColumn != null ? leftColumn : rightColumn;
            }
        }
        return foundColumn;
    }

    public static Column getColumnForName(WithTableReference withTableRef, String columnName) {
        WithTableSpecification withTableSpec;
        Column columnFound = null;
        if (withTableRef != null && columnName != null && (withTableSpec = withTableRef.getWithTableSpecification()) != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.datatools.modelbase.sql.query.helper.TableHelper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StatementHelper.logError(String.valueOf(clazz.getName()) + "#getColumnForName(WithTableReference,String) is not implemented.");
        }
        return columnFound;
    }

    public static List getEffectiveResultColumns(TableReference tableRef) {
        List resultColExprList = new ArrayList();
        if (tableRef == null) {
            return null;
        }
        if (tableRef instanceof TableExpression) {
            TableExpression tableExpr = (TableExpression)tableRef;
            if (tableExpr.getColumnList() == null || tableExpr.getColumnList().isEmpty()) {
                TableHelper.exposeEffectiveResultColumns(tableExpr);
            }
            resultColExprList.addAll(tableExpr.getColumnList());
        } else if (tableRef instanceof TableJoined) {
            TableJoined tableJoin = (TableJoined)tableRef;
            List leftCols = TableHelper.getEffectiveResultColumns(tableJoin.getTableRefLeft());
            List rightCols = TableHelper.getEffectiveResultColumns(tableJoin.getTableRefRight());
            resultColExprList.addAll(leftCols);
            resultColExprList.addAll(rightCols);
        } else if (tableRef instanceof TableNested) {
            TableNested tableNest = (TableNested)tableRef;
            resultColExprList = TableHelper.getEffectiveResultColumns(tableNest.getNestedTableRef());
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.datatools.modelbase.sql.query.helper.TableHelper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StatementHelper.logError(String.valueOf(clazz.getName()) + ": implement getEffectiveResultColumns(TableReference)" + " for " + tableRef.getClass().getName());
        }
        return resultColExprList;
    }

    public static String getExposedTableName(TableExpression tableExpr) {
        String tablename = null;
        if (tableExpr != null) {
            tablename = tableExpr.getTableCorrelation() != null ? tableExpr.getTableCorrelation().getName() : tableExpr.getName();
        }
        return tablename;
    }

    public static List getForeignKeyColumns(Table table) {
        ArrayList fkCols = new ArrayList();
        if (table instanceof BaseTable) {
            EList list = ((BaseTable)table).getConstraints();
            Iterator conItr = list.iterator();
            while (conItr.hasNext()) {
                Constraint con = (Constraint)conItr.next();
                if (!(con instanceof ForeignKey)) continue;
                fkCols.addAll(((ForeignKey)con).getMembers());
            }
        }
        return fkCols;
    }

    public static String getFullTableName(Table table) {
        String tablename = table.getName();
        if (table.getSchema() != null) {
            tablename = String.valueOf(table.getSchema().getName()) + "." + tablename;
        }
        return tablename;
    }

    public static ValueExpressionColumn getOrCreateColumnExpression(String columnName, TableExpression tableExpr) {
        ValueExpressionColumn newCol = null;
        if (columnName != null && tableExpr != null && tableExpr.getColumnList() != null) {
            newCol = TableHelper.getColumnExpressionForName(tableExpr, columnName);
        }
        if (newCol == null) {
            newCol = StatementHelper.createColumnExpression(columnName);
        }
        return newCol;
    }

    public static List getPrimaryKeyColumns(Table table) {
        ArrayList primarykeyCols = new ArrayList();
        if (table instanceof BaseTable) {
            EList list = ((BaseTable)table).getConstraints();
            Iterator conItr = list.iterator();
            while (conItr.hasNext()) {
                Constraint con = (Constraint)conItr.next();
                if (!(con instanceof PrimaryKey)) continue;
                primarykeyCols.addAll(((PrimaryKey)con).getMembers());
            }
        }
        return primarykeyCols;
    }

    public static ResultColumn getResultColumnForAliasOrColumnName(QueryExpressionBody tableQuery, String columnName) {
        ResultColumn resultColFound = null;
        if (tableQuery != null && columnName != null) {
            List resultColList = TableHelper.getResultColumnsOfQueryExpression(tableQuery);
            Iterator resultColListIter = resultColList.iterator();
            while (resultColListIter.hasNext() && resultColFound == null) {
                ValueExpressionColumn valExprCol;
                String valExprColName;
                ResultColumn resultCol = (ResultColumn)resultColListIter.next();
                String resultColName = resultCol.getName();
                QueryValueExpression resultColValExpr = resultCol.getValueExpr();
                if (StatementHelper.equalSQLIdentifiers(columnName, resultColName)) {
                    resultColFound = resultCol;
                    continue;
                }
                if (!(resultColValExpr instanceof ValueExpressionColumn) || !StatementHelper.equalSQLIdentifiers(columnName, valExprColName = (valExprCol = (ValueExpressionColumn)resultColValExpr).getName())) continue;
                resultColFound = resultCol;
            }
        }
        return resultColFound;
    }

    public static ResultColumn getResultColumnForName(QueryExpressionBody tableQuery, String columnName) {
        ResultColumn resultColFound = null;
        if (tableQuery != null && columnName != null) {
            List resultColList = TableHelper.getResultColumnsOfQueryExpression(tableQuery);
            Iterator resultColListIter = resultColList.iterator();
            while (resultColListIter.hasNext() && resultColFound == null) {
                ResultColumn resultCol = (ResultColumn)resultColListIter.next();
                String resultColName = resultCol.getName();
                if (!StatementHelper.equalSQLIdentifiers(columnName, resultColName)) continue;
                resultColFound = resultCol;
            }
        }
        return resultColFound;
    }

    public static List getResultColumnsOfQueryExpression(QueryExpressionBody queryExpr) {
        ArrayList<ResultColumn> resultColList = new ArrayList<ResultColumn>();
        if (queryExpr != null) {
            if (queryExpr instanceof QuerySelect) {
                QuerySelect select = (QuerySelect)queryExpr;
                EList resultClause = select.getSelectClause();
                Iterator resultClauseIter = resultClause.iterator();
                while (resultClauseIter.hasNext()) {
                    QueryResultSpecification resultSpec = (QueryResultSpecification)resultClauseIter.next();
                    if (!(resultSpec instanceof ResultColumn)) continue;
                    ResultColumn resultCol = (ResultColumn)resultSpec;
                    resultColList.add(resultCol);
                }
            } else if (queryExpr instanceof QueryCombined) {
                QueryCombined combinedQ = (QueryCombined)queryExpr;
                resultColList.addAll(TableHelper.getResultColumnsOfQueryExpression(combinedQ.getLeftQuery()));
                resultColList.addAll(TableHelper.getResultColumnsOfQueryExpression(combinedQ.getRightQuery()));
            } else if (queryExpr instanceof QueryNested) {
                QueryNested nest = (QueryNested)queryExpr;
                QueryExpressionBody nestedQuery = nest.getNestedQuery();
                resultColList.addAll(TableHelper.getResultColumnsOfQueryExpression(nestedQuery));
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.datatools.modelbase.sql.query.helper.TableHelper");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new UnsupportedOperationException(String.valueOf(clazz.getName()) + "#getColumnExpressionForName(QueryExpressionBody,String) not implemented for TableExpression of type " + queryExpr.getClass().getName());
            }
        }
        return resultColList;
    }

    public static Schema getSchemaForTableInDatabase(TableInDatabase tableInDB) {
        Schema colTblRefSchema = null;
        if (tableInDB.getDatabaseTable() != null && tableInDB.getDatabaseTable().getSchema() != null) {
            colTblRefSchema = tableInDB.getDatabaseTable().getSchema();
        }
        return colTblRefSchema;
    }

    public static String getSchemaNameForTableExpression(TableExpression tableExpr) {
        Schema schema;
        TableInDatabase tableInDB;
        Table table;
        String schemaName = null;
        if (tableExpr instanceof TableInDatabase && (table = (tableInDB = (TableInDatabase)tableExpr).getDatabaseTable()) != null && (schema = table.getSchema()) != null) {
            schemaName = schema.getName();
        }
        return schemaName;
    }

    public static TableExpression getTableExpressionForNamedColumn(String aTableName, String aColName, List aTableExprList) {
        TableExpression tableExpr = null;
        Column rdbColumn = null;
        boolean foundIt = false;
        Iterator tableExprListIter = aTableExprList.iterator();
        while (tableExprListIter.hasNext() && !foundIt) {
            TableInDatabase dbTable;
            tableExpr = (TableExpression)tableExprListIter.next();
            if (aTableName != null && aTableName.length() > 0) {
                String tableExprName = tableExpr.getName();
                String tableExprCorrName = null;
                if (tableExpr.getTableCorrelation() != null) {
                    tableExprCorrName = tableExpr.getTableCorrelation().getName();
                }
                if (!StatementHelper.equalSQLIdentifiers(aTableName, tableExprName) && !StatementHelper.equalSQLIdentifiers(aTableName, tableExprCorrName)) continue;
                foundIt = true;
                continue;
            }
            if (!(tableExpr instanceof TableInDatabase) || (rdbColumn = TableHelper.getColumnForName(dbTable = (TableInDatabase)tableExpr, aColName)) == null) continue;
            foundIt = true;
        }
        if (!foundIt) {
            tableExpr = null;
        }
        return tableExpr;
    }

    public static TableExpression getTableExpressionFromTableExprList(String aTableName, List aTableExprList) {
        TableExpression retTableExpr = null;
        boolean foundIt = false;
        Iterator tableExprListIter = aTableExprList.iterator();
        while (tableExprListIter.hasNext() && !foundIt) {
            TableExpression tableExpr = null;
            tableExpr = (TableExpression)tableExprListIter.next();
            if (aTableName == null || aTableName.length() <= 0) continue;
            String tableExprName = tableExpr.getName();
            String tableExprCorrName = null;
            if (tableExpr.getTableCorrelation() != null) {
                tableExprCorrName = tableExpr.getTableCorrelation().getName();
            }
            if (!StatementHelper.equalSQLIdentifiers(aTableName, tableExprName) && !StatementHelper.equalSQLIdentifiers(aTableName, tableExprCorrName)) continue;
            retTableExpr = tableExpr;
            foundIt = true;
        }
        return retTableExpr;
    }

    public static List getTableExpressionsInTableReference(TableReference tableRef) {
        ArrayList<TableExpression> tableExprList = new ArrayList<TableExpression>();
        if (tableRef instanceof TableExpression) {
            TableExpression tableExpr = (TableExpression)tableRef;
            tableExprList.add(tableExpr);
        }
        if (tableRef instanceof TableNested) {
            TableNested nest = (TableNested)tableRef;
            tableExprList.addAll(TableHelper.getTableExpressionsInTableReference(nest.getNestedTableRef()));
        }
        if (tableRef instanceof TableJoined) {
            TableJoined join = (TableJoined)tableRef;
            tableExprList.addAll(TableHelper.getTableExpressionsInTableReference(join.getTableRefLeft()));
            tableExprList.addAll(TableHelper.getTableExpressionsInTableReference(join.getTableRefRight()));
        }
        return tableExprList;
    }

    public static List getTableExpressionsInTableReferenceList(List tableReferenceList) {
        ArrayList tableExprList = new ArrayList();
        Iterator tableRefIt = tableReferenceList.iterator();
        while (tableRefIt.hasNext()) {
            TableReference tableRef = (TableReference)tableRefIt.next();
            tableExprList.addAll(TableHelper.getTableExpressionsInTableReference(tableRef));
        }
        return tableExprList;
    }

    public static Table getTableForTableExpression(TableExpression tableExpr) {
        Table table = null;
        if (tableExpr != null && tableExpr instanceof TableInDatabase) {
            TableInDatabase tableInDB = (TableInDatabase)tableExpr;
            table = tableInDB.getDatabaseTable();
        }
        return table;
    }

    public static List getTableInDatabaseInTableReferenceList(List tableReferenceList) {
        ArrayList tableExprList = new ArrayList();
        Iterator tableRefIt = tableReferenceList.iterator();
        while (tableRefIt.hasNext()) {
            TableReference tableRef = (TableReference)tableRefIt.next();
            tableExprList.addAll(TableHelper.getTableExpressionsInTableReference(tableRef));
        }
        Iterator tableExprIt = tableExprList.iterator();
        while (tableExprIt.hasNext()) {
            if (tableExprIt.next() instanceof TableInDatabase) continue;
            tableExprIt.remove();
        }
        return tableExprList;
    }

    public static boolean isForeignKey(Column column) {
        boolean retValue = false;
        Table table = column.getTable();
        List fkCols = TableHelper.getForeignKeyColumns(table);
        Iterator fkcolItr = fkCols.iterator();
        while (fkcolItr.hasNext() && !retValue) {
            if (column != (Column)fkcolItr.next()) continue;
            retValue = true;
        }
        return retValue;
    }

    public static boolean isForeignKey(ValueExpressionColumn colExpr) {
        Column column;
        boolean retValue = false;
        if (colExpr != null && colExpr.getTableExpr() instanceof TableInDatabase && (column = TableHelper.getColumnForColumnExpression(colExpr.getTableExpr(), colExpr)) != null) {
            retValue = TableHelper.isForeignKey(column);
        }
        return retValue;
    }

    public static boolean isPrimaryKey(Column column) {
        boolean retValue = false;
        Table table = column.getTable();
        List primarykeyCols = TableHelper.getPrimaryKeyColumns(table);
        Iterator pkcolItr = primarykeyCols.iterator();
        while (pkcolItr.hasNext() && !retValue) {
            if (column != (Column)pkcolItr.next()) continue;
            retValue = true;
        }
        return retValue;
    }

    public static boolean isPrimaryKey(ValueExpressionColumn colExpr) {
        Column column;
        boolean retValue = false;
        if (colExpr != null && colExpr.getTableExpr() instanceof TableInDatabase && (column = TableHelper.getColumnForColumnExpression(colExpr.getTableExpr(), colExpr)) != null) {
            retValue = TableHelper.isPrimaryKey(column);
        }
        return retValue;
    }

    public static boolean isTableReferencedByColumnWithName(TableExpression tableExpr, String referencedByColumnName) {
        boolean colExprFound = false;
        if (tableExpr != null && referencedByColumnName != null) {
            EList tableColList = tableExpr.getValueExprColumns();
            Iterator tableColListIter = tableColList.iterator();
            while (tableColListIter.hasNext() && !colExprFound) {
                ValueExpressionColumn tableCol = (ValueExpressionColumn)tableColListIter.next();
                String tableColName = tableCol.getName();
                if (!StatementHelper.equalSQLIdentifiers(referencedByColumnName, tableColName)) continue;
                colExprFound = true;
            }
        }
        return colExprFound;
    }

    public static void populateTableExpressionColumns(TableInDatabase tableInDB, Table databaseTable) {
        if (databaseTable == null || tableInDB == null) {
            return;
        }
        EList rdbColumnList = databaseTable.getColumns();
        Iterator colItr = rdbColumnList.iterator();
        EList columnList = tableInDB.getColumnList();
        columnList.clear();
        SQLQueryModelFactory factory = SQLQueryModelFactory.eINSTANCE;
        while (colItr.hasNext()) {
            Column col = (Column)colItr.next();
            ValueExpressionColumn valueExprColumn = null;
            valueExprColumn = factory.createValueExpressionColumn();
            valueExprColumn.setName(col.getName());
            DataType type = ValueExpressionHelper.copyDataType(col.getDataType());
            valueExprColumn.setDataType(type);
            valueExprColumn.setTableInDatabase(tableInDB);
            columnList.add(valueExprColumn);
        }
    }

    public static void removeColumnExpressionFromTableIfNotReferenced(ValueExpressionColumn col) {
        boolean isReferenced = false;
        if (col != null && col.getTableExpr() != null) {
            Iterator refIt = col.eClass().getEAllReferences().iterator();
            while (refIt.hasNext()) {
                EReference ref = (EReference)refIt.next();
                if (ref.isMany()) {
                    EList refList = (EList)col.eGet((EStructuralFeature)ref);
                    if (refList.size() <= 0) continue;
                    isReferenced = true;
                    continue;
                }
                EObject reference = (EObject)col.eGet((EStructuralFeature)ref);
                if (reference == null || reference == col.getTableExpr() || reference == col.getTableInDatabase()) continue;
                isReferenced = true;
            }
            if (!isReferenced) {
                col.setTableExpr(null);
            }
        }
    }

    public static void resolveColumnTableReferences(Collection unresolvedColumns, List aTableRefList) {
        if (unresolvedColumns == null) {
            return;
        }
        List tableExprList = TableHelper.getTableExpressionsInTableReferenceList(aTableRefList);
        ValueExpressionColumn col = null;
        String colName = null;
        TableExpression colTblRef = null;
        TableCorrelation colTblRefCorr = null;
        String colTblRefSchemaName = null;
        String colQualifier = null;
        TableExpression refTableFound = null;
        Iterator colIt = unresolvedColumns.iterator();
        while (colIt.hasNext()) {
            col = (ValueExpressionColumn)colIt.next();
            colName = col.getName();
            colTblRef = col.getTableExpr();
            if (colTblRef == null) {
                refTableFound = tableExprList.size() == 1 ? (TableExpression)tableExprList.get(0) : TableHelper.findTableExpressionForColumnName(tableExprList, colName, true);
            } else if (StatementHelper.getQuerySelectForTableReference(colTblRef) != null) {
                refTableFound = colTblRef;
            } else {
                colQualifier = colTblRef.getName();
                colTblRefCorr = colTblRef.getTableCorrelation();
                if (colTblRefCorr != null) {
                    colQualifier = colTblRefCorr.getName();
                }
                refTableFound = (colTblRefSchemaName = TableHelper.getSchemaName(colTblRef)) != null ? TableHelper.findTableExpressionInTableExpressionList(colTblRefSchemaName, colTblRef.getName(), tableExprList, TableHelper.getDefaultSchemaName(col)) : TableHelper.findTableExpressionsByNameOrAlias(colQualifier, tableExprList, TableHelper.getDefaultSchemaName(col));
            }
            if (refTableFound == null) continue;
            ValueExpressionColumn corrExposedTableCol = TableHelper.getColumnExpressionForName(refTableFound, colName);
            if (corrExposedTableCol != null) {
                DataType dataType = corrExposedTableCol.getDataType();
                DataType colDataType = ValueExpressionHelper.copyDataType(dataType);
                if (colDataType != null) {
                    col.setDataType(colDataType);
                }
                if (corrExposedTableCol.getTableInDatabase() != null) {
                    col.setTableInDatabase(corrExposedTableCol.getTableInDatabase());
                }
            }
            col.setTableExpr(refTableFound);
            colIt.remove();
        }
    }

    public static void resolveResultTableReferences(List resultTableList, List tableExprList) {
        if (resultTableList == null || resultTableList.isEmpty()) {
            return;
        }
        Iterator resultTableIt = resultTableList.iterator();
        while (resultTableIt.hasNext()) {
            String resultTableName;
            TableExpression tableExpr;
            ResultTableAllColumns resultTable = (ResultTableAllColumns)resultTableIt.next();
            if (resultTable == null || resultTable.getName() == null || (tableExpr = TableHelper.getTableExpressionFromTableExprList(resultTableName = resultTable.getName(), tableExprList)) == null) continue;
            resultTable.setTableExpr(tableExpr);
        }
    }

    public static void setTableAliasInTableExpression(TableExpression tableExpr, String alias) {
        if (alias.trim().length() > 0) {
            TableCorrelation tableCorr = SQLQueryModelFactory.eINSTANCE.createTableCorrelation();
            tableCorr.setName(alias.trim().toUpperCase());
            tableExpr.setTableCorrelation(tableCorr);
        }
    }

    private static List copyColumnExprList(List origColExprList) {
        ArrayList<ValueExpressionColumn> result;
        if (origColExprList == null) {
            result = new ArrayList<ValueExpressionColumn>();
        } else {
            result = new ArrayList(origColExprList.size());
            Iterator it = origColExprList.iterator();
            while (it.hasNext()) {
                ValueExpressionColumn original = (ValueExpressionColumn)it.next();
                ValueExpressionColumn copy = (ValueExpressionColumn)EcoreUtil.copy((EObject)original);
                copy.setTableInDatabase(original.getTableInDatabase());
                result.add(copy);
            }
        }
        return result;
    }

    private static List exposeResultColumnsOfQueryCombined(QueryCombined queryCombined) {
        ArrayList<ValueExpressionColumn> exposedColumns = new ArrayList<ValueExpressionColumn>();
        if (queryCombined == null) {
            return exposedColumns;
        }
        List exposedColListLeft = TableHelper.getEffectiveResultColumns(queryCombined.getLeftQuery());
        List exposedColListRight = TableHelper.getEffectiveResultColumns(queryCombined.getRightQuery());
        if (exposedColListLeft != null && exposedColListRight != null && exposedColListLeft.size() == exposedColListRight.size()) {
            int i = 0;
            while (i < exposedColListLeft.size()) {
                ValueExpressionColumn resultColExprLeft = (ValueExpressionColumn)exposedColListLeft.get(i);
                ValueExpressionColumn resultColExprRight = (ValueExpressionColumn)exposedColListRight.get(i);
                String leftName = resultColExprLeft.getName();
                String rightName = resultColExprRight.getName();
                String exposedColumnName = null;
                exposedColumnName = queryCombined.getLeftQuery() instanceof QueryValues && !(queryCombined.getRightQuery() instanceof QueryValues) ? rightName : leftName;
                ValueExpressionColumn exposedColumn = TableHelper.getOrCreateColumnExpression(exposedColumnName, queryCombined);
                ValueExpressionHelper.resolveCombinedDataType(resultColExprLeft.getDataType(), resultColExprRight.getDataType());
                if (resultColExprLeft.getTableInDatabase() == resultColExprRight.getTableInDatabase()) {
                    exposedColumn.setTableInDatabase(resultColExprLeft.getTableInDatabase());
                }
                exposedColumns.add(exposedColumn);
                ++i;
            }
        }
        queryCombined.getColumnList().clear();
        queryCombined.getColumnList().addAll(exposedColumns);
        return exposedColumns;
    }

    private static List exposeResultColumnsOfQuerySelect(QuerySelect querySelect) {
        ArrayList<ValueExpressionColumn> exposedColumns = new ArrayList<ValueExpressionColumn>();
        if (querySelect == null) {
            return exposedColumns;
        }
        EList resultSpecList = querySelect.getSelectClause();
        if (resultSpecList == null || resultSpecList.isEmpty()) {
            Iterator it = querySelect.getFromClause().iterator();
            while (it.hasNext()) {
                TableReference tableRef = (TableReference)it.next();
                List tableRefCols = TableHelper.getEffectiveResultColumns(tableRef);
                exposedColumns.addAll(TableHelper.copyColumnExprList(tableRefCols));
            }
        } else {
            Iterator resultIt = resultSpecList.iterator();
            while (resultIt.hasNext()) {
                ValueExpressionColumn colExprsTableExposedColumn;
                ValueExpressionColumn colExpr;
                QueryResultSpecification resultSpec = (QueryResultSpecification)resultIt.next();
                if (resultSpec instanceof ResultTableAllColumns) {
                    ResultTableAllColumns tableAll = (ResultTableAllColumns)resultSpec;
                    TableExpression tableExpr = tableAll.getTableExpr();
                    if (tableExpr.getColumnList().isEmpty()) {
                        String tableNameOrAlias = tableAll.getName();
                        List tableExprList = TableHelper.getTableExpressionsInTableReferenceList((List)querySelect.getFromClause());
                        tableExpr = TableHelper.getTableExpressionFromTableExprList(tableNameOrAlias, tableExprList);
                    }
                    List tableExprCols = TableHelper.getEffectiveResultColumns(tableExpr);
                    exposedColumns.addAll(TableHelper.copyColumnExprList(tableExprCols));
                    continue;
                }
                if (!(resultSpec instanceof ResultColumn)) continue;
                ResultColumn resultCol = (ResultColumn)resultSpec;
                QueryValueExpression resultColExpr = resultCol.getValueExpr();
                String exposedColumnName = null;
                TableInDatabase derivedFromTableInDB = null;
                if (resultCol.getName() != null) {
                    exposedColumnName = resultCol.getName();
                } else if (resultColExpr != null && resultColExpr instanceof ValueExpressionColumn) {
                    colExpr = (ValueExpressionColumn)resultColExpr;
                    exposedColumnName = colExpr.getName();
                }
                if (resultColExpr != null && resultColExpr instanceof ValueExpressionColumn && (colExpr = (ValueExpressionColumn)resultColExpr).getDataType() == null) {
                    HashSet<ValueExpressionColumn> unresolvedColumns = new HashSet<ValueExpressionColumn>();
                    unresolvedColumns.add(colExpr);
                    EList tableRefList = querySelect.getFromClause();
                    TableHelper.resolveColumnTableReferences(unresolvedColumns, (List)tableRefList);
                }
                if (resultColExpr != null && resultColExpr instanceof ValueExpressionColumn && (colExprsTableExposedColumn = TableHelper.getColumnExpressionForName((colExpr = (ValueExpressionColumn)resultColExpr).getTableExpr(), colExpr.getName())) != null && colExprsTableExposedColumn.getTableInDatabase() != null) {
                    derivedFromTableInDB = colExprsTableExposedColumn.getTableInDatabase();
                }
                ValueExpressionColumn exposedColumn = TableHelper.getOrCreateColumnExpression(exposedColumnName, querySelect);
                if (resultColExpr != null) {
                    DataType resultColDataType = resultColExpr.getDataType();
                    if (resultColDataType == null) {
                        ValueExpressionHelper.resolveValueExpressionDatatypeRecursively(resultColExpr);
                        resultColDataType = resultColExpr.getDataType();
                    }
                    DataType exposedColumnDataType = ValueExpressionHelper.copyDataType(resultColDataType);
                    exposedColumn.setDataType(exposedColumnDataType);
                }
                exposedColumn.setTableInDatabase(derivedFromTableInDB);
                exposedColumns.add(exposedColumn);
            }
        }
        querySelect.getColumnList().clear();
        querySelect.getColumnList().addAll(exposedColumns);
        return exposedColumns;
    }

    private static List exposeResultColumnsOfQueryValues(QueryValues queryValues) {
        ArrayList<ValueExpressionColumn> exposedColumns = new ArrayList<ValueExpressionColumn>();
        if (queryValues == null || queryValues.getValuesRowList().isEmpty()) {
            return exposedColumns;
        }
        ValuesRow firstRow = (ValuesRow)queryValues.getValuesRowList().get(0);
        EList firstRowValues = firstRow.getExprList();
        int i = 0;
        while (i < firstRowValues.size()) {
            QueryValueExpression valueExpr = (QueryValueExpression)firstRowValues.get(i);
            ValueExpressionColumn exposedCol = StatementHelper.createColumnExpression(null);
            if (valueExpr.getDataType() == null) {
                ValueExpressionHelper.resolveValueExpressionDatatypeRecursively(valueExpr);
            }
            DataType exposedDataType = valueExpr.getDataType();
            exposedCol.setDataType(exposedDataType);
            exposedColumns.add(exposedCol);
            ++i;
        }
        queryValues.getColumnList().clear();
        queryValues.getColumnList().addAll(exposedColumns);
        return exposedColumns;
    }

    private static TableExpression findTableExpressionForColumnName(List tableExprList, String columnName) {
        return TableHelper.findTableExpressionForColumnName(tableExprList, columnName, false);
    }

    private static TableExpression findTableExpressionForColumnName(List tableExprList, String columnName, boolean checkDisconnected) {
        TableExpression tableFound = null;
        ArrayList<TableExpression> tablesReferencedByColumn = null;
        if (checkDisconnected) {
            tablesReferencedByColumn = new ArrayList<TableExpression>();
        }
        Iterator it = tableExprList.iterator();
        while (it.hasNext()) {
            String tableExprName;
            ValueExpressionColumn columnFound;
            TableExpression tableExpr = (TableExpression)it.next();
            if (checkDisconnected && TableHelper.isTableReferencedByColumnWithName(tableExpr, columnName)) {
                tablesReferencedByColumn.add(tableExpr);
            }
            if ((columnFound = TableHelper.getColumnExpressionForName(tableExpr, columnName)) == null) continue;
            if (tableFound == null) {
                tableFound = tableExpr;
                continue;
            }
            String tableFoundName = tableFound.getName();
            if (StatementHelper.equalSQLIdentifiers(tableFoundName, tableExprName = tableExpr.getName())) {
                tableFound = null;
                break;
            }
            String tableExprSchema = TableHelper.getSchemaName(tableExpr);
            String tableFoundSchema = TableHelper.getSchemaName(tableFound);
            String defaultSchema = TableHelper.getDefaultSchemaName(tableExpr);
            if (tableExprSchema == null) {
                tableExprSchema = defaultSchema;
            }
            if (tableFoundSchema == null) {
                tableFoundSchema = defaultSchema;
            }
            if (!StatementHelper.equalSQLIdentifiers(tableExprSchema, tableFoundSchema)) continue;
            tableFound = null;
            break;
        }
        if (tableFound == null && checkDisconnected && tablesReferencedByColumn != null && tablesReferencedByColumn.size() == 1) {
            tableFound = (TableExpression)tablesReferencedByColumn.get(0);
        }
        return tableFound;
    }

    private static TableExpression findTableExpressionInTableExpressionList(String schemaName, String tableName, List tableExprList, String defaultSchemaName) {
        TableExpression foundTableExpr = null;
        SQLQuerySourceFormat sourceFormat = null;
        if (tableName != null && tableExprList != null) {
            Iterator tableIt = tableExprList.iterator();
            while (tableIt.hasNext()) {
                String tableSchema;
                TableExpression tableExpr = (TableExpression)tableIt.next();
                String tableExprName = tableExpr.getName();
                if (tableExpr.getSourceInfo() != null && tableExpr.getSourceInfo().getSqlFormat() != null && (sourceFormat = tableExpr.getSourceInfo().getSqlFormat()).getOmitSchema() != null && sourceFormat.getOmitSchema().length() > 0) {
                    defaultSchemaName = sourceFormat.getOmitSchema();
                }
                if (!StatementHelper.equalSQLIdentifiers(tableName, tableExprName)) continue;
                if (schemaName != null) {
                    String tableExprSchemaName = TableHelper.getSchemaName(tableExpr);
                    if (tableExprSchemaName == null) {
                        tableExprSchemaName = defaultSchemaName;
                    }
                    if (!StatementHelper.equalSQLIdentifiers(schemaName, tableExprSchemaName) || tableExpr.getTableCorrelation() != null) continue;
                    foundTableExpr = tableExpr;
                    break;
                }
                if (tableExpr.getTableCorrelation() != null || (tableSchema = TableHelper.getSchemaName(tableExpr)) != null && !StatementHelper.equalSQLIdentifiers(tableSchema, defaultSchemaName)) continue;
                foundTableExpr = tableExpr;
                break;
            }
        }
        return foundTableExpr;
    }

    private static String getDefaultSchemaName(SQLQueryObject queryObject) {
        String defaultSchema = null;
        if (queryObject.getSourceInfo() != null && queryObject.getSourceInfo().getSqlFormat() != null) {
            defaultSchema = queryObject.getSourceInfo().getSqlFormat().getOmitSchema();
        }
        return defaultSchema;
    }

    private static String getSchemaName(TableExpression tableExpr) {
        Schema schema;
        TableInDatabase tableInDB;
        Table dbTable;
        String schemaName = null;
        if (tableExpr instanceof TableInDatabase && (dbTable = (tableInDB = (TableInDatabase)tableExpr).getDatabaseTable()) != null && (schema = dbTable.getSchema()) != null) {
            schemaName = schema.getName();
        }
        return schemaName;
    }
}

