/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.modelbase.sql.query.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.datatools.modelbase.sql.datatypes.ApproximateNumericDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.ArrayDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.BinaryStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DateDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.FixedPrecisionDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.IntegerDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.MultisetDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PrimitiveType;
import org.eclipse.datatools.modelbase.sql.datatypes.TimeDataType;
import org.eclipse.datatools.modelbase.sql.query.ColumnName;
import org.eclipse.datatools.modelbase.sql.query.GroupingExpression;
import org.eclipse.datatools.modelbase.sql.query.GroupingSets;
import org.eclipse.datatools.modelbase.sql.query.GroupingSetsElementExpression;
import org.eclipse.datatools.modelbase.sql.query.GroupingSetsElementSublist;
import org.eclipse.datatools.modelbase.sql.query.NullOrderingType;
import org.eclipse.datatools.modelbase.sql.query.OrderByOrdinal;
import org.eclipse.datatools.modelbase.sql.query.OrderByResultColumn;
import org.eclipse.datatools.modelbase.sql.query.OrderBySpecification;
import org.eclipse.datatools.modelbase.sql.query.OrderByValueExpression;
import org.eclipse.datatools.modelbase.sql.query.OrderingSpecType;
import org.eclipse.datatools.modelbase.sql.query.Predicate;
import org.eclipse.datatools.modelbase.sql.query.PredicateBasic;
import org.eclipse.datatools.modelbase.sql.query.PredicateBetween;
import org.eclipse.datatools.modelbase.sql.query.PredicateComparisonOperator;
import org.eclipse.datatools.modelbase.sql.query.PredicateExists;
import org.eclipse.datatools.modelbase.sql.query.PredicateInValueList;
import org.eclipse.datatools.modelbase.sql.query.PredicateInValueRowSelect;
import org.eclipse.datatools.modelbase.sql.query.PredicateInValueSelect;
import org.eclipse.datatools.modelbase.sql.query.PredicateIsNull;
import org.eclipse.datatools.modelbase.sql.query.PredicateLike;
import org.eclipse.datatools.modelbase.sql.query.PredicateQuantifiedRowSelect;
import org.eclipse.datatools.modelbase.sql.query.PredicateQuantifiedType;
import org.eclipse.datatools.modelbase.sql.query.PredicateQuantifiedValueSelect;
import org.eclipse.datatools.modelbase.sql.query.QueryCombined;
import org.eclipse.datatools.modelbase.sql.query.QueryCombinedOperator;
import org.eclipse.datatools.modelbase.sql.query.QueryDeleteStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionBody;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionRoot;
import org.eclipse.datatools.modelbase.sql.query.QueryInsertStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryNested;
import org.eclipse.datatools.modelbase.sql.query.QuerySearchCondition;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryUpdateStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.QueryValues;
import org.eclipse.datatools.modelbase.sql.query.ResultColumn;
import org.eclipse.datatools.modelbase.sql.query.ResultTableAllColumns;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionCombined;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionCombinedOperator;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionNested;
import org.eclipse.datatools.modelbase.sql.query.SuperGroup;
import org.eclipse.datatools.modelbase.sql.query.SuperGroupElementExpression;
import org.eclipse.datatools.modelbase.sql.query.SuperGroupElementSublist;
import org.eclipse.datatools.modelbase.sql.query.SuperGroupType;
import org.eclipse.datatools.modelbase.sql.query.TableCorrelation;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.TableFunction;
import org.eclipse.datatools.modelbase.sql.query.TableInDatabase;
import org.eclipse.datatools.modelbase.sql.query.TableJoined;
import org.eclipse.datatools.modelbase.sql.query.TableJoinedOperator;
import org.eclipse.datatools.modelbase.sql.query.TableNested;
import org.eclipse.datatools.modelbase.sql.query.TableReference;
import org.eclipse.datatools.modelbase.sql.query.UpdateAssignmentExpression;
import org.eclipse.datatools.modelbase.sql.query.UpdateSource;
import org.eclipse.datatools.modelbase.sql.query.UpdateSourceExprList;
import org.eclipse.datatools.modelbase.sql.query.UpdateSourceQuery;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionAtomic;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseElse;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSearch;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSearchContent;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSimple;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSimpleContent;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCast;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCombined;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCombinedOperator;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionDefaultValue;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionFunction;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionLabeledDuration;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionLabeledDurationType;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionNested;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionNullValue;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionRow;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionScalarSelect;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionSimple;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionUnaryOperator;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionVariable;
import org.eclipse.datatools.modelbase.sql.query.ValuesRow;
import org.eclipse.datatools.modelbase.sql.query.WithTableReference;
import org.eclipse.datatools.modelbase.sql.query.WithTableSpecification;
import org.eclipse.datatools.modelbase.sql.query.helper.DataTypeHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.modelbase.sql.query.util.SQLComment;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceFormat;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceInfo;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceWriterProvider;
import org.eclipse.datatools.modelbase.sql.query.util.SQLSourceWriter;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class SQLQuerySourceWriter
implements SQLSourceWriter {
    protected static final int STANDARD_INDENT = 2;
    protected int displayWidth = 80;
    protected boolean alwaysQualifyColumnNamesForMultipleTables = true;
    protected boolean alwaysQualifyColumnNamesForSubqueries = false;
    protected boolean qualifyColumnNamesInSubqueriesWhenQualifiedInSuperQuery = false;
    protected boolean alwaysQualifyColumnNamesReferencedInSubqueries = true;
    public static final String DEFAULT_STMT_SELECT = "SELECT *\n  FROM";
    protected static String COMMENT_PREFIX_SINGLE_LINE = "--";
    protected static String COMMENT_PREFIX_MULTI_LINE = "/*";
    protected static String COMMENT_SUFFIX_MULTI_LINE = "*/";
    private static final String FUNCTION_COUNT = "COUNT";
    protected static final String ORDERING_SPEC_TYPE_ASC = "ASC";
    protected static final String ORDERING_SPEC_TYPE_DESC = "DESC";
    protected static final String NULL_ORDERING_TYPE_NULLS_FIRST = "NULLS FIRST";
    protected static final String NULL_ORDERING_TYPE_NULLS_LAST = "NULLS LAST";
    protected static final char DOT = '.';
    protected static final char NEW_LINE = '\n';
    protected static final String NEW_LINE_STRING = String.valueOf('\n');
    protected static final char PAREN_LEFT = '(';
    protected static final char PAREN_RIGHT = ')';
    protected static final char BRACKET_LEFT = '[';
    protected static final char BRACKET_RIGHT = ']';
    protected static final char SPACE = ' ';
    protected static final char COMMA = ',';
    protected static final String EQUAL = "=";
    protected static final String NOT_EQUAL = "<>";
    protected static final String LESS_THAN = "<";
    protected static final String GREATER_THAN = ">";
    protected static final String LESS_THAN_OR_EQUAL = "<=";
    protected static final String GREATER_THAN_OR_EQUAL = ">=";
    protected static final String AND = "AND";
    protected static final String OR = "OR";
    protected static final String PLUS = "+";
    protected static final String MINUS = "-";
    protected static final String ADD = "+";
    protected static final String SUBTRACT = "-";
    protected static final String MULTIPLY = "*";
    protected static final String DIVIDE = "/";
    protected static final String CONCATENATE = "||";
    protected static final String UNION = "UNION";
    protected static final String UNION_ALL = "UNION ALL";
    protected static final String INTERSECT = "INTERSECT";
    protected static final String INTERSECT_ALL = "INTERSECT ALL";
    protected static final String EXCEPT = "EXCEPT";
    protected static final String EXCEPT_ALL = "EXCEPT ALL";
    protected static final String COLON = ":";
    protected static final String QUESTIONMARK = "?";
    protected static final String ARRAY = "ARRAY";
    protected static final String AS = "AS";
    protected static final String ALL = "ALL";
    protected static final String ANY = "ANY";
    protected static final String ASC = "ASC";
    protected static final String ASTERISK = "*";
    protected static final String BETWEEN = "BETWEEN";
    protected static final String CASE = "CASE";
    protected static final String CAST = "CAST";
    protected static final String CUBE = "CUBE";
    protected static final String DAYS = "DAYS";
    protected static final String DEFAULT = "DEFAULT";
    protected static final String DELETE = "DELETE";
    protected static final String DESC = "DESC";
    protected static final String DISTINCT = "DISTINCT";
    protected static final String ELSE = "ELSE";
    protected static final String END = "END";
    protected static final String ESCAPE = "ESCAPE";
    protected static final String EXISTS = "EXISTS";
    protected static final String FROM = "FROM";
    protected static final String FULL = "FULL";
    protected static final String GRANDTOTAL = "GRANDTOTAL";
    protected static final String GROUP_BY = "GROUP BY";
    protected static final String GROUPING_SETS = "GROUPING SETS";
    protected static final String HAVING = "HAVING";
    protected static final String HOURS = "HOURS";
    protected static final String IN = "IN";
    protected static final String INSERT = "INSERT";
    protected static final String INNER = "INNER";
    protected static final String INTO = "INTO";
    protected static final String IS = "IS";
    protected static final String JOIN = "JOIN";
    protected static final String LIKE = "LIKE";
    protected static final String LEFT = "LEFT";
    protected static final String MICROSECONDS = "MICROSECONDS";
    protected static final String MINUTES = "MINUTES";
    protected static final String MONTHS = "MONTHS";
    protected static final String MULTISET = "MULTISET";
    protected static final String NOT = "NOT";
    protected static final String NULL = "NULL";
    protected static final String ON = "ON";
    protected static final String ORDER_BY = "ORDER BY";
    protected static final String OUTER = "OUTER";
    protected static final String RIGHT = "RIGHT";
    protected static final String ROLLUP = "ROLLUP";
    protected static final String SECONDS = "SECONDS";
    protected static final String SELECT = "SELECT";
    protected static final String SELECTIVITY = "SELECTIVITY";
    protected static final String SET = "SET";
    protected static final String STAR = "*";
    protected static final String SOME = "SOME";
    protected static final String TABLE = "TABLE";
    protected static final String THEN = "THEN";
    protected static final String UPDATE = "UPDATE";
    protected static final String VALUES = "VALUES";
    protected static final String WITH = "WITH";
    protected static final String WHEN = "WHEN";
    protected static final String WHERE = "WHERE";
    protected static final String YEARS = "YEARS";
    private boolean preserveComments = true;
    protected static Object lastExternalyProcessed = null;
    private Map lastSLCommentIndentMap = null;
    private char delimitedIdentifierQuote = (char)34;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public String getSQL(SQLQueryObject queryObject) {
        String sql = null;
        if (queryObject != null) {
            SQLQuerySourceFormat sourceFormat;
            try {
                if (this.getSpecificAppendSQLMethod(queryObject) != null) {
                    SQLQuerySourceWriterProvider.getInstance().registerSourceWriter(this.getClass(), queryObject.getClass().getPackage().getName());
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            this.preserveComments = (sourceFormat = queryObject.getSourceInfo().getSqlFormat()).isPreserveComments() && (queryObject instanceof QueryStatement || !sourceFormat.isGenerateCommentsForStatementOnly());
            this.delimitedIdentifierQuote = sourceFormat.getDelimitedIdentifierQuote();
            StringBuffer sb = new StringBuffer();
            this.appendSQL(queryObject, sb);
            sql = sb.toString();
            sql = this.filterOutEmptyLines(sql);
            this.lastSLCommentIndentMap = null;
        }
        return sql;
    }

    protected String filterOutEmptyLines(String sql) {
        String previousSql = sql;
        sql = sql.replaceAll("\n(\\s*\\n)+", NEW_LINE_STRING);
        if (previousSql.length() > sql.length()) {
            StatementHelper.logError(String.valueOf(this.getClass().getName()) + NEW_LINE_STRING + "...find out why we generate an empty line here!" + NEW_LINE_STRING + previousSql.replaceAll("\n", "/n") + " was substituted with " + NEW_LINE_STRING + sql.replaceAll("\n", "/n") + "\n .../n = new line character\n");
        }
        if (sql.startsWith(NEW_LINE_STRING)) {
            sql = sql.substring(1);
        }
        return sql;
    }

    protected boolean appendExternalSQL(SQLQueryObject queryObject, StringBuffer sb) {
        boolean foundExternalSourceWriter = false;
        if (lastExternalyProcessed != queryObject) {
            lastExternalyProcessed = queryObject;
            String externalSQL = null;
            Class swClass = SQLQuerySourceWriterProvider.getInstance().getQuerySourceWriterClass(queryObject.getClass());
            SQLQuerySourceWriter sw = null;
            if (swClass != null) {
                try {
                    sw = (SQLQuerySourceWriter)swClass.newInstance();
                    externalSQL = sw.getSQL(queryObject);
                    if (externalSQL != null && externalSQL.length() > 0) {
                        SQLQuerySourceWriterProvider.getInstance().registerSourceWriter(swClass, queryObject.getClass().getPackage().getName());
                        StringBuffer externalSQLSB = new StringBuffer(externalSQL);
                        int lastLineIndent = this.getLastLineIndent(sb);
                        int externalSQLIndent = lastLineIndent + 2;
                        this.indentSQL(externalSQLSB, externalSQLIndent);
                        sb.append(externalSQLSB);
                        foundExternalSourceWriter = true;
                        lastExternalyProcessed = null;
                    }
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return foundExternalSourceWriter;
    }

    protected void appendSQL(SQLQueryObject queryObject, StringBuffer sb) {
        block10: {
            if (queryObject == null) {
                return;
            }
            try {
                Method getSQL = this.getSpecificAppendSQLMethod(queryObject);
                if (getSQL != null) {
                    Object[] invokationArgs = new Object[]{queryObject, sb};
                    getSQL.setAccessible(true);
                    if (this.preserveComments) {
                        this.appendCommentsPreceeding(queryObject, sb);
                    }
                    getSQL.invoke((Object)this, invokationArgs);
                    if (this.preserveComments) {
                        this.appendCommentsSucceeding(queryObject, sb);
                    }
                    break block10;
                }
                throw new NoSuchMethodException("appendSQL(\"" + queryObject.getClass().getName() + "\")" + " not found in " + this.getClass().getName());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                boolean isSqlGenerated = this.appendExternalSQL(queryObject, sb);
                if (!isSqlGenerated) {
                    String interfaceName = SQLQuerySourceWriter.getInterfaceName(queryObject.getClass());
                    StatementHelper.logError(String.valueOf('\n') + this.getClass().getName() + ": getSQL(" + interfaceName + ") not implemented for given argument type: " + queryObject.getClass().getName());
                }
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
            }
            catch (IllegalArgumentException iae) {
                iae.printStackTrace();
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace();
                ite.getTargetException().printStackTrace();
            }
        }
    }

    protected void appendSQL(SQLObject sqlObject, StringBuffer sb) {
        if (sqlObject == null) {
            return;
        }
        if (sqlObject instanceof SQLQueryObject) {
            this.appendSQL((SQLQueryObject)sqlObject, sb);
            return;
        }
        try {
            Method getSQL = this.getSpecificAppendSQLMethod(sqlObject);
            Object[] invokationArgs = new Object[]{sqlObject, sb};
            getSQL.setAccessible(true);
            getSQL.invoke((Object)this, invokationArgs);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
            ite.getTargetException().printStackTrace();
        }
    }

    static String getInterfaceName(Class sqlObjectClass) {
        if (sqlObjectClass == null) {
            return null;
        }
        StringBuffer className = null;
        String interfaceName = null;
        className = new StringBuffer(sqlObjectClass.getName());
        if (sqlObjectClass.getPackage().getName().endsWith("impl")) {
            int implStart = className.lastIndexOf(".impl.") + 1;
            int implEnd = implStart + 5;
            className.delete(implStart, implEnd);
        }
        if (sqlObjectClass.getName().endsWith("Impl")) {
            className.delete(className.length() - 4, className.length());
        }
        interfaceName = className.toString();
        return interfaceName;
    }

    protected Method getSpecificAppendSQLMethod(SQLObject sqlObject) throws NoSuchMethodException {
        return this.getSpecificAppendSQLMethod(this.getClass(), sqlObject);
    }

    protected Method getSpecificAppendSQLMethod(Class sourceWriterClass, SQLObject sqlObject) throws NoSuchMethodException {
        Class<?> sqlObjectClass;
        if (sqlObject == null) {
            return null;
        }
        String interfaceName = null;
        Method appendSQL = null;
        Class<?> sqlObjectInterfaceClass = sqlObjectClass = sqlObject.getClass();
        if (sqlObjectClass.getName().endsWith("Impl")) {
            interfaceName = SQLQuerySourceWriter.getInterfaceName(sqlObject.getClass());
            Class<?>[] sqlObjectInterfaces = sqlObjectClass.getInterfaces();
            int i = 0;
            while (i < sqlObjectInterfaces.length) {
                Class<?> interfaceClass = sqlObjectClass.getInterfaces()[i];
                if (interfaceClass.getName().equals(interfaceName)) {
                    sqlObjectInterfaceClass = interfaceClass;
                    break;
                }
                ++i;
            }
        }
        appendSQL = SQLQuerySourceWriter.getSpecificAppendSQLMethod(sourceWriterClass, sqlObjectInterfaceClass);
        return appendSQL;
    }

    static Method getSpecificAppendSQLMethod(Class sourceWriterClass, Class queryObjectInterfaceClass) throws NoSuchMethodException {
        if (queryObjectInterfaceClass == null || sourceWriterClass == null) {
            return null;
        }
        Method appendSQL = null;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.StringBuffer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> stringBufferClass = clazz;
            Class[] methodArgTypes = new Class[]{queryObjectInterfaceClass, stringBufferClass};
            appendSQL = sourceWriterClass.getDeclaredMethod("appendSpecificSQL", methodArgTypes);
        }
        catch (NoSuchMethodException nsme) {
            Class superClass = sourceWriterClass.getSuperclass();
            if (superClass != null) {
                Class clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceWriter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isAssignableFrom(superClass)) {
                    appendSQL = SQLQuerySourceWriter.getSpecificAppendSQLMethod(superClass, queryObjectInterfaceClass);
                }
            }
            throw nsme;
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
        }
        return appendSQL;
    }

    protected void appendCommentsPreceeding(SQLQueryObject queryObject, StringBuffer sb) {
        List comments = queryObject.getSourceInfo().getComments();
        if (comments != null) {
            Iterator it = comments.iterator();
            while (it.hasNext()) {
                SQLComment comment = (SQLComment)it.next();
                if (comment.getRelativePosition() != 1) continue;
                this.appendComment(comment, sb);
            }
        }
    }

    protected void appendCommentsSucceeding(SQLQueryObject queryObject, StringBuffer sb) {
        List comments = queryObject.getSourceInfo().getComments();
        if (comments != null) {
            Iterator it = comments.iterator();
            while (it.hasNext()) {
                SQLComment comment = (SQLComment)it.next();
                if (comment.getRelativePosition() == 1) continue;
                this.appendComment(comment, sb);
            }
        }
    }

    protected void appendComment(SQLComment comment, StringBuffer sb) {
        if (comment == null) {
            return;
        }
        if (!(comment.getRelativePosition() != 2 && comment.getRelativePosition() != 1 || this.isLastLineEmpty(sb))) {
            int lastLineIndent = this.getLastLineIndent(sb);
            sb.append('\n');
            this.appendSpace(sb, lastLineIndent);
        }
        if (comment.isMultiLineComment()) {
            String text = comment.getText();
            String trimText = text.trim();
            StringBuffer sbComment = new StringBuffer();
            if (!trimText.startsWith(COMMENT_PREFIX_MULTI_LINE)) {
                sbComment.append(COMMENT_PREFIX_MULTI_LINE);
            }
            sbComment.append(text);
            if (!trimText.endsWith(COMMENT_SUFFIX_MULTI_LINE)) {
                sbComment.append(COMMENT_SUFFIX_MULTI_LINE);
            }
            sb.append(sbComment);
            if (this.getLastLineLength(sbComment) > 40 && !text.endsWith(NEW_LINE_STRING)) {
                sb.append('\n');
            }
        } else {
            String text = comment.getText();
            if (!this.isLastLineEmpty(sb)) {
                sb.append(' ');
            }
            if (comment.getRelativePosition() == 0) {
                int currentIndent = this.getLastLineLength(sb);
                if (this.lastSLCommentIndentMap == null) {
                    this.lastSLCommentIndentMap = new HashMap();
                }
                if (this.lastSLCommentIndentMap.containsKey(sb)) {
                    int lastSingleLineCommentStart = (Integer)this.lastSLCommentIndentMap.get(sb);
                    if (lastSingleLineCommentStart > currentIndent) {
                        this.appendSpace(sb, lastSingleLineCommentStart - currentIndent);
                    } else {
                        this.lastSLCommentIndentMap.put(sb, new Integer(currentIndent));
                    }
                } else {
                    this.lastSLCommentIndentMap.put(sb, new Integer(currentIndent));
                }
            }
            if (!text.startsWith(COMMENT_PREFIX_SINGLE_LINE)) {
                sb.append(COMMENT_PREFIX_SINGLE_LINE);
            }
            sb.append(text);
            if (!text.endsWith(NEW_LINE_STRING)) {
                sb.append('\n');
            }
        }
    }

    protected void appendSpace(StringBuffer sb, int number) {
        int i = 0;
        while (i < number) {
            sb.append(' ');
            ++i;
        }
    }

    protected void appendSpecificSQL(OrderingSpecType orderingType, StringBuffer sb) {
        int type = orderingType.getValue();
        switch (type) {
            case 1: {
                sb.append("ASC");
                break;
            }
            case 2: {
                sb.append("DESC");
                break;
            }
        }
    }

    protected void appendSpecificSQL(NullOrderingType nullOrderingType, StringBuffer sb) {
        int type = nullOrderingType.getValue();
        switch (type) {
            case 1: {
                sb.append(NULL_ORDERING_TYPE_NULLS_FIRST);
                break;
            }
            case 2: {
                sb.append(NULL_ORDERING_TYPE_NULLS_LAST);
                break;
            }
        }
    }

    protected void appendSpecificSQL(PredicateComparisonOperator op, StringBuffer sb) {
        int operator = op.getValue();
        switch (operator) {
            case 0: {
                sb.append(EQUAL);
                break;
            }
            case 1: {
                sb.append(NOT_EQUAL);
                break;
            }
            case 2: {
                sb.append(LESS_THAN);
                break;
            }
            case 3: {
                sb.append(GREATER_THAN);
                break;
            }
            case 4: {
                sb.append(LESS_THAN_OR_EQUAL);
                break;
            }
            case 5: {
                sb.append(GREATER_THAN_OR_EQUAL);
                break;
            }
        }
    }

    protected void appendSpecificSQL(SearchConditionCombinedOperator op, StringBuffer sb) {
        int operator = op.getValue();
        switch (operator) {
            case 0: {
                sb.append(AND);
                break;
            }
            case 1: {
                sb.append(OR);
                break;
            }
        }
    }

    protected void appendSpecificSQL(ValueExpressionCombinedOperator op, StringBuffer sb) {
        int operator = op.getValue();
        switch (operator) {
            case 0: {
                sb.append("+");
                break;
            }
            case 1: {
                sb.append("-");
                break;
            }
            case 2: {
                sb.append("*");
                break;
            }
            case 3: {
                sb.append(DIVIDE);
                break;
            }
            case 4: {
                sb.append(CONCATENATE);
                break;
            }
        }
    }

    protected void appendSpecificSQL(ValueExpressionUnaryOperator op, StringBuffer sb) {
        int operator = op.getValue();
        switch (operator) {
            case 0: {
                break;
            }
            case 1: {
                sb.append("+");
                break;
            }
            case 2: {
                sb.append("-");
                break;
            }
        }
    }

    protected void appendSpecificSQL(PredicateQuantifiedType quantifier, StringBuffer sb) {
        int operator = quantifier.getValue();
        switch (operator) {
            case 2: {
                sb.append(ALL);
                break;
            }
            case 1: {
                sb.append(ANY);
                break;
            }
            case 0: {
                sb.append(SOME);
                break;
            }
        }
    }

    protected void appendSpecificSQL(ValueExpressionLabeledDurationType duration, StringBuffer sb) {
        int type = duration.getValue();
        switch (type) {
            case 0: {
                sb.append(YEARS);
                break;
            }
            case 1: {
                sb.append(MONTHS);
                break;
            }
            case 2: {
                sb.append(DAYS);
                break;
            }
            case 3: {
                sb.append(HOURS);
                break;
            }
            case 4: {
                sb.append(MINUTES);
                break;
            }
            case 5: {
                sb.append(SECONDS);
                break;
            }
            case 6: {
                sb.append(MICROSECONDS);
                break;
            }
        }
    }

    protected void appendSpecificSQL(TableJoinedOperator op, StringBuffer sb) {
        int operator = op.getValue();
        switch (operator) {
            case 0: {
                break;
            }
            case 1: {
                sb.append(INNER);
                break;
            }
            case 4: {
                sb.append(FULL);
                sb.append(' ');
                sb.append(OUTER);
                break;
            }
            case 2: {
                sb.append(LEFT);
                sb.append(' ');
                sb.append(OUTER);
                break;
            }
            case 3: {
                sb.append(RIGHT);
                sb.append(' ');
                sb.append(OUTER);
                break;
            }
        }
    }

    protected void appendSpecificSQL(QueryCombinedOperator op, StringBuffer sb) {
        int operator = op.getValue();
        switch (operator) {
            case 0: {
                sb.append(UNION);
                break;
            }
            case 1: {
                sb.append(UNION_ALL);
                break;
            }
            case 2: {
                sb.append(INTERSECT);
                break;
            }
            case 3: {
                sb.append(INTERSECT_ALL);
                break;
            }
            case 4: {
                sb.append(EXCEPT);
                break;
            }
            case 5: {
                sb.append(EXCEPT_ALL);
                break;
            }
        }
    }

    protected void appendSpecificSQL(SuperGroupType type, StringBuffer sb) {
        int grouping = type.getValue();
        switch (grouping) {
            case 0: {
                sb.append(CUBE);
                break;
            }
            case 2: {
                sb.append(ROLLUP);
                break;
            }
            case 1: {
                break;
            }
        }
    }

    protected void appendSpecificSQL(UpdateAssignmentExpression impl, StringBuffer sb) {
        if (!impl.getTargetColumnList().isEmpty()) {
            EList columns = impl.getTargetColumnList();
            if (columns.size() == 1) {
                ValueExpressionColumn col = (ValueExpressionColumn)columns.get(0);
                this.appendSQL(col, sb);
            } else {
                sb.append('(');
                this.appendSQLForSQLObjectList((List)columns, sb);
                sb.append(')');
            }
        }
        this.appendSpace(sb, 1);
        sb.append(EQUAL);
        this.appendSpace(sb, 1);
        UpdateSource updateSrc = impl.getUpdateSource();
        this.appendSQL(updateSrc, sb);
    }

    protected void appendSpecificSQL(UpdateSourceExprList sourceExprList, StringBuffer sb) {
        EList values = sourceExprList.getValueExprList();
        if (values != null) {
            if (values.size() == 1) {
                QueryValueExpression expr = (QueryValueExpression)values.get(0);
                this.appendSQL(expr, sb);
            } else {
                sb.append('(');
                this.appendSQLForSQLObjectList((List)values, sb);
                sb.append(')');
            }
        }
    }

    protected void appendSpecificSQL(UpdateSourceQuery sourceQuery, StringBuffer sb) {
        sb.append('(');
        this.appendSQL(sourceQuery.getQueryExpr(), sb);
        sb.append(')');
    }

    protected void appendSpecificSQL(PrimitiveType primitiveType, StringBuffer sb) {
        if (primitiveType != null) {
            sb.append(DataTypeHelper.getPrimitiveTypeName(primitiveType));
        }
    }

    protected void appendSpecificSQL(BinaryStringDataType dataType, StringBuffer sb) {
        StringBuffer lengthSB = new StringBuffer();
        if (dataType.getLength() > 0) {
            lengthSB.append('(');
            if (dataType.getPrimitiveType() == PrimitiveType.BINARY_LARGE_OBJECT_LITERAL) {
                this.appendSQLForLargeObjectSize(dataType.getLength(), lengthSB);
            } else {
                lengthSB.append(dataType.getLength());
            }
            lengthSB.append(')');
        }
        String length = lengthSB.toString();
        String name = dataType.getName();
        if (name == null || name.indexOf(95) >= 0) {
            this.appendSpecificSQL(dataType.getPrimitiveType(), sb);
            if (length.length() > 0) {
                sb.append(' ');
                sb.append(length);
            }
        } else {
            name = name.replaceFirst("\\(.*\\)", length);
            sb.append(name);
        }
    }

    protected void appendSpecificSQL(CharacterStringDataType dataType, StringBuffer sb) {
        this.appendSpecificSQL(dataType.getPrimitiveType(), sb);
        if (dataType.getLength() > 0) {
            sb.append(' ');
            sb.append('(');
            if (dataType.getPrimitiveType() == PrimitiveType.CHARACTER_LARGE_OBJECT_LITERAL || dataType.getPrimitiveType() == PrimitiveType.NATIONAL_CHARACTER_LARGE_OBJECT_LITERAL) {
                this.appendSQLForLargeObjectSize(dataType.getLength(), sb);
            } else {
                sb.append(dataType.getLength());
            }
            sb.append(')');
        }
    }

    protected void appendSQLForLargeObjectSize(int size, StringBuffer sb) {
        int kilo = 1024;
        int mega = 0x100000;
        int giga = 0x40000000;
        if (size > kilo && size % kilo == 0) {
            if (size > mega && size % mega == 0) {
                if (size > giga && size % giga == 0) {
                    sb.append(size / giga);
                    sb.append('G');
                } else {
                    sb.append(size / mega);
                    sb.append('M');
                }
            } else {
                sb.append(size / kilo);
                sb.append('K');
            }
        } else if (size == Integer.MAX_VALUE) {
            sb.append(2);
            sb.append('G');
        } else {
            sb.append(size);
        }
    }

    protected void appendSpecificSQL(ColumnName columnName, StringBuffer sb) {
        sb.append(StatementHelper.convertCatalogIdentifierToSQLFormat(columnName.getName(), this.getDelimitedIdentifierQuote()));
    }

    protected void appendSpecificSQL(DateDataType dataType, StringBuffer sb) {
        this.appendSpecificSQL(dataType.getPrimitiveType(), sb);
    }

    protected void appendSpecificSQL(TimeDataType dataType, StringBuffer sb) {
        this.appendSpecificSQL(dataType.getPrimitiveType(), sb);
    }

    protected void appendSpecificSQL(IntegerDataType dataType, StringBuffer sb) {
        this.appendSpecificSQL(dataType.getPrimitiveType(), sb);
    }

    protected void appendSpecificSQL(FixedPrecisionDataType dataType, StringBuffer sb) {
        this.appendSpecificSQL(dataType.getPrimitiveType(), sb);
        if (dataType.getPrecision() != 0) {
            sb.append(' ');
            sb.append('(');
            sb.append(dataType.getPrecision());
            if (dataType.getScale() != 0) {
                sb.append(',');
                sb.append(dataType.getScale());
            }
            sb.append(')');
        }
    }

    protected void appendSpecificSQL(ApproximateNumericDataType dataType, StringBuffer sb) {
        this.appendSpecificSQL(dataType.getPrimitiveType(), sb);
        if (dataType.getPrecision() != 0) {
            sb.append(' ');
            sb.append('(');
            sb.append(dataType.getPrecision());
            sb.append(')');
        }
    }

    protected void appendSpecificSQL(ArrayDataType dataType, StringBuffer sb) {
        if (!dataType.getElement().isEmpty()) {
            DataType elementType = (DataType)dataType.getElement().get(0);
            this.appendSQL((SQLObject)elementType, sb);
        }
        sb.append(ARRAY);
        if (dataType.getMaxCardinality() != 0) {
            sb.append('[');
            sb.append(dataType.getMaxCardinality());
            sb.append(']');
        }
    }

    protected void appendSpecificSQL(MultisetDataType dataType, StringBuffer sb) {
        if (!dataType.getElement().isEmpty()) {
            DataType elementType = (DataType)dataType.getElement().get(0);
            this.appendSQL((SQLObject)elementType, sb);
        }
        sb.append(MULTISET);
    }

    protected void appendSpecificSQL(GroupingExpression groupingExpr, StringBuffer sb) {
        this.appendSQL(groupingExpr.getValueExpr(), sb);
    }

    protected void appendSpecificSQL(SuperGroup superGroup, StringBuffer sb) {
        this.appendSpecificSQL(superGroup.getSuperGroupType(), sb);
        sb.append('(');
        EList superGroupElementList = superGroup.getSuperGroupElementList();
        this.appendSQLForSQLObjectList((List)superGroupElementList, sb);
        sb.append(')');
    }

    protected void appendSpecificSQL(SuperGroupElementExpression superGroupElementExpr, StringBuffer sb) {
        this.appendSQL(superGroupElementExpr.getGroupingExpr(), sb);
    }

    protected void appendSpecificSQL(SuperGroupElementSublist superGroupSublist, StringBuffer sb) {
        sb.append('(');
        EList superGroupElementExprList = superGroupSublist.getSuperGroupElementExprList();
        this.appendSQLForSQLObjectList((List)superGroupElementExprList, sb);
        sb.append(')');
    }

    protected void appendSpecificSQL(GroupingSets groupingSets, StringBuffer sb) {
        sb.append(GROUPING_SETS);
        sb.append(' ');
        sb.append('(');
        EList groupingSetsElementList = groupingSets.getGroupingSetsElementList();
        this.appendSQLForSQLObjectList((List)groupingSetsElementList, sb);
        sb.append(')');
    }

    protected void appendSpecificSQL(GroupingSetsElementExpression groupingSetsElementExpr, StringBuffer sb) {
        this.appendSQL(groupingSetsElementExpr.getGrouping(), sb);
    }

    protected void appendSpecificSQL(GroupingSetsElementSublist groupingSetsSublist, StringBuffer sb) {
        sb.append('(');
        EList groupingSetsElementExprList = groupingSetsSublist.getGroupingSetsElementExprList();
        this.appendSQLForSQLObjectList((List)groupingSetsElementExprList, sb);
        sb.append(')');
    }

    protected void appendSpecificSQL(QueryDeleteStatement deleteStmt, StringBuffer sb) {
        sb.append(DELETE);
        this.appendSpace(sb, 1);
        sb.append(FROM);
        this.appendSpace(sb, 1);
        this.appendSQL(deleteStmt.getTargetTable(), sb);
        this.appendNewLine(sb);
        if (deleteStmt.getWhereClause() != null) {
            this.appendSpace(sb, 1);
            sb.append(WHERE);
            this.appendSpace(sb, 1);
            this.appendSQL(deleteStmt.getWhereClause(), sb);
        }
        if (deleteStmt.getWhereCurrentOfClause() != null) {
            sb.append("  CURSOR REFERENCE TO BE getSQL()ed IN " + deleteStmt.getClass() + "! ");
        }
    }

    protected void appendNewLine(StringBuffer sb) {
        if (!this.isLastLineEmpty(sb)) {
            sb.append('\n');
        }
    }

    protected void appendSpecificSQL(QueryInsertStatement insertStmt, StringBuffer sb) {
        sb.append(INSERT);
        this.appendSpace(sb, 1);
        sb.append(INTO);
        this.appendSpace(sb, 1);
        if (insertStmt.getTargetTable() != null) {
            this.appendSQL(insertStmt.getTargetTable(), sb);
        }
        if (!insertStmt.getTargetColumnList().isEmpty()) {
            this.appendSpace(sb, 1);
            EList targetColumnList = insertStmt.getTargetColumnList();
            sb.append('(');
            this.appendSQLForSQLObjectList((List)targetColumnList, sb);
            sb.append(')');
        }
        if (insertStmt.getSourceQuery() != null) {
            this.appendNewLine(sb);
            this.appendSpace(sb, 2);
            this.appendSQL(insertStmt.getSourceQuery(), sb);
        } else {
            this.appendNewLine(sb);
            this.appendSpace(sb, 2);
            sb.append(VALUES);
            this.appendSpace(sb, 1);
            if (!insertStmt.getSourceValuesRowList().isEmpty()) {
                Iterator it = insertStmt.getSourceValuesRowList().iterator();
                while (it.hasNext()) {
                    ValuesRow row = (ValuesRow)it.next();
                    this.appendSQL(row, sb);
                    if (!it.hasNext()) continue;
                    sb.append(',');
                    sb.append('\n');
                    this.appendSpace(sb, 9);
                }
            }
        }
    }

    protected void appendSpecificSQL(QuerySelectStatement selectStmt, StringBuffer sb) {
        if (selectStmt.getQueryExpr() != null) {
            this.appendSQL(selectStmt.getQueryExpr(), sb);
            this.appendSQLForOrderByClause((List)selectStmt.getOrderByClause(), sb);
        } else {
            sb.append(DEFAULT_STMT_SELECT);
        }
        this.appendNewLine(sb);
    }

    protected void appendSpecificSQL(QueryExpressionRoot qryExprRoot, StringBuffer sb) {
        int withTableIndent = 2;
        if (qryExprRoot != null) {
            EList withTableSpecList = qryExprRoot.getWithClause();
            if (withTableSpecList != null && !withTableSpecList.isEmpty()) {
                sb.append(WITH);
                sb.append('\n');
                this.appendSpace(sb, withTableIndent);
                Iterator withIt = withTableSpecList.iterator();
                while (withIt.hasNext()) {
                    WithTableSpecification tableWith = (WithTableSpecification)withIt.next();
                    this.appendSQL(tableWith, sb);
                    if (!withIt.hasNext()) continue;
                    sb.append(',');
                    sb.append('\n');
                    this.appendSpace(sb, withTableIndent);
                }
                this.appendNewLine(sb);
            }
            this.appendSQL(qryExprRoot.getQuery(), sb);
        }
    }

    protected void appendSpecificSQL(QueryCombined qryComb, StringBuffer sb) {
        int combinedIndent = this.getLastLineLength(sb);
        this.appendSQL(qryComb.getLeftQuery(), sb);
        this.appendNewLine(sb);
        this.appendSpace(sb, combinedIndent);
        this.appendSpecificSQL(qryComb.getCombinedOperator(), sb);
        this.appendNewLine(sb);
        boolean isRightQueryNested = qryComb.getRightQuery() instanceof QueryCombined;
        if (isRightQueryNested) {
            sb.append('(');
            this.appendNewLine(sb);
            this.appendSpace(sb, 4);
        }
        this.appendSpace(sb, combinedIndent);
        this.appendSQL(qryComb.getRightQuery(), sb);
        if (isRightQueryNested) {
            this.appendNewLine(sb);
            this.appendSpace(sb, combinedIndent);
            sb.append(')');
        }
    }

    protected void appendSpecificSQL(QueryNested qryNest, StringBuffer sb) {
        sb.append('(');
        this.appendSQL(qryNest.getNestedQuery(), sb);
        sb.append(')');
    }

    protected void appendSpecificSQL(QuerySelect select, StringBuffer sb) {
        StringBuffer sbSelect = new StringBuffer();
        StringBuffer clauseIndent = new StringBuffer();
        int selectStartOffset = this.getLastLineLength(sb);
        String spacer4 = "    ";
        if (selectStartOffset > 20) {
            selectStartOffset = this.getLastLineIndent(sb) + 4;
            sbSelect.append('\n');
            this.appendSpace(sbSelect, selectStartOffset);
        }
        this.appendSpace(clauseIndent, selectStartOffset + 2);
        sbSelect.append(SELECT);
        sbSelect.append(' ');
        if (select.isDistinct()) {
            sbSelect.append(DISTINCT);
            sbSelect.append(' ');
        }
        if (select.getSelectClause() != null && !select.getSelectClause().isEmpty()) {
            this.appendSQLForSQLObjectList((List)select.getSelectClause(), sbSelect);
        } else {
            sbSelect.append("*");
        }
        this.appendNewLine(sbSelect);
        sbSelect.append(clauseIndent);
        sbSelect.append(FROM);
        sbSelect.append(' ');
        if (select.getFromClause() != null && !select.getFromClause().isEmpty()) {
            int lastTableStartIndex = sbSelect.length();
            Iterator fromIt = select.getFromClause().iterator();
            while (fromIt.hasNext()) {
                TableReference tableRef = (TableReference)fromIt.next();
                this.appendSQLForTableExpression(tableRef, sbSelect);
                if (fromIt.hasNext()) {
                    sbSelect.append(',');
                    sbSelect.append(' ');
                }
                if (this.getLastLineLength(sbSelect) > this.displayWidth) {
                    sbSelect.insert(lastTableStartIndex - 1, spacer4);
                    sbSelect.insert(lastTableStartIndex - 1, clauseIndent.toString());
                    sbSelect.insert(lastTableStartIndex - 1, '\n');
                }
                lastTableStartIndex = sbSelect.length();
            }
        }
        if (select.getWhereClause() != null) {
            this.appendNewLine(sbSelect);
            sbSelect.append(clauseIndent);
            sbSelect.append(WHERE);
            sbSelect.append(' ');
            this.appendSQL(select.getWhereClause(), sbSelect);
        }
        if (select.getGroupByClause() != null && !select.getGroupByClause().isEmpty()) {
            this.appendNewLine(sbSelect);
            sbSelect.append(clauseIndent);
            sbSelect.append(GROUP_BY);
            sbSelect.append(' ');
            this.appendSQLForSQLObjectList((List)select.getGroupByClause(), sbSelect);
        }
        if (select.getHavingClause() != null) {
            this.appendNewLine(sbSelect);
            sbSelect.append(clauseIndent);
            sbSelect.append(HAVING);
            sbSelect.append(' ');
            this.appendSQL(select.getHavingClause(), sbSelect);
        }
        if (select.getIntoClause() != null && !select.getIntoClause().isEmpty()) {
            String msg = "#appendSQL(QuerySelect) not implemented for IntoClause!";
            throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + msg);
        }
        if (!(select.eContainer() instanceof QueryExpressionRoot && select.eContainer().eContainer() instanceof QuerySelectStatement || sbSelect.length() >= 0)) {
            this.trimWhiteSpace(sbSelect);
        }
        sb.append(sbSelect);
    }

    protected void appendSpecificSQL(OrderByOrdinal orderByOrd, StringBuffer sb) {
        StringBuffer localSb = new StringBuffer();
        localSb.append(orderByOrd.getOrdinalValue());
        this.wrapSQL(orderByOrd, localSb);
        sb.append(localSb);
    }

    protected void appendSpecificSQL(OrderByResultColumn orderByExpr, StringBuffer sb) {
        if (orderByExpr == null || orderByExpr.getResultCol() == null) {
            return;
        }
        StringBuffer localSb = new StringBuffer();
        ResultColumn resultColumn = orderByExpr.getResultCol();
        String orderByColumnName = null;
        orderByColumnName = resultColumn.getName() != null ? StatementHelper.convertCatalogIdentifierToSQLFormat(resultColumn.getName(), this.getDelimitedIdentifierQuote()) : this.getSQL(resultColumn.getValueExpr());
        localSb.append(orderByColumnName);
        this.wrapSQL(orderByExpr, localSb);
        sb.append(localSb);
    }

    protected void appendSpecificSQL(OrderByValueExpression orderByExpr, StringBuffer sb) {
        StringBuffer localSb = new StringBuffer();
        this.appendSQL(orderByExpr.getValueExpr(), localSb);
        this.wrapSQL(orderByExpr, localSb);
        sb.append(localSb);
    }

    protected void appendSQLForOrderByClause(List orderByClause, StringBuffer sb) {
        if (StatementHelper.isOrderByClauseContainsValidOrderBySpecification(orderByClause)) {
            this.appendNewLine(sb);
            this.appendSpace(sb, 2);
            sb.append(ORDER_BY);
            sb.append(' ');
            Iterator it = orderByClause.iterator();
            while (it.hasNext()) {
                OrderBySpecification orderBySpec = (OrderBySpecification)it.next();
                if (!StatementHelper.isOrderBySpecificationValid(orderBySpec)) continue;
                this.appendSQL(orderBySpec, sb);
                sb.append(',');
                sb.append(' ');
            }
            sb.delete(sb.length() - 2, sb.length());
        }
    }

    protected void appendSQLForSQLObjectList(List sqlObjectList, StringBuffer sb) {
        int indent = this.getLastLineIndent(sb) + 2;
        if (sqlObjectList != null) {
            Iterator it = sqlObjectList.iterator();
            while (it.hasNext()) {
                SQLObject sqlObject = (SQLObject)it.next();
                if (sqlObject == null) continue;
                this.appendSQL(sqlObject, sb);
                if (!it.hasNext()) continue;
                sb.append(',');
                if (this.getLastLineLength(sb) > this.displayWidth - 20) {
                    sb.append('\n');
                    this.appendSpace(sb, indent);
                    continue;
                }
                sb.append(' ');
            }
        }
    }

    protected void wrapSQL(OrderBySpecification orderBySpec, StringBuffer toWrapUp) {
        NullOrderingType nullOrderingType;
        OrderingSpecType orderingSpecType = orderBySpec.getOrderingSpecOption();
        if (orderingSpecType != OrderingSpecType.NONE_LITERAL) {
            toWrapUp.append(' ');
            this.appendSpecificSQL(orderingSpecType, toWrapUp);
        }
        if ((nullOrderingType = orderBySpec.getNullOrderingOption()) != NullOrderingType.NONE_LITERAL) {
            toWrapUp.append(' ');
            this.appendSpecificSQL(nullOrderingType, toWrapUp);
        }
    }

    protected void wrapSQL(Predicate pred, StringBuffer toWrapUp) {
        if (pred.isNegatedPredicate()) {
            StringBuffer prefix = new StringBuffer(4);
            prefix.append(NOT);
            prefix.append(' ');
            this.indentSQLToLastLineLengthOfContainer(toWrapUp, prefix);
            toWrapUp.insert(0, (Object)prefix);
        }
        this.wrapSQL((QuerySearchCondition)pred, toWrapUp);
    }

    protected void wrapSQL(QuerySearchCondition cond, StringBuffer toWrapUp) {
        if (cond.isNegatedCondition()) {
            StringBuffer prefix = new StringBuffer(4);
            prefix.append(NOT);
            prefix.append(' ');
            prefix.append('(');
            this.indentSQLToLastLineLengthOfContainer(toWrapUp, prefix);
            toWrapUp.insert(0, (Object)prefix);
            toWrapUp.append(')');
        }
    }

    protected void appendSpecificSQL(PredicateBasic pred, StringBuffer sb) {
        StringBuffer sbPred = new StringBuffer();
        if (pred.getLeftValueExpr() != null) {
            this.appendSQL(pred.getLeftValueExpr(), sbPred);
        }
        this.appendSpace(sbPred, 1);
        if (pred.getComparisonOperator() != null) {
            this.appendSpecificSQL(pred.getComparisonOperator(), sbPred);
        }
        this.appendSpace(sbPred, 1);
        if (pred.getRightValueExpr() != null) {
            this.appendSQL(pred.getRightValueExpr(), sbPred);
        }
        if (pred.isHasSelectivity()) {
            sbPred.append(' ');
            sbPred.append(SELECTIVITY);
            sbPred.append(' ');
            sbPred.append(pred.getSelectivityValue());
        }
        this.wrapSQL(pred, sbPred);
        sb.append(sbPred);
    }

    protected void appendSpecificSQL(PredicateBetween between, StringBuffer sb) {
        StringBuffer sbPred = new StringBuffer();
        if (between.isNotBetween()) {
            sbPred.append(NOT);
            sbPred.append(' ');
        }
        this.appendSQL(between.getLeftValueExpr(), sbPred);
        sbPred.append(' ');
        sbPred.append(BETWEEN);
        sbPred.append(' ');
        this.appendSQL(between.getRightValueExpr1(), sbPred);
        sbPred.append(' ');
        sbPred.append(AND);
        sbPred.append(' ');
        this.appendSQL(between.getRightValueExpr2(), sbPred);
        this.wrapSQL(between, sbPred);
        sb.append(sbPred);
    }

    protected void appendSpecificSQL(PredicateExists exists, StringBuffer sb) {
        StringBuffer sbPred = new StringBuffer();
        sbPred.append(EXISTS);
        sbPred.append(' ');
        sbPred.append('(');
        this.appendSQL(exists.getQueryExpr(), sbPred);
        sbPred.append(')');
        this.wrapSQL(exists, sbPred);
        this.indentSQLToLastLineLengthOfContainer(sbPred, sb);
        sb.append(sbPred);
    }

    protected void appendSpecificSQL(PredicateIsNull predNull, StringBuffer sb) {
        StringBuffer sbPred = new StringBuffer();
        this.appendSQL(predNull.getValueExpr(), sbPred);
        sbPred.append(' ');
        sbPred.append(IS);
        sbPred.append(' ');
        if (predNull.isNotNull()) {
            sbPred.append(NOT);
            sbPred.append(' ');
        }
        sbPred.append(NULL);
        this.wrapSQL(predNull, sbPred);
        sb.append(sbPred);
    }

    protected void appendSpecificSQL(PredicateInValueList predInValueList, StringBuffer sb) {
        StringBuffer sbPred = new StringBuffer();
        this.appendSQL(predInValueList.getValueExpr(), sbPred);
        sbPred.append(' ');
        if (predInValueList.isNotIn()) {
            sbPred.append(NOT);
            sbPred.append(' ');
        }
        sbPred.append(IN);
        sbPred.append(' ');
        if (predInValueList.getValueExprList() != null) {
            sbPred.append('(');
            this.appendSQLForSQLObjectList((List)predInValueList.getValueExprList(), sbPred);
            sbPred.append(')');
        }
        this.wrapSQL(predInValueList, sbPred);
        sb.append(sbPred);
    }

    protected void appendSpecificSQL(PredicateInValueRowSelect predInRowSelect, StringBuffer sb) {
        StringBuffer sbPred = new StringBuffer();
        if (predInRowSelect.getValueExprList() != null) {
            sbPred.append('(');
            this.appendSQLForSQLObjectList((List)predInRowSelect.getValueExprList(), sbPred);
            sbPred.append(')');
        }
        sbPred.append(' ');
        if (predInRowSelect.isNotIn()) {
            sbPred.append(NOT);
            sbPred.append(' ');
        }
        sbPred.append(IN);
        sbPred.append(' ');
        if (predInRowSelect.getQueryExpr() != null) {
            sbPred.append('(');
            this.appendSQL(predInRowSelect.getQueryExpr(), sbPred);
            sbPred.append(')');
        }
        this.wrapSQL(predInRowSelect, sbPred);
        this.indentSQLToLastLineLengthOfContainer(sbPred, sb);
        sb.append(sbPred);
    }

    protected void appendSpecificSQL(PredicateInValueSelect predInSelect, StringBuffer sb) {
        StringBuffer sbPred = new StringBuffer();
        this.appendSQL(predInSelect.getValueExpr(), sbPred);
        sbPred.append(' ');
        if (predInSelect.isNotIn()) {
            sbPred.append(NOT);
            sbPred.append(' ');
        }
        sbPred.append(IN);
        sbPred.append(' ');
        if (predInSelect.getQueryExpr() != null) {
            sbPred.append('(');
            this.appendSQL(predInSelect.getQueryExpr(), sbPred);
            sbPred.append(')');
        }
        this.wrapSQL(predInSelect, sbPred);
        this.indentSQLToLastLineLengthOfContainer(sbPred, sb);
        sb.append(sbPred);
    }

    protected void appendSpecificSQL(PredicateLike like, StringBuffer sb) {
        StringBuffer sbPred = new StringBuffer();
        this.appendSQL(like.getMatchingValueExpr(), sbPred);
        sbPred.append(' ');
        if (like.isNotLike()) {
            sbPred.append(NOT);
            sbPred.append(' ');
        }
        sbPred.append(LIKE);
        sbPred.append(' ');
        this.appendSQL(like.getPatternValueExpr(), sbPred);
        if (like.getEscapeValueExpr() != null) {
            sbPred.append(' ');
            sbPred.append(ESCAPE);
            sbPred.append(' ');
            this.appendSQL(like.getEscapeValueExpr(), sbPred);
        }
        this.wrapSQL(like, sbPred);
        sb.append(sbPred);
    }

    protected void appendSpecificSQL(PredicateQuantifiedValueSelect predQuantified, StringBuffer sb) {
        StringBuffer sbPred = new StringBuffer();
        this.appendSQL(predQuantified.getValueExpr(), sbPred);
        sbPred.append(' ');
        this.appendSpecificSQL(predQuantified.getComparisonOperator(), sbPred);
        sbPred.append(' ');
        this.appendSpecificSQL(predQuantified.getQuantifiedType(), sbPred);
        sbPred.append(' ');
        if (predQuantified.getQueryExpr() != null) {
            sbPred.append('(');
            this.appendSQL(predQuantified.getQueryExpr(), sbPred);
            sbPred.append(')');
        }
        this.wrapSQL(predQuantified, sbPred);
        this.indentSQLToLastLineLengthOfContainer(sbPred, sb);
        sb.append(sbPred);
    }

    protected void appendSpecificSQL(PredicateQuantifiedRowSelect predQuantified, StringBuffer sb) {
        StringBuffer sbPred = new StringBuffer();
        sbPred.append('(');
        this.appendSQLForSQLObjectList((List)predQuantified.getValueExprList(), sbPred);
        sbPred.append(')');
        sbPred.append(' ');
        sbPred.append(EQUAL);
        sbPred.append(' ');
        this.appendSpecificSQL(predQuantified.getQuantifiedType(), sbPred);
        sbPred.append(' ');
        if (predQuantified.getQueryExpr() != null) {
            sbPred.append('(');
            this.appendSQL(predQuantified.getQueryExpr(), sbPred);
            sbPred.append(')');
        }
        this.wrapSQL(predQuantified, sbPred);
        this.indentSQLToLastLineLengthOfContainer(sbPred, sb);
        sb.append(sbPred);
    }

    protected void appendSpecificSQL(ResultColumn result, StringBuffer sb) {
        this.appendSQL(result.getValueExpr(), sb);
        if (result.getName() != null && result.getName().trim().length() > 0) {
            sb.append(' ');
            sb.append(AS);
            sb.append(' ');
            sb.append(StatementHelper.convertCatalogIdentifierToSQLFormat(result.getName(), this.getDelimitedIdentifierQuote()));
        }
    }

    protected void appendSpecificSQL(ResultTableAllColumns result, StringBuffer sb) {
        if (result.getTableExpr() != null) {
            TableExpression tableExpr = result.getTableExpr();
            TableCorrelation tableCor = tableExpr.getTableCorrelation();
            if (tableCor != null && tableCor.getName() != null && tableCor.getName().trim().length() > 0) {
                String tableCorrName = tableCor.getName();
                tableCorrName = StatementHelper.convertCatalogIdentifierToSQLFormat(tableCorrName, this.getDelimitedIdentifierQuote());
                sb.append(tableCorrName);
            } else if (tableExpr instanceof TableInDatabase) {
                TableInDatabase tableInDB = (TableInDatabase)tableExpr;
                this.appendSQLForTableExpression(tableInDB, sb);
            } else {
                sb.append(tableExpr.getName());
            }
        } else {
            sb.append(result.getName());
        }
        sb.append('.');
        sb.append("*");
    }

    protected void appendSpecificSQL(TableInDatabase tableInDB, StringBuffer sb) {
        this.appendSQLForTableInDatabase(tableInDB, sb);
        if (tableInDB.getTableCorrelation() != null) {
            sb.append(' ');
            sb.append(AS);
            sb.append(' ');
            this.appendSQL(tableInDB.getTableCorrelation(), sb);
        }
    }

    protected void appendSpecificSQL(WithTableReference withTableRef, StringBuffer sb) {
        sb.append(StatementHelper.convertCatalogIdentifierToSQLFormat(withTableRef.getName(), this.getDelimitedIdentifierQuote()));
        if (withTableRef.getTableCorrelation() != null) {
            sb.append(' ');
            sb.append(AS);
            sb.append(' ');
            this.appendSQL(withTableRef.getTableCorrelation(), sb);
        }
    }

    protected void appendSpecificSQL(TableCorrelation tableCorrelation, StringBuffer sb) {
        sb.append(StatementHelper.convertCatalogIdentifierToSQLFormat(tableCorrelation.getName(), this.getDelimitedIdentifierQuote()));
        if (tableCorrelation.getColumnNameList().size() > 0) {
            EList columnNameList = tableCorrelation.getColumnNameList();
            sb.append(' ');
            sb.append('(');
            this.appendSQLForSQLObjectList((List)columnNameList, sb);
            sb.append(')');
        }
    }

    protected void appendSpecificSQL(TableFunction tableFunc, StringBuffer sb) {
        sb.append(TABLE);
        sb.append(' ');
        sb.append('(');
        if (tableFunc.getFunction() != null && tableFunc.getFunction().getSchema() != null && tableFunc.getFunction().getSchema().getName() != null) {
            sb.append(StatementHelper.convertCatalogIdentifierToSQLFormat(tableFunc.getFunction().getSchema().getName(), this.getDelimitedIdentifierQuote()));
            sb.append('.');
        }
        sb.append(StatementHelper.convertCatalogIdentifierToSQLFormat(tableFunc.getName(), this.getDelimitedIdentifierQuote()));
        sb.append('(');
        EList paramList = tableFunc.getParameterList();
        if (paramList != null) {
            this.appendSQLForSQLObjectList((List)paramList, sb);
        }
        sb.append(')');
        sb.append(')');
        TableCorrelation tableCorr = tableFunc.getTableCorrelation();
        if (tableCorr != null) {
            sb.append(' ');
            sb.append(AS);
            sb.append(' ');
            this.appendSQL(tableCorr, sb);
        }
    }

    protected void appendSpecificSQL(TableJoined tableJoined, StringBuffer sb) {
        this.appendSQLForTableExpression(tableJoined.getTableRefLeft(), sb);
        if (tableJoined.getJoinOperator() != TableJoinedOperator.DEFAULT_INNER_LITERAL) {
            sb.append(' ');
            this.appendSpecificSQL(tableJoined.getJoinOperator(), sb);
        }
        sb.append(' ');
        sb.append(JOIN);
        sb.append(' ');
        this.appendSQLForTableExpression(tableJoined.getTableRefRight(), sb);
        sb.append(' ');
        sb.append(ON);
        sb.append(' ');
        this.appendSQL(tableJoined.getJoinCondition(), sb);
    }

    protected void appendSpecificSQL(TableNested tableNested, StringBuffer sb) {
        TableReference tableRef = null;
        tableRef = tableNested.getNestedTableRef();
        sb.append('(');
        this.appendSQLForTableExpression(tableRef, sb);
        sb.append(')');
    }

    protected void appendSpecificSQL(WithTableSpecification withTable, StringBuffer sb) {
        int tableWithIndent = this.getLastLineIndent(sb);
        int tableWithQueryIndent = tableWithIndent + 3;
        sb.append(StatementHelper.convertCatalogIdentifierToSQLFormat(withTable.getName(), this.getDelimitedIdentifierQuote()));
        if (!withTable.getColumnNameList().isEmpty()) {
            EList columnNameList = withTable.getColumnNameList();
            sb.append(' ');
            sb.append('(');
            this.appendSQLForSQLObjectList((List)columnNameList, sb);
            sb.append(')');
        }
        sb.append(' ');
        sb.append(AS);
        sb.append('\n');
        this.appendSpace(sb, tableWithQueryIndent);
        sb.append('(');
        this.appendSQL(withTable.getWithTableQueryExpr(), sb);
        sb.append(')');
    }

    protected void appendSQLForTableExpression(TableReference tableRef, StringBuffer sb) {
        if (tableRef instanceof QueryExpressionBody) {
            QueryExpressionBody nestedQuery = (QueryExpressionBody)tableRef;
            sb.append('(');
            this.appendSQL(nestedQuery, sb);
            sb.append(')');
            TableCorrelation tableCorr = nestedQuery.getTableCorrelation();
            if (tableCorr != null) {
                sb.append(' ');
                sb.append(AS);
                sb.append(' ');
                this.appendSQL(tableCorr, sb);
            }
        } else if (tableRef instanceof TableFunction) {
            TableFunction tableFunction = (TableFunction)tableRef;
            this.appendSQL(tableFunction, sb);
        } else {
            this.appendSQL(tableRef, sb);
        }
    }

    protected void appendSQLForTableInDatabase(TableInDatabase tableInDB, StringBuffer sb) {
        String tableName = null;
        if (tableInDB.getDatabaseTable() != null) {
            Schema schema = tableInDB.getDatabaseTable().getSchema();
            tableName = StatementHelper.convertCatalogIdentifierToSQLFormat(tableInDB.getName(), this.getDelimitedIdentifierQuote());
            if (schema != null && schema.getName() != null && schema.getName().length() > 0) {
                SQLQuerySourceInfo sourceInfo = tableInDB.getSourceInfo();
                SQLQuerySourceFormat sourceFormat = sourceInfo.getSqlFormat();
                int qualifySpec = sourceFormat.getQualifyIdentifiers();
                boolean qualify = true;
                if (qualifySpec == 3 || qualifySpec == 2) {
                    qualify = false;
                } else if (qualifySpec == 1) {
                    qualify = true;
                } else if (qualifySpec == 0) {
                    boolean bl = qualify = !StatementHelper.omitSchema(tableInDB);
                }
                if (qualify) {
                    String schemaName = StatementHelper.convertCatalogIdentifierToSQLFormat(schema.getName(), this.getDelimitedIdentifierQuote());
                    sb.append(schemaName);
                    sb.append('.');
                }
            }
        } else {
            tableName = tableInDB.getName();
        }
        sb.append(tableName);
    }

    protected void appendSpecificSQL(SearchConditionCombined condCombined, StringBuffer sb) {
        StringBuffer sbCond = new StringBuffer();
        StringBuffer sbRightCond = new StringBuffer();
        if (condCombined.getLeftCondition() != null) {
            this.appendSQL(condCombined.getLeftCondition(), sbCond);
        }
        if (condCombined.getRightCondition() != null) {
            this.appendSQL(condCombined.getRightCondition(), sbRightCond);
        }
        int currentLineLength = sbCond.length() - sbCond.lastIndexOf(NEW_LINE_STRING);
        int prospectiveNewLineLength = currentLineLength + sbRightCond.length();
        if (currentLineLength > this.displayWidth || prospectiveNewLineLength > this.displayWidth) {
            sbCond.append('\n');
            this.appendSpace(sbCond, 4);
        } else {
            this.appendSpace(sbCond, 1);
        }
        this.appendSpecificSQL(condCombined.getCombinedOperator(), sbCond);
        this.appendSpace(sbCond, 1);
        sbCond.append(sbRightCond);
        this.wrapSQL(condCombined, sbCond);
        sb.append(sbCond);
    }

    protected void appendSpecificSQL(SearchConditionNested condNest, StringBuffer sb) {
        if (condNest.isNegatedCondition()) {
            sb.append(NOT);
            sb.append(' ');
        }
        sb.append('(');
        if (condNest.getNestedCondition() != null) {
            this.appendSQL(condNest.getNestedCondition(), sb);
        }
        sb.append(')');
    }

    protected void appendSpecificSQL(QueryUpdateStatement updateStmt, StringBuffer sb) {
        int clauseIndent = 2;
        sb.append(UPDATE);
        this.appendSpace(sb, 1);
        this.appendSQL(updateStmt.getTargetTable(), sb);
        this.appendNewLine(sb);
        this.appendSpace(sb, clauseIndent);
        if (!updateStmt.getAssignmentClause().isEmpty()) {
            sb.append(SET);
            sb.append(' ');
            Iterator it = updateStmt.getAssignmentClause().iterator();
            while (it.hasNext()) {
                UpdateAssignmentExpression assign = (UpdateAssignmentExpression)it.next();
                this.appendSQL(assign, sb);
                if (!it.hasNext()) continue;
                sb.append(',');
                if (this.getLastLineLength(sb) > 60) {
                    sb.append('\n');
                    this.appendSpace(sb, clauseIndent + 4);
                    continue;
                }
                sb.append(' ');
            }
        }
        if (updateStmt.getWhereClause() != null) {
            this.appendNewLine(sb);
            this.appendSpace(sb, clauseIndent);
            sb.append(WHERE);
            this.appendSpace(sb, 1);
            this.appendSQL(updateStmt.getWhereClause(), sb);
        }
        if (updateStmt.getWhereCurrentOfClause() != null) {
            sb.append("  CURSOR REFERENCE TO BE getSQL()ed IN " + updateStmt.getClass() + "! ");
        }
    }

    protected void appendSpecificSQL(QueryValues queryValues, StringBuffer sb) {
        StringBuffer sbValues = new StringBuffer();
        int valuesStartOffset = this.getLastLineLength(sb);
        if (valuesStartOffset > 20) {
            valuesStartOffset = this.getLastLineIndent(sb) + 4;
            sbValues.append('\n');
            this.appendSpace(sbValues, valuesStartOffset);
        }
        sbValues.append(VALUES);
        sbValues.append(' ');
        EList valuesRowList = queryValues.getValuesRowList();
        this.appendSQLForSQLObjectList((List)valuesRowList, sbValues);
        if (sb.length() > 0 && sbValues.length() < this.displayWidth) {
            this.trimWhiteSpace(sbValues);
        }
        sb.append(sbValues);
    }

    protected void wrapSQL(QueryValueExpression expr, StringBuffer toWrapUp) {
        if (expr.getUnaryOperator() != null) {
            StringBuffer prefix = new StringBuffer();
            this.appendSpecificSQL(expr.getUnaryOperator(), prefix);
            this.indentSQLToLastLineLengthOfContainer(toWrapUp, prefix);
            toWrapUp.insert(0, (Object)prefix);
        }
    }

    protected void appendSpecificSQL(ValueExpressionCaseSearch caseExpr, StringBuffer sb) {
        StringBuffer sbCase = new StringBuffer();
        boolean multipleCases = caseExpr.getSearchContentList() != null && caseExpr.getSearchContentList().size() > 1;
        int startOffset = this.getLastLineLength(sb);
        if (startOffset > 30) {
            startOffset = this.getLastLineIndent(sb) + 4;
            if (multipleCases) {
                sbCase.append('\n');
                this.appendSpace(sbCase, startOffset);
            }
        }
        sbCase.append(CASE);
        if (caseExpr.getSearchContentList() != null) {
            Iterator caseIt = caseExpr.getSearchContentList().iterator();
            while (caseIt.hasNext()) {
                ValueExpressionCaseSearchContent oneCase = (ValueExpressionCaseSearchContent)caseIt.next();
                if (multipleCases) {
                    sbCase.append('\n');
                    this.appendSpace(sbCase, startOffset + 2);
                } else {
                    sbCase.append(' ');
                }
                this.appendSQL(oneCase, sbCase);
            }
        }
        if (caseExpr.getCaseElse() != null) {
            if (multipleCases) {
                sbCase.append('\n');
                this.appendSpace(sbCase, startOffset + 2);
            } else {
                sbCase.append(' ');
            }
            this.appendSQL(caseExpr.getCaseElse(), sbCase);
        }
        if (multipleCases) {
            sbCase.append('\n');
            this.appendSpace(sbCase, startOffset);
        } else {
            sbCase.append(' ');
        }
        sbCase.append(END);
        this.wrapSQL(caseExpr, sbCase);
        sb.append(sbCase);
    }

    protected void appendSpecificSQL(ValueExpressionCaseSearchContent caseSearchContent, StringBuffer sbCase) {
        sbCase.append(WHEN);
        sbCase.append(' ');
        this.appendSQL(caseSearchContent.getSearchCondition(), sbCase);
        sbCase.append(' ');
        sbCase.append(THEN);
        sbCase.append(' ');
        this.appendSQL(caseSearchContent.getValueExpr(), sbCase);
    }

    protected void appendSpecificSQL(ValueExpressionCaseElse caseElse, StringBuffer sbCase) {
        sbCase.append(ELSE);
        sbCase.append(' ');
        this.appendSQL(caseElse.getValueExpr(), sbCase);
    }

    protected void appendSpecificSQL(ValueExpressionCaseSimple caseExpr, StringBuffer sb) {
        StringBuffer sbCase = new StringBuffer();
        boolean multipleCases = caseExpr.getContentList() != null && caseExpr.getContentList().size() > 1;
        int startOffset = this.getLastLineLength(sb);
        if (startOffset > 30) {
            startOffset = this.getLastLineIndent(sb) + 4;
            if (multipleCases) {
                sbCase.append('\n');
                this.appendSpace(sbCase, startOffset);
            }
        }
        sbCase.append(CASE);
        sbCase.append(' ');
        this.appendSQL(caseExpr.getValueExpr(), sbCase);
        if (caseExpr.getContentList() != null) {
            Iterator caseIt = caseExpr.getContentList().iterator();
            while (caseIt.hasNext()) {
                ValueExpressionCaseSimpleContent oneCase = (ValueExpressionCaseSimpleContent)caseIt.next();
                if (multipleCases) {
                    sbCase.append('\n');
                    this.appendSpace(sbCase, startOffset + 2);
                } else {
                    sbCase.append(' ');
                }
                this.appendSQL(oneCase, sbCase);
            }
        }
        if (caseExpr.getCaseElse() != null) {
            if (multipleCases) {
                sbCase.append('\n');
                this.appendSpace(sbCase, startOffset + 2);
            } else {
                sbCase.append(' ');
            }
            this.appendSQL(caseExpr.getCaseElse(), sbCase);
        }
        if (multipleCases) {
            sbCase.append('\n');
            this.appendSpace(sbCase, startOffset);
        } else {
            sbCase.append(' ');
        }
        sbCase.append(END);
        this.wrapSQL(caseExpr, sbCase);
        sb.append(sbCase);
    }

    protected void appendSpecificSQL(ValueExpressionCaseSimpleContent caseSimpleContent, StringBuffer sbCase) {
        sbCase.append(WHEN);
        sbCase.append(' ');
        this.appendSQL(caseSimpleContent.getWhenValueExpr(), sbCase);
        sbCase.append(' ');
        sbCase.append(THEN);
        sbCase.append(' ');
        this.appendSQL(caseSimpleContent.getResultValueExpr(), sbCase);
    }

    protected int getLastLineLength(StringBuffer sb) {
        int lastIndexOfLineBreak = sb.lastIndexOf(NEW_LINE_STRING);
        int lastLineLength = 0;
        lastLineLength = lastIndexOfLineBreak == -1 ? sb.length() : sb.length() - lastIndexOfLineBreak - 1;
        return lastLineLength;
    }

    protected int getLastLineIndent(StringBuffer sb) {
        int lastIndexOfLineBreak = sb.lastIndexOf(NEW_LINE_STRING);
        int i = 0;
        i = 0;
        while (i < sb.length() - lastIndexOfLineBreak - 1) {
            if (sb.charAt(lastIndexOfLineBreak + i + 1) != ' ') break;
            ++i;
        }
        return i;
    }

    protected boolean isLastLineEmpty(StringBuffer sb) {
        boolean isLastLineEmpty = true;
        int lastIndexOfLineBreak = sb.lastIndexOf(NEW_LINE_STRING);
        int i = lastIndexOfLineBreak + 1;
        while (i < sb.length()) {
            if (sb.charAt(i) != ' ') {
                isLastLineEmpty = false;
                break;
            }
            ++i;
        }
        return isLastLineEmpty;
    }

    protected void indentSQLToLastLineLengthOfContainer(StringBuffer subcomponentToIndent, StringBuffer container) {
        String newLine = NEW_LINE_STRING;
        int indentLength = this.getLastLineLength(container);
        StringBuffer indent = new StringBuffer(indentLength);
        this.appendSpace(indent, indentLength);
        int i = subcomponentToIndent.indexOf(newLine, 0);
        while (i > 0) {
            subcomponentToIndent.insert(i + 1, (Object)indent);
            i = subcomponentToIndent.indexOf(newLine, i + 1);
        }
    }

    protected void indentSQL(StringBuffer sql, int indent) {
        String newLine = NEW_LINE_STRING;
        StringBuffer indentWhiteSpace = new StringBuffer(indent);
        this.appendSpace(indentWhiteSpace, indent);
        int i = sql.indexOf(newLine, 0);
        while (i > 0) {
            sql.insert(i + 1, (Object)indentWhiteSpace);
            i = sql.indexOf(newLine, i + 1);
        }
    }

    protected void indentOnNewLine(StringBuffer sb, int indent) {
        int lastLineLength = this.getLastLineLength(sb);
        if (this.isLastLineEmpty(sb)) {
            if (lastLineLength > indent) {
                int hangOver = lastLineLength - indent;
                sb.delete(sb.length() - hangOver, sb.length());
            } else {
                this.appendSpace(sb, indent - lastLineLength);
            }
        } else {
            sb.append('\n');
            this.appendSpace(sb, indent);
        }
    }

    protected void appendWithConditionalLineBreaks(SQLObject sqlObject, StringBuffer sb, int indent, int displayWidth) {
        StringBuffer localSB = new StringBuffer();
        this.appendSQL(sqlObject, localSB);
        int lineLength = this.getLastLineLength(sb);
        int nameSpaceLength = localSB.length();
        if (lineLength + nameSpaceLength > displayWidth) {
            sb.append('\n');
            this.indentSQL(localSB, indent + 2);
        } else {
            sb.append(' ');
        }
        sb.append(localSB);
    }

    protected void trimWhiteSpace(StringBuffer toBeTrimmed) {
        StringBuffer trimmed = new StringBuffer();
        int lastChar = 32;
        int i = 0;
        while (i < toBeTrimmed.length()) {
            char currentChar = toBeTrimmed.charAt(i);
            if (currentChar == '\n') {
                if (lastChar != 32) {
                    trimmed.append(' ');
                    lastChar = 32;
                }
            } else if (currentChar != ' ' || lastChar != 32) {
                trimmed.append(currentChar);
                lastChar = currentChar;
            }
            ++i;
        }
        toBeTrimmed.replace(0, toBeTrimmed.length(), trimmed.toString());
    }

    protected char getDelimitedIdentifierQuote() {
        return this.delimitedIdentifierQuote;
    }

    protected void appendSpecificSQL(ValueExpressionCast castExpr, StringBuffer sb) {
        StringBuffer sbCast = new StringBuffer();
        sbCast.append(CAST);
        sbCast.append(' ');
        sbCast.append('(');
        this.appendSQL(castExpr.getValueExpr(), sbCast);
        sbCast.append(' ');
        sbCast.append(AS);
        sbCast.append(' ');
        this.appendSQL((SQLObject)castExpr.getDataType(), sbCast);
        sbCast.append(')');
        this.wrapSQL(castExpr, sbCast);
        sb.append(sbCast);
    }

    protected void appendSpecificSQL(ValueExpressionAtomic atomicExpr, StringBuffer sb) {
    }

    protected void appendSpecificSQL(ValueExpressionColumn column, StringBuffer sb) {
        TableExpression tableExpr = column.getTableExpr();
        if (tableExpr != null) {
            boolean qualify;
            SQLQuerySourceInfo sourceInfo = column.getSourceInfo();
            SQLQuerySourceFormat sourceFormat = sourceInfo.getSqlFormat();
            int qualifySpec = sourceFormat.getQualifyIdentifiers();
            boolean qualifyWithSchema = qualifySpec == 1;
            boolean qualifyWithTable = qualifySpec == 2;
            boolean qualifyInContext = qualifySpec == 0;
            boolean bl = qualify = qualifyWithSchema || qualifyWithTable || qualifyInContext && this.isQualifiedColumnNameRequired(column);
            if (qualify) {
                if (tableExpr.getTableCorrelation() != null) {
                    String tableCorrName = tableExpr.getTableCorrelation().getName();
                    tableCorrName = StatementHelper.convertCatalogIdentifierToSQLFormat(tableCorrName, this.getDelimitedIdentifierQuote());
                    sb.append(tableCorrName);
                } else if (tableExpr instanceof TableInDatabase) {
                    TableInDatabase tableInDB = (TableInDatabase)tableExpr;
                    this.appendSQLForTableInDatabase(tableInDB, sb);
                } else {
                    sb.append(StatementHelper.convertCatalogIdentifierToSQLFormat(tableExpr.getName(), this.getDelimitedIdentifierQuote()));
                }
                sb.append('.');
            }
        }
        sb.append(StatementHelper.convertCatalogIdentifierToSQLFormat(column.getName(), this.getDelimitedIdentifierQuote()));
    }

    private boolean isQualifiedColumnNameRequired(ValueExpressionColumn column) {
        QuerySelect colRefSelect;
        boolean qualify = true;
        boolean multipleTables = false;
        boolean subquery = false;
        boolean ambiguousColumnNames = false;
        boolean referenceInSubquery = false;
        if (this.alwaysQualifyColumnNamesForMultipleTables) {
            QuerySelect colTableSelect;
            List fromTables;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.datatools.modelbase.sql.query.QuerySelect");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            boolean bl = multipleTables = (fromTables = StatementHelper.getTableExpressionsInQuerySelect(colTableSelect = (QuerySelect)StatementHelper.getEContainerRecursively((EObject)column, clazz))) != null && fromTables.size() > 1;
            if (this.qualifyColumnNamesInSubqueriesWhenQualifiedInSuperQuery) {
                QuerySelect superSelect;
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("org.eclipse.datatools.modelbase.sql.query.QuerySelect");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                QuerySelect subselect = (QuerySelect)StatementHelper.getEContainerRecursively((EObject)column, clazz2);
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("org.eclipse.datatools.modelbase.sql.query.QuerySelect");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((superSelect = (QuerySelect)StatementHelper.getEContainerRecursively((EObject)subselect, clazz3)) != null && (fromTables = StatementHelper.getTableExpressionsInQuerySelect(superSelect)) != null && fromTables.size() > 1) {
                    multipleTables = true;
                }
            }
        }
        if (this.alwaysQualifyColumnNamesForSubqueries) {
            QuerySelect superSelect;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.datatools.modelbase.sql.query.QuerySelect");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            colRefSelect = (QuerySelect)StatementHelper.getEContainerRecursively((EObject)column, clazz);
            Class<?> clazz4 = class$2;
            if (clazz4 == null) {
                try {
                    clazz4 = class$2 = Class.forName("org.eclipse.datatools.modelbase.sql.query.QuerySelect");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            boolean bl = subquery = (superSelect = (QuerySelect)StatementHelper.getEContainerRecursively((EObject)colRefSelect, clazz4)) != null;
        }
        if (this.alwaysQualifyColumnNamesReferencedInSubqueries) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.datatools.modelbase.sql.query.QuerySelect");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            colRefSelect = (QuerySelect)StatementHelper.getEContainerRecursively((EObject)column, clazz);
            QuerySelect colTableSelect = StatementHelper.getQuerySelectForTableReference(column.getTableExpr());
            referenceInSubquery = colRefSelect != null && colTableSelect != colRefSelect;
        }
        qualify = (ambiguousColumnNames = StatementHelper.isColumnNameAmbiguous(column)) || this.alwaysQualifyColumnNamesForMultipleTables && multipleTables || this.alwaysQualifyColumnNamesForSubqueries && subquery || this.alwaysQualifyColumnNamesReferencedInSubqueries && referenceInSubquery;
        return qualify;
    }

    protected void appendSpecificSQL(ValueExpressionCombined exprCombined, StringBuffer sb) {
        if (exprCombined.getLeftValueExpr() != null) {
            this.appendSQL(exprCombined.getLeftValueExpr(), sb);
        }
        sb.append(' ');
        this.appendSpecificSQL(exprCombined.getCombinedOperator(), sb);
        sb.append(' ');
        if (exprCombined.getRightValueExpr() != null) {
            this.appendSQL(exprCombined.getRightValueExpr(), sb);
        }
    }

    protected void appendSpecificSQL(ValueExpressionDefaultValue exprDefault, StringBuffer sb) {
        sb.append(DEFAULT);
    }

    protected void appendSpecificSQL(ValueExpressionFunction function, StringBuffer sb) {
        StringBuffer sbExpr = new StringBuffer();
        if (function.getFunction() != null && function.getFunction().getSchema() != null && function.getFunction().getSchema().getName() != null) {
            sbExpr.append(StatementHelper.convertCatalogIdentifierToSQLFormat(function.getFunction().getSchema().getName(), this.getDelimitedIdentifierQuote()));
            sbExpr.append('.');
        }
        if (function.isSpecialRegister()) {
            ValueExpressionSimple simpleExpr;
            String value;
            sbExpr.append(function.getName());
            EList paramList = function.getParameterList();
            if (!paramList.isEmpty() && (value = (simpleExpr = (ValueExpressionSimple)paramList.get(0)).getValue()) != null) {
                sbExpr.append(' ');
                sbExpr.append(value);
            }
        } else {
            boolean isCountAll;
            sbExpr.append(StatementHelper.convertCatalogIdentifierToSQLFormat(function.getName(), this.getDelimitedIdentifierQuote()));
            sbExpr.append('(');
            if (function.isDistinct()) {
                sbExpr.append(DISTINCT);
                sbExpr.append(' ');
            }
            EList paramList = function.getParameterList();
            boolean bl = isCountAll = function.getName().equalsIgnoreCase(FUNCTION_COUNT) && (paramList == null || paramList.isEmpty());
            if (isCountAll) {
                sbExpr.append("*");
            } else if (paramList != null) {
                this.appendSQLForSQLObjectList((List)paramList, sbExpr);
            }
            sbExpr.append(')');
        }
        this.wrapSQL(function, sbExpr);
        sb.append(sbExpr);
    }

    protected void appendSpecificSQL(ValueExpressionLabeledDuration duration, StringBuffer sb) {
        StringBuffer sbDuration = new StringBuffer();
        this.appendSQL(duration.getValueExpr(), sbDuration);
        sbDuration.append(' ');
        this.appendSpecificSQL(duration.getLabeledDurationType(), sbDuration);
        this.wrapSQL(duration, sbDuration);
        sb.append(sbDuration);
    }

    protected void appendSpecificSQL(ValueExpressionNested exprNest, StringBuffer sb) {
        StringBuffer sbExprNest = new StringBuffer();
        sbExprNest.append('(');
        this.appendSQL(exprNest.getNestedValueExpr(), sbExprNest);
        sbExprNest.append(')');
        this.wrapSQL(exprNest, sbExprNest);
        sb.append(sbExprNest);
    }

    protected void appendSpecificSQL(ValueExpressionNullValue exprNull, StringBuffer sb) {
        sb.append(NULL);
    }

    protected void appendSpecificSQL(ValueExpressionRow valExprRow, StringBuffer sb) {
        sb.append('(');
        this.appendSQLForSQLObjectList((List)valExprRow.getValueExprList(), sb);
        sb.append(')');
    }

    protected void appendSpecificSQL(ValueExpressionScalarSelect exprSelect, StringBuffer sb) {
        StringBuffer sbExpr = new StringBuffer();
        sbExpr.append('(');
        this.appendSQL(exprSelect.getQueryExpr(), sbExpr);
        sbExpr.append(')');
        this.wrapSQL(exprSelect, sbExpr);
        this.indentSQLToLastLineLengthOfContainer(sbExpr, sb);
        sb.append(sbExpr);
    }

    protected void appendSpecificSQL(ValueExpressionSimple exprSimple, StringBuffer sb) {
        StringBuffer sbExpr = new StringBuffer();
        sbExpr.append(exprSimple.getValue());
        this.wrapSQL(exprSimple, sbExpr);
        sb.append(sbExpr);
    }

    protected void appendSpecificSQL(ValueExpressionVariable variable, StringBuffer sb) {
        StringBuffer sbExpr = new StringBuffer();
        String hostVarPrefix = COLON;
        String paramMarker = QUESTIONMARK;
        if (variable.getSourceInfo() != null && variable.getSourceInfo().getSqlFormat() != null) {
            SQLQuerySourceFormat sf = variable.getSourceInfo().getSqlFormat();
            hostVarPrefix = String.valueOf(sf.getHostVariablePrefix());
            paramMarker = String.valueOf(sf.getParameterMarker());
        }
        if (variable.getName() != null) {
            sbExpr.append(hostVarPrefix);
            sbExpr.append(variable.getName());
        } else {
            sbExpr.append(paramMarker);
        }
        this.wrapSQL(variable, sbExpr);
        sb.append(sbExpr);
    }

    protected void appendSpecificSQL(ValuesRow valuesRow, StringBuffer sb) {
        if (valuesRow.getExprList().size() == 1) {
            this.appendSQLForSQLObjectList((List)valuesRow.getExprList(), sb);
        } else if (valuesRow.getExprList().size() > 1) {
            sb.append('(');
            this.appendSQLForSQLObjectList((List)valuesRow.getExprList(), sb);
            sb.append(')');
        }
    }
}

