/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.tablewizard.ui.wizards;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.PersistentTable;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesFactory;
import org.eclipse.datatools.sqltools.ddlgen.internal.ui.wizards.FEConfigurationData;
import org.eclipse.datatools.sqltools.ddlgen.internal.ui.wizards.FESelectOptionsWizardPage;
import org.eclipse.datatools.sqltools.tablewizard.ui.DefaultTableFormModel;
import org.eclipse.datatools.sqltools.tablewizard.ui.TableFormModel;
import org.eclipse.datatools.sqltools.tablewizard.ui.utils.ResourceLoader;
import org.eclipse.datatools.sqltools.tablewizard.ui.utils.UIUtils;
import org.eclipse.datatools.sqltools.tablewizard.ui.wizardpages.columns.GenericColumnsPage;
import org.eclipse.datatools.sqltools.tablewizard.ui.wizardpages.pk.GenericPrimaryKeyPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class GenericTableDefinitionWizard
extends Wizard {
    private static final String NEW_TABLE_NAME = "new_table.name";
    private final IConnectionProfile connectionProfile;
    private final Schema schema;
    private final PersistentTable table;
    private final PersistentTable oldTable;
    private boolean isNewTable = false;
    private final DatabaseDefinition databaseDefinition;
    private FESelectOptionsWizardPage selectOptionsPage;

    public GenericTableDefinitionWizard(IConnectionProfile connectionProfile, Schema schema) {
        this(connectionProfile, schema, null);
        this.isNewTable = true;
    }

    public GenericTableDefinitionWizard(IConnectionProfile connectionProfile, Schema schema, PersistentTable oldTable) {
        this.connectionProfile = connectionProfile;
        this.schema = schema;
        this.table = SQLTablesFactory.eINSTANCE.createPersistentTable();
        this.table.setSchema(this.schema);
        this.oldTable = oldTable;
        Database db = this.schema.getDatabase() != null ? this.schema.getDatabase() : this.schema.getCatalog().getDatabase();
        this.databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(db);
        this.table.setName(ResourceLoader.queryString(NEW_TABLE_NAME));
    }

    public boolean performFinish() {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected void execute(IProgressMonitor monitor) {
                try {
                    try {
                        String[] sqls = GenericTableDefinitionWizard.this.createSql(monitor);
                        Database db = GenericTableDefinitionWizard.this.schema.getDatabase() != null ? GenericTableDefinitionWizard.this.schema.getDatabase() : GenericTableDefinitionWizard.this.schema.getCatalog().getDatabase();
                        UIUtils.openSQLEditor(GenericTableDefinitionWizard.this.connectionProfile, db, sqls, monitor);
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var4_7 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    protected String[] createSql(IProgressMonitor monitor) {
        DDLGenerator generator = this.databaseDefinition.getDDLGenerator();
        String[] sql = this.isNewTable ? this.createTableSql(generator, this.table, monitor) : this.modyfyTableSql(generator, this.table, this.oldTable, monitor);
        return sql;
    }

    protected String[] modyfyTableSql(DDLGenerator generator, PersistentTable table, PersistentTable oldTable, IProgressMonitor monitor) {
        return new String[]{"not yet implemented."};
    }

    protected String[] createTableSql(DDLGenerator generator, PersistentTable table, IProgressMonitor monitor) {
        SQLObject[] objs = new SQLObject[]{table};
        String[] sqls = generator.generateDDL(objs, monitor);
        return sqls;
    }

    public void addPages() {
        super.addPages();
        DefaultTableFormModel model = new DefaultTableFormModel(this.table);
        this.addPages(model);
    }

    protected void addPages(TableFormModel model) {
        FEConfigurationData configurationData = new FEConfigurationData(this.databaseDefinition.getDDLGenerator().getOptions(new SQLObject[]{model.getPersistentTable()}));
        this.selectOptionsPage = new FESelectOptionsWizardPage("org.eclipse.datatools.sqltools.tablewizard.ui.SelectOptionPage", configurationData);
        this.addPage((IWizardPage)this.selectOptionsPage);
        GenericColumnsPage page1 = new GenericColumnsPage("org.eclipse.datatools.sqltools.tablewizard.ui.GenericColumnPage", model.getPersistentTable());
        this.addPage((IWizardPage)page1);
        GenericPrimaryKeyPage page2 = new GenericPrimaryKeyPage("org.eclipse.datatools.sqltools.tablewizard.ui.GenericPrimaryKeyPage", model.getPersistentTable());
        this.addPage((IWizardPage)page2);
    }
}

