/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.rte.jdbc;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.core.util.CatalogLoaderOverrideManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableColumnLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableIndexLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableSuperTableLoader;
import org.eclipse.datatools.modelbase.sql.constraints.SQLConstraintsPackage;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesPackage;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.impl.ViewTableImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class JDBCView
extends ViewTableImpl
implements ICatalogObject {
    private static final long serialVersionUID = 2356307832803481033L;
    private Boolean columnsLoaded = Boolean.FALSE;
    private SoftReference columnLoaderRef;
    private Boolean indexesLoaded = Boolean.FALSE;
    private SoftReference indexLoaderRef;
    private Boolean supertableLoaded = Boolean.FALSE;
    private SoftReference supertableLoaderRef;

    public Database getCatalogDatabase() {
        return this.getSchema().getCatalog().getDatabase();
    }

    public Connection getConnection() {
        Database db = this.getCatalogDatabase();
        if (db instanceof ICatalogObject) {
            return ((ICatalogObject)db).getConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.columnsLoaded;
        synchronized (bl) {
            if (this.columnsLoaded.booleanValue()) {
                this.columnsLoaded = Boolean.FALSE;
            }
        }
        bl = this.indexesLoaded;
        synchronized (bl) {
            if (this.indexesLoaded.booleanValue()) {
                this.indexesLoaded = Boolean.FALSE;
            }
        }
        bl = this.supertableLoaded;
        synchronized (bl) {
            if (this.supertableLoaded.booleanValue()) {
                this.supertableLoaded = Boolean.FALSE;
                this.setSupertable(null);
            }
        }
        RefreshManager.getInstance().referesh(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getColumns() {
        Boolean bl = this.columnsLoaded;
        synchronized (bl) {
            if (!this.columnsLoaded.booleanValue()) {
                this.loadColumns();
            }
        }
        return super.getColumns();
    }

    protected JDBCTableColumnLoader createColumnLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLTablesPackage.eINSTANCE.getColumn().getInstanceClassName());
        if (loader != null) {
            JDBCTableColumnLoader tableColumnLoader = (JDBCTableColumnLoader)loader;
            tableColumnLoader.setCatalogObject(this);
            return tableColumnLoader;
        }
        return new JDBCTableColumnLoader(this);
    }

    protected final JDBCTableColumnLoader getColumnLoader() {
        if (this.columnLoaderRef == null || this.columnLoaderRef.get() == null) {
            this.columnLoaderRef = new SoftReference<JDBCTableColumnLoader>(this.createColumnLoader());
        }
        return (JDBCTableColumnLoader)this.columnLoaderRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadColumns() {
        boolean deliver = this.eDeliver();
        try {
            EList container = super.getColumns();
            ArrayList existingColumns = new ArrayList(container);
            this.eSetDeliver(false);
            container.clear();
            this.getColumnLoader().loadColumns((List)container, existingColumns);
            this.getColumnLoader().clearColumns(existingColumns);
            this.columnsLoaded = Boolean.TRUE;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.eSetDeliver(deliver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getIndex() {
        Boolean bl = this.indexesLoaded;
        synchronized (bl) {
            if (!this.indexesLoaded.booleanValue()) {
                this.loadIndexes();
            }
        }
        return super.getIndex();
    }

    protected JDBCTableIndexLoader createIndexLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLConstraintsPackage.eINSTANCE.getIndex().getInstanceClassName());
        if (loader != null) {
            JDBCTableIndexLoader tableIndexLoader = (JDBCTableIndexLoader)loader;
            tableIndexLoader.setCatalogObject(this);
            return tableIndexLoader;
        }
        return new JDBCTableIndexLoader(this);
    }

    protected final JDBCTableIndexLoader getIndexLoader() {
        if (this.indexLoaderRef == null || this.indexLoaderRef.get() == null) {
            this.indexLoaderRef = new SoftReference<JDBCTableIndexLoader>(this.createIndexLoader());
        }
        return (JDBCTableIndexLoader)this.indexLoaderRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIndexes() {
        boolean deliver = this.eDeliver();
        try {
            EList container = super.getIndex();
            ArrayList existingIndexes = new ArrayList(container);
            this.eSetDeliver(false);
            container.clear();
            this.getIndexLoader().loadIndexes((List)container, existingIndexes);
            this.getIndexLoader().clearIndexes(existingIndexes);
            this.indexesLoaded = Boolean.TRUE;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.eSetDeliver(deliver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getSupertable() {
        Boolean bl = this.supertableLoaded;
        synchronized (bl) {
            if (!this.supertableLoaded.booleanValue()) {
                this.loadSupertable();
            }
        }
        return super.getSupertable();
    }

    protected JDBCTableSuperTableLoader createSupertableLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLTablesPackage.eINSTANCE.getTable().getInstanceClassName());
        if (loader != null) {
            JDBCTableSuperTableLoader tableSuperTableLoader = (JDBCTableSuperTableLoader)loader;
            tableSuperTableLoader.setCatalogObject(this);
            return tableSuperTableLoader;
        }
        return new JDBCTableSuperTableLoader(this);
    }

    protected final JDBCTableSuperTableLoader getSupertableLoader() {
        if (this.supertableLoaderRef == null || this.supertableLoaderRef.get() == null) {
            this.supertableLoaderRef = new SoftReference<JDBCTableSuperTableLoader>(this.createSupertableLoader());
        }
        return (JDBCTableSuperTableLoader)this.supertableLoaderRef.get();
    }

    private void loadSupertable() {
        try {
            this.setSupertable(this.getSupertableLoader().loadSuperTable());
            this.supertableLoaded = Boolean.TRUE;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 7: {
                this.getColumns();
                break;
            }
            case 13: {
                this.getIndex();
                break;
            }
            case 8: {
                this.getSupertable();
            }
        }
        return super.eIsSet(eFeature);
    }
}

